/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.IntVector;
import chemaxon.common.util.LongVector;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import java.io.IOException;

public interface MRecordReader {
    public void setProgressMonitor(MProgressMonitor var1);

    public MRecord nextRecord() throws MRecordParseException, IOException;

    public MRecord skipRecord() throws MRecordParseException, IOException;

    public String getRecognizedFormat();

    public String getHeaderAsString();

    public String getFooterAsString();

    public String getOptions();

    public void close() throws IOException;

    public MRecordReader getEncapsulatedReader();

    public MolInputStream getMolInputStream();

    public long getFilePointer();

    public int getLineCount();

    public boolean isSeekable();

    public void seek(long var1, int var3, int var4) throws IOException;

    public boolean isPropertyRecord();

    public LongVector detectRecordPositions(IntVector var1) throws MolFormatException;

    public static class Position {
        private int recordNumber;
        private int lineNumber;

        public Position(int r, int l) {
            this.recordNumber = r;
            this.lineNumber = l;
        }

        public int getRecordNumber() {
            return this.recordNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String toString() {
            return "line " + this.lineNumber + " [record " + this.recordNumber + "]";
        }
    }
}

