/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.calculations.hydrogenize.Hydrogenize;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MultipleSgroup;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public abstract class MolExportModule {
    private String format;
    private String options;
    private int optionSign = 0;
    protected StringBuffer stringBuffer = new StringBuffer();
    protected int aromatize = 0;
    protected int hydrogenize = 0;
    protected boolean addNumbering = false;
    private String encoding = null;

    public final OptionDescriptor[] getOptionDescriptors(String fmtname) {
        ArrayList<OptionDescriptor> l = new ArrayList<OptionDescriptor>();
        this.getOptionDescriptors(fmtname, null, l);
        OptionDescriptor[] opts = new OptionDescriptor[l.size()];
        l.toArray(opts);
        return opts;
    }

    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        ResourceBundle rc = LocaleUtil.getResourceBundle(MolExportModule.class.getName(), null);
        MolExportModule.getOptionDescriptors(rc, fmtname, optnames, l);
    }

    public Object open(String fmtopts) throws MolExportException {
        return this.open(fmtopts, null);
    }

    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        this.aromatize = 0;
        this.hydrogenize = 0;
        if (fmtopts != null) {
            int i = fmtopts.indexOf(58);
            if (i >= 0) {
                this.format = fmtopts.substring(0, i);
                this.options = fmtopts.substring(i + 1);
                int j = 0;
                this.optionSign = 0;
                while (j < this.options.length()) {
                    if (" ,\n\r\t".indexOf(this.options.substring(j, j + 1)) >= 0 && ++j >= this.options.length()) {
                        throw new IllegalArgumentException("No more options");
                    }
                    int k = this.parseOption(this.options, j);
                    if (k == j) {
                        throw new IllegalArgumentException("Unknown option(s) \"" + this.options.substring(j) + "\"");
                    }
                    j = k;
                }
            } else {
                this.format = fmtopts;
                this.options = null;
            }
        } else {
            this.format = null;
            this.options = null;
        }
        return null;
    }

    public abstract Object convert(Molecule var1) throws MolExportException;

    public Object close() throws MolExportException {
        return null;
    }

    public final String getFormat() {
        return this.format;
    }

    protected final String getOptions() {
        return this.options;
    }

    public boolean isDocumentExport() {
        return false;
    }

    public boolean isCleanable() {
        return true;
    }

    public static boolean isImplicitHcountImportant(MolAtom a) {
        int atno = a.getAtno();
        boolean important = false;
        if (atno == 7 || atno == 15 || atno == 33) {
            int aromBonds = 0;
            for (int j = 0; j < a.getBondCount(); ++j) {
                MolBond b = a.getBond(j);
                if (b.getType() != 4) continue;
                ++aromBonds;
            }
            important = aromBonds == 2 && a.getNonQueryImplicitHcount() > 0;
        }
        return important;
    }

    public boolean isImplicitHcountImportant(MoleculeGraph mol) {
        int atomCount = mol.getAtomCount();
        for (int i = 0; i < atomCount; ++i) {
            if (!MolExportModule.isImplicitHcountImportant(mol.getAtom(i))) continue;
            return true;
        }
        return false;
    }

    public String setEncoding(String opts, String enc) {
        String[] e = MFileFormatUtil.getEncodingFromOptions(opts);
        if (e[0] == null && enc != null) {
            e[0] = Encoding.canonicalName(enc);
        }
        this.encoding = e[0];
        return e[1];
    }

    public String getEncoding() {
        return this.encoding;
    }

    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        int oldindex = i;
        while (i < opts.length()) {
            char c = opts.charAt(i);
            if (c == '+') {
                this.optionSign = 1;
                ++i;
                continue;
            }
            if (c == '-') {
                this.optionSign = -1;
                ++i;
                continue;
            }
            if (c == 'a') {
                int n = this.aromatize = this.optionSign >= 0 ? 1 : -1;
                if (this.aromatize != 0) {
                    if (opts.length() > i + 1) {
                        c = opts.charAt(i + 1);
                        if (c == '_') {
                            int j = MolExportModule.nextOpt(opts, i, "a_chemaxon");
                            if (j > i) {
                                this.aromatize = 2;
                            } else {
                                j = MolExportModule.nextOpt(opts, i, "a_cx");
                                if (j > i) {
                                    this.aromatize = 2;
                                } else {
                                    j = MolExportModule.nextOpt(opts, i, "a_bas");
                                    if (j > i) {
                                        this.aromatize = 2;
                                    } else {
                                        j = MolExportModule.nextOpt(opts, i, "a_gen");
                                        if (j > i) {
                                            this.aromatize = this.aromatize > 0 ? 3 : -1;
                                        } else {
                                            j = MolExportModule.nextOpt(opts, i, "a_loose");
                                            if (j > i) {
                                                this.aromatize = 4;
                                            } else {
                                                j = MolExportModule.nextOpt(opts, i, "a_daylight");
                                                if (j > i) {
                                                    this.aromatize = 3;
                                                } else {
                                                    j = MolExportModule.nextOpt(opts, i, "a_day");
                                                    if (j > i) {
                                                        this.aromatize = 3;
                                                    } else {
                                                        j = MolExportModule.nextOpt(opts, i, "a_ambig");
                                                        if (j > i) {
                                                            this.aromatize = 6;
                                                        } else {
                                                            j = MolExportModule.nextOpt(opts, i, "a_huckel_ex");
                                                            if (j > i) {
                                                                this.aromatize = -3;
                                                            } else {
                                                                j = MolExportModule.nextOpt(opts, i, "a_huckel");
                                                                if (j > i) {
                                                                    this.aromatize = -2;
                                                                } else {
                                                                    throw new IllegalArgumentException("Unknown aromatization option \"" + opts.substring(i) + "\"");
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            return j;
                        }
                        this.aromatize = this.aromatize > 0 ? 3 : -1;
                    } else {
                        this.aromatize = this.aromatize > 0 ? 3 : -1;
                    }
                }
                return i + 1;
            }
            if (c == 'H') {
                this.hydrogenize = this.optionSign >= 0 ? 1 : -1;
                return i + 1;
            }
            if (this.optionSign == 1 && opts.substring(i).startsWith("numbering")) {
                this.addNumbering = true;
                return i + "numbering".length();
            }
            if (" ,\n\t".indexOf(c) >= 0) {
                this.optionSign = 0;
                ++i;
                continue;
            }
            return oldindex;
        }
        return oldindex;
    }

    protected static int nextOpt(String opts, int i, String s) {
        if (opts.substring(i).startsWith(s)) {
            return i + s.length();
        }
        return i;
    }

    protected final int getOptionSign() {
        return this.optionSign;
    }

    protected int parseCharIfOptionSign(String opts, int i) {
        if (i >= opts.length()) {
            return i;
        }
        char c = opts.charAt(i);
        if (c == '-' || c == '+') {
            this.optionSign = c == '+' ? 1 : -1;
            return i + 1;
        }
        return i;
    }

    protected Molecule preconvert(Molecule mol) {
        return this.preconvert(mol, true, 0, false);
    }

    protected final Molecule preconvert(Molecule mol, boolean xg) {
        return this.preconvert(mol, xg, 0, false);
    }

    protected final Molecule preconvert(Molecule mol, boolean xg, int xopts, boolean ih) {
        return (Molecule)this.preconvert((MoleculeGraph)mol, xg, xopts, ih);
    }

    protected final MoleculeGraph preconvert(MoleculeGraph molg, boolean xg, int xopts, boolean ih) {
        boolean xmul = false;
        boolean csup = false;
        boolean hierarchic = molg.properties().isHierarchic();
        if (xg) {
            if (molg instanceof Molecule) {
                Molecule m = (Molecule)molg;
                int nsg = m.getSgroupCount();
                if (nsg != 0) {
                    boolean bl = xg = m.findExpandableSgroup() != null;
                    if ((xopts & 1) != 0) {
                        for (int i = 0; !xg && i < nsg; ++i) {
                            Sgroup sg = m.getSgroup(i);
                            if (sg instanceof MultipleSgroup) {
                                MultipleSgroup msg = (MultipleSgroup)sg;
                                if (!msg.isExpanded()) {
                                    xg = true;
                                }
                                xmul = true;
                                continue;
                            }
                            if (sg.getXState() != 3) continue;
                            csup = true;
                        }
                    }
                }
            } else {
                xg = false;
            }
        }
        if (this.aromatize != 0 || this.hydrogenize != 0 || xg || xmul || csup || ih || this.addNumbering || hierarchic || molg.getDocument() == null) {
            MDocument doc = molg.getDocument();
            boolean simplify = MolExportModule.isSimplified(doc, molg);
            MoleculeGraph moleculeGraph = molg = doc != null ? doc.cloneMainMoleculeGraph() : (MoleculeGraph)molg.clone();
            if (molg.getDocument() == null) {
                doc = new MDocument(molg);
            }
            if (simplify) {
                molg = ((Molecule)molg).getSimplifiedMolecule();
            }
            if (hierarchic) {
                molg.properties().flatten();
            }
            if (this.hydrogenize > 0) {
                Hydrogenize.addHAtoms(molg);
            }
            if (this.hydrogenize < 0) {
                Hydrogenize.removeHAtoms(molg, null, 33, true);
            }
            if (this.aromatize > 0) {
                molg.aromatize(this.aromatize - 1);
            } else if (this.aromatize < 0) {
                molg.dearomatize(-(this.aromatize + 1));
            }
            if (xg) {
                ((Molecule)molg).expandSgroups(xopts);
            } else if (xmul || csup) {
                Molecule m = (Molecule)molg;
                m.setGUIContracted(true);
                Sgroup[] sgroups = m.getSortedSgroups();
                for (int i = 0; i < sgroups.length; ++i) {
                    Sgroup sg = sgroups[i];
                    if (!(sg instanceof Expandable)) continue;
                    Expandable xsg = (Expandable)((Object)sg);
                    if (sg instanceof MultipleSgroup) {
                        xsg.expand(xopts);
                        sgroups = m.getSortedSgroups();
                        continue;
                    }
                    if (sg.getXState() != 2) continue;
                    xsg.expand(xopts | 4);
                    sg.setXState(3);
                }
            }
            if (this.addNumbering && molg instanceof Molecule) {
                NamingCentral.numberMolecule((Molecule)molg, false);
            }
            if (molg instanceof Molecule && ih && this.isImplicitHcountImportant(molg)) {
                this.convertIHToData((Molecule)molg);
            }
        }
        return molg;
    }

    private static boolean isSimplified(MDocument doc, MoleculeGraph molg) {
        if (doc == null) {
            return false;
        }
        MoleculeGraph origmain = doc.getMainMoleculeGraph();
        if (origmain instanceof Molecule && origmain != molg) {
            return ((Molecule)origmain).getSimplifiedMolecule() == molg;
        }
        return false;
    }

    private void convertIHToData(Molecule mol) {
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            MolAtom ma = mol.getAtom(i);
            if (!MolExportModule.isImplicitHcountImportant(ma)) continue;
            int h = ma.getNonQueryImplicitHcount() + ma.getExplicitHcount();
            this.addData(mol, ma, "MRV_IMPLICIT_H", "IMPL_H" + h);
        }
        if (mol instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)mol;
            for (int i = 0; i < rgm.getRgroupCount(); ++i) {
                for (int j = 0; j < rgm.getRgroupMemberCount(i); ++j) {
                    this.convertIHToData(rgm.getRgroupMember(i, j));
                }
            }
        }
    }

    protected void addData(Molecule mol, MolAtom ma, String fieldName, String value) {
        DataSgroup dsg = new DataSgroup(mol);
        dsg.setFieldName(fieldName);
        dsg.setData(value);
        dsg.setDataDetached(true);
        dsg.setAbsolutePlacement(false);
        dsg.setX(0.0);
        dsg.setY(0.0);
        mol.setSgroupParent(ma, dsg, true);
    }

    protected final void appendChars(int n, char c) {
        for (int i = n - 1; i >= 0; --i) {
            this.stringBuffer.append(c);
        }
    }

    protected final void appendLeft(String t, int n) {
        StringBuffer s = this.stringBuffer;
        if (t == null) {
            t = "";
        }
        if (t.length() > n) {
            t = t.substring(0, n);
        }
        s.append(t);
        this.appendChars(n - t.length(), ' ');
    }

    protected final void appendRight(String t, int n, char c) {
        this.appendChars(n - t.length(), c);
        this.stringBuffer.append(t);
    }

    protected final void appendRight(int t, int n, char c) {
        this.appendRight(String.valueOf(t), n, c);
    }

    protected static String getOptionDescriptors(ResourceBundle rc, String fmtname, String optnames, List<OptionDescriptor> l) {
        String definednames = MolExportModule.getString(rc, fmtname, "options");
        if (optnames != null) {
            StringTokenizer st = new StringTokenizer(definednames);
            HashSet<String> definedset = new HashSet<String>();
            while (st.hasMoreTokens()) {
                String optname = st.nextToken();
                definedset.add(optname);
            }
            st = new StringTokenizer(optnames);
            StringBuffer nonprocessed = new StringBuffer();
            while (st.hasMoreTokens()) {
                String optname = st.nextToken();
                if (definedset.contains(optname)) {
                    OptionDescriptor o = MolExportModule.getOptionDescriptor(rc, fmtname, optname);
                    l.add(o);
                    continue;
                }
                if (nonprocessed.length() != 0) {
                    nonprocessed.append(' ');
                }
                nonprocessed.append(optname);
            }
            return nonprocessed.toString();
        }
        StringTokenizer st = new StringTokenizer(definednames);
        while (st.hasMoreTokens()) {
            String optname = st.nextToken();
            OptionDescriptor o = MolExportModule.getOptionDescriptor(rc, fmtname, optname);
            l.add(o);
        }
        return null;
    }

    private static OptionDescriptor getOptionDescriptor(ResourceBundle rc, String fmtname, String optname) {
        String key = "option." + optname;
        String invname = null;
        try {
            invname = MolExportModule.getString(rc, fmtname, key + ".inv");
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        String desc = MolExportModule.getString(rc, fmtname, key + ".desc");
        int type = 0;
        try {
            String s = MolExportModule.getString(rc, fmtname, key + ".type");
            type = OptionDescriptor.parseType(s);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        String[] opts2disable = null;
        try {
            String s = MolExportModule.getString(rc, fmtname, key + ".disable");
            StringTokenizer st = new StringTokenizer(s);
            int n = st.countTokens();
            opts2disable = new String[n];
            for (int j = 0; j < n; ++j) {
                opts2disable[j] = st.nextToken();
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        String[] opts2enable = null;
        try {
            String s = MolExportModule.getString(rc, fmtname, key + ".enable");
            StringTokenizer st = new StringTokenizer(s);
            int n = st.countTokens();
            opts2enable = new String[n];
            for (int j = 0; j < n; ++j) {
                opts2enable[j] = st.nextToken();
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        String[] opts2deselect = null;
        try {
            String s = MolExportModule.getString(rc, fmtname, key + ".deselect");
            StringTokenizer st = new StringTokenizer(s);
            int n = st.countTokens();
            opts2deselect = new String[n];
            for (int j = 0; j < n; ++j) {
                opts2deselect[j] = st.nextToken();
            }
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return new OptionDescriptor(optname, invname, type, desc, opts2disable, opts2enable, opts2deselect);
    }

    private static String getString(ResourceBundle rc, String fmtname, String what) {
        if (fmtname != null) {
            fmtname = MolExportModule.formatKey(fmtname);
            try {
                return rc.getString(fmtname + "." + what);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return rc.getString(what);
    }

    private static String formatKey(String format2) {
        if (format2 != null) {
            int i = format2.indexOf(32);
            if (i > 0) {
                format2 = format2.substring(0, i);
            }
            return format2.replaceAll(":", "_");
        }
        return null;
    }
}

