/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MDocSource;
import chemaxon.struc.MDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;

public class RewindableMDocSource
extends MDocSource {
    private MDocSource docSource;
    private MDocument[] buffer;
    private int bufferStartRecord;
    private int bufferStartIndex;
    private int bufferLength;
    private int nextRecord;
    private int initialRecordCount;
    private long[] tempRecordPos;
    private RandomAccessFile tempFile;
    private int tempCurrentPos;
    private int tempRecord;
    private int tempRecordMax;
    private long tempFileLength;

    public RewindableMDocSource(MDocSource dp, int nbuf) {
        this.docSource = dp;
        int k = dp.getRecordCount();
        this.bufferStartIndex = 0;
        this.nextRecord = this.initialRecordCount = k;
        this.bufferStartRecord = this.initialRecordCount;
        this.bufferLength = 0;
        this.buffer = new MDocument[nbuf];
    }

    @Override
    public MDocument nextDoc() throws IOException {
        MDocument d = null;
        if (this.nextRecord >= this.bufferStartRecord && this.nextRecord < this.bufferStartRecord + this.bufferLength) {
            int k = this.nextRecord++;
            d = this.buffer[(this.bufferStartIndex + (k - this.bufferStartRecord)) % this.buffer.length];
        } else if (this.nextRecord < this.docSource.getRecordCount()) {
            d = this.readTemp();
            ++this.nextRecord;
        } else if (this.nextRecord >= this.docSource.getRecordCount()) {
            int n = this.nextRecord - this.docSource.getRecordCount() + 1;
            for (int i = 0; i < n; ++i) {
                d = this.readDocSource();
                ++this.nextRecord;
            }
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.docSource.close();
        }
        finally {
            if (this.tempFile != null) {
                this.tempFile.close();
            }
        }
    }

    @Override
    public String getDocLabel(int k, MDocument doc) {
        return this.docSource.getDocLabel(k, doc);
    }

    @Override
    public boolean skipRecord() throws IOException {
        if (this.nextRecord >= this.bufferStartRecord && this.nextRecord < this.bufferStartRecord + this.bufferLength) {
            int k = this.nextRecord++;
            return true;
        }
        if (this.nextRecord < this.docSource.getRecordCount()) {
            ++this.nextRecord;
            return true;
        }
        if (this.nextRecord == this.docSource.getRecordCount()) {
            this.readDocSource();
            ++this.nextRecord;
            return true;
        }
        return false;
    }

    private MDocument readDocSource() throws IOException {
        int i;
        int k = this.docSource.getRecordCount();
        MDocument d = this.docSource.nextDoc();
        if (this.docSource.getRecordCount() != k + 1) {
            return null;
        }
        if (k == this.bufferStartRecord + this.bufferLength) {
            if (this.bufferLength < this.buffer.length) {
                i = (this.bufferStartIndex + this.bufferLength) % this.buffer.length;
                ++this.bufferLength;
            } else {
                if (this.tempFile == null) {
                    this.createTemp();
                }
                ++this.bufferStartRecord;
                i = this.bufferStartIndex;
                this.bufferStartIndex = (this.bufferStartIndex + 1) % this.buffer.length;
            }
        } else {
            for (int j = this.bufferStartIndex; j < this.bufferLength; ++j) {
                this.buffer[(this.bufferStartIndex + j) % this.buffer.length] = null;
            }
            this.bufferStartIndex = 0;
            this.bufferStartRecord = k;
            this.bufferLength = 1;
            i = 0;
        }
        this.buffer[i] = d;
        if (this.docSource.getRecordCount() - this.initialRecordCount > this.buffer.length) {
            this.writeTemp(i);
        }
        return d;
    }

    private MDocument readTemp() throws IOException {
        int i;
        MDocument d;
        int k = this.nextRecord;
        long pos = this.tempRecordPos[k - this.initialRecordCount];
        long pos2 = this.tempRecordPos[k + 1 - this.initialRecordCount];
        if (k != this.tempCurrentPos + this.initialRecordCount) {
            this.tempFile.seek(pos);
        }
        int n = (int)(pos2 - pos);
        byte[] data = new byte[n];
        this.tempFile.readFully(data);
        ++this.tempCurrentPos;
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            d = (MDocument)ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Invalid temporary file");
        }
        if (k == this.bufferStartRecord + this.bufferLength) {
            if (this.bufferLength < this.buffer.length) {
                i = (this.bufferStartIndex + this.bufferLength) % this.buffer.length;
                ++this.bufferLength;
            } else {
                ++this.bufferStartRecord;
                i = this.bufferStartIndex;
                this.bufferStartIndex = (this.bufferStartIndex + 1) % this.buffer.length;
            }
        } else {
            this.resetBuffer(k);
            i = 0;
        }
        this.buffer[i] = d;
        return d;
    }

    private void createTemp() throws IOException {
        File f = File.createTempFile("marvin", null);
        f.deleteOnExit();
        this.tempFile = new RandomAccessFile(f, "rw");
        this.tempCurrentPos = 0;
        this.tempRecordMax = 0;
        this.tempFileLength = 0L;
        this.tempRecordPos = new long[this.bufferLength + 1];
        this.tempRecordPos[0] = 0L;
        for (int j = 0; j < this.bufferLength; ++j) {
            int i = (this.bufferStartIndex + j) % this.buffer.length;
            this.writeTemp(i);
        }
    }

    private void writeTemp(int i) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        MDocument d = this.buffer[i];
        oos.writeObject(d);
        oos.flush();
        byte[] data = baos.toByteArray();
        if (this.tempRecord < this.tempRecordMax) {
            this.tempFile.seek(this.tempFile.length());
            this.tempCurrentPos = this.tempRecordMax;
        }
        this.tempFile.write(data);
        ++this.tempCurrentPos;
        ++this.tempRecordMax;
        if (this.tempRecordMax >= this.tempRecordPos.length) {
            long[] t = new long[(this.tempRecordMax + 2) * 3 / 2];
            System.arraycopy(this.tempRecordPos, 0, t, 0, this.tempRecordPos.length);
            this.tempRecordPos = t;
        }
        this.tempFileLength += (long)data.length;
        this.tempRecordPos[this.tempRecordMax] = this.tempFileLength;
    }

    private void resetBuffer(int k) {
        for (int j = this.bufferStartIndex; j < this.bufferLength; ++j) {
            this.buffer[(this.bufferStartIndex + j) % this.buffer.length] = null;
        }
        this.bufferStartIndex = 0;
        this.bufferStartRecord = k;
        this.bufferLength = 1;
    }

    @Override
    public boolean isRewindable() {
        return true;
    }

    @Override
    public void seekRecord(int k, MProgressMonitor pmon) throws EOFException, IOException {
        int k2;
        if (k == this.nextRecord) {
            return;
        }
        if (k > this.nextRecord && (k2 = this.seekForward(k, pmon, 0, null)) != k) {
            throw new EOFException("Cannot seek beyond end of file.");
        }
        this.nextRecord = k;
    }

    @Override
    protected void seekVisitedRecord(int k) throws IOException {
        this.nextRecord = k;
    }

    @Override
    public boolean isEndReached() {
        return this.docSource.isEndReached();
    }

    @Override
    public int getRecordCount() {
        return this.nextRecord;
    }

    @Override
    public int getRecordCountMax() {
        return this.docSource.getRecordCount();
    }

    @Override
    public int estimateNumRecords() {
        return this.docSource.estimateNumRecords();
    }
}

