/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.fieldaccess;

import chemaxon.marvin.io.MFieldAccessor;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.prop.MStringProp;
import java.util.HashSet;
import java.util.Set;

public class MoleculeFieldAccessor
extends MFieldAccessor {
    @Override
    public Molecule getMainMolecule(int irec, Molecule mol) {
        return mol;
    }

    @Override
    public String[] getKeys(int irec, Molecule mol) {
        MPropertyContainer props = mol.properties();
        int n = props.size();
        String[] keys = new String[n];
        for (int i = 0; i < n; ++i) {
            keys[i] = props.getKey(i);
        }
        return keys;
    }

    @Override
    public void getFields(int irec, Molecule mol, String[] keys, MProp[] values) {
        HashSet<String> used = new HashSet<String>();
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (key == null) {
                values[i] = null;
                continue;
            }
            boolean left = MoleculeFieldAccessor.isLeft(key);
            boolean right = MoleculeFieldAccessor.isRight(key);
            if (mol == null) {
                values[i] = new MStringProp("");
                continue;
            }
            if (left || right) {
                String val = this.textFieldValue(mol, keys, irec, i, left, right, used);
                values[i] = new MStringProp(val);
                continue;
            }
            MProp p = mol.properties().get(key);
            values[i] = p != null ? p : new MStringProp("");
        }
    }

    @Override
    public void setFields(int irec, Molecule mol, String[] keys, MProp[] values) {
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (mol == null || !this.isEditable(irec, mol, key)) continue;
            mol.properties().set(key, values[i]);
        }
    }

    @Override
    public boolean isEditable(int irec, Molecule mol, String key) {
        return key != null && !MoleculeFieldAccessor.isLeft(key) && !MoleculeFieldAccessor.isRight(key);
    }

    public static boolean isSpecialKey(String key) {
        return MoleculeFieldAccessor.isLeft(key) || MoleculeFieldAccessor.isRight(key) || key.equals("*");
    }

    private static boolean isLeft(String key) {
        return key.equals("[*") || key.equals("[*]");
    }

    private static boolean isRight(String key) {
        return key.equals("*]") || key.equals("[*]");
    }

    private String textFieldValue(Molecule mol, String[] keys, int irec, int i, boolean left, boolean right, Set<String> used) {
        String key = keys[i];
        if (key == null || key.equals("*") || left || right) {
            StringBuffer sb = new StringBuffer();
            boolean foundfirst = false;
            for (int j = 0; j < mol.getPropertyCount(); ++j) {
                key = mol.getPropertyKey(j);
                if (key.equalsIgnoreCase("$REGNO")) continue;
                if (left && !foundfirst) {
                    if (i == 0 || !key.equals(keys[i - 1])) continue;
                    foundfirst = true;
                    continue;
                }
                if (right && i < keys.length - 1 && key.equals(keys[i + 1])) break;
                if (used.contains(key)) continue;
                MProp p = mol.properties().get(key);
                if (sb.length() != 0) {
                    sb.append('\n');
                }
                sb.append(key);
                if (key.indexOf(58) >= 0) {
                    sb.append("\n= ");
                } else {
                    sb.append(" = ");
                }
                sb.append(this.propToString(p));
                used.add(key);
            }
            return sb.toString();
        }
        used.add(key);
        return mol.getProperty(key);
    }
}

