/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.zip.GZIPOutputStream;

public class GzipExport
extends MolExportModule {
    private MolExportModule exporter2;
    private ByteArrayOutputStream byteArrayOutputStream;
    private GZIPOutputStream gzipOutputStream;

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        Object o;
        String fmt2 = "Mol";
        int i = fmtopts != null ? fmtopts.indexOf(58) : -1;
        String fmtopts2 = i >= 0 ? fmtopts.substring(i + 1) : "";
        int compressionLevel = 57;
        if (fmtopts2 != null) {
            char c;
            if (fmtopts2.length() > 0 && (c = fmtopts2.charAt(0)) >= '0' && c <= '9') {
                compressionLevel = c - 48;
                fmtopts2 = fmtopts2.substring(1);
            }
            fmt2 = (i = fmtopts2.indexOf(58)) >= 0 ? fmtopts2.substring(0, i) : fmtopts2;
        }
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.gzipOutputStream = new GZIPOutputStream(this.byteArrayOutputStream);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.exporter2 = MFileFormatUtil.createExportModule(fmt2);
        if (this.exporter2 != null && (o = this.exporter2.open(fmtopts2, props)) != null) {
            byte[] data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
            try {
                this.gzipOutputStream.write(data);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        if (this.exporter2 == null) {
            return null;
        }
        Object o = this.exporter2.convert(mol);
        byte[] data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
        try {
            this.gzipOutputStream.write(data);
        }
        catch (IOException ex) {
            throw new MolExportException(ex);
        }
        data = this.byteArrayOutputStream.toByteArray();
        this.byteArrayOutputStream.reset();
        return data;
    }

    @Override
    public Object close() throws MolExportException {
        byte[] data;
        Object o = this.exporter2.close();
        try {
            if (o != null) {
                data = o instanceof String ? ((String)o).getBytes() : (byte[])o;
                this.gzipOutputStream.write(data);
            }
            this.gzipOutputStream.close();
        }
        catch (IOException ex) {
            throw new MolExportException(ex.getMessage());
        }
        data = null;
        if (this.byteArrayOutputStream.size() != 0) {
            data = this.byteArrayOutputStream.toByteArray();
            this.byteArrayOutputStream.reset();
        }
        return data;
    }
}

