/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.formats.recognizer.NucleicAcidRecognizer;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.NucleicAcidSource;
import chemaxon.marvin.io.formats.abbrevgroup.AbbrevGroupImport;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class NucleicAcidImport
extends MolImportModule {
    private MolInputStream istream;
    private boolean isRNA;

    @Override
    public void setOptions(String options) {
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.istream = is;
        this.isRNA = !is.getFormat().equals("dna");
    }

    @Override
    public boolean readMol(Molecule m) throws IOException {
        boolean isCorrectFormat;
        String abbrevType = this.isRNA ? "RNA" : "DNA";
        m.clearForImport("nucleicacid:" + abbrevType);
        String line = this.istream.readLine();
        boolean bl = isCorrectFormat = line != null && !line.equals("");
        if (isCorrectFormat) {
            isCorrectFormat = this.isRNA ? NucleicAcidRecognizer.canBeRNASequence(line) : NucleicAcidRecognizer.canBeDNASequence(line);
        }
        if (!isCorrectFormat && line != null) {
            int maxReportLength = 50;
            if (line.length() > maxReportLength) {
                line = line.substring(0, maxReportLength) + "...";
            }
            throw new MolFormatException("Incorrect nucleic acid format: " + line + "\n Use " + "dA, dC, dG, dT to import DNA and A, C, G, U to import RNA");
        }
        if (isCorrectFormat) {
            try {
                int brInd = line.indexOf(123);
                if (brInd > -1) {
                    line = line.substring(0, brInd);
                }
                Molecule mol = new Molecule();
                NucleicAcidImport.convert(mol, line);
                m.fuse(mol);
                m.clean(2, "");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new MolFormatException(line + " : error in molecule file");
            }
        }
        return isCorrectFormat;
    }

    private static void convert(Molecule mol, String line) throws MolFormatException {
        Vector naStr;
        Vector<String> naNames = new Vector<String>();
        NucleicAcidSource nas = NucleicAcidSource.getInstance();
        String[] NAMES_1_LETTER = nas.getImportNames();
        for (int i = 0; i < NAMES_1_LETTER.length; ++i) {
            naNames.add(NAMES_1_LETTER[i]);
        }
        Vector<String> abbrevV = new Vector<String>();
        for (int i = 0; i < NAMES_1_LETTER.length; ++i) {
            abbrevV.add(NAMES_1_LETTER[i]);
        }
        int[] firstStrap = nas.getImportFirtsAttachPoints();
        int[] secondStrap = nas.getImportSecondAttachPoints();
        Vector naSMILES = nas.getSMILESVector();
        line = NucleicAcidImport.addDelimiters(line);
        try {
            naStr = NucleicAcidImport.findBases(naNames, line);
        }
        catch (MolFormatException mfex) {
            mfex.printStackTrace();
            throw new MolFormatException("Could not find nucleic acid in string " + line);
        }
        if (naStr != null) {
            NucleicAcidImport.build(mol, naStr, naNames, naSMILES, firstStrap, secondStrap, abbrevV);
        }
    }

    private static String addDelimiters(String line) {
        int start = 0;
        int end = line.length();
        String newName = "";
        StringCharacterIterator cit = new StringCharacterIterator(line, start, end, start);
        char ch = cit.first();
        while (ch != '\uffff') {
            if (ch == 'X') {
                newName = newName + ch;
                do {
                    ch = cit.next();
                    newName = newName + ch;
                } while (ch != ')' && ch != '\uffff');
                newName = newName + "-";
            } else if (ch != '-') {
                if (ch != 'd') {
                    newName = newName + ch + "-";
                } else {
                    newName = newName + ch;
                    newName = newName + cit.next() + "-";
                }
            } else {
                newName = newName + ch;
            }
            ch = cit.next();
        }
        return newName;
    }

    private static Vector findBases(Vector naNames, String line) throws MolFormatException {
        Vector<String> bases = new Vector<String>();
        StringTokenizer st = new StringTokenizer(line, "-");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (naNames.contains(token)) {
                bases.add(token);
                continue;
            }
            throw new MolFormatException("Unknow nucleic acid " + token);
        }
        return bases;
    }

    private static Molecule build(Molecule mol, Vector naStr, Vector naNames, Vector naSMILES, int[] firstStrap, int[] secondStrap, Vector longAbbrevs) {
        if (naStr.size() > 0) {
            MolAtom rightAtom = null;
            for (int i = 0; i < naStr.size(); ++i) {
                Molecule na = new Molecule();
                String abbrev = (String)naStr.elementAt(i);
                int naIdx = naNames.indexOf(abbrev);
                int firstLink = firstStrap[naIdx];
                int secondLink = secondStrap[naIdx];
                String abbrevStr = NucleicAcidImport.makeAbbrevString(na, firstLink, secondLink, naIdx, naSMILES, longAbbrevs);
                NucleicAcidImport.readAbbrev(na, abbrevStr);
                block5: for (int j = 0; j < na.getAtomCount(); ++j) {
                    MolAtom a = na.getAtom(j);
                    switch (a.getAttach()) {
                        case 1: {
                            firstLink = j + 1;
                            continue block5;
                        }
                        case 2: {
                            secondLink = j + 1;
                            continue block5;
                        }
                    }
                }
                MolAtom leftAtom = na.getAtom(firstLink - 1);
                mol.fuse(na);
                if (leftAtom != null && rightAtom != null) {
                    mol.add(new MolBond(leftAtom, rightAtom));
                }
                rightAtom = na.getAtom(secondLink - 1);
            }
            mol.contractSgroups();
        }
        return mol;
    }

    private static void readAbbrev(Molecule mol, String str) {
        try {
            MolInputStream mis = new MolInputStream((InputStream)new ByteArrayInputStream(str.getBytes()), "abbrevgroup");
            AbbrevGroupImport mii = new AbbrevGroupImport();
            ((MolImportModule)mii).initMolImport(mis);
            ((MolImportModule)mii).readMol(mol);
        }
        catch (Exception e) {
            System.out.println("Could not read abbreviation string " + str);
            e.printStackTrace();
        }
    }

    private static String makeAbbrevString(Molecule na, int firstLink, int secondLink, int naIdx, Vector naSMILES, Vector longAbbrevs) {
        String naSmiles = (String)naSMILES.elementAt(naIdx);
        String sgroupName = (String)longAbbrevs.elementAt(naIdx);
        String abbrevStr = sgroupName + "\t" + naSmiles + "\t" + firstLink + "\t" + secondLink;
        NucleicAcidImport.readAbbrev(na, abbrevStr);
        block10: for (int j = 0; j < na.getAtomCount(); ++j) {
            MolAtom a = na.getAtom(j);
            a.clearQProps();
            int attachInfo = a.getAttach();
            switch (attachInfo) {
                case 1: {
                    a.setAtomMap(1);
                    continue block10;
                }
                case 2: {
                    a.setAtomMap(2);
                    continue block10;
                }
            }
        }
        naSmiles = na.toFormat("smiles");
        SmilesImport si = new SmilesImport();
        try {
            si.readMol(naSmiles, na);
            block11: for (int i = 0; i < na.getAtomCount(); ++i) {
                MolAtom a = na.getAtom(i);
                switch (a.getAtomMap()) {
                    case 1: {
                        a.setAtomMap(0);
                        firstLink = i + 1;
                        continue block11;
                    }
                    case 2: {
                        a.setAtomMap(0);
                        secondLink = i + 1;
                        continue block11;
                    }
                }
            }
            naSmiles = na.toFormat("smiles");
            abbrevStr = sgroupName + "\t" + naSmiles + "\t" + firstLink + "\t" + secondLink;
        }
        catch (IOException e) {
            System.err.println("Could not generate molecule from " + naSmiles + " during nucleic acid import.");
            e.printStackTrace();
            abbrevStr = "";
        }
        return abbrevStr;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }
}

