/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class SingleLineRecordReader
extends AbstractMRecordReader {
    protected String[] fieldNames;

    public SingleLineRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        String line = this.readLine();
        if (line == null) {
            return;
        }
        this.fieldNames = this.parseFieldNamesFromHeaderRow(line);
        if (this.fieldNames == null) {
            this.putBackLine();
        }
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        String line;
        long startpos = this.getFilePointer();
        StringBuffer sb = new StringBuffer();
        do {
            if ((line = this.readLine()) == null) continue;
            this.appendLine(sb, line);
        } while (line != null && this.isComment(line));
        if (line != null) {
            int lineno = this.getLineCount() - 1;
            long endpos = this.getFilePointer();
            int[] map = this.endRecord(false);
            MPropertyContainer pc = new MPropertyContainer();
            String s = line = this.parseFields(line, pc);
            if (s != null && !s.endsWith("\n") && !s.endsWith("\r")) {
                s = s + "\n";
            }
            return new MRecord(startpos, endpos, lineno, s, pc, map);
        }
        return null;
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        String line;
        long startpos = this.getFilePointer();
        while ((line = this.readLine()) != null && this.isComment(line)) {
        }
        if (line != null) {
            int lineno = this.getLineCount() - 1;
            long endpos = this.getFilePointer();
            return new MRecord(startpos, endpos, lineno, null, null, null);
        }
        return null;
    }

    protected boolean isComment(String line) {
        return line.startsWith("#");
    }

    protected String[] parseFieldNamesFromHeaderRow(String line) {
        return null;
    }

    protected String parseFields(String line, MPropertyContainer pc) {
        return line;
    }
}

