/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.Encoding;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.util.text.EncodingUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class XmlImport {
    private static final boolean[] NEEDS_CDATA = new boolean[256];
    protected PositionedInputStream inputStream;
    private boolean tagClosing;
    private boolean tagSingle;
    private boolean readingTagProperties;
    private long currentLineFilePos;
    private long currentTagFilePos;
    private long lastTokenStartPos;
    private int currentColumn;
    private int lastLessThanColumn;
    private int cdataLength;
    private String currentLine;
    private String grabbedHeader;
    private Properties tagProperties = new Properties();
    private boolean containsSpecialSpace = false;
    private static final Properties xmlEscapedChars;

    protected void initImport(PositionedInputStream is) throws IOException {
        String s;
        this.inputStream = is;
        this.currentLine = null;
        this.currentLineFilePos = 0L;
        this.currentColumn = 0;
        this.lastLessThanColumn = -1;
        this.lastTokenStartPos = 0L;
        this.cdataLength = 0;
        do {
            this.currentLine = s = this.readLine();
        } while (s != null && (s = s.trim().toLowerCase()).length() == 0);
        if (s.startsWith("<?xml ")) {
            StringBuilder grabsb = new StringBuilder();
            while ((s = this.nextToken(grabsb)) != null) {
                if (s.equalsIgnoreCase("encoding=")) {
                    int start = grabsb.length();
                    s = this.nextToken(grabsb);
                    if (s == null) break;
                    grabsb.setLength(start);
                    grabsb.append('\"');
                    Encoding origenc = this.inputStream.getEncoding();
                    if (origenc == null) {
                        this.inputStream.setEncoding(s);
                    }
                    grabsb.append(this.inputStream.getEncoding().name());
                    grabsb.append('\"');
                }
                if (!s.equals(">")) continue;
            }
            this.grabbedHeader = grabsb.toString();
        } else {
            this.putBackLine();
            this.currentLine = null;
            this.grabbedHeader = null;
        }
    }

    public String getTagProperty(String key) {
        String s = this.getTagPropertyEscaped(key);
        return s != null ? XmlImport.unescapeString(s) : null;
    }

    protected String getTagPropertyEscaped(String key) {
        return this.tagProperties.getProperty(key.toLowerCase());
    }

    protected Integer getTagPropertyAsInteger(String key) {
        String s = this.getTagPropertyEscaped(key);
        if (s != null) {
            try {
                if (s.startsWith("+")) {
                    s = s.substring(1);
                }
                return Integer.valueOf(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    protected double[] getTagPropertyAsDoubleArray(String key) throws IOException {
        String s = this.getTagPropertyEscaped(key);
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s);
            int n = st.countTokens();
            try {
                double[] x = new double[n];
                for (int i = 0; i < n; ++i) {
                    x[i] = Double.valueOf(st.nextToken());
                }
                return x;
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("invalid number in floating point array");
            }
        }
        return null;
    }

    protected void addTagProperties(Properties hash) {
        Enumeration<Object> en = this.tagProperties.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = this.tagProperties.getProperty(key);
            hash.put(key, XmlImport.unescapeString(val));
        }
    }

    protected String getGrabbedHeader() {
        return this.grabbedHeader;
    }

    protected long getCurrentTagFilePos() {
        return this.currentTagFilePos;
    }

    protected int getCurrentTagColumn() {
        return this.lastLessThanColumn;
    }

    public boolean isTagClosing() {
        return this.tagClosing;
    }

    public boolean isTagSingle() {
        return this.tagSingle;
    }

    protected void skipTag(String name, StringBuilder grabsb) throws IOException {
        String s;
        name = name.toLowerCase();
        while ((s = this.readNextTag(grabsb)) != null) {
            s = s.toLowerCase();
            if (!this.isTagClosing()) {
                this.skipTag(s, grabsb);
                continue;
            }
            if (this.isTagSingle()) continue;
            if (s.equals(name)) {
                return;
            }
            throw new MolFormatException("unexpected tag closing");
        }
        throw new MolFormatException("unexpected end of file while skipping tag '" + name + "'");
    }

    public String readNextTag(StringBuilder grabsb) throws IOException {
        this.tagClosing = false;
        String s = this.readTillNextTag(grabsb, null);
        if (s != null && !this.tagClosing) {
            boolean beg = this.readTagProperties(s, grabsb);
            this.tagClosing = !beg;
            this.tagSingle = !beg;
        }
        return s;
    }

    protected String readTillNextTag(StringBuilder grabsb, StringBuilder restLine) throws IOException {
        String s;
        while ((s = this.nextToken(grabsb)) != null) {
            if (s.equals("<![CDATA[")) {
                this.readCdata(grabsb);
                continue;
            }
            if (s.startsWith("<!--")) {
                while ((s = this.nextToken(grabsb)) != null && !s.equals("-->")) {
                }
                continue;
            }
            if (s.startsWith("<!")) {
                while ((s = this.nextToken(grabsb)) != null && !s.equals(">")) {
                }
                continue;
            }
            if (s.startsWith("</")) {
                this.tagClosing = true;
                this.tagSingle = false;
                String ss = this.nextToken(grabsb);
                if (!ss.equals(">")) {
                    throw new MolFormatException("'>' expected");
                }
                this.currentTagFilePos = this.currentLineFilePos + (long)this.currentLine.length() + (long)this.cdataLength;
                for (int i = this.currentColumn; i < this.currentLine.length(); ++i) {
                    char c = this.currentLine.charAt(i);
                    if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
                    this.currentTagFilePos = this.currentLineFilePos + (long)i + (long)this.cdataLength;
                    break;
                }
                s = s.substring(2);
                return s;
            }
            if (!s.startsWith("<")) continue;
            this.currentTagFilePos = this.lastTokenStartPos;
            s = s.substring(1);
            if (restLine != null) {
                restLine.append(this.currentLine.substring(this.currentColumn));
            }
            return s;
        }
        return null;
    }

    protected String getCurrentLine() {
        return this.currentLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean readTagProperties(String tagName, StringBuilder grabsb) throws IOException {
        this.tagProperties.clear();
        this.readingTagProperties = true;
        try {
            String s;
            while ((s = this.nextToken(grabsb)) != null) {
                if (s.equals(">")) {
                    boolean bl = true;
                    return bl;
                }
                if (s.equals("/>")) {
                    this.readingTagProperties = false;
                    boolean bl = false;
                    return bl;
                }
                String name = s;
                s = this.nextToken(grabsb);
                if (!s.equals("=")) {
                    throw new MolFormatException("Bad <" + tagName + " " + name + "=...> syntax" + ", = missing");
                }
                String val = this.nextToken(grabsb);
                if (val == null) {
                    throw new MolFormatException("Bad <" + tagName + " " + name + "=...> syntax" + ", value missing");
                }
                this.tagProperties.put(name.toLowerCase(), val);
            }
        }
        finally {
            this.readingTagProperties = false;
        }
        return false;
    }

    protected void readClosing(String key, StringBuilder grabsb) throws IOException {
        String s = this.nextToken(grabsb);
        if (s == null) {
            throw new MolFormatException("Premature end of file");
        }
        if (s.startsWith("</")) {
            this.readKet(key, grabsb);
            if (!s.equals("</" + key)) {
                throw new MolFormatException("Bad <" + key + "> closing " + s + ">");
            }
        } else {
            throw new MolFormatException("Closing tag expected for <" + key + ">, not " + s);
        }
        this.currentTagFilePos = this.currentLineFilePos + (long)this.currentColumn;
    }

    protected void readKet(String key, StringBuilder grabsb) throws IOException {
        String s = this.nextToken(grabsb);
        if (s == null) {
            throw new MolFormatException("Premature end of file");
        }
        if (!s.equals(">")) {
            throw new MolFormatException("Bad <" + key + "> closing");
        }
    }

    protected String readData(StringBuilder grabsb) throws IOException {
        if (!(this.currentColumn >= this.currentLine.length() || this.currentLine.charAt(this.currentColumn) != '<' || this.currentLine.length() >= this.currentColumn + 9 && this.currentLine.substring(this.currentColumn, this.currentColumn + 9).equals("<![CDATA["))) {
            return "";
        }
        String v = this.nextToken(grabsb);
        if (v.equals("<![CDATA[")) {
            v = this.readCdata(grabsb);
        }
        v = EncodingUtil.unescape(v);
        return v;
    }

    protected String nextToken(StringBuilder grabsb) throws IOException {
        String s;
        while ((s = this.nextToken0(false, grabsb)) != null) {
            if (s.equals("\"")) {
                StringBuilder sbuf = new StringBuilder();
                while ((s = this.nextToken0(true, grabsb)) != null && !s.equals("\"")) {
                    sbuf.append(s);
                }
                s = sbuf.toString();
                break;
            }
            if (s.equals("'")) {
                StringBuilder sbuf = new StringBuilder();
                while ((s = this.nextToken0(true, grabsb)) != null && !s.equals("'")) {
                    sbuf.append(s);
                }
                s = sbuf.toString();
                break;
            }
            if (s.length() == 0) continue;
            break;
        }
        return s;
    }

    private String nextToken0(boolean quoted, StringBuilder grabsb) throws IOException {
        if (this.currentLine == null || this.currentColumn >= this.currentLine.length()) {
            this.currentColumn = 0;
            this.currentLineFilePos = this.inputStream.getFilePointer();
            this.currentLine = this.readLine();
            if (this.currentLine == null) {
                return null;
            }
            this.currentLine = this.currentLine + "\n";
            this.cdataLength = 0;
        }
        int startcol = this.currentColumn;
        String s = this.nextToken00(quoted);
        if (grabsb != null) {
            String tmp = this.currentLine.substring(startcol, this.currentColumn);
            if (this.containsSpecialSpace) {
                byte[] a = new byte[tmp.length()];
                a = tmp.getBytes();
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != -96) continue;
                    a[i] = 10;
                }
                tmp = new String(a);
                this.containsSpecialSpace = false;
            }
            grabsb.append(tmp);
        }
        return s;
    }

    private String nextToken00(boolean quoted) throws IOException {
        StringBuilder sbuf = new StringBuilder();
        while (this.currentColumn < this.currentLine.length()) {
            char c = this.currentLine.charAt(this.currentColumn);
            ++this.currentColumn;
            if (quoted) {
                if (c == '\"') {
                    if (sbuf.length() == 0) {
                        this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                        return "\"";
                    }
                    --this.currentColumn;
                    return sbuf.toString();
                }
                if (c == '\'') {
                    if (sbuf.length() == 0) {
                        this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                        return "'";
                    }
                    --this.currentColumn;
                    return sbuf.toString();
                }
                if (sbuf.length() == 0) {
                    this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                }
                if (c == '&') {
                    int j = this.currentLine.indexOf(59, this.currentColumn);
                    if (j >= this.currentColumn) {
                        sbuf.append(this.currentLine.substring(this.currentColumn - 1, j + 1));
                        this.currentColumn = j + 1;
                        continue;
                    }
                    sbuf.append(c);
                    continue;
                }
                sbuf.append(c);
                continue;
            }
            if (c == '&') {
                int j = this.currentLine.indexOf(59, this.currentColumn);
                if (j >= this.currentColumn) {
                    sbuf.append(this.currentLine.substring(this.currentColumn - 1, j + 1));
                    this.currentColumn = j + 1;
                    continue;
                }
                sbuf.append(c);
                continue;
            }
            if (c == '<') {
                String l = this.currentLine;
                int i = this.currentColumn;
                this.lastLessThanColumn = i - 1;
                if (l.length() > i + 7 && l.charAt(i + 0) == '!' && l.charAt(i + 1) == '[' && l.charAt(i + 2) == 'C' && l.charAt(i + 3) == 'D' && l.charAt(i + 4) == 'A' && l.charAt(i + 5) == 'T' && l.charAt(i + 6) == 'A' && l.charAt(i + 7) == '[') {
                    this.currentColumn += 8;
                    return "<![CDATA[";
                }
                if (sbuf.length() == 0) {
                    this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                    sbuf.append(c);
                    continue;
                }
                --this.currentColumn;
                return sbuf.toString();
            }
            if (c == '>' && sbuf.toString().endsWith("--")) {
                if (sbuf.length() == 2) {
                    sbuf.append(c);
                    return sbuf.toString();
                }
                this.currentColumn -= 3;
                return sbuf.toString().substring(0, sbuf.length() - 2);
            }
            if (c == '>' && sbuf.length() == 1 && sbuf.charAt(0) == '/') {
                sbuf.append(c);
                return sbuf.toString();
            }
            if (!(NEEDS_CDATA[c] && (quoted || this.readingTagProperties || c != '\"' && c != '\'') || c == '=' && this.readingTagProperties)) {
                if (sbuf.length() == 0) {
                    this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                }
                sbuf.append(c);
                continue;
            }
            if (Character.isWhitespace(c) || Character.isSpaceChar(c)) {
                if (" \t\n".indexOf(c) < 0) {
                    this.containsSpecialSpace = true;
                }
                if (sbuf.length() == 0) continue;
                return sbuf.toString();
            }
            if (sbuf.length() == 0) {
                this.lastTokenStartPos = this.currentLineFilePos + (long)this.currentColumn - 1L;
                return String.valueOf(c);
            }
            --this.currentColumn;
            if (c == '>' && sbuf.charAt(sbuf.length() - 1) == '/') {
                sbuf.deleteCharAt(sbuf.length() - 1);
                --this.currentColumn;
            }
            return sbuf.toString();
        }
        return sbuf.toString();
    }

    protected static String unescapeString(String str) {
        if (str.indexOf(38) < 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '&') {
                int j = str.indexOf(59, i + 1);
                if (j >= 0) {
                    String s;
                    if (str.charAt(i + 1) == '#') {
                        try {
                            s = str.substring(i + 2, j);
                            int k = Integer.parseInt(s);
                            sb.append((char)k);
                            i = j;
                        }
                        catch (NumberFormatException ex) {
                            sb.append(c);
                        }
                        continue;
                    }
                    s = str.substring(i, j + 1);
                    String v = xmlEscapedChars.getProperty(s);
                    if (v != null) {
                        sb.append(v);
                        i += s.length() - v.length();
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected String readLine() throws IOException {
        String s = this.inputStream.readLine();
        return s;
    }

    protected void putBackLine() throws IOException {
        this.putBackLine(0);
    }

    protected void putBackLine(int col) throws IOException {
        if (this.inputStream == null) {
            throw new IOException("cannot put line back into closed input stream");
        }
        this.inputStream.putBackLine(col);
        this.currentColumn = this.currentLine.length();
    }

    private String readCdata(StringBuilder grabsb) throws IOException {
        int startcol = this.currentColumn;
        StringBuffer sbuf = new StringBuffer();
        block0: while (true) {
            int i;
            if ((i = this.currentLine.indexOf("]]>", this.currentColumn)) >= 0) {
                sbuf.append(this.currentLine.substring(this.currentColumn, i));
                this.currentColumn = i += 3;
                while (this.currentLine.length() >= i + 6 && this.currentLine.substring(i, i + 6).equals("]]&gt;")) {
                    sbuf.append("]]>");
                    this.currentColumn = i += 6;
                    if (this.currentLine.length() < i + 9 || !this.currentLine.substring(i, i + 9).equals("<![CDATA[")) continue;
                    this.currentColumn = i += 9;
                    continue block0;
                }
                if (grabsb != null) {
                    grabsb.append(this.currentLine.substring(startcol, this.currentColumn));
                }
                return sbuf.toString();
            }
            this.cdataLength += this.currentLine.length();
            sbuf.append(this.currentLine.substring(this.currentColumn));
            if (grabsb != null) {
                grabsb.append(this.currentLine.substring(startcol));
                startcol = 0;
            }
            this.currentLine = this.readLine();
            if (this.currentLine == null) {
                return sbuf.toString();
            }
            this.currentLine = this.currentLine + "\n";
            this.currentColumn = 0;
        }
    }

    static {
        for (int c = 0; c < 256; ++c) {
            if (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || "*\\/!?+-%$^=.,_#()[]{}:~|".indexOf(c) >= 0) continue;
            XmlImport.NEEDS_CDATA[c] = true;
        }
        xmlEscapedChars = new Properties();
        xmlEscapedChars.put("&gt;", ">");
        xmlEscapedChars.put("&lt;", "<");
        xmlEscapedChars.put("&amp;", "&");
    }
}

