/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cdx;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.cdx.CDXConstants;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextAttributes;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.graphics.MTextDocument;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CDXExport
extends MolExportModule
implements CDXConstants {
    String format = "cdx";
    int cID = 1;
    double cdxBondLength = 1966080.0;
    boolean is3d = false;
    int xShift = 0;
    int yShift = 0;
    MFont defFont = new MFont("SansSerif", 0, 12.0);
    String encoding;

    @Override
    public boolean isDocumentExport() {
        return true;
    }

    private void addBracketedGroup(Sgroup sg, HashMap id, ByteArrayOutputStream out) throws IOException {
        SelectionMolecule mg = sg.getSgroupGraph();
        ArrayList<MBracket> braList = sg.getBrackets();
        if (braList == null) {
            double xmin = Double.MAX_VALUE;
            double xmax = -1.7976931348623157E308;
            double ymin = Double.MAX_VALUE;
            double ymax = -1.7976931348623157E308;
            for (int i = mg.getAtomCount() - 1; i >= 0; --i) {
                MolAtom atom = mg.getAtom(i);
                double x = atom.getX();
                xmin = Math.min(x, xmin);
                xmax = Math.max(x, xmax);
                double y = atom.getY();
                ymin = Math.min(y, ymin);
                ymax = Math.max(y, ymax);
            }
            DPoint3 topLeft = new DPoint3(xmin, ymin, 0.0);
            DPoint3 bottomRigth = new DPoint3(xmax, ymax, 0.0);
            int rightBracket = this.cID;
            this.addRigthBracket(topLeft, bottomRigth, sg, out, true, 1);
            int leftBracket = this.cID;
            this.addLeftBracket(topLeft, bottomRigth, out, true, 1);
            this.writeInt16(32791, out);
            this.writeInt32(this.cID, out);
            ++this.cID;
            this.addGrapAttach(rightBracket, out);
            this.addGrapAttach(leftBracket, out);
        } else {
            int[] bracketIndexes = new int[braList.size()];
            for (int i = 0; i < braList.size(); ++i) {
                bracketIndexes[i] = this.cID;
                MBracket mb = braList.get(i);
                MPoint[] points = mb.getPoints();
                double xmin = Double.MAX_VALUE;
                double xmax = -1.7976931348623157E308;
                double ymin = Double.MAX_VALUE;
                double ymax = -1.7976931348623157E308;
                for (int j = 0; j < points.length; ++j) {
                    double x = points[j].getLocation().x;
                    xmin = Math.min(x, xmin);
                    xmax = Math.max(x, xmax);
                    double y = -points[j].getLocation().y;
                    ymin = Math.min(y, ymin);
                    ymax = Math.max(y, ymax);
                }
                DPoint3 topLeft = new DPoint3(xmin, ymin, 0.0);
                DPoint3 bottomRigth = new DPoint3(xmax, ymax, 0.0);
                int rightBracket = this.cID;
                this.addRigthBracket(topLeft, bottomRigth, sg, out, false, mb.getType());
                int leftBracket = this.cID;
                this.addLeftBracket(topLeft, bottomRigth, out, false, mb.getType());
                this.writeInt16(32791, out);
                this.writeInt32(this.cID, out);
                ++this.cID;
                this.addGrapAttach(rightBracket, out);
                this.addGrapAttach(leftBracket, out);
            }
        }
        this.writeBracketUsage(sg, out);
        this.writeRepeatPattern(sg, out);
        this.writeFlipType(sg, out);
        this.writeRepatCount(sg, out);
        MolAtom[] mas = mg.getAtomArray();
        this.writeInt16(2599, out);
        int prop_a27_length = 4 * mas.length;
        if (prop_a27_length > 65535) {
            this.writeInt16(65535, out);
            this.writeInt32(prop_a27_length, out);
        } else {
            this.writeInt16(prop_a27_length, out);
        }
        for (MolAtom ma : mas) {
            String atomIdAsString = (String)id.get(ma);
            int atomId = Integer.parseInt(atomIdAsString);
            this.writeInt32(atomId, out);
        }
        this.end(out);
    }

    private void writeFlipType(Sgroup sg, ByteArrayOutputStream out) throws IOException {
        if (sg instanceof RepeatingUnitSgroup) {
            RepeatingUnitSgroup rsg = (RepeatingUnitSgroup)sg;
            this.writeInt16(2598, out);
            this.writeInt16(2, out);
            if (rsg.isFlipped()) {
                this.writeInt16(2, out);
            } else {
                this.writeInt16(1, out);
            }
            String sruLabel = rsg.getSubscript();
            this.writeInt16(2602, out);
            if (sruLabel.length() + 2 > 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(sruLabel.length() + 2, out);
            } else {
                this.writeInt16(sruLabel.length() + 2, out);
            }
            this.writeUnformattedString(sruLabel.toCharArray(), out);
        }
    }

    private void addGrapAttach(int bracket, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32792, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(2603, out);
        this.writeInt16(4, out);
        this.writeInt32(bracket, out);
        this.end(out);
    }

    private void addLeftBracket(DPoint3 tl, DPoint3 br, ByteArrayOutputStream out, boolean autosize, int braType) throws IOException {
        double right;
        double bottom;
        double left;
        double top;
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        double w = br.x - tl.x;
        double h = br.y - tl.y;
        if (autosize) {
            top = tl.y - h * 0.09;
            left = tl.x - 0.05 * w;
            bottom = br.y + h * 0.09;
            right = tl.x - 0.05 * w;
        } else {
            top = tl.y;
            left = tl.x;
            bottom = br.y;
            right = tl.x;
        }
        this.writeInt32(this.yCoord(bottom), out);
        this.writeInt32(this.xCoord(right), out);
        this.writeInt32(this.yCoord(top), out);
        this.writeInt32(this.xCoord(left), out);
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(6, out);
        this.writeInt16(2566, out);
        this.writeInt16(2, out);
        switch (braType) {
            case 0: {
                this.writeInt16(5, out);
                break;
            }
            default: {
                this.writeInt16(3, out);
            }
        }
        this.end(out);
    }

    private void addRgroup(RgMolecule rgmol, int rgroupNum, HashMap id, HashMap rgid, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32778, out);
        this.writeInt32(Integer.parseInt((String)rgid.get(Integer.toString(rgmol.getRgroupId(rgroupNum)))), out);
        int xmin = Integer.MAX_VALUE;
        int xmax = -2147483647;
        int ymin = Integer.MAX_VALUE;
        int ymax = -2147483647;
        for (int i = 0; i < rgmol.getRgroupMemberCount(rgroupNum); ++i) {
            int[] currBB = this.addMol(rgmol.getRgroupMember(rgroupNum, i), id, null, out);
            ymin = Math.min(currBB[0], ymin);
            xmin = Math.min(currBB[1], xmin);
            ymax = Math.max(currBB[2], ymax);
            xmax = Math.max(currBB[3], xmax);
        }
        int w = xmax - xmin;
        int h = ymax - ymin;
        int top = (int)((double)ymin - (double)h * 0.05);
        int left = (int)((double)xmin - (double)w * 0.05);
        int bottom = (int)((double)ymax + (double)h * 0.05);
        int right = (int)((double)xmax + (double)w * 0.05);
        this.writeInt16(2817, out);
        this.writeInt16(16, out);
        this.writeInt32(top, out);
        this.writeInt32(left, out);
        this.writeInt32(bottom, out);
        this.writeInt32(right, out);
        this.writeInt16(2816, out);
        this.writeInt16(16, out);
        this.writeInt32((int)((double)top - this.cdxBondLength), out);
        this.writeInt32(left, out);
        this.writeInt32(top, out);
        this.writeInt32((int)((double)left + this.cdxBondLength), out);
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32((int)((double)top - this.cdxBondLength), out);
        this.writeInt32(left, out);
        this.writeInt32(bottom, out);
        this.writeInt32(right, out);
        int rgMarvinID = rgmol.getRgroupId(rgroupNum);
        String s = "";
        if (rgMarvinID != 0) {
            s = Integer.toString(rgMarvinID);
        }
        this.addSubTextbox("R" + s, (int)((double)top - this.cdxBondLength / 2.0), (int)((double)left + this.cdxBondLength / 2.0), top, (int)((double)left + this.cdxBondLength), out);
        this.end(out);
    }

    private void addRigthBracket(DPoint3 tl, DPoint3 br, Sgroup sg, ByteArrayOutputStream out, boolean autosize, int braType) throws IOException {
        double right;
        double bottom;
        double left;
        double top;
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        double w = br.x - tl.x;
        double h = br.y - tl.y;
        if (autosize) {
            top = tl.y - h * 0.09;
            left = br.x + 0.05 * w;
            bottom = br.y + h * 0.09;
            right = br.x + 0.05 * w;
        } else {
            top = tl.y;
            left = br.x;
            bottom = br.y;
            right = br.x;
        }
        this.writeInt32(this.yCoord(top), out);
        this.writeInt32(this.xCoord(left), out);
        this.writeInt32(this.yCoord(bottom), out);
        this.writeInt32(this.xCoord(right), out);
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(6, out);
        this.writeInt16(2566, out);
        this.writeInt16(2, out);
        switch (braType) {
            case 0: {
                this.writeInt16(5, out);
                break;
            }
            default: {
                this.writeInt16(3, out);
            }
        }
        this.writeBracketUsage(sg, out);
        this.writeRepeatPattern(sg, out);
        this.writeFlipType(sg, out);
        this.writeRepatCount(sg, out);
        if (sg instanceof MultipleSgroup) {
            MultipleSgroup msg = (MultipleSgroup)sg;
            this.writeInt16(32785, out);
            this.writeInt32(0, out);
            this.writeInt16(3328, out);
            this.writeInt16(2, out);
            this.writeInt16(0, out);
            this.writeInt16(8, out);
            String bracketUsage = "bracketusage";
            byte[] brub = bracketUsage.getBytes();
            this.writeInt16(brub.length, out);
            out.write(brub);
            this.addSubTextbox(Integer.toString(msg.getMultiplier()), this.yCoord(bottom), this.xCoord(right), this.yCoord(bottom) + 30, this.xCoord(right) + 30, out);
            this.end(out);
        }
        this.end(out);
    }

    private void addSubTextbox(String string, MolAtom ma, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32774, out);
        this.writeInt32(0, out);
        this.writeInt16(512, out);
        this.writeInt16(8, out);
        int y = this.yCoord(ma.getY());
        int x = this.xCoord(ma.getX());
        this.writeInt32(y, out);
        this.writeInt32(x, out);
        this.writeInt16(1792, out);
        char[] str = string.toCharArray();
        this.writeInt16(str.length + 2, out);
        this.writeUnformattedString(str, out);
        this.end(out);
    }

    private void addSubTextBoxForHIsotopes(String string, MolAtom ma, HashMap id, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32774, out);
        this.writeInt32(0, out);
        this.writeInt16(512, out);
        this.writeInt16(8, out);
        this.writeInt32(this.yCoord(ma.getY()), out);
        this.writeInt32(this.xCoord(ma.getX()), out);
        ByteArrayOutputStream text = new ByteArrayOutputStream();
        int sectionCount = 2;
        this.writeInt16(sectionCount, text);
        int defFontID = Integer.parseInt((String)id.get(this.defFont));
        for (int i = 0; i < sectionCount; ++i) {
            this.writeInt16(i, text);
            this.writeInt16(defFontID, text);
            int style = 0;
            if (i == 0) {
                style |= 0x40;
            }
            this.writeInt16(style, text);
            this.writeInt16(200, text);
            this.writeInt16(0, text);
        }
        text.write(string.getBytes(this.encoding));
        this.writeInt16(1792, out);
        if (text.size() > 65535) {
            this.writeInt16(65535, out);
            this.writeInt32(text.size(), out);
        } else {
            this.writeInt16(text.size(), out);
        }
        byte[] b = text.toByteArray();
        out.write(b);
        this.end(out);
    }

    private void addSubTextbox(String string, int top, int left, int bottom, int right, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32774, out);
        this.writeInt32(0, out);
        this.writeInt16(512, out);
        this.writeInt16(8, out);
        this.writeInt32(top, out);
        this.writeInt32(left, out);
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32(top, out);
        this.writeInt32(left, out);
        this.writeInt32(bottom, out);
        this.writeInt32(right, out);
        this.writeInt16(1792, out);
        char[] str = string.toCharArray();
        this.writeInt16(str.length + 2, out);
        this.writeUnformattedString(str, out);
        this.end(out);
    }

    private int[] writeBoundingBox(MoleculeGraph mg, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (int i = mg.getAtomCount() - 1; i >= 0; --i) {
            MolAtom atom = mg.getAtom(i);
            double x = atom.getX();
            xmin = Math.min(x, xmin);
            xmax = Math.max(x, xmax);
            double y = atom.getY();
            ymin = Math.min(y, ymin);
            ymax = Math.max(y, ymax);
        }
        int top = this.yCoord(ymin) - this.toCDXUnits(0.07700000000000001);
        int left = this.xCoord(xmin) - this.toCDXUnits(0.07700000000000001);
        int bottom = this.yCoord(ymax) + this.toCDXUnits(0.07700000000000001);
        int right = this.xCoord(xmax) + this.toCDXUnits(0.07700000000000001);
        this.writeInt32(top, out);
        this.writeInt32(left, out);
        this.writeInt32(bottom, out);
        this.writeInt32(right, out);
        return new int[]{top, left, bottom, right};
    }

    private int[] writeBoundingBox(DPoint3[] points, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        double xmin = Double.MAX_VALUE;
        double xmax = -1.7976931348623157E308;
        double ymin = Double.MAX_VALUE;
        double ymax = -1.7976931348623157E308;
        for (int i = 0; i < points.length; ++i) {
            double x = points[i].x;
            xmin = Math.min(x, xmin);
            xmax = Math.max(x, xmax);
            double y = points[i].y;
            ymin = Math.min(y, ymin);
            ymax = Math.max(y, ymax);
        }
        int top = this.yCoord(ymin);
        int left = this.xCoord(xmin);
        int bottom = this.yCoord(ymax);
        int right = this.xCoord(xmax);
        this.writeInt32(top, out);
        this.writeInt32(left, out);
        this.writeInt32(bottom, out);
        this.writeInt32(right, out);
        return new int[]{top, left, bottom, right};
    }

    private void writeBracketUsage(Sgroup sg, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(2596, out);
        this.writeInt16(1, out);
        int sgType = sg.getType();
        int subType = sg.getSubType();
        block0 : switch (sgType) {
            case 13: {
                out.write(13);
                break;
            }
            case 5: {
                switch (subType) {
                    case 1: {
                        out.write(7);
                        break block0;
                    }
                    case 3: {
                        out.write(9);
                        break block0;
                    }
                    case 2: {
                        out.write(8);
                        break block0;
                    }
                }
                out.write(6);
                break;
            }
            case 6: {
                out.write(10);
                break;
            }
            case 9: {
                out.write(15);
                break;
            }
            case 12: {
                out.write(17);
                break;
            }
            case 15: {
                out.write(11);
                break;
            }
            case 4: {
                out.write(5);
                break;
            }
            case 8: {
                out.write(14);
                break;
            }
            case 7: {
                out.write(12);
                break;
            }
            case 3: {
                out.write(4);
                break;
            }
            case 1: {
                out.write(16);
                break;
            }
            case 2: {
                out.write(3);
                break;
            }
            case 11: {
                out.write(18);
                break;
            }
            default: {
                out.write(0);
            }
        }
    }

    private void writeRepeatPattern(Sgroup sg, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(2597, out);
        this.writeInt16(1, out);
        int repPattern = sg.getConnectivity();
        switch (repPattern) {
            case 0: {
                out.write(2);
                break;
            }
            case 1: {
                out.write(1);
                break;
            }
            default: {
                out.write(0);
            }
        }
    }

    private void writeInt16(int x, ByteArrayOutputStream out) throws IOException {
        byte[] buf = new byte[2];
        buf[1] = (byte)((x & 0xFF00) >>> 8);
        buf[0] = (byte)(x & 0xFF);
        out.write(buf);
    }

    private void writeInt32(int x, ByteArrayOutputStream out) throws IOException {
        byte[] buf = new byte[4];
        buf[3] = (byte)((x & 0xFF000000) >>> 24);
        buf[2] = (byte)((x & 0xFF0000) >>> 16);
        buf[1] = (byte)((x & 0xFF00) >>> 8);
        buf[0] = (byte)(x & 0xFF);
        out.write(buf);
    }

    private void writeFloat(float f, ByteArrayOutputStream out) throws IOException {
        int x = Float.floatToIntBits(f);
        byte[] buf = new byte[4];
        buf[3] = (byte)((x & 0xFF000000) >>> 24);
        buf[2] = (byte)((x & 0xFF0000) >>> 16);
        buf[1] = (byte)((x & 0xFF00) >>> 8);
        buf[0] = (byte)(x & 0xFF);
        out.write(buf);
    }

    private void end(ByteArrayOutputStream out) throws IOException {
        this.writeInt16(0, out);
    }

    @Override
    public Object convert(Molecule omol) throws MolExportException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            MolAtom[] atoms;
            Molecule mol;
            MDocument mDoc;
            HashMap id = new HashMap();
            if (2 < omol.getDim()) {
                this.is3d = true;
            }
            if ((mDoc = (mol = omol.cloneMoleculeWithDocument()).getDocument()) == null) {
                mDoc = new MDocument(mol);
            }
            byte[] b = new byte[]{86, 106, 67, 68, 48, 49, 48, 48, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            out.write(b);
            Sgroup[] sgs = mol.getSgroupArray();
            for (int i = 0; i < sgs.length; ++i) {
                Sgroup sgroup = sgs[i];
                if (!(sgroup instanceof SuperatomSgroup) || !sgroup.isVisible()) continue;
                sgroup.setXState(2);
            }
            double xMin = 100.0;
            double xMax = -100.0;
            double yMin = 100.0;
            double yMax = -100.0;
            double zMin = 100.0;
            double zMax = -100.0;
            for (int i = 0; i < mDoc.getObjectCount(); ++i) {
                MObject mo = mDoc.getObject(i);
                if (!(mo instanceof MPolyline)) continue;
                MPolyline mpo = (MPolyline)mo;
                MPoint[] newPoints = new MPoint[mpo.getPointCount()];
                for (int j = 0; j < mpo.getPointCount(); ++j) {
                    MPoint mp = mpo.getPoint(j);
                    DPoint3 p = mp.getLocation();
                    newPoints[j] = new MPoint(p.x, -p.y, p.z);
                    if (xMin > p.x) {
                        xMin = p.x;
                    }
                    if (xMax < p.x) {
                        xMax = p.x;
                    }
                    if (yMin > -p.y) {
                        yMin = -p.y;
                    }
                    if (yMax < -p.y) {
                        yMax = -p.y;
                    }
                    if (zMin > p.z) {
                        zMin = p.z;
                    }
                    if (!(zMax < p.z)) continue;
                    zMax = p.z;
                }
                mpo.setPoints(newPoints);
            }
            for (MolAtom ma : atoms = mol.getAtomArray()) {
                double y = -ma.getY();
                double x = ma.getX();
                double z = ma.getZ();
                if (y < yMin) {
                    yMin = y;
                }
                if (x < xMin) {
                    xMin = x;
                }
                if (z < zMin) {
                    zMin = z;
                }
                if (z > zMax) {
                    zMax = z;
                }
                if (y > yMax) {
                    yMax = y;
                }
                if (x > xMax) {
                    xMax = x;
                }
                ma.setY(y);
            }
            DPoint3 center = mDoc.calcCenter();
            this.xShift = this.toCDXUnits(13.5 - center.x);
            this.yShift = this.toCDXUnits(20.0 - center.y);
            this.writeInt16(516, out);
            this.writeInt16(16, out);
            this.writeInt32(this.yCoord(yMin), out);
            this.writeInt32(this.xCoord(xMin), out);
            this.writeInt32(this.yCoord(yMax), out);
            this.writeInt32(this.xCoord(xMax), out);
            this.writeInt16(2052, out);
            this.writeInt16(4, out);
            this.writeInt32((int)this.cdxBondLength, out);
            Vector<Color> colorVector = new Vector<Color>();
            HashMap<MFont, String> mFontMap = new HashMap<MFont, String>();
            mFontMap.put(this.defFont, Integer.toString(this.cID));
            ++this.cID;
            colorVector.add(Color.WHITE);
            colorVector.add(Color.BLACK);
            mDoc = mol.getDocument();
            for (int i = 0; i < mDoc.getObjectCount(); ++i) {
                Color c;
                if (mDoc.getObject(i) instanceof MTextBox) {
                    MTextBox mtb = (MTextBox)mDoc.getObject(i);
                    MTextDocument mtd = mtb.getTextDocument();
                    for (int j = 0; j < mtb.getText().length(); ++j) {
                        mtb.setCursorPos(j, false);
                        MTextAttributes currentTextAttr = mtb.getCurrentTextAttributes(1023);
                        MFont mf = mtd.getAttrFont(currentTextAttr);
                        Color c2 = currentTextAttr.getForeground();
                        if (mf != null && !mFontMap.containsKey(mf)) {
                            mFontMap.put(mf, Integer.toString(this.cID));
                            ++this.cID;
                        }
                        if (c2 == null || colorVector.contains(c2)) continue;
                        colorVector.add(c2);
                    }
                }
                if ((c = mDoc.getObject(i).getBackground()) != null && !colorVector.contains(c)) {
                    colorVector.add(c);
                }
                if ((c = mDoc.getObject(i).getLineColor()) != null && !colorVector.contains(c)) {
                    colorVector.add(c);
                }
                if ((c = mDoc.getObject(i).getColor()) == null || colorVector.contains(c)) continue;
                colorVector.add(c);
            }
            HashMap<Color, String> colorMap = new HashMap<Color, String>();
            this.writeInt16(768, out);
            int colorTableLength = colorVector.size() * 6 + 2;
            if (colorTableLength >= 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(colorTableLength, out);
            } else {
                this.writeInt16(colorTableLength, out);
            }
            this.writeInt16(colorVector.size(), out);
            colorVector.remove(Color.BLACK);
            colorVector.remove(Color.WHITE);
            colorMap.put(Color.BLACK, "3");
            colorMap.put(Color.WHITE, "2");
            this.writeInt16(65535, out);
            this.writeInt16(65535, out);
            this.writeInt16(65535, out);
            this.writeInt16(0, out);
            this.writeInt16(0, out);
            this.writeInt16(0, out);
            int colorIndex = 4;
            for (int ci = 0; ci < colorVector.size(); ++ci) {
                Color c = (Color)colorVector.get(ci);
                this.writeInt16(c.getRed() * 255, out);
                this.writeInt16(c.getGreen() * 255, out);
                this.writeInt16(c.getBlue() * 255, out);
                colorMap.put(c, Integer.toString(colorIndex));
                ++colorIndex;
            }
            ByteArrayOutputStream ftBaos = new ByteArrayOutputStream();
            this.writeInt16(1, ftBaos);
            boolean system = true;
            this.encoding = "windows-1250";
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS")) {
                system = false;
                this.encoding = "x-mac-roman";
            } else if (osName.startsWith("Windows")) {
                system = true;
                this.encoding = "windows-1250";
            }
            this.writeInt16(mFontMap.size(), ftBaos);
            for (Map.Entry e : mFontMap.entrySet()) {
                this.writeInt16(Integer.parseInt((String)e.getValue()), ftBaos);
                if (system) {
                    this.writeInt16(1250, ftBaos);
                } else {
                    this.writeInt16(10000, ftBaos);
                }
                this.writeInt16(((MFont)e.getKey()).getFamily().length(), ftBaos);
                for (int x = 0; x < ((MFont)e.getKey()).getFamily().length(); ++x) {
                    ftBaos.write(((MFont)e.getKey()).getFamily().charAt(x));
                }
                id.put(e.getKey(), e.getValue());
            }
            this.writeInt16(256, out);
            int ftLength = ftBaos.size();
            if (ftLength >= 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(ftLength, out);
            } else {
                this.writeInt16(ftLength, out);
            }
            byte[] ftArray = ftBaos.toByteArray();
            out.write(ftArray, 0, ftArray.length);
            this.writeInt16(32769, out);
            this.writeInt32(this.cID, out);
            ++this.cID;
            HashMap<String, String> rghashmap = new HashMap<String, String>();
            if (mol instanceof RgMolecule) {
                int i;
                RgMolecule rgmol = (RgMolecule)mol;
                int rgid = 100 * rgmol.getAtomCount();
                for (i = 0; i < rgmol.getRgroupCount(); ++i) {
                    int rgidmrv = rgmol.getRgroupId(i);
                    rghashmap.put(Integer.toString(rgidmrv), Integer.toString(rgid));
                    ++rgid;
                }
                if (rgmol.getRoot() instanceof RxnMolecule) {
                    this.addReaction(rgmol.getRoot(), id, rghashmap, out);
                } else {
                    this.addMol(rgmol.getRoot(), id, rghashmap, out);
                }
                for (i = 0; i < rgmol.getRgroupCount(); ++i) {
                    this.addRgroup(rgmol, i, id, rghashmap, out);
                }
            } else if (mol instanceof RxnMolecule) {
                this.addReaction(mol, id, null, out);
            } else {
                this.addMol(mol, id, null, out);
            }
            if (mDoc != null) {
                int mCount = mDoc.getObjectCount();
                for (int i = 0; i < mCount; ++i) {
                    MPolyline mp;
                    if (mDoc.getObject(i) instanceof MTextBox) {
                        this.addTextBox((MTextBox)mDoc.getObject(i), id, out, colorMap);
                        continue;
                    }
                    if (mDoc.getObject(i) instanceof MEllipse) {
                        this.addEllipse((MEllipse)mDoc.getObject(i), out, colorMap);
                        continue;
                    }
                    if (mDoc.getObject(i) instanceof MRoundedRectangle) {
                        this.addRectangle((MRectangle)mDoc.getObject(i), id, out, colorMap);
                        continue;
                    }
                    if (mDoc.getObject(i) instanceof MRectangle) {
                        this.addRectangle((MRectangle)mDoc.getObject(i), id, out, colorMap);
                        continue;
                    }
                    if (!(mDoc.getObject(i) instanceof MPolyline) || !(mp = (MPolyline)mDoc.getObject(i)).isArrow()) continue;
                    this.addGraphicalArrow(mp, id, out, colorMap);
                }
            }
            this.end(out);
            this.end(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    private void addReaction(Molecule root, HashMap id, HashMap rghashmap, ByteArrayOutputStream out) throws IOException {
        int i;
        ByteArrayOutputStream reactionBAOS = new ByteArrayOutputStream();
        RxnMolecule rmol = (RxnMolecule)root;
        ArrayList<RxnMolecule> al = rmol.getReactionSteps();
        if (al == null) {
            al = new ArrayList();
            al.add(rmol);
        }
        for (RxnMolecule rm : al) {
            int i2;
            for (i2 = 0; i2 < rm.getReactantCount(); ++i2) {
                this.addMol(rm.getReactant(i2), id, rghashmap, reactionBAOS);
            }
            for (i2 = 0; i2 < rm.getProductCount(); ++i2) {
                this.addMol(rm.getProduct(i2), id, rghashmap, reactionBAOS);
            }
            for (i2 = 0; i2 < rm.getAgentCount(); ++i2) {
                this.addMol(rm.getAgent(i2), id, rghashmap, reactionBAOS);
            }
        }
        this.writeInt16(32781, reactionBAOS);
        this.writeInt32(this.cID, reactionBAOS);
        ++this.cID;
        ByteArrayOutputStream[] arrows = new ByteArrayOutputStream[al.size()];
        for (i = 0; i < al.size(); ++i) {
            arrows[i] = new ByteArrayOutputStream();
            this.addReactionStep(al.get(i), id, rghashmap, reactionBAOS, arrows[i]);
        }
        this.end(reactionBAOS);
        for (i = 0; i < arrows.length; ++i) {
            out.write(arrows[i].toByteArray());
        }
        out.write(reactionBAOS.toByteArray());
    }

    private void addReactionStep(RxnMolecule rm, HashMap id, HashMap rghashmap, ByteArrayOutputStream out, ByteArrayOutputStream arrow) throws IOException {
        this.writeInt16(32782, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        HashMap<String, int[]> atomMap = new HashMap<String, int[]>();
        String[] reactants = new String[rm.getReactantCount()];
        for (int i = 0; i < rm.getReactantCount(); ++i) {
            reactants[i] = (String)id.get(rm.getReactant(i));
            for (int j = 0; j < rm.getReactant(i).getAtomCount(); ++j) {
                MolAtom ma = rm.getReactant(i).getAtom(j);
                if (ma.getAtomMap() == 0) continue;
                int[] a = new int[]{Integer.parseInt((String)id.get(ma)), -1};
                atomMap.put(Integer.toString(ma.getAtomMap()), a);
            }
        }
        String[] products = new String[rm.getProductCount()];
        for (int i = 0; i < rm.getProductCount(); ++i) {
            products[i] = (String)id.get(rm.getProduct(i));
            for (int j = 0; j < rm.getProduct(i).getAtomCount(); ++j) {
                int[] a;
                MolAtom ma = rm.getProduct(i).getAtom(j);
                if (ma.getAtomMap() == 0 || (a = (int[])atomMap.get(Integer.toString(ma.getAtomMap()))) == null) continue;
                a[1] = Integer.parseInt((String)id.get(ma));
            }
        }
        this.writeInt16(3073, out);
        if (reactants.length * 4 > 65535) {
            this.writeInt16(65535, out);
            this.writeInt32(reactants.length * 4, out);
        } else {
            this.writeInt16(reactants.length * 4, out);
        }
        this.writeObjIdArray(reactants, out);
        this.writeInt16(3074, out);
        if (products.length * 4 > 65535) {
            this.writeInt16(65535, out);
            this.writeInt32(products.length * 4, out);
        } else {
            this.writeInt16(products.length * 4, out);
        }
        this.writeObjIdArray(products, out);
        if (!atomMap.isEmpty()) {
            int j;
            Set am = atomMap.entrySet();
            int[][] atomMapArray = new int[atomMap.size()][3];
            int i = 0;
            for (Map.Entry e : am) {
                int[] a = (int[])e.getValue();
                if (a[1] == -1) continue;
                atomMapArray[i] = new int[3];
                atomMapArray[i][0] = Integer.parseInt((String)e.getKey());
                atomMapArray[i][1] = ((int[])e.getValue())[0];
                atomMapArray[i][2] = ((int[])e.getValue())[1];
                ++i;
            }
            boolean wasChange = true;
            while (wasChange) {
                for (int j2 = 1; j2 < i; ++j2) {
                    if (atomMapArray[j2 - 1][0] <= atomMapArray[j2][0]) continue;
                    int[] tmp = atomMapArray[j2];
                    atomMapArray[j2] = atomMapArray[j2 - 1];
                    atomMapArray[j2 - 1] = tmp;
                    wasChange = true;
                }
                wasChange = false;
            }
            this.writeInt16(3072, out);
            if (i * 8 > 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(i * 8, out);
            } else {
                this.writeInt16(i * 8, out);
            }
            for (j = 0; j < i; ++j) {
                this.writeInt32(atomMapArray[j][1], out);
                this.writeInt32(atomMapArray[j][2], out);
            }
            this.writeInt16(3079, out);
            if (i * 8 > 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(i * 8, out);
            } else {
                this.writeInt16(i * 8, out);
            }
            for (j = 0; j < i; ++j) {
                this.writeInt32(atomMapArray[j][1], out);
                this.writeInt32(atomMapArray[j][2], out);
            }
        }
        this.writeInt16(3076, out);
        this.writeInt16(4, out);
        this.writeInt32(this.cID, out);
        this.addReactionArrow(rm, id, rghashmap, arrow);
        this.end(out);
    }

    private void writeObjIdArray(String[] arr, ByteArrayOutputStream out) throws IOException {
        for (int i = 0; i < arr.length; ++i) {
            this.writeInt32(Integer.parseInt(arr[i]), out);
        }
    }

    private void addTextBox(MTextBox mt, HashMap id, ByteArrayOutputStream out, HashMap colorMap) throws IOException {
        MTextDocument mtd = mt.getTextDocument();
        this.writeInt16(32774, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        id.put(mt, Integer.toString(this.cID));
        this.writeBoundingBox(mt, out);
        this.writeInt16(512, out);
        this.writeInt16(8, out);
        this.writeInt32(this.yCoord(mt.getPoint((int)0).getLocation().y), out);
        this.writeInt32(this.xCoord(mt.getPoint((int)0).getLocation().x), out);
        ByteArrayOutputStream text = new ByteArrayOutputStream();
        int sectionCount = mtd.getSectionCount();
        this.writeInt16(sectionCount, text);
        int defFontID = Integer.parseInt((String)id.get(this.defFont));
        for (int i = 0; i < sectionCount; ++i) {
            MTextDocument.Section section = mtd.getSection(i);
            this.writeInt16(section.getPosition(), text);
            MTextAttributes mta = section.getAttributes();
            MFont mf = mtd.getAttrFont(mta);
            int fontID = defFontID;
            if (mf != null) {
                try {
                    fontID = Integer.parseInt((String)id.get(mf));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.writeInt16(fontID, text);
            int style = 0;
            if (mf.isBold()) {
                style |= 1;
            }
            if (mf.isItalic()) {
                style |= 2;
            }
            if (mta.getSubLevel() == 1) {
                style |= 0x40;
            } else if (mta.getSubLevel() == -1) {
                style |= 0x20;
            }
            this.writeInt16(style, text);
            this.writeInt16((int)(mf.getSizeDouble() * 20.0 * 1.25), text);
            Color c = mta.getForeground();
            if (c == null) {
                c = Color.black;
            }
            String colorIndexString = (String)colorMap.get(c);
            int colorIndex = Integer.parseInt(colorIndexString);
            this.writeInt16(colorIndex, text);
        }
        String plainText = mtd.getPlainText();
        if (!plainText.contains("\r\n")) {
            plainText = plainText.replaceAll("\n", "\r\n");
        }
        text.write(plainText.getBytes(this.encoding));
        this.writeInt16(1792, out);
        if (text.size() > 65535) {
            this.writeInt16(65535, out);
            this.writeInt32(text.size(), out);
        } else {
            this.writeInt16(text.size(), out);
        }
        byte[] b = text.toByteArray();
        out.write(b);
        this.end(out);
    }

    private void addBond(MolBond bond, HashMap id, ByteArrayOutputStream out) throws IOException {
        int rc;
        int topology;
        this.writeInt16(32773, out);
        this.writeInt32(this.cID, out);
        id.put(bond, Integer.toString(this.cID));
        ++this.cID;
        this.writeInt16(1540, out);
        this.writeInt16(4, out);
        this.writeInt32(Integer.parseInt((String)id.get(bond.getAtom1())), out);
        this.writeInt16(1541, out);
        this.writeInt16(4, out);
        this.writeInt32(Integer.parseInt((String)id.get(bond.getAtom2())), out);
        this.writeInt16(1536, out);
        this.writeInt16(2, out);
        int type = bond.getType();
        switch (type) {
            case 1: 
            case 2: {
                this.writeInt16(bond.getType(), out);
                break;
            }
            case 3: {
                this.writeInt16(4, out);
                break;
            }
            case 6: {
                this.writeInt16(129, out);
                break;
            }
            case 7: {
                this.writeInt16(130, out);
                break;
            }
            case 5: {
                this.writeInt16(3, out);
                break;
            }
            case 4: {
                this.writeInt16(128, out);
                break;
            }
            case 9: {
                this.writeInt16(4096, out);
                break;
            }
            default: {
                this.writeInt16(0, out);
            }
        }
        this.writeInt16(1537, out);
        this.writeInt16(2, out);
        int flags = bond.getFlags();
        int stereo = flags & 0x30;
        if (stereo == 16) {
            this.writeInt16(6, out);
        } else if (stereo == 32) {
            this.writeInt16(3, out);
        } else if (stereo == 48) {
            this.writeInt16(8, out);
        } else if (type == 0) {
            this.writeInt16(1, out);
        } else if (type == 4) {
            if (bond.isBold()) {
                this.writeInt16(5, out);
            } else {
                this.writeInt16(1, out);
            }
            this.writeInt16(1538, out);
            this.writeInt16(2, out);
            this.writeInt16(1, out);
        } else if (bond.isBold()) {
            this.writeInt16(5, out);
        } else if (bond.isHashed()) {
            this.writeInt16(2, out);
        } else {
            this.writeInt16(0, out);
        }
        int ctstereo = flags & 0x1C0;
        if (ctstereo == 192) {
            this.writeInt16(1537, out);
            this.writeInt16(2, out);
            this.writeInt16(8, out);
        }
        if (ctstereo != 0) {
            this.writeInt16(1546, out);
            this.writeInt16(1, out);
            if (ctstereo == 128) {
                out.write(2);
            } else if (ctstereo == 64) {
                out.write(3);
            } else {
                out.write(1);
            }
        }
        if ((topology = flags & 0xC00) != 0) {
            this.writeInt16(1542, out);
            this.writeInt16(1, out);
            if (topology == 2048) {
                out.write(2);
            } else if (topology == 1024) {
                out.write(1);
            } else {
                out.write(3);
            }
        }
        if ((rc = flags & 0xF000) != 0) {
            this.writeInt16(1543, out);
            this.writeInt16(1, out);
            switch (rc) {
                case 16384: {
                    out.write(4);
                    break;
                }
                case 12288: {
                    out.write(3);
                    break;
                }
                case 8192: {
                    out.write(2);
                    break;
                }
                case 20480: {
                    out.write(5);
                    break;
                }
                case 24576: {
                    out.write(6);
                    break;
                }
                case 4096: {
                    out.write(1);
                    break;
                }
                case 28672: {
                    out.write(7);
                    break;
                }
                default: {
                    out.write(0);
                }
            }
        }
        this.end(out);
    }

    private void addAtom(MolAtom atom, HashMap id, MoleculeGraph mg, HashMap rgid, ByteArrayOutputStream out) throws IOException {
        int r;
        int R;
        int X;
        int V2;
        int freeSites;
        int h;
        int rb;
        int s;
        int eStereoType;
        int flags;
        int cip;
        int reactionStereo;
        int radical;
        int isotope;
        this.writeInt16(32772, out);
        this.writeInt32(this.cID, out);
        id.put(atom, Integer.toString(this.cID));
        ++this.cID;
        this.writeInt16(512, out);
        this.writeInt16(8, out);
        int y = this.yCoord(atom.getY());
        int x = this.xCoord(atom.getX());
        this.writeInt32(y, out);
        this.writeInt32(x, out);
        if (this.is3d) {
            int z = this.zCoord(atom.getZ());
            this.writeInt16(513, out);
            this.writeInt16(12, out);
            this.writeInt32(x, out);
            this.writeInt32(y, out);
            this.writeInt32(z, out);
        }
        int type = atom.getAtno();
        boolean rgAtom = false;
        if (type > 0 && type < 109) {
            this.writeInt16(1026, out);
            this.writeInt16(2, out);
            this.writeInt16(type, out);
            if (type == 6 && this.hasOnlyLPBonds(atom)) {
                if (atom.getImplicitHcount() == 0) {
                    this.addSubTextbox("C", atom, out);
                } else {
                    this.addSubTextbox("CH" + atom.getImplicitHcount(), atom, out);
                }
            } else if (type == 1) {
                if (atom.isSpecIsotopeSymbolPreferred()) {
                    if (atom.getMassno() == 2) {
                        this.addSubTextbox("D", atom, out);
                    } else if (atom.getMassno() == 3) {
                        this.addSubTextbox("T", atom, out);
                    }
                } else if (atom.getMassno() == 2) {
                    this.addSubTextBoxForHIsotopes("2H", atom, id, out);
                } else if (atom.getMassno() == 3) {
                    this.addSubTextBoxForHIsotopes("3H", atom, id, out);
                }
            }
            int linkNodeMin = atom.getMinRepetitions();
            int linkNodeMax = atom.getMaxRepetitions();
            if (linkNodeMax > 1) {
                this.writeInt16(1024, out);
                this.writeInt16(2, out);
                this.writeInt16(13, out);
                this.writeInt16(1085, out);
                this.writeInt16(2, out);
                this.writeInt16(linkNodeMin, out);
                this.writeInt16(1086, out);
                this.writeInt16(2, out);
                this.writeInt16(linkNodeMax, out);
            }
        } else {
            this.writeInt16(1024, out);
            this.writeInt16(2, out);
            switch (type) {
                case 128: 
                case 129: {
                    this.writeInt16(2, out);
                    this.writeInt16(1027, out);
                    int[] list = atom.getList();
                    this.writeInt16(2 + 2 * list.length, out);
                    StringBuffer listBox = new StringBuffer();
                    if (type == 128) {
                        this.writeInt16(list.length, out);
                    } else {
                        this.writeInt16(-list.length, out);
                        listBox.append("NOT ");
                    }
                    listBox.append("[");
                    for (int i = 0; i < list.length; ++i) {
                        this.writeInt16(list[i], out);
                        listBox.append(MolAtom.symbolOf(list[i]));
                        if (i >= list.length - 1) continue;
                        listBox.append(", ");
                    }
                    listBox.append("]");
                    this.addSubTextbox(listBox.toString(), atom, out);
                    break;
                }
                case 133: {
                    this.writeInt16(0, out);
                    break;
                }
                case 131: {
                    this.writeInt16(7, out);
                    this.addSubTextbox("A", atom, out);
                    break;
                }
                case 132: {
                    this.writeInt16(7, out);
                    this.addSubTextbox("Q", atom, out);
                    break;
                }
                case 136: {
                    this.writeInt16(7, out);
                    this.addSubTextbox(atom.getAliasstr(), atom, out);
                    break;
                }
                case 134: {
                    RgMolecule rgmol;
                    int rgIndex;
                    this.writeInt16(9, out);
                    int rgnum = atom.getRgroup();
                    if (rgnum == 0) {
                        this.addSubTextbox("R", atom, out);
                    } else {
                        this.addSubTextbox("R" + rgnum, atom, out);
                    }
                    if (mg instanceof RgMolecule && (rgIndex = (rgmol = (RgMolecule)mg).getRgroupIndex(rgmol.getRgroupMemberID(atom))) > 0) {
                        this.writeInt16(1076, out);
                        this.writeInt16(4, out);
                        this.writeInt32(Integer.parseInt((String)rgid.get(Integer.toString(rgIndex))), out);
                    }
                    rgAtom = true;
                    break;
                }
                case 135: {
                    this.writeInt16(5, out);
                    if (atom instanceof SgroupAtom) {
                        SgroupAtom sga = (SgroupAtom)atom;
                        String symb = sga.getSymbol();
                        SuperatomSgroup sas = sga.getSgroup();
                        SelectionMolecule mol = sas.getSgroupGraph();
                        HashMap intId = new HashMap();
                        this.addMol(mol, intId, null, out);
                        this.addSubTextbox(symb, atom, out);
                        break;
                    }
                    System.err.println("Atom with SGROUP number is not a sgroupatom");
                    break;
                }
                case 137: {
                    Sgroup[] sgs;
                    this.writeInt16(10, out);
                    for (Sgroup s2 : sgs = ((Molecule)mg).getSgroupArray()) {
                        MulticenterSgroup mus;
                        if (!(s2 instanceof MulticenterSgroup) || (mus = (MulticenterSgroup)s2).getCentralAtom() != atom) continue;
                        this.writeInt16(1074, out);
                        int ac = mus.getAtomCount();
                        int propLength = 2 + ac * 4;
                        if (propLength > 65535) {
                            this.writeInt16(65535, out);
                            this.writeInt32(propLength, out);
                        } else {
                            this.writeInt16(propLength, out);
                        }
                        this.writeInt16(ac, out);
                        for (int i = 0; i < ac; ++i) {
                            this.writeInt32(Integer.parseInt((String)id.get(mus.getAtom(i))), out);
                        }
                    }
                    break;
                }
                case 138: {
                    this.writeInt16(12, out);
                    break;
                }
                default: {
                    this.writeInt16(0, out);
                }
            }
        }
        int charge = atom.getCharge();
        if (charge != 0) {
            this.writeInt16(1057, out);
            this.writeInt16(1, out);
            out.write(charge);
        }
        if ((isotope = atom.getMassno()) != 0) {
            this.writeInt16(1056, out);
            this.writeInt16(2, out);
            this.writeInt16(isotope, out);
        }
        if ((radical = atom.getRadical()) == 1 || radical == 3 || radical == 2) {
            this.writeInt16(1058, out);
            this.writeInt16(1, out);
            if (radical == 1) {
                out.write(2);
            } else if (radical == 2) {
                out.write(1);
            } else {
                out.write(3);
            }
        }
        if ((reactionStereo = atom.getReactionStereo()) != 0) {
            this.writeInt16(1064, out);
            this.writeInt16(1, out);
            if (reactionStereo == 1) {
                out.write(1);
            } else {
                out.write(2);
            }
        }
        if ((cip = (flags = atom.getFlags()) | 0x18) != 0) {
            this.writeInt16(1079, out);
            this.writeInt16(1, out);
            if (cip == 8) {
                out.write(2);
            } else if (cip == 16) {
                out.write(3);
            } else {
                out.write(6);
            }
        }
        if ((eStereoType = atom.getStereoGroupType()) != 0) {
            this.writeInt16(1093, out);
            this.writeInt16(1, out);
            out.write(1);
            this.writeInt16(1094, out);
            this.writeInt16(1, out);
            if (eStereoType == 1) {
                out.write(2);
            } else if (eStereoType == 3) {
                out.write(4);
                int eStereoGroup = atom.getStereoGroupNumber();
                this.writeInt16(1095, out);
                this.writeInt16(2, out);
                this.writeInt16(eStereoGroup, out);
            } else {
                out.write(3);
                int eStereoGroup = atom.getStereoGroupNumber();
                this.writeInt16(1095, out);
                this.writeInt16(2, out);
                this.writeInt16(eStereoGroup, out);
            }
        }
        int implHcount = atom.getImplicitHcount();
        this.writeInt16(1067, out);
        this.writeInt16(2, out);
        this.writeInt16(implHcount, out);
        int u = atom.getQPropAsInt("u");
        if (u == 1) {
            this.writeInt16(1062, out);
            this.writeInt16(1, out);
            out.write(2);
        }
        if ((s = atom.getQPropAsInt("s")) == -2) {
            this.writeInt16(1059, out);
            this.writeInt16(1, out);
            out.write(0);
        } else if (s != -1) {
            this.writeInt16(1078, out);
            this.writeInt16(1, out);
            out.write(s);
        }
        int D = atom.getQPropAsInt("D");
        if (D > -1) {
            this.writeInt16(1078, out);
            this.writeInt16(1, out);
            out.write(D);
        }
        if ((rb = atom.getQPropAsInt("rb")) != -1) {
            this.writeInt16(1061, out);
            this.writeInt16(1, out);
            if (rb == -2) {
                out.write(1);
            } else {
                out.write(rb);
            }
        }
        if ((h = atom.getQPropAsInt("h")) == 0) {
            this.writeInt16(1060, out);
            this.writeInt16(0, out);
        } else if (h > 0 && (freeSites = atom.getImplicitHcount() - h) >= 0) {
            this.writeInt16(1059, out);
            this.writeInt16(1, out);
            out.write(freeSites);
        }
        int H = atom.getQPropAsInt("H");
        if (H != -1) {
            this.writeInt16(16641, out);
            this.writeInt16(2, out);
            this.writeInt16(H, out);
        }
        if ((V2 = atom.getValenceProp()) != -1) {
            this.writeInt16(16642, out);
            this.writeInt16(2, out);
            this.writeInt16(V2, out);
        }
        if ((X = atom.getQPropAsInt("X")) != -1) {
            this.writeInt16(16643, out);
            this.writeInt16(2, out);
            this.writeInt16(X, out);
        }
        if ((R = atom.getQPropAsInt("R")) != -1) {
            this.writeInt16(16644, out);
            this.writeInt16(2, out);
            this.writeInt16(R, out);
        }
        if ((r = atom.getQPropAsInt("r")) != -1) {
            this.writeInt16(16645, out);
            this.writeInt16(2, out);
            this.writeInt16(r, out);
        }
        if (!rgAtom) {
            this.end(out);
            if (atom.getAttach() != 0) {
                this.writeInt16(32772, out);
                this.writeInt32(this.cID, out);
                int extId = this.cID++;
                this.writeInt16(1024, out);
                this.writeInt16(2, out);
                this.writeInt16(12, out);
                this.end(out);
                this.writeInt16(32773, out);
                this.writeInt32(this.cID, out);
                ++this.cID;
                this.writeInt16(1540, out);
                this.writeInt16(4, out);
                this.writeInt32(extId, out);
                this.writeInt16(1541, out);
                this.writeInt16(4, out);
                this.writeInt32(Integer.parseInt((String)id.get(atom)), out);
                this.writeInt16(1536, out);
                this.writeInt16(2, out);
                this.writeInt16(1, out);
                this.end(out);
            }
        }
    }

    private int xCoord(double f) {
        return this.toCDXUnits(f) + this.xShift;
    }

    private int yCoord(double f) {
        return this.toCDXUnits(f) + this.yShift;
    }

    private int zCoord(double f) {
        return this.toCDXUnits(f);
    }

    private int toCDXUnits(double f) {
        return (int)(f * (this.cdxBondLength / 1.54));
    }

    private int[] addMol(MoleculeGraph mg, HashMap id, HashMap rgid, ByteArrayOutputStream out) throws IOException {
        int i;
        this.writeInt16(32771, out);
        this.writeInt32(this.cID, out);
        id.put(mg, Integer.toString(this.cID));
        ++this.cID;
        int[] bb = this.writeBoundingBox(mg, out);
        ArrayList<MolAtom> LPs = new ArrayList<MolAtom>();
        IntVector attach = new IntVector();
        IntVector Rgatoms = new IntVector();
        ByteArrayOutputStream[] atoms = new ByteArrayOutputStream[mg.getAtomCount()];
        for (int i2 = 0; i2 < mg.getAtomCount(); ++i2) {
            atoms[i2] = new ByteArrayOutputStream();
            MolAtom ma = mg.getAtom(i2);
            if (ma.getAtno() == 130) {
                LPs.add(ma);
            } else {
                this.addAtom(ma, id, mg, rgid, atoms[i2]);
            }
            if (ma.getAtno() == 134) {
                Rgatoms.add(i2);
            }
            if (ma.getAtno() != 138) continue;
            attach.add(i2);
        }
        this.addLonePairs(LPs, id, mg, rgid, out);
        LPs = null;
        ByteArrayOutputStream bonds = new ByteArrayOutputStream();
        for (i = 0; i < mg.getBondCount(); ++i) {
            MolBond mb = mg.getBond(i);
            if (mb.getAtom1().getAtno() == 130 || mb.getAtom2().getAtno() == 130) continue;
            this.addBond(mb, id, bonds);
        }
        for (i = 0; i < Rgatoms.size(); ++i) {
            int rgAtomIndex = Rgatoms.get(i);
            MolAtom atom = mg.getAtom(rgAtomIndex);
            MolAtom[] ligands = atom.getLigands();
            if (ligands.length > 1) {
                String[] bondOrder = new String[ligands.length];
                for (int ij = 0; ij < ligands.length; ++ij) {
                    int order = atom.getLigandOrder(atom.getLigand(ij)) == 0 ? 0 : atom.getLigandOrder(atom.getLigand(ij)) - 1;
                    bondOrder[order] = (String)id.get(atom.getBondTo(atom.getLigand(ij)));
                }
                this.writeInt16(1073, atoms[rgAtomIndex]);
                if (bondOrder.length * 4 > 65535) {
                    this.writeInt16(65535, atoms[rgAtomIndex]);
                    this.writeInt32(bondOrder.length * 4, atoms[rgAtomIndex]);
                } else {
                    this.writeInt16(bondOrder.length * 4, atoms[rgAtomIndex]);
                }
                this.writeObjIdArray(bondOrder, atoms[rgAtomIndex]);
            }
            this.end(atoms[rgAtomIndex]);
        }
        for (i = 0; i < atoms.length; ++i) {
            out.write(atoms[i].toByteArray());
        }
        out.write(bonds.toByteArray());
        if (attach.size() > 0) {
            String[] connectionOrder = new String[attach.size()];
            for (int i3 = 0; i3 < attach.size(); ++i3) {
                MolAtom molAtom = mg.getAtom(attach.get(i3));
                int o = molAtom.getRgroupAttachmentPointOrder() == 0 ? 0 : molAtom.getRgroupAttachmentPointOrder() - 1;
                connectionOrder[o] = (String)id.get(molAtom);
            }
            this.writeInt16(1285, out);
            if (connectionOrder.length * 4 > 65535) {
                this.writeInt16(65535, out);
                this.writeInt32(connectionOrder.length * 4, out);
            } else {
                this.writeInt16(connectionOrder.length * 4, out);
            }
            this.writeObjIdArray(connectionOrder, out);
        }
        if (mg.isAbsStereo()) {
            this.writeInt16(32775, out);
            this.writeInt32(this.cID, out);
            ++this.cID;
            this.writeInt16(2560, out);
            this.writeInt16(2, out);
            this.writeInt16(7, out);
            this.writeInt16(2567, out);
            this.writeInt16(2, out);
            this.writeInt16(11, out);
            this.writeInt16(32774, out);
            this.writeInt32(0, out);
            this.writeInt16(1792, out);
            String s = "Abs";
            byte[] array = s.getBytes();
            this.writeInt16(array.length, out);
            out.write(array);
            this.end(out);
            this.end(out);
        }
        this.end(out);
        Molecule mol = null;
        if (mg instanceof Molecule) {
            Sgroup[] sgs;
            mol = (Molecule)mg;
            for (Sgroup sg : sgs = mol.getSgroupArray()) {
                if (sg instanceof SuperatomSgroup || sg instanceof DataSgroup || sg instanceof MulticenterSgroup) continue;
                this.addBracketedGroup(sg, id, out);
            }
        }
        return bb;
    }

    private void writeUnformattedString(char[] str, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(0, out);
        for (int i = 0; i < str.length; ++i) {
            out.write(str[i]);
        }
    }

    private void addReactionArrow(RxnMolecule rm, HashMap id, HashMap rghashmap, ByteArrayOutputStream out) throws IOException {
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(1, out);
        int arrType = rm.getReactionArrowType();
        switch (arrType) {
            case 3: {
                arrType = 8;
                break;
            }
            case 1: {
                arrType = 4;
                break;
            }
            case 2: {
                arrType = 32;
                break;
            }
            default: {
                arrType = 2;
            }
        }
        this.writeInt16(2562, out);
        this.writeInt16(2, out);
        this.writeInt16(arrType, out);
        DPoint3[] arrCoords = rm.getReactionArrow();
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32(this.yCoord(-arrCoords[1].y), out);
        this.writeInt32(this.xCoord(arrCoords[1].x), out);
        this.writeInt32(this.yCoord(-arrCoords[0].y), out);
        this.writeInt32(this.xCoord(arrCoords[0].x), out);
        this.end(out);
    }

    private void writeBoundingBox(MObject mo, ByteArrayOutputStream out) throws IOException {
        int pn = mo.getPointCount();
        DPoint3[] points = new DPoint3[pn];
        for (int i = 0; i < points.length; ++i) {
            points[i] = mo.getPoint(i).getLocation();
        }
        this.writeBoundingBox(points, out);
    }

    private void writeRepatCount(Sgroup sg, ByteArrayOutputStream out) throws IOException {
        if (sg instanceof MultipleSgroup) {
            MultipleSgroup msg = (MultipleSgroup)sg;
            double rc = msg.getMultiplier();
            long data = Double.doubleToLongBits(rc);
            byte[] b = new byte[]{(byte)(data >> 0 & 0xFFL), (byte)(data >> 8 & 0xFFL), (byte)(data >> 16 & 0xFFL), (byte)(data >> 24 & 0xFFL), (byte)(data >> 32 & 0xFFL), (byte)(data >> 40 & 0xFFL), (byte)(data >> 48 & 0xFFL), (byte)(data >> 56 & 0xFFL)};
            this.writeInt16(2600, out);
            this.writeInt16(8, out);
            out.write(b);
        }
    }

    private double distance(DPoint3 p1, DPoint3 p2) {
        return this.length(new DPoint3(p1.x - p2.x, p1.y - p2.y, p1.z - p2.z));
    }

    private double length(DPoint3 p) {
        return Math.sqrt(Math.pow(p.x, 2.0) + Math.pow(p.z, 2.0) + Math.pow(p.y, 2.0));
    }

    private void addGraphicalArrow(MPolyline mp, HashMap id, ByteArrayOutputStream out, HashMap<Color, String> colorMap) throws IOException {
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        String s = mp.getAttribute("tailLength");
        int arrType = 2;
        if (s != null) {
            arrType = 4;
        }
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(1, out);
        this.writeInt16(2562, out);
        this.writeInt16(2, out);
        this.writeInt16(arrType, out);
        MPoint[] arrCoords = mp.getPoints();
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32(this.yCoord(arrCoords[1].getLocation().y), out);
        this.writeInt32(this.xCoord(arrCoords[1].getLocation().x), out);
        this.writeInt32(this.yCoord(arrCoords[0].getLocation().y), out);
        this.writeInt32(this.xCoord(arrCoords[0].getLocation().x), out);
        this.end(out);
    }

    private void addRectangle(MRectangle mRectangle, HashMap id, ByteArrayOutputStream out, HashMap<Color, String> colorMap) throws IOException {
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(3, out);
        int rectType = 0;
        Color backgroundColor = mRectangle.getBackground();
        if (backgroundColor != null) {
            rectType |= 8;
            this.writeInt16(769, out);
            this.writeInt16(2, out);
            this.writeInt16(Integer.parseInt(colorMap.get(backgroundColor)), out);
        }
        if (mRectangle instanceof MRoundedRectangle) {
            rectType |= 1;
        }
        if (mRectangle.getThickness() > MRectangle.DEFAULT_THICKNESS) {
            rectType |= 0x20;
        }
        this.writeInt16(2563, out);
        this.writeInt16(2, out);
        this.writeInt16(rectType, out);
        MPoint[] points = mRectangle.getPoints();
        DPoint3[] p = new DPoint3[points.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = points[i].getLocation();
        }
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32(this.yCoord(p[0].y), out);
        this.writeInt32(this.xCoord(p[0].x), out);
        this.writeInt32(this.yCoord(p[2].y), out);
        this.writeInt32(this.xCoord(p[2].x), out);
        DPoint3 center = new DPoint3();
        mRectangle.calcCenter(center, null);
        DPoint3 major = new DPoint3((p[0].x + p[1].x) / 2.0, (p[0].y + p[1].y) / 2.0, (p[0].z + p[1].z) / 2.0);
        DPoint3 minor = new DPoint3((p[0].x + p[3].x) / 2.0, (p[0].y + p[3].y) / 2.0, (p[0].z + p[3].z) / 2.0);
        double dminor = this.distance(center, minor);
        double dmajor = this.distance(center, major);
        if (dmajor < dminor) {
            DPoint3 tmp = minor;
            minor = major;
            major = tmp;
        }
        this.writeInt16(525, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(center.x), out);
        this.writeInt32(this.yCoord(center.y), out);
        this.writeInt32(this.zCoord(center.z), out);
        this.writeInt16(526, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(major.x), out);
        this.writeInt32(this.yCoord(major.y), out);
        this.writeInt32(this.zCoord(major.z), out);
        this.writeInt16(527, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(minor.x), out);
        this.writeInt32(this.yCoord(minor.y), out);
        this.writeInt32(this.zCoord(minor.z), out);
        this.end(out);
    }

    private void addEllipse(MEllipse mEllipse, ByteArrayOutputStream out, HashMap<Color, String> colorMap) throws IOException {
        this.writeInt16(32775, out);
        this.writeInt32(this.cID, out);
        ++this.cID;
        this.writeInt16(2560, out);
        this.writeInt16(2, out);
        this.writeInt16(4, out);
        int ovalType = 0;
        MPoint[] points = mEllipse.getPoints();
        DPoint3[] p = new DPoint3[points.length];
        for (int i = 0; i < p.length; ++i) {
            p[i] = points[i].getLocation();
        }
        DPoint3 center = new DPoint3();
        mEllipse.calcCenter(center, null);
        Color backgroundColor = mEllipse.getBackground();
        if (backgroundColor != null) {
            ovalType |= 4;
            this.writeInt16(769, out);
            this.writeInt16(2, out);
            this.writeInt16(Integer.parseInt(colorMap.get(backgroundColor)), out);
        }
        if (mEllipse.getThickness() > MEllipse.DEFAULT_THICKNESS) {
            ovalType |= 0x10;
        }
        DPoint3 major = new DPoint3((p[0].x + p[1].x) / 2.0, (p[0].y + p[1].y) / 2.0, (p[0].z + p[1].z) / 2.0);
        DPoint3 minor = new DPoint3((p[0].x + p[3].x) / 2.0, (p[0].y + p[3].y) / 2.0, (p[0].z + p[3].z) / 2.0);
        double dminor = this.distance(center, minor);
        double dmajor = this.distance(center, major);
        if (dmajor < dminor) {
            DPoint3 tmp = minor;
            minor = major;
            major = tmp;
        } else if (dmajor == dminor) {
            ovalType |= 1;
        }
        if (ovalType != 0) {
            this.writeInt16(2564, out);
            this.writeInt16(2, out);
            this.writeInt16(ovalType, out);
        }
        this.writeInt16(525, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(center.x), out);
        this.writeInt32(this.yCoord(center.y), out);
        this.writeInt32(this.zCoord(center.z), out);
        this.writeInt16(526, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(major.x), out);
        this.writeInt32(this.yCoord(major.y), out);
        this.writeInt32(this.zCoord(major.z), out);
        this.writeInt16(527, out);
        this.writeInt16(12, out);
        this.writeInt32(this.xCoord(minor.x), out);
        this.writeInt32(this.yCoord(minor.y), out);
        this.writeInt32(this.zCoord(minor.z), out);
        this.writeInt16(516, out);
        this.writeInt16(16, out);
        this.writeInt32(this.yCoord(minor.y), out);
        this.writeInt32(this.xCoord(minor.x), out);
        this.writeInt32(this.yCoord(center.y), out);
        this.writeInt32(this.xCoord(center.x), out);
        this.end(out);
    }

    private void addLonePairs(ArrayList<MolAtom> LPs, HashMap id, MoleculeGraph mg, HashMap rgid, ByteArrayOutputStream out) throws IOException {
        for (MolAtom ma : LPs) {
            this.writeInt16(32775, out);
            this.writeInt32(this.cID, out);
            ++this.cID;
            this.writeInt16(516, out);
            this.writeInt16(16, out);
            this.writeInt32(this.yCoord(ma.getY()), out);
            this.writeInt32(this.xCoord(ma.getX()), out);
            this.writeInt32(this.yCoord(ma.getY() + 0.1), out);
            this.writeInt32(this.xCoord(ma.getX() + 0.1), out);
            this.writeInt16(769, out);
            this.writeInt16(2, out);
            this.writeInt16(3, out);
            if (ma.getBondCount() == 1) {
                this.writeInt16(14, out);
                this.writeInt16(6, out);
                this.writeInt32(Integer.parseInt((String)id.get(ma.getBond(0).getOtherAtom(ma))), out);
                this.writeInt16(1058, out);
            }
            this.writeInt16(2560, out);
            this.writeInt16(2, out);
            this.writeInt16(7, out);
            this.writeInt16(2567, out);
            this.writeInt16(2, out);
            this.writeInt16(0, out);
            this.end(out);
        }
    }

    private boolean hasOnlyLPBonds(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getBond(i).getOtherAtom(atom).getAtno() == 130) continue;
            return false;
        }
        return true;
    }
}

