/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cdx;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.license.Base64;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.cdx.CDXConstants;
import chemaxon.marvin.io.formats.cdx.CDXObject;
import chemaxon.marvin.io.formats.cdx.CDXObjectReader;
import chemaxon.struc.MDocument;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.util.ConversionUtil;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CDXImport
extends MolImportModule
implements CDXConstants {
    MolInputStream mis;
    StringBuffer output = new StringBuffer();
    int pageNum = 0;
    boolean firstAtomInFragment;
    CDXObject root;

    private boolean checkHeader() throws IOException {
        byte[] b1 = new byte[28];
        this.mis.read(b1, 0, 28);
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < 8; ++i) {
            char c = (char)b1[i];
            s.append(c);
        }
        String s2 = s.toString();
        if (!s2.equals("VjCD0100")) {
            return false;
        }
        if (b1[8] != 4 || b1[9] != 3 || b1[10] != 2 || b1[11] != 1) {
            return false;
        }
        for (int i = 12; i < 28; ++i) {
            if (b1[i] == 0) continue;
        }
        return true;
    }

    private int joinToInt(byte[] b1, int l) {
        return ConversionUtil.joinToInt(b1, l);
    }

    private int joinToInt(byte[] b1, int from, int to) {
        return ConversionUtil.joinToInt(b1, from, to);
    }

    private double arr2double(byte[] arr, int start) {
        int i = 0;
        int len = 8;
        int cnt = 0;
        byte[] tmp = new byte[len];
        for (i = start; i < start + len; ++i) {
            tmp[cnt] = arr[i];
            ++cnt;
        }
        long accum = 0L;
        i = 0;
        for (int shiftBy = 0; shiftBy < 64; shiftBy += 8) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
        }
        return Double.longBitsToDouble(accum);
    }

    private void processBond(CDXObject bond) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int bondId = this.joinToInt(b1, 4);
        bond.setID(bondId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block90: while (code != 0) {
            this.zero(b1);
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 10: {
                        int zorder = this.joinToInt(prop, propLength);
                        bond.setProperty("Z", Integer.toString(zorder));
                        break;
                    }
                    case 15: {
                        bond.setProperty("IgnoreWarnings", "True");
                        break;
                    }
                    case 17: {
                        int vis = this.joinToInt(prop, propLength);
                        if (vis != 0 || propLength == 0) {
                            bond.setProperty("Visible", "True");
                            break;
                        }
                        bond.setProperty("Visible", "False");
                        break;
                    }
                    case 1536: {
                        int intTmp = this.joinToInt(prop, propLength);
                        switch (intTmp) {
                            case 1: 
                            case 2: {
                                bond.setProperty("Order", Integer.toString(intTmp));
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("Order", "1 2");
                                break block0;
                            }
                            case 129: {
                                bond.setProperty("Order", "1 1.5");
                                break block0;
                            }
                            case 130: {
                                bond.setProperty("Order", "2 1.5");
                                break block0;
                            }
                            case 4: {
                                bond.setProperty("Order", "3");
                                break block0;
                            }
                            case 8: {
                                bond.setProperty("Order", "4");
                                break block0;
                            }
                            case 16: {
                                bond.setProperty("Order", "5");
                                break block0;
                            }
                            case 32: {
                                bond.setProperty("Order", "6");
                                break block0;
                            }
                            case 64: {
                                bond.setProperty("Order", "0.5");
                                break block0;
                            }
                            case 128: {
                                bond.setProperty("Order", "1.5");
                                break block0;
                            }
                            case 256: {
                                bond.setProperty("Order", "2.5");
                                break block0;
                            }
                            case 512: {
                                bond.setProperty("Order", "3.5");
                                break block0;
                            }
                            case 1024: {
                                bond.setProperty("Order", "4.5");
                                break block0;
                            }
                            case 2048: {
                                bond.setProperty("Order", "5.5");
                                break block0;
                            }
                            case 4096: {
                                bond.setProperty("Order", "dative");
                                break block0;
                            }
                            case 8192: {
                                bond.setProperty("Order", "ionic");
                                break block0;
                            }
                            case 16384: {
                                bond.setProperty("Order", "hydrogen");
                                break block0;
                            }
                            case 32768: {
                                bond.setProperty("Order", "threecenter");
                                break block0;
                            }
                        }
                        bond.setProperty("Order", "any");
                        break;
                    }
                    case 1537: {
                        int intTmp = this.joinToInt(prop, propLength);
                        switch (intTmp) {
                            case 0: {
                                bond.setProperty("Display", "Solid");
                                break block0;
                            }
                            case 1: {
                                bond.setProperty("Display", "Dash");
                                break block0;
                            }
                            case 2: {
                                bond.setProperty("Display", "Hash");
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("Display", "WedgedHashBegin");
                                break block0;
                            }
                            case 4: {
                                bond.setProperty("Display", "WedgedHashEnd");
                                break block0;
                            }
                            case 5: {
                                bond.setProperty("Display", "Bold");
                                break block0;
                            }
                            case 6: {
                                bond.setProperty("Display", "WedgeBegin");
                                break block0;
                            }
                            case 7: {
                                bond.setProperty("Display", "WedgeEnd");
                                break block0;
                            }
                            case 8: {
                                bond.setProperty("Display", "Wavy");
                                break block0;
                            }
                            case 9: {
                                bond.setProperty("Display", "HollowWedgeBegin");
                                break block0;
                            }
                            case 10: {
                                bond.setProperty("Display", "HollowWedgeEnd");
                                break block0;
                            }
                            case 11: {
                                bond.setProperty("Display", "WawyWedgeBegin");
                                break block0;
                            }
                            case 12: {
                                bond.setProperty("Display", "WavyWedgeEnd");
                                break block0;
                            }
                            case 13: {
                                bond.setProperty("Display", "Dot");
                                break block0;
                            }
                            case 14: {
                                bond.setProperty("Display", "DashDot");
                                break block0;
                            }
                        }
                        bond.setProperty("Display", "Solid");
                        break;
                    }
                    case 1538: {
                        int intTmp = this.joinToInt(prop, propLength);
                        switch (intTmp) {
                            case 0: {
                                bond.setProperty("Display2", "Solid");
                                break block0;
                            }
                            case 1: {
                                bond.setProperty("Display2", "Dash");
                                break block0;
                            }
                            case 2: {
                                bond.setProperty("Display2", "Hash");
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("Display2", "WedgedHashBegin");
                                break block0;
                            }
                            case 4: {
                                bond.setProperty("Display2", "WedgedHashEnd");
                                break block0;
                            }
                            case 5: {
                                bond.setProperty("Display2", "Bold");
                                break block0;
                            }
                            case 6: {
                                bond.setProperty("Display2", "WedgeBegin");
                                break block0;
                            }
                            case 7: {
                                bond.setProperty("Display2", "WedgeEnd");
                                break block0;
                            }
                            case 8: {
                                bond.setProperty("Display2", "Wavy");
                                break block0;
                            }
                            case 9: {
                                bond.setProperty("Display2", "HollowWedgeBegin");
                                break block0;
                            }
                            case 10: {
                                bond.setProperty("Display2", "HollowWedgeEnd");
                                break block0;
                            }
                            case 11: {
                                bond.setProperty("Display2", "WawyWedgeBegin");
                                break block0;
                            }
                            case 12: {
                                bond.setProperty("Display2", "WavyWedgeEnd");
                                break block0;
                            }
                            case 13: {
                                bond.setProperty("Display2", "Dot");
                                break block0;
                            }
                            case 14: {
                                bond.setProperty("Display2", "DashDot");
                                break block0;
                            }
                        }
                        bond.setProperty("Display2", "Solid");
                        break;
                    }
                    case 1540: {
                        int intTmp = this.joinToInt(prop, propLength);
                        bond.setProperty("B", Integer.toString(intTmp));
                        break;
                    }
                    case 1541: {
                        int intTmp = this.joinToInt(prop, propLength);
                        bond.setProperty("E", Integer.toString(intTmp));
                        break;
                    }
                    case 1542: {
                        int top = this.joinToInt(prop, propLength);
                        switch (top) {
                            case 1: {
                                bond.setProperty("Topology", "Ring");
                                break block0;
                            }
                            case 2: {
                                bond.setProperty("Topology", "Chain");
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("Topology", "RingOrChain");
                                break block0;
                            }
                        }
                        bond.setProperty("Topology", "Unspecified");
                        break;
                    }
                    case 1543: {
                        int rxnState = this.joinToInt(prop, propLength);
                        switch (rxnState) {
                            case 1: {
                                bond.setProperty("RxnParticipation", "ReactionCenter");
                                break block0;
                            }
                            case 2: {
                                bond.setProperty("RxnParticipation", "MakeOrBreak");
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("RxnParticipation", "ChangeType");
                                break block0;
                            }
                            case 4: {
                                bond.setProperty("RxnParticipation", "MakeAndChange");
                                break block0;
                            }
                            case 5: {
                                bond.setProperty("RxnParticipation", "NotReactionCenter");
                                break block0;
                            }
                            case 6: {
                                bond.setProperty("RxnParticipation", "NoChange");
                                break block0;
                            }
                            case 7: {
                                bond.setProperty("RxnParticipation", "Unmapped");
                                break block0;
                            }
                        }
                        bond.setProperty("RxnParticipation", "Unspecified");
                        break;
                    }
                    case 1546: {
                        byte bs = prop[0];
                        switch (bs) {
                            case 1: {
                                bond.setProperty("BS", "N");
                                break block0;
                            }
                            case 2: {
                                bond.setProperty("BS", "E");
                                break block0;
                            }
                            case 3: {
                                bond.setProperty("BS", "Z");
                                break block0;
                            }
                        }
                        bond.setProperty("BS", "U");
                        break;
                    }
                    case 1547: {
                        String ids = this.readObjIdArr(prop);
                        bond.setProperty("BondCircularOrder", ids);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(bond);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!bond.hasChild()) {
                bond.setFirstChild(curr);
            }
            switch (code) {
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block90;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processFragment(CDXObject fr) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int fragmentId = this.joinToInt(b1, 4);
        fr.setID(fragmentId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block10: while (code != 0) {
            this.zero(b1);
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 516: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        fr.setProperty("BoundingBox", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 1285: {
                        fr.setProperty("ConnectionOrder", this.readObjIdArr(prop));
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(fr);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!fr.hasChild()) {
                fr.setFirstChild(curr);
            }
            switch (code) {
                case 32772: {
                    this.processNode(curr);
                    curr = obj;
                    continue block10;
                }
                case 32773: {
                    this.processBond(curr);
                    curr = obj;
                    continue block10;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block10;
                }
                case 32775: {
                    this.processGraphic(curr);
                    curr = obj;
                    continue block10;
                }
            }
            this.skipObject(obj);
            curr = obj;
        }
        if (!fr.hasProp("BoundingBox")) {
            double bb_left = 0.0;
            double bb_top = 0.0;
            double bb_right = 0.0;
            double bb_bottom = 0.0;
            boolean first = true;
            for (CDXObject c = fr.firstChild(); c != null; c = c.Next()) {
                String p = (String)c.getProperty("p");
                if (c.Type() != 32772 || p == null) continue;
                String[] tarr = p.split(" ");
                double x = Double.parseDouble(tarr[0]);
                double y = Double.parseDouble(tarr[1]);
                if (first || x < bb_left) {
                    bb_left = x - 2.0;
                }
                if (first || x > bb_right) {
                    bb_right = x + 2.0;
                }
                if (first || y < bb_top) {
                    bb_top = y - 2.0;
                }
                if (first || y > bb_bottom) {
                    bb_bottom = y + 2.0;
                }
                first = false;
            }
            fr.setProperty("BoundingBox", bb_left + " " + bb_top + " " + bb_right + " " + bb_bottom);
        }
    }

    private void processNode(CDXObject node) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int nodeId = this.joinToInt(b1, 4);
        node.setID(nodeId);
        int propLength = 0;
        int code = -1;
        CDXObject curr = new CDXObject();
        block127: while (code != 0) {
            this.zero(b1);
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 10: {
                        int zorder = this.joinToInt(prop, propLength);
                        node.setProperty("Z", Integer.toString(zorder));
                        break;
                    }
                    case 15: {
                        node.setProperty("IgnoreWarnings", "True");
                        break;
                    }
                    case 17: {
                        int vis = this.joinToInt(prop, propLength);
                        if (vis != 0 || propLength == 0) {
                            node.setProperty("Visible", "True");
                            break;
                        }
                        node.setProperty("Visible", "False");
                        break;
                    }
                    case 512: {
                        int y = this.joinToInt(prop, 0, 4);
                        int x = this.joinToInt(prop, 4, 8);
                        node.setProperty("p", x + " " + y);
                        break;
                    }
                    case 513: {
                        int xx = this.joinToInt(prop, 0, 4);
                        int yy = this.joinToInt(prop, 4, 8);
                        int zz = this.joinToInt(prop, 8, 12);
                        node.setProperty("xyz", xx + " " + yy + " " + zz);
                        break;
                    }
                    case 1024: {
                        int nodeType = this.joinToInt(prop, propLength);
                        switch (nodeType) {
                            case 1: {
                                node.setProperty("NodeType", "Element");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("NodeType", "ElementList");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("NodeType", "ElementListNickname");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("NodeType", "Nickname");
                                break block0;
                            }
                            case 5: {
                                node.setProperty("NodeType", "Fragment");
                                break block0;
                            }
                            case 6: {
                                node.setProperty("NodeType", "Formula");
                                break block0;
                            }
                            case 7: {
                                node.setProperty("NodeType", "GenericNickname");
                                break block0;
                            }
                            case 8: {
                                node.setProperty("NodeType", "AnonymousAlternativeGroup");
                                break block0;
                            }
                            case 9: {
                                node.setProperty("NodeType", "NamedAlternativeGroup");
                                break block0;
                            }
                            case 10: {
                                node.setProperty("NodeType", "MultiAttachment");
                                break block0;
                            }
                            case 11: {
                                node.setProperty("NodeType", "VariableAttachment");
                                break block0;
                            }
                            case 12: {
                                node.setProperty("NodeType", "ExternalConnectionPoint");
                                break block0;
                            }
                            case 13: {
                                node.setProperty("NodeType", "LinkNode");
                                break block0;
                            }
                        }
                        node.setProperty("NodeType", "Unspecified");
                        break;
                    }
                    case 1025: {
                        int ld = this.joinToInt(prop, propLength);
                        switch (ld) {
                            case 1: {
                                node.setProperty("LabelDisplay", "Left");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("LabelDisplay", "Center");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("LabelDisplay", "Right");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("LabelDisplay", "Above");
                                break block0;
                            }
                            case 5: {
                                node.setProperty("LabelDisplay", "Below");
                                break block0;
                            }
                        }
                        node.setProperty("LabelDisplay", "Auto");
                        break;
                    }
                    case 1026: {
                        int intTmp = this.joinToInt(prop, propLength);
                        node.setProperty("Element", Integer.toString(intTmp));
                        break;
                    }
                    case 1027: {
                        StringBuffer sb = new StringBuffer();
                        if (prop[0] < 0) {
                            prop[1] = 0;
                            byte t1 = -prop[0];
                            prop[0] = t1;
                            sb.append("NOT ");
                        }
                        int elementNum = this.joinToInt(prop, 2);
                        int[] elements = new int[elementNum];
                        for (int i = 0; i < elements.length; ++i) {
                            elements[i] = this.joinToInt(prop, 2 * i + 2, 2 * i + 4);
                            sb.append(elements[i] + " ");
                        }
                        node.setProperty("ElementList", sb.toString());
                        break;
                    }
                    case 1056: {
                        int isotope = this.joinToInt(prop, propLength);
                        node.setProperty("Isotope", Integer.toString(isotope));
                        break;
                    }
                    case 1057: {
                        node.setProperty("Charge", Integer.toString(prop[0]));
                        break;
                    }
                    case 1058: {
                        int rad = this.joinToInt(prop, propLength);
                        switch (rad) {
                            case 1: {
                                node.setProperty("Radical", "Singlet");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("Radical", "Doublet");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("Radical", "Triplet");
                                break block0;
                            }
                        }
                        node.setProperty("Radical", "None");
                        break;
                    }
                    case 1059: {
                        node.setProperty("FreeSites", Integer.toString(prop[0]));
                        break;
                    }
                    case 1060: {
                        node.setProperty("ImplicitHydrogens", "True");
                        break;
                    }
                    case 1061: {
                        int rbc = this.joinToInt(prop, propLength);
                        switch (rbc) {
                            case 0: {
                                node.setProperty("RingBondCount", "NoRingBonds");
                                break block0;
                            }
                            case 1: {
                                node.setProperty("RingBondCount", "AsDrawn");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("RingBondCount", "SimpleRing");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("RingBondCount", "Fusion");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("RingBondCount", "SpiroOrHigher");
                                break block0;
                            }
                        }
                        node.setProperty("RingBondCount", "Unspecified");
                        break;
                    }
                    case 1062: {
                        int uns = this.joinToInt(prop, propLength);
                        switch (uns) {
                            case 1: {
                                node.setProperty("UnsaturatedBonds", "MustBeAbsent");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("UnsaturatedBonds", "MustBePresent");
                                break block0;
                            }
                        }
                        node.setProperty("UnsaturatedBonds", "Unspecified");
                        break;
                    }
                    case 1064: {
                        int rxnStereo = this.joinToInt(prop, propLength);
                        switch (rxnStereo) {
                            case 1: {
                                node.setProperty("RxnStereo", "Inversion");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("RxnStereo", "Retension");
                                break block0;
                            }
                        }
                        node.setProperty("RxnStereo", "Unspecified");
                        break;
                    }
                    case 1067: {
                        int intTmp = this.joinToInt(prop, propLength);
                        node.setProperty("NumHydrogens", Integer.toString(intTmp));
                        break;
                    }
                    case 1070: {
                        node.setProperty("HDot", "True");
                        break;
                    }
                    case 1071: {
                        node.setProperty("HDash", "True");
                        break;
                    }
                    case 1072: {
                        int geom = this.joinToInt(prop, propLength);
                        switch (geom) {
                            case 1: {
                                node.setProperty("Geometry", "1");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("Geometry", "Linear");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("Geometry", "Bent");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("Geometry", "TrigonalPlanar");
                                break block0;
                            }
                            case 5: {
                                node.setProperty("Geometry", "TrigonalPyramidal");
                                break block0;
                            }
                            case 6: {
                                node.setProperty("Geometry", "SquarePlanar");
                                break block0;
                            }
                            case 7: {
                                node.setProperty("Geometry", "Tetrahedral");
                                break block0;
                            }
                            case 8: {
                                node.setProperty("Geometry", "TrigonalBipyramidal");
                                break block0;
                            }
                            case 9: {
                                node.setProperty("Geometry", "SquarePyramidal");
                                break block0;
                            }
                            case 10: {
                                node.setProperty("Geometry", "5");
                                break block0;
                            }
                            case 11: {
                                node.setProperty("Geometry", "Octahedral");
                                break block0;
                            }
                            case 12: {
                                node.setProperty("Geometry", "6");
                                break block0;
                            }
                            case 13: {
                                node.setProperty("Geometry", "7");
                                break block0;
                            }
                            case 14: {
                                node.setProperty("Geometry", "8");
                                break block0;
                            }
                            case 15: {
                                node.setProperty("Geometry", "9");
                                break block0;
                            }
                            case 16: {
                                node.setProperty("Geometry", "10");
                                break block0;
                            }
                        }
                        node.setProperty("Geometry", "Unknown");
                        break;
                    }
                    case 1073: {
                        String ids = this.readObjIdArr(prop);
                        node.setProperty("BondOrdering", ids);
                        break;
                    }
                    case 1074: {
                        String att = this.readObjIdArrWithC(prop);
                        node.setProperty("Attachments", att);
                        break;
                    }
                    case 1075: {
                        this.readCDXString(node, prop, "GenericNickname");
                        break;
                    }
                    case 1076: {
                        int agid = this.joinToInt(prop, propLength);
                        node.setProperty("AltGroupID", Integer.toString(agid));
                        break;
                    }
                    case 1077: {
                        node.setProperty("SubstituentsUpTo", Integer.toString(prop[0]));
                        break;
                    }
                    case 1078: {
                        node.setProperty("SubstituentsExactly", Integer.toString(prop[0]));
                        break;
                    }
                    case 1079: {
                        int cip = this.joinToInt(prop, propLength);
                        switch (cip) {
                            case 1: {
                                node.setProperty("AS", "N");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("AS", "R");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("AS", "S");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("AS", "r");
                                break block0;
                            }
                            case 5: {
                                node.setProperty("AS", "s");
                                break block0;
                            }
                            case 6: {
                                node.setProperty("AS", "u");
                                break block0;
                            }
                        }
                        node.setProperty("AS", "U");
                        break;
                    }
                    case 1080: {
                        int trl = this.joinToInt(prop, propLength);
                        switch (trl) {
                            case 1: {
                                node.setProperty("Translation", "Broad");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("Translation", "Narrow");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("Translation", "Any");
                                break block0;
                            }
                        }
                        node.setProperty("Translation", "Equal");
                        break;
                    }
                    case 1081: {
                        break;
                    }
                    case 1085: {
                        int lcl = this.joinToInt(prop, propLength);
                        node.setProperty("LinkCountLow", Integer.toString(lcl));
                        break;
                    }
                    case 1086: {
                        int lch = this.joinToInt(prop, propLength);
                        node.setProperty("LinkCountHigh", Integer.toString(lch));
                        break;
                    }
                    case 1093: {
                        int saes = this.joinToInt(prop, propLength);
                        if (saes != 0 || propLength == 0) {
                            node.setProperty("ShowAtomEnhancedStereo", "true");
                            break;
                        }
                        node.setProperty("ShowAtomEnhancedStereo", "false");
                        break;
                    }
                    case 1094: {
                        int est = this.joinToInt(prop, propLength);
                        switch (est) {
                            case 1: {
                                node.setProperty("EnhancedStereoType", "None");
                                break block0;
                            }
                            case 2: {
                                node.setProperty("EnhancedStereoType", "Absolute");
                                break block0;
                            }
                            case 3: {
                                node.setProperty("EnhancedStereoType", "Or");
                                break block0;
                            }
                            case 4: {
                                node.setProperty("EnhancedStereoType", "And");
                                break block0;
                            }
                        }
                        node.setProperty("EnhancedStereoType", "Unspecified");
                        break;
                    }
                    case 1095: {
                        int esgn = this.joinToInt(prop, propLength);
                        node.setProperty("EnhancedStereoGroupNum", Integer.toString(esgn));
                        break;
                    }
                    case 16641: {
                        int H = this.joinToInt(prop, propLength);
                        node.setProperty("CXN_Query_NumberOfHydrogens", Integer.toString(H));
                        break;
                    }
                    case 16642: {
                        int V2 = this.joinToInt(prop, propLength);
                        node.setProperty("CXN_Query_Valence", Integer.toString(V2));
                        break;
                    }
                    case 16643: {
                        int X = this.joinToInt(prop, propLength);
                        node.setProperty("CXN_Query_NumberOfConnections", Integer.toString(X));
                        break;
                    }
                    case 16644: {
                        int R = this.joinToInt(prop, propLength);
                        node.setProperty("CXN_Query_NumberOfRings", Integer.toString(R));
                        break;
                    }
                    case 16645: {
                        int r = this.joinToInt(prop, propLength);
                        node.setProperty("CXN_Query_SmallestRingSize", Integer.toString(r));
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(node);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!node.hasChild()) {
                node.setFirstChild(curr);
            }
            switch (code) {
                case 0: {
                    return;
                }
                case 32771: {
                    this.processFragment(curr);
                    curr = obj;
                    continue block127;
                }
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block127;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block127;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processPage(CDXObject page1) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int pageId = this.joinToInt(b1, 4);
        page1.setID(pageId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block20: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 516: {
                        int top3 = this.joinToInt(prop, 0, 4);
                        int left3 = this.joinToInt(prop, 4, 8);
                        int bottom3 = this.joinToInt(prop, 8, 12);
                        int right3 = this.joinToInt(prop, 12, 16);
                        page1.setProperty("BoundingBox", left3 + " " + top3 + " " + right3 + " " + bottom3);
                        break;
                    }
                    case 518: {
                        int top4 = this.joinToInt(prop, 0, 4);
                        int left4 = this.joinToInt(prop, 4, 8);
                        int bottom4 = this.joinToInt(prop, 8, 12);
                        int right4 = this.joinToInt(prop, 12, 16);
                        page1.setProperty("BoundsInParent", left4 + " " + top4 + " " + right4 + " " + bottom4);
                        break;
                    }
                    case 2066: {
                        int width = this.joinToInt(prop, propLength);
                        page1.setProperty("Width", width);
                        break;
                    }
                    case 2067: {
                        int height = this.joinToInt(prop, propLength);
                        page1.setProperty("Height", height);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(page1);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!page1.hasChild()) {
                page1.setFirstChild(curr);
            }
            switch (code) {
                case 32771: {
                    this.processFragment(curr);
                    curr = obj;
                    continue block20;
                }
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block20;
                }
                case 32775: {
                    this.processGraphic(curr);
                    curr = obj;
                    continue block20;
                }
                case 32778: {
                    this.processAltGroup(curr);
                    curr = obj;
                    continue block20;
                }
                case 32781: {
                    this.processScheme(curr);
                    curr = obj;
                    continue block20;
                }
                case 32782: {
                    this.processStep(curr);
                    curr = obj;
                    continue block20;
                }
                case 32791: {
                    this.processBracketedGroup(curr);
                    curr = obj;
                    continue block20;
                }
                case 32770: {
                    this.processGroup(curr);
                    curr = obj;
                    continue block20;
                }
                case 32800: {
                    this.processChemicalProperty(curr);
                    curr = obj;
                    continue block20;
                }
                case 32809: {
                    this.processRLogic(curr);
                    curr = obj;
                    continue block20;
                }
                case 32790: {
                    this.processTable(curr);
                    curr = obj;
                    continue block20;
                }
                case 32797: {
                    this.processTLCPlate(curr);
                    curr = obj;
                    continue block20;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processTable(CDXObject table) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        table.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block9: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 516: {
                        int top3 = this.joinToInt(prop, 0, 4);
                        int left3 = this.joinToInt(prop, 4, 8);
                        int bottom3 = this.joinToInt(prop, 8, 12);
                        int right3 = this.joinToInt(prop, 12, 16);
                        table.setProperty("BoundingBox", left3 + " " + top3 + " " + right3 + " " + bottom3);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(table);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!table.hasChild()) {
                table.setFirstChild(curr);
            }
            switch (code) {
                case 32769: {
                    this.processPage(curr);
                    curr = obj;
                    continue block9;
                }
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block9;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block9;
                }
                case 32770: {
                    this.processGroup(curr);
                    curr = obj;
                    continue block9;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processStep(CDXObject step1) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        step1.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                String ids = null;
                switch (code) {
                    case 3072: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepAtomMap", ids);
                        break;
                    }
                    case 3073: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepReactants", ids);
                        break;
                    }
                    case 3074: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepProducts", ids);
                        break;
                    }
                    case 3075: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepPlusses", ids);
                        break;
                    }
                    case 3076: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepArrows", ids);
                        break;
                    }
                    case 3077: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepAboveArrow", ids);
                        break;
                    }
                    case 3078: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepBelowArrow", ids);
                        break;
                    }
                    case 3079: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepAtomMapManual", ids);
                        break;
                    }
                    case 3080: {
                        ids = this.readObjIdArr(prop);
                        step1.setProperty("ReactionStepAtomMapAuto", ids);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(step1);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!step1.hasChild()) {
                step1.setFirstChild(curr);
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private String readObjIdArr(byte[] prop) {
        StringBuffer ids = new StringBuffer();
        for (int i = 0; i < prop.length / 4; ++i) {
            int id = this.joinToInt(prop, i * 4, i * 4 + 4);
            ids.append(id);
            ids.append(" ");
        }
        return ids.toString();
    }

    private String readObjIdArrWithC(byte[] prop) {
        StringBuffer ids = new StringBuffer();
        int idCount = this.joinToInt(prop, 2);
        for (int i = 0; i < idCount; ++i) {
            int id = this.joinToInt(prop, i * 4 + 2, i * 4 + 6);
            ids.append(id);
            ids.append(" ");
        }
        return ids.toString();
    }

    private void processScheme(CDXObject scheme1) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        scheme1.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block3: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                continue;
            }
            curr.setType(code);
            curr.setParent(scheme1);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!scheme1.hasChild()) {
                scheme1.setFirstChild(curr);
            }
            switch (code) {
                case 32782: {
                    this.processStep(curr);
                    curr = obj;
                    continue block3;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processAltGroup(CDXObject altg) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        altg.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block12: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 2816: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        altg.setProperty("TextFrame", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 2817: {
                        int top2 = this.joinToInt(prop, 0, 4);
                        int left2 = this.joinToInt(prop, 4, 8);
                        int bottom2 = this.joinToInt(prop, 8, 12);
                        int right2 = this.joinToInt(prop, 12, 16);
                        altg.setProperty("GroupFrame", left2 + " " + top2 + " " + right2 + " " + bottom2);
                        break;
                    }
                    case 2818: {
                        altg.setProperty("Valence", Integer.toString(this.joinToInt(prop, propLength)));
                        break;
                    }
                    case 516: {
                        int top3 = this.joinToInt(prop, 0, 4);
                        int left3 = this.joinToInt(prop, 4, 8);
                        int bottom3 = this.joinToInt(prop, 8, 12);
                        int right3 = this.joinToInt(prop, 12, 16);
                        altg.setProperty("BoundingBox", left3 + " " + top3 + " " + right3 + " " + bottom3);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(altg);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!altg.hasChild()) {
                altg.setFirstChild(curr);
            }
            switch (code) {
                case 32771: {
                    this.processFragment(curr);
                    curr = obj;
                    continue block12;
                }
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block12;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block12;
                }
                case 32770: {
                    this.processGroup(curr);
                    curr = obj;
                    continue block12;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processGroup(CDXObject group1) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        group1.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block13: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 2818: {
                        int in = this.joinToInt(prop, propLength);
                        if (in != 0 || propLength == 0) {
                            group1.setProperty("Integral", "True");
                            break;
                        }
                        group1.setProperty("Integral", "False");
                        break;
                    }
                    case 516: {
                        int top3 = this.joinToInt(prop, 0, 4);
                        int left3 = this.joinToInt(prop, 4, 8);
                        int bottom3 = this.joinToInt(prop, 8, 12);
                        int right3 = this.joinToInt(prop, 12, 16);
                        group1.setProperty("BoundingBox", left3 + " " + top3 + " " + right3 + " " + bottom3);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(group1);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!group1.hasChild()) {
                group1.setFirstChild(curr);
            }
            switch (code) {
                case 32771: {
                    this.processFragment(curr);
                    curr = obj;
                    continue block13;
                }
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block13;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block13;
                }
                case 32770: {
                    this.processGroup(curr);
                    curr = obj;
                    continue block13;
                }
                case 32775: {
                    this.processGraphic(curr);
                    curr = obj;
                    continue block13;
                }
                case 32778: {
                    this.processAltGroup(curr);
                    curr = obj;
                    continue block13;
                }
                case 32782: {
                    this.processStep(curr);
                    curr = obj;
                    continue block13;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processText(CDXObject text) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int textId = this.joinToInt(b1, 4);
        text.setID(textId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block33: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 512: {
                        int y = this.joinToInt(prop, 0, 4);
                        int x = this.joinToInt(prop, 4, 8);
                        text.setProperty("p", x + " " + y);
                        break;
                    }
                    case 513: {
                        int zz = this.joinToInt(prop, 0, 4);
                        int yy = this.joinToInt(prop, 4, 8);
                        int xx = this.joinToInt(prop, 8, 12);
                        text.setProperty("xyz", xx + " " + yy + " " + zz);
                        break;
                    }
                    case 516: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        text.setProperty("BoundingBox", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 517: {
                        int angle = this.joinToInt(prop, propLength);
                        text.setProperty("RotationAngle", Integer.toString(angle));
                        break;
                    }
                    case 16: {
                        this.readCDXString(text, prop, "Warning");
                        break;
                    }
                    case 1792: {
                        this.readCDXString(text, prop, "Text");
                        break;
                    }
                    case 1793: {
                        int just = this.joinToInt(prop, propLength);
                        switch (just) {
                            case -1: {
                                text.setProperty("Justification", "Right");
                                break block0;
                            }
                            case 0: {
                                text.setProperty("Justification", "Left");
                                break block0;
                            }
                            case 1: {
                                text.setProperty("Justification", "Center");
                                break block0;
                            }
                            case 2: {
                                text.setProperty("Justification", "Full");
                                break block0;
                            }
                            case 3: {
                                text.setProperty("Justification", "Above");
                                break block0;
                            }
                            case 4: {
                                text.setProperty("Justification", "Below");
                                break block0;
                            }
                            case 5: {
                                text.setProperty("Justification", "Auto");
                                break block0;
                            }
                            case 6: {
                                text.setProperty("Justification", "Best");
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2060: {
                        int cjust = this.joinToInt(prop, propLength);
                        switch (cjust) {
                            case -1: {
                                text.setProperty("CaptionJustification", "Right");
                                break block0;
                            }
                            case 0: {
                                text.setProperty("CaptionJustification", "Left");
                                break block0;
                            }
                            case 1: {
                                text.setProperty("CaptionJustification", "Center");
                                break block0;
                            }
                            case 2: {
                                text.setProperty("CaptionJustification", "Full");
                                break block0;
                            }
                            case 3: {
                                text.setProperty("CaptionJustification", "Above");
                                break block0;
                            }
                            case 4: {
                                text.setProperty("CaptionJustification", "Below");
                                break block0;
                            }
                            case 5: {
                                text.setProperty("CaptionJustification", "Auto");
                                break block0;
                            }
                            case 6: {
                                text.setProperty("CaptionJustification", "Best");
                                break block0;
                            }
                        }
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(text);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!text.hasChild()) {
                text.setFirstChild(curr);
            }
            switch (code) {
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block33;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void readCDXString(CDXObject obj, byte[] b1, String type) {
        int styleRunCount = this.joinToInt(b1, 2);
        CDXObject[] style1 = new CDXObject[styleRunCount];
        int[] startChars = new int[styleRunCount];
        obj.setProperty(type + "_styleRunCount", Integer.toString(styleRunCount));
        for (int i = 0; i < styleRunCount; ++i) {
            int charStart = this.joinToInt(b1, 10 * i + 2, 10 * i + 4);
            int fontId = this.joinToInt(b1, 10 * i + 4, 10 * i + 6);
            int fontType = this.joinToInt(b1, 10 * i + 6, 10 * i + 8);
            int fontSize = this.joinToInt(b1, 10 * i + 8, 10 * i + 10);
            int fontColor = this.joinToInt(b1, 10 * i + 10, 10 * i + 12);
            startChars[i] = charStart;
            style1[i] = new CDXObject(258);
            style1[i].setParent(obj);
            if (i != 0) {
                style1[i].setPrev(style1[i - 1]);
                style1[i - 1].setNext(style1[i]);
            } else {
                obj.setFirstChild(style1[i]);
            }
            style1[i].setProperty("charstart", Integer.toString(charStart));
            style1[i].setProperty("font", Integer.toString(fontId));
            style1[i].setProperty("face", Integer.toString(fontType));
            style1[i].setProperty("size", Integer.toString(fontSize));
            style1[i].setProperty("color", Integer.toString(fontColor));
            CDXObject fonttable1 = (CDXObject)this.root.getProperty("fonttable");
            CDXObject font1 = (CDXObject)fonttable1.getProperty(Integer.toString(fontId));
            if (font1 == null) continue;
            String enc = (String)font1.getProperty("charset");
            style1[i].setProperty("charset", enc);
        }
        StringBuffer sb = new StringBuffer();
        if (styleRunCount > 0) {
            byte[] text = new byte[b1.length - (styleRunCount * 10 + 2)];
            int j = 0;
            for (int i = styleRunCount * 10 + 2; i < b1.length; ++i) {
                text[j] = b1[i];
                ++j;
            }
            byte[] part = null;
            for (int i = 0; i < styleRunCount; ++i) {
                int partLength = 0;
                partLength = i < styleRunCount - 1 ? startChars[i + 1] - startChars[i] : text.length - startChars[i];
                part = new byte[partLength];
                String enc = (String)style1[i].getProperty("charset");
                j = 0;
                for (int k = startChars[i]; k < startChars[i] + partLength; ++k) {
                    part[j] = text[k];
                    ++j;
                }
                try {
                    String str = enc == null ? new String(part) : new String(part, enc);
                    sb.append(str);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    String str = new String(part);
                    sb.append(str);
                }
            }
        } else {
            for (int i = styleRunCount * 10 + 2; i < b1.length; ++i) {
                if (b1[i] <= 0) continue;
                sb.append((char)b1[i]);
            }
        }
        obj.setProperty(type, sb.toString());
    }

    private void processBracketedGroup(CDXObject bgr) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int textId = this.joinToInt(b1, 4);
        bgr.setID(textId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block39: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 2596: {
                        int bru = this.joinToInt(prop, propLength);
                        switch (bru) {
                            case 3: {
                                bgr.setProperty("BracketUsage", "SRU");
                                break block0;
                            }
                            case 4: {
                                bgr.setProperty("BracketUsage", "Monomer");
                                break block0;
                            }
                            case 5: {
                                bgr.setProperty("BracketUsage", "Mer");
                                break block0;
                            }
                            case 6: {
                                bgr.setProperty("BracketUsage", "Copolymer");
                                break block0;
                            }
                            case 7: {
                                bgr.setProperty("BracketUsage", "CopolymerAlternating");
                                break block0;
                            }
                            case 8: {
                                bgr.setProperty("BracketUsage", "CopolymerRandom");
                                break block0;
                            }
                            case 9: {
                                bgr.setProperty("BracketUsage", "CopolymerBlock");
                                break block0;
                            }
                            case 10: {
                                bgr.setProperty("BracketUsage", "Crosslink");
                                break block0;
                            }
                            case 11: {
                                bgr.setProperty("BracketUsage", "Graft");
                                break block0;
                            }
                            case 12: {
                                bgr.setProperty("BracketUsage", "Modification");
                                break block0;
                            }
                            case 13: {
                                bgr.setProperty("BracketUsage", "Component");
                                break block0;
                            }
                            case 14: {
                                bgr.setProperty("BracketUsage", "MixtureUnordered");
                                break block0;
                            }
                            case 15: {
                                bgr.setProperty("BracketUsage", "MixtureOrdered");
                                break block0;
                            }
                            case 16: {
                                bgr.setProperty("BracketUsage", "MultipleGroup");
                                break block0;
                            }
                            case 17: {
                                bgr.setProperty("BracketUsage", "Generic");
                                break block0;
                            }
                            case 18: {
                                bgr.setProperty("BracketUsage", "Anypolymer");
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2597: {
                        int ht = this.joinToInt(prop, propLength);
                        switch (ht) {
                            case 1: {
                                bgr.setProperty("PolymerRepeatPattern", "HeadToHead");
                                break block0;
                            }
                            case 2: {
                                bgr.setProperty("PolymerRepeatPattern", "EitherUnknown");
                                break block0;
                            }
                        }
                        bgr.setProperty("PolymerRepeatPattern", "HeadToTail");
                        break;
                    }
                    case 2598: {
                        int flip = this.joinToInt(prop, propLength);
                        switch (flip) {
                            case 1: {
                                bgr.setProperty("PolymerFlipType", "NoFlip");
                                break block0;
                            }
                            case 2: {
                                bgr.setProperty("PolymerFlipType", "Flip");
                                break block0;
                            }
                        }
                        bgr.setProperty("PolymerFlipType", "Unspecified");
                        break;
                    }
                    case 2599: {
                        String ids = this.readObjIdArr(prop);
                        bgr.setProperty("BracketedObjectIDs", ids);
                        break;
                    }
                    case 2600: {
                        double repeatCount = this.arr2double(prop, 0);
                        bgr.setProperty("RepeatCount", Double.toString(repeatCount));
                        break;
                    }
                    case 2601: {
                        int co = this.joinToInt(prop, propLength);
                        bgr.setProperty("ComponentOrder", Integer.toString(co));
                        break;
                    }
                    case 2602: {
                        StringBuffer sb = new StringBuffer();
                        for (int i = 0; i < prop.length; ++i) {
                            if (prop[i] == 0) continue;
                            sb.append((char)prop[i]);
                        }
                        bgr.setProperty("SRULabel", sb.toString());
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(bgr);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!bgr.hasChild()) {
                bgr.setFirstChild(curr);
            }
            switch (code) {
                case 32791: {
                    this.processBracketedGroup(curr);
                    curr = obj;
                    continue block39;
                }
                case 32792: {
                    this.processBracketAttachment(curr);
                    curr = obj;
                    continue block39;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processBracketAttachment(CDXObject bra) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        bra.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 2603: {
                        int gid = this.joinToInt(prop, propLength);
                        bra.setProperty("GraphicID", Integer.toString(gid));
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(bra);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!bra.hasChild()) {
                bra.setFirstChild(curr);
            }
            switch (code) {
                case 32793: {
                    this.processCrossingBond(curr);
                    curr = obj;
                    break;
                }
                default: {
                    this.skipObject(curr);
                    curr = obj;
                }
            }
            curr = obj;
        }
    }

    private void processCrossingBond(CDXObject cb) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        cb.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 2604: {
                        int bondID = this.joinToInt(prop, propLength);
                        cb.setProperty("BondID", Integer.toString(bondID));
                        break;
                    }
                    case 2605: {
                        int innerAtomID = this.joinToInt(prop, propLength);
                        cb.setProperty("InnerAtomID", Integer.toString(innerAtomID));
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(cb);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!cb.hasChild()) {
                cb.setFirstChild(curr);
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processGraphic(CDXObject gr) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        gr.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block84: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 14: {
                        int object = this.joinToInt(prop, 0, 4);
                        int attribute = this.joinToInt(prop, 4, 6);
                        CDXObject representspropery = new CDXObject(14);
                        representspropery.setProperty("object", Integer.toString(object));
                        representspropery.setProperty("attribute", Integer.toString(attribute));
                        representspropery.setParent(gr);
                        gr.setProperty("represent", representspropery);
                        break;
                    }
                    case 18: {
                        int supersededby = this.joinToInt(prop, propLength);
                        gr.setProperty("SupersededBy", Integer.toString(supersededby));
                        break;
                    }
                    case 516: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        gr.setProperty("BoundingBox", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 526: {
                        int X = this.joinToInt(prop, 0, 4);
                        int Y = this.joinToInt(prop, 4, 8);
                        int Z = this.joinToInt(prop, 8, 12);
                        gr.setProperty("MajorAxisEnd3D", X + " " + Y + " " + Z);
                        break;
                    }
                    case 527: {
                        int X2 = this.joinToInt(prop, 0, 4);
                        int Y2 = this.joinToInt(prop, 4, 8);
                        int Z2 = this.joinToInt(prop, 8, 12);
                        gr.setProperty("MinorAxisEnd3D", X2 + " " + Y2 + " " + Z2);
                        break;
                    }
                    case 769: {
                        int color1 = this.joinToInt(prop, propLength);
                        gr.setProperty("color", Integer.toString(color1));
                        break;
                    }
                    case 770: {
                        int bgcolor = this.joinToInt(prop, propLength);
                        gr.setProperty("bgcolor", Integer.toString(bgcolor));
                        break;
                    }
                    case 2560: {
                        int grapType = this.joinToInt(prop, propLength);
                        switch (grapType) {
                            case 1: {
                                gr.setProperty("GraphicType", "Line");
                                break block0;
                            }
                            case 2: {
                                gr.setProperty("GraphicType", "Arc");
                                break block0;
                            }
                            case 3: {
                                gr.setProperty("GraphicType", "Rectangle");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("GraphicType", "Oval");
                                break block0;
                            }
                            case 5: {
                                gr.setProperty("GraphicType", "Orbital");
                                break block0;
                            }
                            case 6: {
                                gr.setProperty("GraphicType", "Bracket");
                                break block0;
                            }
                            case 7: {
                                gr.setProperty("GraphicType", "Symbol");
                                break block0;
                            }
                        }
                        gr.setProperty("GraphicType", "Undefined");
                        break;
                    }
                    case 2561: {
                        int lineType = this.joinToInt(prop, propLength);
                        switch (lineType) {
                            case 0: {
                                gr.setProperty("LineType", "Solid");
                                break block0;
                            }
                            case 1: {
                                gr.setProperty("LineType", "Dashed");
                                break block0;
                            }
                            case 2: {
                                gr.setProperty("LineType", "Bold");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("LineType", "Wavy");
                                break block0;
                            }
                        }
                        gr.setProperty("LineType", "Solid");
                        break;
                    }
                    case 2562: {
                        int arrowType = this.joinToInt(prop, propLength);
                        switch (arrowType) {
                            case 1: {
                                gr.setProperty("ArrowType", "HalfHead");
                                break block0;
                            }
                            case 2: {
                                gr.setProperty("ArrowType", "FullHead");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("ArrowType", "Resonance");
                                break block0;
                            }
                            case 8: {
                                gr.setProperty("ArrowType", "Equilibrium");
                                break block0;
                            }
                            case 16: {
                                gr.setProperty("ArrowType", "Hollow");
                                break block0;
                            }
                            case 32: {
                                gr.setProperty("ArrowType", "RetroSynthetic");
                                break block0;
                            }
                        }
                        gr.setProperty("ArrowType", "NoHead");
                        break;
                    }
                    case 2563: {
                        int rectType = this.joinToInt(prop, propLength);
                        if (rectType == 0) {
                            gr.setProperty("RectangleType", "Plain");
                            break;
                        }
                        StringBuffer rb = new StringBuffer();
                        if ((rectType & 1) != 0) {
                            rb.append("RoundEdge ");
                        }
                        if ((rectType & 2) != 0) {
                            rb.append("Shadow ");
                        }
                        if ((rectType & 4) != 0) {
                            rb.append("Shaded ");
                        }
                        if ((rectType & 8) != 0) {
                            rb.append("Filled ");
                        }
                        if ((rectType & 0x10) != 0) {
                            rb.append("Dashed ");
                        }
                        if ((rectType & 0x20) != 0) {
                            rb.append("Bold ");
                        }
                        gr.setProperty("RectangleType", rb.toString());
                        break;
                    }
                    case 2564: {
                        int ovalType = this.joinToInt(prop, propLength);
                        StringBuffer ot = new StringBuffer();
                        if ((ovalType & 1) != 0) {
                            ot.append("Circle ");
                        }
                        if ((ovalType & 2) != 0) {
                            ot.append("Shaded ");
                        }
                        if ((ovalType & 4) != 0) {
                            ot.append("Filled ");
                        }
                        if ((ovalType & 8) != 0) {
                            ot.append("Dashed ");
                        }
                        if ((ovalType & 0x10) != 0) {
                            ot.append("Bold ");
                        }
                        if ((ovalType & 0x20) != 0) {
                            ot.append("Shadowed ");
                        }
                        gr.setProperty("OvalType", ot.toString());
                        break;
                    }
                    case 2566: {
                        int bracketType = this.joinToInt(prop, propLength);
                        switch (bracketType) {
                            case 1: {
                                gr.setProperty("BracketType", "SquarePair");
                                break block0;
                            }
                            case 2: {
                                gr.setProperty("BracketType", "CurlyPair");
                                break block0;
                            }
                            case 3: {
                                gr.setProperty("BracketType", "Square");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("BracketType", "Curly");
                                break block0;
                            }
                            case 5: {
                                gr.setProperty("BracketType", "Round");
                                break block0;
                            }
                        }
                        gr.setProperty("BracketType", "RoundPair");
                        break;
                    }
                    case 2567: {
                        int symbType = this.joinToInt(prop, propLength);
                        switch (symbType) {
                            case 1: {
                                gr.setProperty("SymbolType", "Electron");
                                break block0;
                            }
                            case 2: {
                                gr.setProperty("SymbolType", "RadicalCaltion");
                                break block0;
                            }
                            case 3: {
                                gr.setProperty("SymbolType", "RadicalAnion");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("SymbolType", "CirclePlus");
                                break block0;
                            }
                            case 5: {
                                gr.setProperty("SymbolType", "CircleMinus");
                                break block0;
                            }
                            case 6: {
                                gr.setProperty("SymbolType", "Dagger");
                                break block0;
                            }
                            case 7: {
                                gr.setProperty("SymbolType", "DoubleDagger");
                                break block0;
                            }
                            case 8: {
                                gr.setProperty("SymbolType", "Plus");
                                break block0;
                            }
                            case 9: {
                                gr.setProperty("SymbolType", "Minus");
                                break block0;
                            }
                            case 10: {
                                gr.setProperty("SymbolType", "Racemic");
                                break block0;
                            }
                            case 11: {
                                gr.setProperty("SymbolType", "Absolute");
                                break block0;
                            }
                            case 12: {
                                gr.setProperty("SymbolType", "Relative");
                                break block0;
                            }
                        }
                        gr.setProperty("SymbolType", "LonePair");
                        break;
                    }
                    case 2593: {
                        int angSize = this.joinToInt(prop, propLength);
                        if (angSize > Short.MAX_VALUE) {
                            angSize = 65536 - angSize;
                        }
                        gr.setProperty("AngularSize", Integer.toString(angSize / 10));
                        break;
                    }
                    case 2596: {
                        int bru = this.joinToInt(prop, propLength);
                        switch (bru) {
                            case 3: {
                                gr.setProperty("BracketUsage", "SRU");
                                break block0;
                            }
                            case 4: {
                                gr.setProperty("BracketUsage", "Monomer");
                                break block0;
                            }
                            case 5: {
                                gr.setProperty("BracketUsage", "Mer");
                                break block0;
                            }
                            case 6: {
                                gr.setProperty("BracketUsage", "Copolymer");
                                break block0;
                            }
                            case 7: {
                                gr.setProperty("BracketUsage", "CopolymerAlternating");
                                break block0;
                            }
                            case 8: {
                                gr.setProperty("BracketUsage", "CopolymerRandom");
                                break block0;
                            }
                            case 9: {
                                gr.setProperty("BracketUsage", "CopolymerBlock");
                                break block0;
                            }
                            case 10: {
                                gr.setProperty("BracketUsage", "Crosslink");
                                break block0;
                            }
                            case 11: {
                                gr.setProperty("BracketUsage", "Graft");
                                break block0;
                            }
                            case 12: {
                                gr.setProperty("BracketUsage", "Modification");
                                break block0;
                            }
                            case 13: {
                                gr.setProperty("BracketUsage", "Component");
                                break block0;
                            }
                            case 14: {
                                gr.setProperty("BracketUsage", "MixtureUnordered");
                                break block0;
                            }
                            case 15: {
                                gr.setProperty("BracketUsage", "MixtureOrdered");
                                break block0;
                            }
                            case 16: {
                                gr.setProperty("BracketUsage", "MultipleGroup");
                                break block0;
                            }
                            case 17: {
                                gr.setProperty("BracketUsage", "Generic");
                                break block0;
                            }
                            case 18: {
                                gr.setProperty("BracketUsage", "Anypolymer");
                                break block0;
                            }
                        }
                        break;
                    }
                    case 2599: {
                        String ids = this.readObjIdArr(prop);
                        gr.setProperty("BracketedObjectIDs", ids);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(gr);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!gr.hasChild()) {
                gr.setFirstChild(curr);
            }
            switch (code) {
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block84;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processObjectTag(CDXObject ot) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        ot.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block7: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 3328: {
                        int type = this.joinToInt(prop, propLength);
                        ot.setProperty("TagType", Integer.toString(type));
                        break;
                    }
                    case 8: {
                        StringBuffer sbx = new StringBuffer();
                        for (int i = 0; i < prop.length; ++i) {
                            sbx.append((char)prop[i]);
                        }
                        ot.setProperty("Name", sbx.toString());
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(ot);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!ot.hasChild()) {
                ot.setFirstChild(curr);
            }
            switch (code) {
                case 32774: {
                    this.processText(curr);
                    curr = obj;
                    continue block7;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void skipObject(CDXObject xobj) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        xobj.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                continue;
            }
            curr.setType(code);
            curr.setParent(xobj);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!xobj.hasChild()) {
                xobj.setFirstChild(curr);
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processCDX() throws MolFormatException {
        block49: {
            try {
                if (!this.checkHeader()) {
                    throw new MolFormatException("Not CDX file! Header error.");
                }
                int code = -1;
                int propLength = 0;
                this.root = new CDXObject(32768);
                this.root.setProperty("FromCDX", "True");
                CDXObject curr = new CDXObject();
                byte[] b1 = new byte[4];
                block30: while (code != 0) {
                    int z = this.mis.read(b1, 0, 2);
                    code = this.joinToInt(b1, z);
                    if (code < 32768) {
                        if (code == 0) break;
                        z = this.mis.read(b1, 0, 2);
                        propLength = this.joinToInt(b1, z);
                        if (propLength == 65535) {
                            z = this.mis.read(b1, 0, 4);
                            propLength = this.joinToInt(b1, z);
                        }
                        byte[] prop = new byte[propLength];
                        this.mis.read(prop, 0, propLength);
                        switch (code) {
                            case 1: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("CreationUserName", s.toString());
                                break;
                            }
                            case 2: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("CreationDate", s.toString());
                                break;
                            }
                            case 3: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("CreationProgram", s.toString());
                                break;
                            }
                            case 4: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("ModificationUserName", s.toString());
                                break;
                            }
                            case 5: {
                                break;
                            }
                            case 6: {
                                break;
                            }
                            case 8: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("Name", s.toString());
                                break;
                            }
                            case 9: {
                                int i;
                                StringBuffer s = new StringBuffer();
                                for (i = 0; i < propLength; ++i) {
                                    if (prop[i] == 0) continue;
                                    s.append((char)prop[i]);
                                }
                                this.root.setProperty("Comment", s.toString());
                                break;
                            }
                            case 2053: {
                                int bl = this.joinToInt(prop, 4);
                                this.root.setProperty("BondLength", Integer.toString(bl));
                                break;
                            }
                            case 256: {
                                int env = this.joinToInt(prop, 2);
                                int styleRunCount = this.joinToInt(prop, 2, 4);
                                CDXObject fonttable1 = new CDXObject(256);
                                fonttable1.setProperty("env", Integer.toString(env));
                                fonttable1.setParent(this.root);
                                this.root.setProperty("fonttable", fonttable1);
                                CDXObject font1 = new CDXObject(257);
                                fonttable1.setFirstChild(font1);
                                font1.setParent(fonttable1);
                                int in = 4;
                                while (in < prop.length) {
                                    in = this.readFont(font1, in, prop);
                                    CDXObject next = new CDXObject(257);
                                    fonttable1.setProperty(font1.ID(), font1);
                                    font1.setNext(next);
                                    next.setPrev(font1);
                                    next.setParent(fonttable1);
                                    font1 = next;
                                }
                                break;
                            }
                            case 516: {
                                break;
                            }
                            case 768: {
                                int colorNum = this.joinToInt(prop, 2);
                                Color[] colors = new Color[colorNum + 2];
                                colors[0] = Color.BLACK;
                                colors[1] = Color.WHITE;
                                byte[] col = new byte[2];
                                for (int i = 0; i < colorNum; ++i) {
                                    col[0] = prop[2 + i * 6];
                                    col[1] = prop[3 + i * 6];
                                    int redInt = this.joinToInt(col, 2);
                                    col[0] = prop[4 + i * 6];
                                    col[1] = prop[5 + i * 6];
                                    int greenInt = this.joinToInt(col, 2);
                                    col[0] = prop[6 + i * 6];
                                    col[1] = prop[7 + i * 6];
                                    int blueInt = this.joinToInt(col, 2);
                                    float red = (float)redInt / 65535.0f;
                                    float green = (float)greenInt / 65535.0f;
                                    float blue = (float)blueInt / 65535.0f;
                                    colors[i + 2] = new Color(red, green, blue);
                                }
                                this.root.setProperty("colors", colors);
                                break;
                            }
                            case 2054: {
                                int bw = this.joinToInt(prop, propLength);
                                this.root.setProperty("BoldWidth", Integer.toString(bw));
                                break;
                            }
                            case 2055: {
                                int lw = this.joinToInt(prop, propLength);
                                this.root.setProperty("LineWidth", Integer.toString(lw));
                                break;
                            }
                            case 1082: {
                                int saq = this.joinToInt(prop, propLength);
                                if (saq != 0 || propLength == 0) {
                                    this.root.setProperty("ShowAtomQuery", "true");
                                    break;
                                }
                                this.root.setProperty("ShowAtomQuery", "false");
                                break;
                            }
                            case 1083: {
                                int sas = this.joinToInt(prop, propLength);
                                if (sas != 0 || propLength == 0) {
                                    this.root.setProperty("ShowAtomStereo", "true");
                                    break;
                                }
                                this.root.setProperty("ShowAtomStereo", "false");
                                break;
                            }
                            case 1084: {
                                int san = this.joinToInt(prop, propLength);
                                if (san != 0 || propLength == 0) {
                                    this.root.setProperty("ShowAtomNumber", "true");
                                    break;
                                }
                                this.root.setProperty("ShowAtomNumber", "false");
                                break;
                            }
                            case 1548: {
                                int sbq = this.joinToInt(prop, propLength);
                                if (sbq != 0 || propLength == 0) {
                                    this.root.setProperty("ShowBondQuery", "true");
                                    break;
                                }
                                this.root.setProperty("ShowBondQuery", "false");
                                break;
                            }
                            case 1549: {
                                int sbs = this.joinToInt(prop, propLength);
                                if (sbs != 0 || propLength == 0) {
                                    this.root.setProperty("ShowBondStereo", "true");
                                    break;
                                }
                                this.root.setProperty("ShowBondStereo", "false");
                                break;
                            }
                            case 1551: {
                                int sbr = this.joinToInt(prop, propLength);
                                if (sbr != 0 || propLength == 0) {
                                    this.root.setProperty("ShowBondRxn", "true");
                                    break;
                                }
                                this.root.setProperty("ShowBondRxn", "false");
                                break;
                            }
                            case 2050: {
                                int top = this.joinToInt(prop, 0, 4);
                                int left = this.joinToInt(prop, 4, 8);
                                int bottom = this.joinToInt(prop, 8, 12);
                                int right = this.joinToInt(prop, 12, 16);
                                this.root.setProperty("PrintMargins", left + " " + top + " " + right + " " + bottom);
                                break;
                            }
                            case 2062: {
                                int magn = this.joinToInt(prop, propLength);
                                this.root.setProperty("Magnification", Integer.toString(magn));
                                break;
                            }
                        }
                        continue;
                    }
                    curr.setType(code);
                    curr.setParent(this.root);
                    CDXObject obj = new CDXObject();
                    obj.setPrev(curr);
                    curr.setNext(obj);
                    if (!this.root.hasChild()) {
                        this.root.setFirstChild(curr);
                    }
                    switch (code) {
                        case 32769: {
                            this.processPage(curr);
                            curr = obj;
                            continue block30;
                        }
                    }
                    this.skipObject(curr);
                    curr = obj;
                    throw new MolFormatException("illegal subobject: " + code);
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(CDXImport.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                if (!(ex instanceof MolFormatException)) break block49;
                throw new MolFormatException(ex);
            }
        }
    }

    private int readFont(CDXObject font1, int index, byte[] b1) {
        int i = index;
        int id = this.joinToInt(b1, i, i + 2);
        font1.ID(id);
        int fontC = this.joinToInt(b1, i += 2, i + 2);
        i += 2;
        String charsetName = null;
        for (int j = 0; j < charsetCodes.length; ++j) {
            if (charsetCodes[j] != fontC) continue;
            charsetName = charsetNames[j];
            break;
        }
        font1.setProperty("charset", charsetName);
        int fontNameLength = this.joinToInt(b1, i, i + 1);
        StringBuffer sb = new StringBuffer();
        for (int j = i += 2; j < i + fontNameLength; ++j) {
            sb.append((char)b1[j]);
        }
        font1.setProperty("name", sb.toString());
        return i + fontNameLength;
    }

    private void zero(byte[] ar) {
        for (int i = 0; i < ar.length; ++i) {
            ar[i] = 0;
        }
    }

    private void zero(byte[] ar, int l) {
        for (int i = 0; i < l; ++i) {
            ar[i] = 0;
        }
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        mol.clearForImport("cdx");
        mol.setStartPosition(this.mis.getFilePointer());
        this.processCDX();
        CDXObjectReader r = new CDXObjectReader();
        boolean notEmpty = r.readMol(this.root, mol);
        mol.setEndPosition(this.mis.getFilePointer());
        return notEmpty;
    }

    @Override
    public MDocument readDocument(MDocument md) throws IOException {
        this.processCDX();
        CDXObjectReader reader = new CDXObjectReader();
        md = reader.readDocument(this.root, md);
        return md;
    }

    @Override
    public boolean isDocumentImporter() {
        return true;
    }

    @Override
    public void initMolImport(MRecord record, String fname) throws MolFormatException, IOException {
        String molstr = record.getMolString();
        String enc = record.getEncoding();
        byte[] molData = Base64.decode(molstr);
        ByteArrayInputStream bais = new ByteArrayInputStream(molData);
        this.mis = new MolInputStream((InputStream)bais, record.getFormat(), enc, fname);
        this.initMolImport(this.mis);
    }

    @Override
    public void initMolImport(MolInputStream is) throws MolFormatException, IOException {
        this.mis = is;
    }

    @Override
    public Molecule createMol() {
        RgMolecule mol = new RgMolecule();
        return mol;
    }

    private void processChemicalProperty(CDXObject chemProp) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        chemProp.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 8: {
                        if (prop[0] != 0 && prop[1] != 0) {
                            byte[] newprop = new byte[propLength + 2];
                            newprop[0] = 0;
                            newprop[1] = 0;
                            for (int i = 0; i < prop.length; ++i) {
                                newprop[i + 2] = prop[i];
                            }
                            prop = newprop;
                        }
                        this.readCDXString(chemProp, prop, "Name");
                        break;
                    }
                    case 2946: {
                        String boIDs = this.readObjIdArr(prop);
                        chemProp.setProperty("BasisObjects", boIDs);
                        break;
                    }
                    case 2992: {
                        String cpType = this.readObjIdArr(prop);
                        chemProp.setProperty("ChemicalPropertyType", cpType);
                        break;
                    }
                    case 2993: {
                        int cpID = this.joinToInt(prop, propLength);
                        chemProp.setProperty("ChemicalPropertyDisplayID", cpID);
                        break;
                    }
                    case 2994: {
                        chemProp.setProperty("ChemicalPropertyActive", "True");
                        break;
                    }
                    case 3334: {
                        String posS;
                        byte pos = prop[0];
                        switch (pos) {
                            case 1: {
                                posS = "angle";
                                break;
                            }
                            case 2: {
                                posS = "offset";
                                break;
                            }
                            case 3: {
                                posS = "absolute";
                                break;
                            }
                            default: {
                                posS = "auto";
                            }
                        }
                        chemProp.setProperty("PositionintType", posS);
                        break;
                    }
                    case 3335: {
                        int pangle = this.joinToInt(prop, propLength);
                        chemProp.setProperty("PositionintAngle", Integer.toString(pangle));
                        break;
                    }
                    case 3336: {
                        int y = this.joinToInt(prop, 0, 4);
                        int x = this.joinToInt(prop, 4, 8);
                        chemProp.setProperty("PositionintOffset", x + " " + y);
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(chemProp);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!chemProp.hasChild()) {
                chemProp.setFirstChild(curr);
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processRLogic(CDXObject rLogic) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        rLogic.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block21: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                block0 : switch (code) {
                    case 10: {
                        int zorder = this.joinToInt(prop, propLength);
                        rLogic.setProperty("Z", Integer.toString(zorder));
                        break;
                    }
                    case 512: {
                        int y = this.joinToInt(prop, 0, 4);
                        int x = this.joinToInt(prop, 4, 8);
                        rLogic.setProperty("p", x + " " + y);
                        break;
                    }
                    case 516: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        rLogic.setProperty("BoundingBox", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 769: {
                        int color1 = this.joinToInt(prop, propLength);
                        rLogic.setProperty("color", Integer.toString(color1));
                        break;
                    }
                    case 1792: {
                        break;
                    }
                    case 1793: {
                        int just = this.joinToInt(prop, propLength);
                        switch (just) {
                            case -1: {
                                rLogic.setProperty("Justification", "Right");
                                break block0;
                            }
                            case 0: {
                                rLogic.setProperty("Justification", "Left");
                                break block0;
                            }
                            case 1: {
                                rLogic.setProperty("Justification", "Center");
                                break block0;
                            }
                            case 2: {
                                rLogic.setProperty("Justification", "Full");
                                break block0;
                            }
                            case 3: {
                                rLogic.setProperty("Justification", "Above");
                                break block0;
                            }
                            case 4: {
                                rLogic.setProperty("Justification", "Below");
                                break block0;
                            }
                            case 5: {
                                rLogic.setProperty("Justification", "Auto");
                                break block0;
                            }
                            case 6: {
                                rLogic.setProperty("Justification", "Best");
                                break block0;
                            }
                        }
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(rLogic);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!rLogic.hasChild()) {
                rLogic.setFirstChild(curr);
            }
            switch (code) {
                case 32810: {
                    this.processRLogicItem(curr);
                    curr = obj;
                    continue block21;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processRLogicItem(CDXObject rLogicItem) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        rLogicItem.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block9: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                switch (code) {
                    case 5120: {
                        int i;
                        StringBuilder sb = new StringBuilder();
                        for (i = 0; i < propLength; ++i) {
                            sb.append(new Character((char)prop[i]));
                        }
                        rLogicItem.setProperty("RLogicGroup", sb.toString());
                        break;
                    }
                    case 5121: {
                        int i;
                        StringBuilder sb = new StringBuilder();
                        for (i = 0; i < propLength; ++i) {
                            sb.append(new Character((char)prop[i]));
                        }
                        rLogicItem.setProperty("RLogicOccurrence", sb.toString());
                        break;
                    }
                    case 5122: {
                        rLogicItem.setProperty("RLogicRestH", "true");
                        break;
                    }
                    case 5123: {
                        int i;
                        StringBuilder sb = new StringBuilder();
                        for (i = 0; i < propLength; ++i) {
                            sb.append(new Character((char)prop[i]));
                        }
                        rLogicItem.setProperty("RLogicIfThenGroup", sb.toString());
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(rLogicItem);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!rLogicItem.hasChild()) {
                rLogicItem.setFirstChild(curr);
            }
            switch (code) {
                case 32810: {
                    this.processRLogicItem(curr);
                    curr = obj;
                    continue block9;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processTLCPlate(CDXObject plate) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        plate.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block20: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                String propname = "";
                boolean propNameSet = false;
                switch (code) {
                    case 516: {
                        int top = this.joinToInt(prop, 0, 4);
                        int left = this.joinToInt(prop, 4, 8);
                        int bottom = this.joinToInt(prop, 8, 12);
                        int right = this.joinToInt(prop, 12, 16);
                        plate.setProperty("BoundingBox", left + " " + top + " " + right + " " + bottom);
                        break;
                    }
                    case 521: {
                        propname = "TopLeft";
                        propNameSet = true;
                    }
                    case 522: {
                        if (!propNameSet) {
                            propname = "TopRight";
                            propNameSet = true;
                        }
                    }
                    case 523: {
                        if (!propNameSet) {
                            propname = "BottomLeft";
                            propNameSet = true;
                        }
                    }
                    case 524: {
                        if (!propNameSet) {
                            propname = "BottomRight";
                            propNameSet = true;
                        }
                        int y = this.joinToInt(prop, 0, 4);
                        int x = this.joinToInt(prop, 4, 8);
                        plate.setProperty(propname, x + " " + y);
                        propNameSet = false;
                        break;
                    }
                    case 769: {
                        int color1 = this.joinToInt(prop, propLength);
                        plate.setProperty("color", Integer.toString(color1));
                        break;
                    }
                    case 770: {
                        int bgcolor = this.joinToInt(prop, propLength);
                        plate.setProperty("bgcolor", Integer.toString(bgcolor));
                        break;
                    }
                    case 2066: {
                        int width = this.joinToInt(prop, propLength);
                        plate.setProperty("Width", width);
                        break;
                    }
                    case 2067: {
                        int height = this.joinToInt(prop, propLength);
                        plate.setProperty("Height", height);
                        break;
                    }
                    case 2720: {
                        double origin = this.arr2double(prop, 0);
                        plate.setProperty("OriginFraction", Double.toString(origin));
                        break;
                    }
                    case 2721: {
                        double solvent = this.arr2double(prop, 0);
                        plate.setProperty("SolventFraction", Double.toString(solvent));
                        break;
                    }
                    case 2722: {
                        int sor = this.joinToInt(prop, propLength);
                        if (sor != 0 || propLength == 0) {
                            plate.setProperty("ShowOrigin", "True");
                            break;
                        }
                        plate.setProperty("ShowOrigin", "False");
                        break;
                    }
                    case 2723: {
                        int ssf = this.joinToInt(prop, propLength);
                        boolean f = false;
                        if (ssf != 0 || propLength == 0) {
                            plate.setProperty("ShowSolventFront", "True");
                            break;
                        }
                        plate.setProperty("ShowSolventFront", "False");
                        break;
                    }
                    case 2724: {
                        int sbb = this.joinToInt(prop, propLength);
                        if (sbb != 0 || propLength == 0) {
                            plate.setProperty("ShowBorders", "True");
                            break;
                        }
                        plate.setProperty("ShowBorders", "False");
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(plate);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!plate.hasChild()) {
                plate.setFirstChild(curr);
            }
            switch (code) {
                case 32798: {
                    this.processTLCLane(curr);
                    curr = obj;
                    continue block20;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block20;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processTLCLane(CDXObject lane) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        lane.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block7: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                String propname = "";
                boolean propNameSet = false;
                switch (code) {
                    case 17: {
                        int vis = this.joinToInt(prop, propLength);
                        if (vis != 0 || propLength == 0) {
                            lane.setProperty("Visible", "True");
                            break;
                        }
                        lane.setProperty("Visible", "False");
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(lane);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!lane.hasChild()) {
                lane.setFirstChild(curr);
            }
            switch (code) {
                case 32799: {
                    this.processTLCSpot(curr);
                    curr = obj;
                    continue block7;
                }
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block7;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }

    private void processTLCSpot(CDXObject spot) throws IOException {
        byte[] b1 = new byte[4];
        int z = this.mis.read(b1, 0, 4);
        int objId = this.joinToInt(b1, 4);
        spot.setID(objId);
        int code = -1;
        int propLength = 0;
        CDXObject curr = new CDXObject();
        block14: while (code != 0) {
            z = this.mis.read(b1, 0, 2);
            code = this.joinToInt(b1, z);
            if (code < 32768) {
                if (code == 0) break;
                z = this.mis.read(b1, 0, 2);
                propLength = this.joinToInt(b1, z);
                if (propLength == 65535) {
                    z = this.mis.read(b1, 0, 4);
                    propLength = this.joinToInt(b1, z);
                }
                byte[] prop = new byte[propLength];
                this.mis.read(prop, 0, propLength);
                String propname = "";
                boolean propNameSet = false;
                switch (code) {
                    case 17: {
                        int vis = this.joinToInt(prop, propLength);
                        if (vis != 0 || propLength == 0) {
                            spot.setProperty("Visible", "True");
                            break;
                        }
                        spot.setProperty("Visible", "False");
                        break;
                    }
                    case 769: {
                        int color1 = this.joinToInt(prop, propLength);
                        spot.setProperty("color", Integer.toString(color1));
                        break;
                    }
                    case 770: {
                        int bgcolor = this.joinToInt(prop, propLength);
                        spot.setProperty("bgcolor", Integer.toString(bgcolor));
                        break;
                    }
                    case 2066: {
                        int width = this.joinToInt(prop, propLength);
                        spot.setProperty("Width", Integer.toString(width));
                        break;
                    }
                    case 2067: {
                        int height = this.joinToInt(prop, propLength);
                        spot.setProperty("Height", Integer.toString(height));
                        break;
                    }
                    case 2568: {
                        int ct = this.joinToInt(prop, propLength);
                        spot.setProperty("CurveType", Integer.toString(ct));
                        break;
                    }
                    case 2736: {
                        double rf = this.arr2double(prop, 0);
                        spot.setProperty("Rf", Double.toString(rf));
                        break;
                    }
                    case 2738: {
                        int srf = this.joinToInt(prop, propLength);
                        if (srf != 0 || propLength == 0) {
                            spot.setProperty("ShowRf", "True");
                            break;
                        }
                        spot.setProperty("ShowRf", "False");
                        break;
                    }
                    case 2737: {
                        int tail = this.joinToInt(prop, propLength);
                        spot.setProperty("Tail", Integer.toString(tail));
                        break;
                    }
                }
                continue;
            }
            curr.setType(code);
            curr.setParent(spot);
            CDXObject obj = new CDXObject();
            obj.setPrev(curr);
            curr.setNext(obj);
            if (!spot.hasChild()) {
                spot.setFirstChild(curr);
            }
            switch (code) {
                case 32785: {
                    this.processObjectTag(curr);
                    curr = obj;
                    continue block14;
                }
            }
            this.skipObject(curr);
            curr = obj;
        }
    }
}

