/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cdx;

import chemaxon.common.util.IntVector;
import chemaxon.core.util.GeomUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cdx.CDXConstants;
import chemaxon.marvin.io.formats.cdx.CDXObject;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MPoint;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class CDXObjectReader
implements CDXConstants {
    private HashMap<String, Object> altgr = new HashMap();
    private IntVector reactants = null;
    private IntVector products = null;
    private int[] atomMapR = null;
    private int[] atomMapP = null;
    private boolean grapArrows = false;
    private int stepNum = 0;
    private int arrowNum = 0;
    private int sgNumber = 0;
    private int[] sgANum = new int[100];
    private CDXObject[] bracketedGroup = new CDXObject[100];
    private HashMap<String, Object> id = new HashMap();
    private double cdxUnitsToMarvin;
    private double lineWidth = 0.0;
    private boolean cleanFrags = false;
    private Color[] color = null;
    private HashMap<String, CDXObject> fonts = new HashMap();
    private HashMap<String, CDXObject> graphics = new HashMap();
    private Map<String, CDXObject> connectionPoints = new HashMap<String, CDXObject>();
    Vector<String> reactionArrows;
    private boolean fromCDX = false;

    private void preprocessGroup(CDXObject g, Molecule mol, double xShift, double yShift) throws MolFormatException {
        this.id.put(g.ID(), g);
        CDXObject curr = g.firstChild();
        block6: while (curr != null) {
            switch (curr.Type()) {
                case 32782: {
                    this.processStep(curr, mol);
                    curr = curr.Next();
                    continue block6;
                }
                case 32778: {
                    this.preprocessAltGroup(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block6;
                }
                case 32770: {
                    this.preprocessGroup(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block6;
                }
                case 32775: {
                    this.preprocessGraphic(curr, mol);
                    curr = curr.Next();
                    continue block6;
                }
            }
            curr = curr.Next();
        }
    }

    private void preprocessFragment(CDXObject fr, Molecule mol, double xShift, double yShift) throws MolFormatException {
        CDXObject curr = fr.firstChild();
        block5: while (curr != null) {
            switch (curr.Type()) {
                case 32771: {
                    this.preprocessFragment(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block5;
                }
                case 32775: {
                    this.preprocessGraphic(curr, mol);
                    curr = curr.Next();
                    continue block5;
                }
                case 32770: {
                    this.preprocessGroup(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block5;
                }
            }
            curr = curr.Next();
        }
    }

    private void preprocessAltGroup(CDXObject altg, Molecule m, double xShift, double yShift) throws MolFormatException {
        CDXObject text;
        String bb = (String)altg.getProperty("BoundingBox");
        for (text = altg.firstChild(); text != null && text.Type() != 32774; text = text.Next()) {
        }
        String rgname = (String)text.getProperty("Text");
        this.altgr.put(altg.ID(), rgname + " " + bb);
        block4: for (CDXObject curr = altg.firstChild(); curr != null; curr = curr.Next()) {
            switch (curr.Type()) {
                case 32770: {
                    this.preprocessGroup(curr, m, xShift, yShift);
                    continue block4;
                }
            }
        }
    }

    private void preprocessGraphic(CDXObject curr, Molecule mol) {
        String tmp;
        this.graphics.put(curr.ID(), curr);
        String grType = (String)curr.getProperty("GraphicType");
        if (grType.equals("Line") && ((tmp = (String)curr.getProperty("ArrowType")) == null || tmp.equals("FullHead") || tmp.equals("HalfHead") || tmp.equals("Hollow") || tmp.equals("Resonance") || tmp.equals("Equilibrium") || tmp.equals("RetroSynthetic"))) {
            ++this.arrowNum;
            if (this.arrowNum > 1) {
                this.grapArrows = true;
            }
        }
    }

    private double addCoord(double d, double shift) {
        return shift + d * this.cdxUnitsToMarvin;
    }

    private void processBond(CDXObject bond, Molecule mol, boolean inSgroup) throws MolFormatException {
        String dispType;
        MolBond mb;
        block69: {
            Object o1 = this.id.get(bond.getProperty("B"));
            Object o2 = this.id.get(bond.getProperty("E"));
            if (o1 == null || o2 == null) {
                this.readAgaintExternalConnectionPoints(bond.Parent(), inSgroup);
                o1 = this.id.get(bond.getProperty("B"));
                o2 = this.id.get(bond.getProperty("E"));
            }
            if (o1 == null || o2 == null) {
                throw new MolFormatException("Error in file. Can't read bond " + bond.getID());
            }
            if (o1 == o2) {
                return;
            }
            MolAtom ma1 = null;
            MolAtom ma2 = null;
            if (o1 instanceof MolAtom) {
                ma1 = (MolAtom)o1;
            }
            if (o2 instanceof MolAtom) {
                ma2 = (MolAtom)o2;
            }
            mb = new MolBond(ma1, ma2);
            if (bond.hasProp("Order")) {
                String tmp = (String)bond.getProperty("Order");
                try {
                    String[] ordarr = tmp.split(" ");
                    double order = 0.0;
                    if (ordarr.length == 1) {
                        order = Double.parseDouble(tmp);
                    } else {
                        for (int i = 0; i < ordarr.length; ++i) {
                            order += Double.parseDouble(ordarr[i]);
                        }
                        order *= 10.0;
                    }
                    int o = (int)order;
                    if ((double)o != order) {
                        o = (int)(order *= 10.0);
                    }
                    switch (o) {
                        case 1: 
                        case 2: 
                        case 3: {
                            mb.setType(o);
                            break;
                        }
                        case 15: {
                            String d1;
                            mb.setType(4);
                            if (bond.hasProp("Display2") && bond.getProperty("Display2").equals("Dash") && ((d1 = (String)bond.getProperty("Display")) == null || !d1.equals("Dash"))) {
                                mb.setType(5);
                            }
                            break;
                        }
                        case 35: {
                            mb.setType(7);
                            break;
                        }
                        case 25: {
                            mb.setType(6);
                            break;
                        }
                        case 30: {
                            mb.setType(5);
                            break;
                        }
                        default: {
                            mb.setType(0);
                        }
                    }
                }
                catch (NumberFormatException e) {
                    if (tmp.equals("dative")) {
                        mb.setType(9);
                        break block69;
                    }
                    if (tmp.equals("ionic")) {
                        mb.setType(9);
                        break block69;
                    }
                    if (tmp.equals("hydrogen")) {
                        mb.setType(9);
                        break block69;
                    }
                    if (tmp.equals("threecentre")) {
                        mb.setType(9);
                        break block69;
                    }
                    mb.setType(0);
                }
            } else {
                mb.setType(1);
            }
        }
        if (mb.getType() == 1 && bond.hasProp("Display")) {
            dispType = (String)bond.getProperty("Display");
            if (dispType.equals("WedgeBegin") || dispType.indexOf("Hollow") > -1) {
                mb.setFlags(16, 48);
            } else if (dispType.equals("WedgeEnd")) {
                mb.setFlags(16, 48);
                mb.swap();
            } else if (dispType.equals("Bold")) {
                mb.setFlags(0x40000000, 0x40000000);
            } else if (dispType.equals("WedgedHashBegin")) {
                mb.setFlags(32, 48);
            } else if (dispType.equals("WedgedHashEnd")) {
                mb.setFlags(32, 48);
                mb.swap();
            } else if (dispType.equals("Hash") || dispType.equals("Dash")) {
                mb.setFlags(Integer.MIN_VALUE, Integer.MIN_VALUE);
            } else if (dispType.indexOf("Wavy") > -1) {
                mb.setFlags(48, 48);
            } else if (dispType.equals("Dot")) {
                mb.setType(0);
            }
        } else if (mb.getType() == 2 && bond.hasProp("Display") && (dispType = (String)bond.getProperty("Display")).equals("Wavy")) {
            mb.setFlags(192, 448);
        }
        if (bond.hasProp("Topology")) {
            String top = (String)bond.getProperty("Topology");
            if (top.equalsIgnoreCase("Chain")) {
                mb.setFlags(2048, 3072);
            } else if (top.equalsIgnoreCase("Ring")) {
                mb.setFlags(1024, 3072);
            } else if (top.equalsIgnoreCase("RingOrChain")) {
                // empty if block
            }
        }
        if (bond.hasProp("RxnParticipation")) {
            String rxn = (String)bond.getProperty("RxnParticipation");
            if (rxn.equals("ReactionCenter")) {
                mb.setFlags(4096, 61440);
            } else if (rxn.equals("MakeOrBreak")) {
                mb.setFlags(8192, 61440);
            } else if (rxn.equals("ChangeType")) {
                mb.setFlags(12288, 61440);
            } else if (rxn.equals("MakeAndChange")) {
                mb.setFlags(16384, 61440);
            } else if (rxn.equals("NotReactionCenter")) {
                mb.setFlags(20480, 61440);
            } else if (rxn.equals("NoChange")) {
                mb.setFlags(24576, 61440);
            } else if (rxn.equals("Unmapped")) {
                mb.setFlags(28672, 61440);
            }
        }
        if (bond.hasProp("BS")) {
            String bs = (String)bond.getProperty("BS");
            if (bs.equals("Z")) {
                mb.setFlags(128, 512);
            } else if (bs.equals("E")) {
                mb.setFlags(64, 512);
            } else if (bs.equals("N")) {
                // empty if block
            }
        }
        this.id.put(bond.ID(), mb);
        mol.add(mb);
    }

    private void readAgaintExternalConnectionPoints(CDXObject fragment, boolean inSgroup) {
        CDXObject node = fragment.firstChild();
        while (node != null) {
            if (node.Type() == 32772) {
                if (!node.hasProp("NodeType")) {
                    node = node.Next();
                    continue;
                }
                String type = (String)node.getProperty("NodeType");
                if (type.equals("ExternalConnectionPoint")) {
                    for (CDXObject bond = fragment.firstChild(); bond != null; bond = bond.Next()) {
                        String order;
                        if (bond.Type() != 32773) continue;
                        if (bond.getProperty("B").equals(node.ID())) {
                            this.id.put(node.ID(), this.id.get(bond.getProperty("E")));
                            if (inSgroup) continue;
                            order = (String)bond.getProperty("Order");
                            if (order == null) {
                                order = "1";
                            }
                            node.setProperty("ConnectionPointOrder", order);
                            this.connectionPoints.put(node.ID(), node);
                            continue;
                        }
                        if (!bond.getProperty("E").equals(node.ID())) continue;
                        this.id.put(node.ID(), this.id.get(bond.getProperty("B")));
                        if (inSgroup) continue;
                        order = (String)bond.getProperty("Order");
                        if (order == null) {
                            order = "1";
                        }
                        node.setProperty("ConnectionPointOrder", order);
                        this.connectionPoints.put(node.ID(), node);
                    }
                }
            }
            node = node.Next();
        }
    }

    private void processGraphic(CDXObject grap, Molecule mol1, double xShift, double yShift) {
        String grType;
        RgMolecule rg = null;
        RxnMolecule mol = null;
        MDocument mdoc = null;
        if (mol1 instanceof RgMolecule) {
            rg = (RgMolecule)mol1;
            mol = (RxnMolecule)rg.getRoot();
            mdoc = mol.getDocument();
        } else if (mol1 instanceof RxnMolecule) {
            mol = (RxnMolecule)mol1;
            mdoc = mol.getDocument();
        } else {
            mdoc = mol1.getDocument();
        }
        if (mdoc == null) {
            mdoc = new MDocument(mol1);
        }
        if ((grType = (String)grap.getProperty("GraphicType")) == null) {
            grType = "Undefined";
        }
        if (grType.equals("Line")) {
            String tmp = (String)grap.getProperty("BoundingBox");
            String[] tarr = tmp.split(" ");
            MPoint end = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
            MPoint begin = new MPoint(this.addCoord(Double.parseDouble(tarr[2]), xShift), this.addCoord(-Double.parseDouble(tarr[3]), yShift));
            MPolyline line = new MPolyline(begin, end);
            MRArrow newArrow = new MRArrow(begin, end);
            tmp = (String)grap.getProperty("ArrowType");
            if (tmp == null || tmp.equals("NoHead")) {
                mdoc.addObject(line);
            } else if (tmp.equals("FullHead") || tmp.equals("HalfHead") || tmp.equals("Hollow")) {
                newArrow.setType(0);
                line.setArrow(true);
                line.setArrowLength(MPolyline.HEAD, 0.8);
                line.setArrowWidth(MPolyline.HEAD, 0.5);
            } else if (tmp.equals("Resonance")) {
                newArrow.setType(1);
                line.setArrow(true);
                line.setArrowLength(MPolyline.HEAD, 0.8);
                line.setArrowWidth(MPolyline.HEAD, 0.5);
                line.setArrowLength(MPolyline.TAIL, 0.8);
                line.setArrowWidth(MPolyline.TAIL, 0.5);
                line.setAttribute("tailFlags", "1");
            } else if (tmp.equals("Equilibrium")) {
                newArrow.setType(3);
                line.setArrow(true);
                line.setArrowLength(MPolyline.HEAD, 0.8);
                line.setArrowWidth(MPolyline.HEAD, 0.5);
                line.setArrowLength(MPolyline.TAIL, 0.8);
                line.setArrowWidth(MPolyline.TAIL, 0.5);
                line.setAttribute("tailFlags", "1");
            } else if (tmp.equals("RetroSynthetic")) {
                newArrow.setType(2);
                line.setArrow(true);
                line.setArrowLength(MPolyline.HEAD, 0.8);
                line.setArrowWidth(MPolyline.HEAD, 0.5);
            }
            tmp = (String)grap.getProperty("HeadSize");
            if (tmp == null) {
                newArrow.setArrowWidth(1, this.addCoord(this.lineWidth * 10.0, 0.0));
                newArrow.setArrowLength(1, 0.8);
            } else {
                newArrow.setArrowWidth(1, this.addCoord(this.lineWidth * Double.parseDouble(tmp) / 100.0, 0.0));
                newArrow.setArrowLength(1, 0.8);
            }
            if (this.stepNum == 0 || this.reactionArrows == null || this.grapArrows || !this.reactionArrows.contains(grap.ID())) {
                mdoc.addObject(line);
            } else if (!this.grapArrows) {
                mol.setReactionArrow(newArrow);
            }
        } else if (!grType.equals("Bracket")) {
            if (grType.equals("Rectangle")) {
                MRectangle mr;
                String tmp = (String)grap.getProperty("BoundingBox");
                String[] tarr = tmp.split(" ");
                String rectType = (String)grap.getProperty("RectangleType");
                if (rectType == null) {
                    rectType = "Plain";
                }
                MPoint topleft = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
                MPoint bottomright = new MPoint(this.addCoord(Double.parseDouble(tarr[2]), xShift), this.addCoord(-Double.parseDouble(tarr[3]), yShift));
                MPoint center = new MPoint((topleft.getLocation().x + bottomright.getLocation().x) / 2.0, (topleft.getLocation().y + bottomright.getLocation().y) / 2.0);
                if (rectType.indexOf("RoundEdge") > -1) {
                    MRectangle mrr = mr = new MRoundedRectangle();
                    ((MRoundedRectangle)mrr).setCornersRadius(0.3, 0.3);
                } else {
                    mr = new MRectangle();
                }
                MPoint[] p = this.getCornerPoints(grap, center, xShift, yShift);
                if (p != null) {
                    mr.setPoints(p);
                } else {
                    mr.setCorners(topleft, bottomright);
                }
                String col = (String)grap.getProperty("color");
                int colorId = 3;
                if (col != null) {
                    colorId = Integer.parseInt(col);
                    mr.setColor(this.color[colorId]);
                }
                if (rectType.indexOf("Filled") > -1) {
                    mr.setBackground(this.color[colorId]);
                } else {
                    String bgcol = (String)grap.getProperty("bgcolor");
                    if (bgcol != null) {
                        int bgColorId = Integer.parseInt(bgcol);
                        mr.setBackground(this.color[bgColorId]);
                    }
                }
                if (rectType.indexOf("Bold") > -1) {
                    mr.setThickness(0.2);
                }
                mdoc.addObject(mr);
            } else if (grType.equals("Oval")) {
                MPoint[] points;
                String tmp = (String)grap.getProperty("BoundingBox");
                String[] tarr = tmp.split(" ");
                MPoint semi = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
                MPoint center = new MPoint(this.addCoord(Double.parseDouble(tarr[2]), xShift), this.addCoord(-Double.parseDouble(tarr[3]), yShift));
                MEllipse me = new MEllipse();
                String eType = (String)grap.getProperty("OvalType");
                if (eType == null) {
                    eType = "";
                }
                MPoint[] mp = this.getCornerPoints(grap, center, xShift, yShift);
                if (eType.indexOf("Circle") > -1 || mp == null) {
                    double rX = center.getLocation().x - semi.getLocation().x;
                    double rY = center.getLocation().y - semi.getLocation().y;
                    double rZ = center.getLocation().z - semi.getLocation().z;
                    double rLength = Math.sqrt(Math.pow(rZ, 2.0) + Math.pow(rX, 2.0) + Math.pow(rY, 2.0));
                    double top = center.getLocation().y + rLength;
                    double left = center.getLocation().x - rLength;
                    double bottom = center.getLocation().y - rLength;
                    double right = center.getLocation().x + rLength;
                    me.setCorners(new MPoint(left, top), new MPoint(right, bottom));
                } else {
                    me.setPoints(mp);
                }
                String col = (String)grap.getProperty("color");
                int colorId = 3;
                if (col != null) {
                    colorId = Integer.parseInt(col);
                    me.setColor(this.color[colorId]);
                }
                if (eType != null && eType.indexOf("Filled") > -1) {
                    me.setBackground(this.color[colorId]);
                } else {
                    String bgcol = (String)grap.getProperty("bgcolor");
                    if (bgcol != null) {
                        int bgColorId = Integer.parseInt(bgcol);
                        me.setBackground(this.color[bgColorId]);
                    }
                }
                if (eType.indexOf("Bold") > -1) {
                    me.setThickness(0.2);
                }
                if (!this.isInARing(points = me.getPoints(), mol1)) {
                    mdoc.addObject(me);
                }
            } else if (grType.equals("Symbol")) {
                CDXObject repr;
                String sType = (String)grap.getProperty("SymbolType");
                if (sType == null) {
                    sType = "LonePair";
                }
                if (sType.equals("Absolute")) {
                    mol1.setAbsStereo(true);
                } else if (!sType.equals("Relative") && sType.equals("LonePair") && (repr = (CDXObject)grap.getProperty("represent")) != null) {
                    int attribute = Integer.parseInt((String)repr.getProperty("attribute"));
                    switch (attribute) {
                        case 1058: {
                            MolAtom ma = (MolAtom)this.id.get(repr.getProperty("object"));
                            int lp = ma.getElectronProp();
                            ma.setElectronProp(++lp);
                            break;
                        }
                    }
                }
            } else if (grType.equals("Arc")) {
                String bgcol;
                String suprby = (String)grap.getProperty("SupersededBy");
                CDXObject curr = null;
                if (suprby != null) {
                    CDXObject parpage = grap.Parent();
                    for (curr = parpage.firstChild(); curr != null && curr.ID().equals(suprby); curr = curr.Next()) {
                    }
                }
                String tmp = null;
                tmp = curr == null ? (String)grap.getProperty("BoundingBox") : (String)curr.getProperty("BoundingBox");
                String[] tarr = tmp.split(" ");
                MPoint end = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
                MPoint center = new MPoint(this.addCoord(Double.parseDouble(tarr[2]), xShift), this.addCoord(-Double.parseDouble(tarr[3]), yShift));
                CTransform3D tr = new CTransform3D();
                String arcAngle = (String)grap.getProperty("AngularSize");
                int aa = 90;
                if (arcAngle != null) {
                    double aaa = Double.parseDouble(arcAngle);
                    aa = (int)aaa;
                }
                tr.setRotation(1.0, 1.0, 1.0, aa);
                tr.setRotationCenter(center.getLocation());
                DPoint3 p = new DPoint3(end.getLocation());
                tr.transform(p);
                MPoint begin = new MPoint(p);
                MPolyline mpl = aa > 0 ? new MPolyline(end, begin) : new MPolyline(begin, end);
                mpl.setArcAngle(aa);
                String col = (String)grap.getProperty("color");
                if (col != null) {
                    int colorId = Integer.parseInt(col);
                    mpl.setColor(this.color[colorId]);
                }
                if ((bgcol = (String)grap.getProperty("bgcolor")) != null) {
                    int bgColorId = Integer.parseInt(bgcol);
                    mpl.setBackground(this.color[bgColorId]);
                }
            }
        }
    }

    private MPoint[] getCornerPoints(CDXObject grap, MPoint center, double xShift, double yShift) {
        String tmp = (String)grap.getProperty("MajorAxisEnd3D");
        if (tmp == null) {
            return null;
        }
        String[] tarr = tmp.split(" ");
        MPoint major = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift) - center.getLocation().x, -this.addCoord(Double.parseDouble(tarr[1]), yShift) - center.getLocation().y, this.addCoord(Double.parseDouble(tarr[2]), 0.0) - center.getLocation().z);
        tmp = (String)grap.getProperty("MinorAxisEnd3D");
        if (tmp == null) {
            return null;
        }
        tarr = tmp.split(" ");
        MPoint minor = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift) - center.getLocation().x, -this.addCoord(Double.parseDouble(tarr[1]), yShift) - center.getLocation().y, this.addCoord(Double.parseDouble(tarr[2]), 0.0) - center.getLocation().z);
        double[] px = new double[]{center.getLocation().x - major.getLocation().x - minor.getLocation().x, center.getLocation().x + major.getLocation().x - minor.getLocation().x, center.getLocation().x - major.getLocation().x + minor.getLocation().x, center.getLocation().x + major.getLocation().x + minor.getLocation().x};
        double[] py = new double[]{center.getLocation().y - major.getLocation().y - minor.getLocation().y, center.getLocation().y + major.getLocation().y - minor.getLocation().y, center.getLocation().y - major.getLocation().y + minor.getLocation().y, center.getLocation().y + major.getLocation().y + minor.getLocation().y};
        double[] pz = new double[]{center.getLocation().z - major.getLocation().z - minor.getLocation().z, center.getLocation().z + major.getLocation().z - minor.getLocation().z, center.getLocation().z - major.getLocation().z + minor.getLocation().z, center.getLocation().z + major.getLocation().z + minor.getLocation().z};
        MPoint[] p = new MPoint[4];
        p[2] = new MPoint(px[0], py[0], pz[0]);
        p[1] = new MPoint(px[1], py[1], pz[1]);
        p[3] = new MPoint(px[2], py[2], pz[2]);
        p[0] = new MPoint(px[3], py[3], pz[3]);
        return p;
    }

    private String getBoundingBox(CDXObject fr) {
        double right = 0.0;
        double bottom = 0.0;
        double left = 0.0;
        double top = 0.0;
        boolean first = true;
        for (CDXObject curr = fr.firstChild(); curr != null; curr = curr.Next()) {
            if (curr.Type() != 32772) continue;
            String p = (String)curr.getProperty("p");
            String[] tarr = p.split(" ");
            double x = Double.parseDouble(tarr[0]);
            double y = Double.parseDouble(tarr[1]);
            if (first) {
                top = bottom = y;
                left = right = x;
                first = false;
                continue;
            }
            if (x < left) {
                left = x;
            }
            if (x > right) {
                right = x;
            }
            if (y < top) {
                top = y;
            }
            if (!(y > bottom)) continue;
            bottom = y;
        }
        return left + " " + top + " " + right + " " + bottom;
    }

    private void processNode(CDXObject node, Molecule mol, double xShift, double yShift, boolean inSgroup) throws MolFormatException {
        boolean is3d = false;
        String type = node.hasProp("NodeType") ? (String)node.getProperty("NodeType") : "Element";
        if (type.equals("Unspecified")) {
            String text;
            boolean fragmentChild = false;
            boolean textChild = false;
            CDXObject textChildP = null;
            for (CDXObject child = node.firstChild(); child != null; child = child.Next()) {
                if (child.Type() == 32771) {
                    fragmentChild = true;
                    continue;
                }
                if (child.Type() != 32774) continue;
                textChild = true;
                if (textChildP != null) continue;
                textChildP = child;
            }
            if (fragmentChild) {
                type = "Fragment";
            } else if (textChild && !(text = (String)textChildP.getProperty("Text")).equals("*")) {
                type = text.startsWith("R") && text.substring(1).matches("[0-9]+") ? "NamedAlternativeGroup" : (text.equals("R'") ? "AnonymousAlternativeGroup" : "GenericNickname");
            }
        }
        if (type.equals("Element") || type.equals("LinkNode")) {
            String label;
            CDXObject text;
            int intTmp = 6;
            if (node.hasProp("Element")) {
                intTmp = Integer.parseInt((String)node.Property("Element"));
            }
            MolAtom ma = new MolAtom(intTmp);
            if (intTmp == 1 && (text = node.firstChild()) != null && text.Type() == 32774 && ((label = (String)text.getProperty("Text")).equals("D") || label.equals("T"))) {
                ma.setSpecIsotopeSymbolPreferred(true);
            }
            is3d = this.setAtomProperties(node, ma, xShift, yShift);
            this.id.put(node.ID(), ma);
            mol.add(ma);
        } else if (type.equals("ElementList")) {
            MolAtom ma;
            String tmp = null;
            if (node.hasProp("ElementList")) {
                tmp = (String)node.getProperty("ElementList");
            }
            if (node.hasProp("GenerickList") || tmp == null) {
                throw new MolFormatException("GenerickLists are not supported.");
            }
            boolean notList = false;
            String[] elements = tmp.trim().split(" ");
            if (elements[0].equals("NOT")) {
                ma = new MolAtom(129);
                notList = true;
            } else {
                ma = new MolAtom(128);
            }
            IntVector olist = new IntVector();
            for (int i = 0; i < elements.length; ++i) {
                if (i == 0 && notList) continue;
                if (elements[i].equals("")) break;
                int atno = Integer.parseInt(elements[i]);
                if (atno < 1 || atno > 109) {
                    throw new MolFormatException("unknown element in list");
                }
                olist.add(atno);
            }
            int[] list = olist.toArray();
            ma.setList(list);
            this.id.put(node.ID(), ma);
            is3d = this.setAtomProperties(node, ma, xShift, yShift);
            mol.add(ma);
        } else if (type.equals("ExternalConnectionPoint")) {
            for (CDXObject bond = node.Parent().firstChild(); bond != null; bond = bond.Next()) {
                if (bond.Type() != 32773) continue;
                if (bond.getProperty("B").equals(node.ID())) {
                    this.id.put(node.ID(), this.id.get(bond.getProperty("E")));
                    if (inSgroup) continue;
                    String order = (String)bond.getProperty("Order");
                    if (order == null) {
                        order = "1";
                    }
                    node.setProperty("ConnectionPointOrder", order);
                    this.connectionPoints.put(node.ID(), node);
                    continue;
                }
                if (!bond.getProperty("E").equals(node.ID())) continue;
                this.id.put(node.ID(), this.id.get(bond.getProperty("B")));
                if (inSgroup) continue;
                String order = (String)bond.getProperty("Order");
                if (order == null) {
                    order = "1";
                }
                node.setProperty("ConnectionPointOrder", order);
                this.connectionPoints.put(node.ID(), node);
            }
        } else if (type.equals("Unspecified")) {
            MolAtom ma = new MolAtom(MolAtom.numOf("*"));
            is3d = this.setAtomProperties(node, ma, xShift, yShift);
            this.id.put(node.ID(), ma);
            mol.add(ma);
        } else if (type.equals("GenericNickname")) {
            MolAtom ma;
            CDXObject text = node.firstChild();
            String pseudoType = text == null ? (String)node.getProperty("GenericNickname") : (String)text.getProperty("Text");
            if (pseudoType.equals("Q")) {
                ma = new MolAtom(132);
            } else if (pseudoType.equals("A")) {
                ma = new MolAtom(131);
            } else if (pseudoType.substring(0, 1).equals("R")) {
                ma = new MolAtom(134);
                String num = pseudoType.substring(1);
                try {
                    ma.setRgroup(Integer.parseInt(num));
                }
                catch (NumberFormatException nfe) {
                    if (num.equals("'")) {
                        ma.setRgroup(1);
                    }
                }
            } else {
                ma = new MolAtom(136);
                ma.setAliasstr(pseudoType);
            }
            is3d = this.setAtomProperties(node, ma, xShift, yShift);
            this.id.put(node.ID(), ma);
            mol.add(ma);
        } else if (type.equals("Fragment") || type.equals("Nickname")) {
            CDXObject curr;
            CDXObject fr;
            CDXObject text;
            SuperatomSgroup sg = new SuperatomSgroup(mol);
            for (text = node.firstChild(); text != null && text.Type() != 32774; text = text.Next()) {
            }
            String sgt = (String)text.getProperty("Text");
            sg.setSubscript(sgt);
            for (fr = node.firstChild(); fr != null && fr.Type() != 32771; fr = fr.Next()) {
            }
            this.processFragment(fr, mol, xShift, yShift, true);
            SelectionMolecule sm = new SelectionMolecule();
            for (curr = fr.firstChild(); curr != null; curr = curr.Next()) {
                if (curr.Type() != 32772) continue;
                MolAtom ma = (MolAtom)this.id.get(curr.ID());
                sm.add(ma);
            }
            int sgc = mol.getSgroupCount();
            for (int i = 0; i < sgc; ++i) {
                Sgroup tsg = mol.getSgroup(i);
                if (tsg == sg || !(tsg instanceof SuperatomSgroup) || !sm.contains(((SuperatomSgroup)tsg).getSuperAtom())) continue;
                if (tsg.getParentSgroup() == null) {
                    sg.addChildSgroup(tsg);
                    continue;
                }
                if (tsg.getParentSgroup().getSgroupGraph().getAtomCount() <= sm.getAtomCount()) continue;
                Sgroup oldParent = tsg.getParentSgroup();
                oldParent.removeChildSgroup(tsg);
                sg.addChildSgroup(tsg);
                oldParent.addChildSgroup(sg);
            }
            boolean first = true;
            for (curr = fr.firstChild(); curr != null; curr = curr.Next()) {
                if (curr.Type() != 32772) continue;
                MolAtom ma = (MolAtom)this.id.get(curr.ID());
                mol.setSgroupParent(ma, sg, true);
                if (!curr.hasProp("NodeType") || !((String)curr.getProperty("NodeType")).equals("ExternalConnectionPoint")) continue;
                if (first) {
                    ma.setAttach(1, sg);
                    first = false;
                } else {
                    ma.setAttach(2, sg);
                }
                ma.valenceCheck();
            }
            this.setAtomProperties(node, sg.getSuperAtom(), xShift, yShift);
            sg.contract(2);
            this.id.put(node.ID(), sg.getSuperAtom());
        } else if (type.equals("NamedAlternativeGroup")) {
            CDXObject text;
            MolAtom ma = new MolAtom(134);
            for (text = node.firstChild(); text != null && text.Type() != 32774; text = text.Next()) {
            }
            String rgstr = (String)text.getProperty("Text");
            if (rgstr != null && rgstr.length() >= 2) {
                int rgnum = Integer.parseInt(rgstr.substring(1));
                ma.setRgroup(rgnum);
            }
            this.id.put(node.ID(), ma);
            is3d = this.setAtomProperties(node, ma, xShift, yShift);
            mol.add(ma);
        } else if (type.equals("MultiAttachment") || type.equals("VariableAttachment")) {
            MulticenterSgroup sg = new MulticenterSgroup(mol);
            String attachments = (String)node.getProperty("Attachments");
            if (attachments == null) {
                throw new MolFormatException("Missing attachments for " + type + " group");
            }
            String[] ids = attachments.split(" ");
            for (int i = 0; i < ids.length; ++i) {
                MolAtom ma = (MolAtom)this.id.get(ids[i]);
                if (ma == null) {
                    throw new MolFormatException("Null in attachments.");
                }
                mol.setSgroupParent(ma, sg, true);
            }
            sg.addCentralAtom();
            this.id.put(node.ID(), sg.getCentralAtom());
        } else if (type.equals("AnonymousAlternativeGroup")) {
            CDXObject curr;
            Set<String> keys = this.altgr.keySet();
            Iterator<String> i = keys.iterator();
            int maxRgNum = 0;
            while (i.hasNext()) {
                int rgNum;
                String key = i.next();
                String bb = (String)this.altgr.get(key);
                String[] tarr = bb.split(" ");
                String rgname = tarr[0];
                String rgnumber = rgname.substring(1);
                try {
                    rgNum = Integer.parseInt(rgnumber);
                }
                catch (NumberFormatException nfex) {
                    rgNum = 0;
                }
                if (maxRgNum >= rgNum) continue;
                maxRgNum = rgNum;
            }
            double altg_left = 0.0;
            double altg_top = 0.0;
            double altg_right = 0.0;
            double altg_bottom = 0.0;
            boolean first = true;
            CDXObject text = null;
            for (curr = node.firstChild(); curr != null; curr = curr.Next()) {
                if (curr.Type() == 32771) {
                    String bb = (String)curr.getProperty("BoundingBox");
                    if (bb == null) {
                        bb = this.getBoundingBox(curr);
                    }
                    String[] tarr = bb.split(" ");
                    double left = Double.parseDouble(tarr[0]);
                    double top = Double.parseDouble(tarr[1]);
                    double right = Double.parseDouble(tarr[2]);
                    double bottom = Double.parseDouble(tarr[3]);
                    if (first || left < altg_left) {
                        altg_left = left;
                    }
                    if (first || right > altg_right) {
                        altg_right = right;
                    }
                    if (first || top < altg_top) {
                        altg_top = top;
                    }
                    if (first || bottom > altg_bottom) {
                        altg_bottom = bottom;
                    }
                    first = false;
                    continue;
                }
                if (curr.Type() != 32774) continue;
                text = curr;
            }
            if (this.hasBondTo(node)) {
                String boundingBox = altg_left + " " + altg_top + " " + altg_right + " " + altg_bottom;
                MolAtom ma = new MolAtom(134);
                ma.setRgroup(++maxRgNum);
                is3d = this.setAtomProperties(node, ma, xShift, yShift);
                mol.add(ma);
                this.id.put(node.ID(), ma);
                this.altgr.put(node.ID(), "R" + maxRgNum + " " + boundingBox);
                for (curr = node.firstChild(); curr != null; curr = curr.Next()) {
                    if (curr.Type() != 32771) continue;
                    this.processFragment(curr, mol, xShift, yShift, false);
                }
                this.cleanFrags = true;
            } else {
                this.processText(text, mol, xShift, yShift);
            }
        }
        if (is3d) {
            mol.setDim(3);
        }
    }

    private boolean hasBondTo(CDXObject node) {
        CDXObject parent = node.Parent();
        String id = node.ID();
        for (CDXObject c = parent.firstChild(); c != null; c = c.Next()) {
            if (c.Type() != 32773 || !id.equals(c.getProperty("B")) && !id.equals(c.getProperty("E"))) continue;
            return true;
        }
        return false;
    }

    private boolean setAtomProperties(CDXObject node, MolAtom ma, double xShift, double yShift) throws MolFormatException {
        String impH;
        String unsatur;
        String[] tarr;
        boolean is3d = false;
        if (node.hasProp("p")) {
            String p = (String)node.getProperty("p");
            tarr = p.split(" ");
            ma.setXY(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
        }
        if (node.hasProp("xyz")) {
            is3d = true;
            String xyz = (String)node.getProperty("xyz");
            tarr = xyz.split(" ");
            ma.setXYZ(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift), this.addCoord(Double.parseDouble(tarr[2]), 0.0));
        }
        if (node.hasProp("NumHydrogens")) {
            String nh = (String)node.getProperty("NumHydrogens");
            ma.setImplicitHcount(Integer.parseInt(nh));
        }
        if (node.hasProp("Isotope")) {
            String iso = (String)node.getProperty("Isotope");
            int mass = 0;
            try {
                mass = Integer.parseInt(iso);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (mass != 0) {
                ma.setMassno(mass);
            }
        }
        if (node.hasProp("Radical")) {
            String rad = (String)node.getProperty("Radical");
            int radical = 0;
            if (rad.equals("Singlet")) {
                radical = 2;
            } else if (rad.equals("Doublet")) {
                radical = 1;
            } else if (rad.equals("Triplet")) {
                radical = 3;
            }
            if (ma.getCharge() == 0) {
                ma.setRadical(radical);
            }
        }
        if (node.hasProp("Charge")) {
            String ch = (String)node.getProperty("Charge");
            ma.setCharge(Integer.parseInt(ch));
        }
        if (node.hasProp("AS")) {
            String cip = (String)node.getProperty("AS");
            if (cip.equalsIgnoreCase("S")) {
                ma.setFlags(16, 24);
            } else if (cip.equalsIgnoreCase("R")) {
                ma.setFlags(8, 24);
            } else if (cip.equals("u")) {
                ma.setFlags(24, 24);
            }
        }
        if (node.hasProp("RxnStereo")) {
            String rxnStereo = (String)node.getProperty("RxnStereo");
            if (rxnStereo.equals("Inversion")) {
                ma.setReactionStereo(1);
            } else if (rxnStereo.equals("Retension")) {
                ma.setReactionStereo(2);
            } else {
                ma.setReactionStereo(0);
            }
        }
        if (node.hasProp("EnhancedStereoType")) {
            String stereoType = (String)node.getProperty("EnhancedStereoType");
            if (stereoType.equals("Absolute")) {
                ma.setStereoGroupType(1);
            } else if (stereoType.equals("Or")) {
                ma.setStereoGroupType(2);
                String num = (String)node.getProperty("EnhancedStereoGroupNum");
                try {
                    int n = Integer.parseInt(num);
                    if (n < 0) {
                        throw new MolFormatException("negative number for stereo group");
                    }
                    ma.setStereoGroupNumber(n);
                }
                catch (NumberFormatException ex) {
                    ma.setStereoGroupNumber(1);
                }
            } else if (stereoType.equals("And")) {
                ma.setStereoGroupType(3);
                String num = (String)node.getProperty("EnhancedStereoGroupNum");
                try {
                    int n = Integer.parseInt(num);
                    if (n < 0) {
                        throw new MolFormatException("negative number for stereo group");
                    }
                    ma.setStereoGroupNumber(n);
                }
                catch (NumberFormatException ex) {
                    ma.setStereoGroupNumber(1);
                }
            } else if (stereoType.equals("None")) {
                ma.setStereoGroupType(0);
            }
        }
        if (node.hasProp("UnsaturatedBonds") && (unsatur = (String)node.getProperty("UnsaturatedBonds")).equals("MustBePresent")) {
            ma.setQProp("u", 1);
        }
        if (node.hasProp("SubstituentsUpTo")) {
            try {
                int x = Integer.parseInt((String)node.getProperty("SubstituentsUpTo"));
                if (x > 6) {
                    x = 6;
                }
                ma.setQProp("s", x);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (node.hasProp("SubstituentsExactly")) {
            try {
                int x = Integer.parseInt((String)node.getProperty("SubstituentsExactly"));
                if (x > 6) {
                    x = 6;
                }
                ma.setQProp("s", x);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (node.hasProp("FreeSites")) {
            try {
                int fs = Integer.parseInt((String)node.getProperty("FreeSites"));
                if (fs == 0) {
                    ma.setQProp("s", -2);
                } else {
                    CDXObject fr = node.Parent();
                    int bondNumber = 0;
                    for (CDXObject curr = fr.firstChild(); curr != null; curr = curr.Next()) {
                        if (curr.Type() != 32773) continue;
                        ++bondNumber;
                    }
                    if ((fs -= bondNumber) > 6) {
                        fs = 6;
                    } else if (fs < 0) {
                        fs = 0;
                    }
                    ma.setQProp("s", fs);
                }
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if (node.hasProp("RingBondCount")) {
            String rbc = (String)node.getProperty("RingBondCount");
            int rbcnum = -1;
            if (rbc.equals("NoRingBonds")) {
                rbcnum = 0;
            } else if (rbc.equals("SimpleRing")) {
                rbcnum = 2;
            } else if (rbc.equals("Fusion")) {
                rbcnum = 3;
            } else if (rbc.equals("SpiroOrHigher")) {
                rbcnum = 4;
            } else if (rbc.equals("AsDrawn")) {
                rbcnum = -2;
            }
            ma.setQProp("rb", rbcnum);
        }
        if (node.hasProp("ImplicitHydrogens") && (impH = (String)node.getProperty("ImplicitHydrogens")).equalsIgnoreCase("true")) {
            ma.setQProp("h", 0);
        }
        if (node.hasProp("CXN_Query_NumberOfHydrogens")) {
            String NOH = (String)node.getProperty("CXN_Query_NumberOfHydrogens");
            ma.setQProp("H", Integer.parseInt(NOH));
        }
        if (node.hasProp("CXN_Query_Valence")) {
            String QV = (String)node.getProperty("CXN_Query_Valence");
            ma.setValenceProp(Integer.parseInt(QV));
        }
        if (node.hasProp("CXN_Query_NumberOfConnections")) {
            String NOC = (String)node.getProperty("CXN_Query_NumberOfConnections");
            ma.setQProp("X", Integer.parseInt(NOC));
        }
        if (node.hasProp("CXN_Query_NumberOfRings")) {
            String NOR = (String)node.getProperty("CXN_Query_NumberOfRings");
            ma.setQProp("R", Integer.parseInt(NOR));
        }
        if (node.hasProp("CXN_Query_SmallestRingSize")) {
            String SRS = (String)node.getProperty("CXN_Query_SmallestRingSize");
            ma.setQProp("r", Integer.parseInt(SRS));
        }
        return is3d;
    }

    private void processPage(CDXObject page, RgMolecule rg, double xShift, double yShift) throws MolFormatException {
        if (rg.getRoot() == null) {
            rg.setRoot(new Molecule());
        }
        Molecule mol = rg.getRoot();
        CDXObject curr = page.firstChild();
        block11: while (curr != null) {
            switch (curr.Type()) {
                case 32771: {
                    this.processFragment(curr, mol, xShift, yShift, false);
                    curr = curr.Next();
                    continue block11;
                }
                case 32774: {
                    this.processText(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
                case 32775: {
                    this.processGraphic(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
                case 32791: {
                    this.processBracketedGroup(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
                case 32778: {
                    this.processAltGroup(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
                case 32770: {
                    this.processGroup(curr, mol, xShift, yShift, false);
                    curr = curr.Next();
                    continue block11;
                }
                case 32809: {
                    this.processRLogic(curr, rg);
                    curr = curr.Next();
                    continue block11;
                }
                case 32790: {
                    this.processTable(curr, rg, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
                case 32797: {
                    this.processTLCPlate(curr, rg, xShift, yShift);
                    curr = curr.Next();
                    continue block11;
                }
            }
            curr = curr.Next();
        }
    }

    private void processTable(CDXObject table, RgMolecule mol, double xShift, double yShift) throws MolFormatException {
        block3: for (CDXObject curr = table.firstChild(); curr != null; curr = curr.Next()) {
            switch (curr.Type()) {
                case 32769: {
                    double xs = 0.0;
                    double ys = 0.0;
                    if (curr.hasProp("BoundsInParent")) {
                        String tmp = (String)curr.getProperty("BoundsInParent");
                        String[] tarr = tmp.split(" ");
                        xs = this.addCoord(Double.parseDouble(tarr[0]), xShift);
                        ys = this.addCoord(-Double.parseDouble(tarr[1]), yShift);
                        MPoint topleft = new MPoint(xs, ys);
                        MPoint bottomright = new MPoint(this.addCoord(Double.parseDouble(tarr[2]), xShift), this.addCoord(-Double.parseDouble(tarr[3]), yShift));
                        MRectangle mr = new MRectangle(topleft, bottomright);
                        mol.getDocument().addObject(mr);
                    }
                    this.processPage(curr, mol, xs, ys);
                    continue block3;
                }
            }
        }
    }

    private void processBracketedGroup(CDXObject bgr, Molecule mol, double xShift, double yShift) throws MolFormatException {
        block3: for (CDXObject curr = bgr.firstChild(); curr != null; curr = curr.Next()) {
            switch (curr.Type()) {
                case 32791: {
                    this.processBracketedGroup(curr, mol, xShift, yShift);
                    continue block3;
                }
            }
        }
        String ids = (String)bgr.getProperty("BracketedObjectIDs");
        if (ids != null) {
            String[] idarr = ids.split(" ");
            this.sgANum[this.sgNumber] = idarr.length;
            this.bracketedGroup[this.sgNumber] = bgr;
            ++this.sgNumber;
        }
        CDXObject[] brackets = new CDXObject[2];
        int i = 0;
        for (CDXObject bra = bgr.firstChild(); bra != null; bra = bra.Next()) {
            if (bra.Type() != 32792) continue;
            String braID = (String)bra.getProperty("GraphicID");
            brackets[i] = this.graphics.get(braID);
            if (++i == 2) break;
        }
        String bb0 = (String)brackets[0].getProperty("BoundingBox");
        String[] tmp = bb0.split(" ");
        DPoint3 p1 = new DPoint3(this.addCoord(Double.parseDouble(tmp[0]), xShift), this.addCoord(-Double.parseDouble(tmp[1]), yShift), 0.0);
        DPoint3 p2 = new DPoint3(this.addCoord(Double.parseDouble(tmp[2]), xShift), this.addCoord(-Double.parseDouble(tmp[3]), yShift), 0.0);
        double size1 = (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
        bb0 = (String)brackets[1].getProperty("BoundingBox");
        tmp = bb0.split(" ");
        p1 = new DPoint3(this.addCoord(Double.parseDouble(tmp[0]), xShift), this.addCoord(-Double.parseDouble(tmp[1]), yShift), 0.0);
        p2 = new DPoint3(this.addCoord(Double.parseDouble(tmp[2]), xShift), this.addCoord(-Double.parseDouble(tmp[3]), yShift), 0.0);
        double size2 = (p1.x - p2.x) * (p1.x - p2.x) + (p1.y - p2.y) * (p1.y - p2.y);
        if (size1 - size2 > 0.01) {
            // empty if block
        }
    }

    private void postprocessBracketedGroup(CDXObject bgr, Molecule mol, double xShift, double yShift) {
        String patt;
        int i;
        MolAtom ma;
        Sgroup sg;
        String brUsage = (String)bgr.getProperty("BracketUsage");
        if (brUsage == null) {
            brUsage = "Generic";
        }
        if (brUsage.equals("SRU")) {
            sg = new RepeatingUnitSgroup(mol, 2);
        } else if (brUsage.equals("Monomer")) {
            sg = new RepeatingUnitSgroup(mol, 3);
        } else if (brUsage.equals("Mer")) {
            sg = new RepeatingUnitSgroup(mol, 4);
        } else if (brUsage.equals("Copolymer")) {
            sg = new RepeatingUnitSgroup(mol, 5);
        } else if (brUsage.equals("CopolymerAlternating")) {
            sg = new RepeatingUnitSgroup(mol, 5);
            sg.setSubType(1);
        } else if (brUsage.equals("CopolymerRandom")) {
            sg = new RepeatingUnitSgroup(mol, 5);
            sg.setSubType(2);
        } else if (brUsage.equals("CopolymerBlock")) {
            sg = new RepeatingUnitSgroup(mol, 5);
            sg.setSubType(3);
        } else {
            sg = brUsage.equals("Crosslink") ? new RepeatingUnitSgroup(mol, 6) : (brUsage.equals("Graft") ? new RepeatingUnitSgroup(mol, 15) : (brUsage.equals("Modification") ? new RepeatingUnitSgroup(mol, 7) : (brUsage.equals("Component") ? new Sgroup(mol, 13) : (brUsage.equals("MixtureOrdered") ? new Sgroup(mol, 9) : (brUsage.equals("MixtureUnordered") ? new Sgroup(mol, 8) : (brUsage.equals("MultipleGroup") ? new MultipleSgroup(mol, false) : (brUsage.equals("Generic") ? new Sgroup(mol, 12) : (brUsage.equals("Anypolymer") ? new RepeatingUnitSgroup(mol, 11) : new RepeatingUnitSgroup(mol, 11)))))))));
        }
        String ids = (String)bgr.getProperty("BracketedObjectIDs");
        String[] idarr = ids.split(" ");
        SelectionMolecule sm = new SelectionMolecule();
        for (int i2 = 0; i2 < idarr.length; ++i2) {
            Object o = this.id.get(idarr[i2]);
            if (!(o instanceof MolAtom)) continue;
            ma = (MolAtom)o;
            sm.add(ma);
        }
        int sgc = mol.getSgroupCount();
        for (i = 0; i < sgc; ++i) {
            Sgroup tsg = mol.getSgroup(i);
            if (tsg == sg) continue;
            if (tsg instanceof SuperatomSgroup && sm.contains(((SuperatomSgroup)tsg).getSuperAtom())) {
                if (tsg.getParentSgroup() != null) continue;
                sg.addChildSgroup(tsg);
                continue;
            }
            if (!sm.contains(tsg.getSgroupGraph()) || tsg.getParentSgroup() != null) continue;
            sg.addChildSgroup(tsg);
        }
        for (i = 0; i < idarr.length; ++i) {
            Object o = this.id.get(idarr[i]);
            if (!(o instanceof MolAtom)) continue;
            MolAtom ma2 = (MolAtom)o;
            mol.setSgroupParent(ma2, sg, true);
        }
        if (sg instanceof RepeatingUnitSgroup) {
            String flip;
            RepeatingUnitSgroup rsg = sg;
            MolBond[] crbs = new MolBond[4];
            int braNum = 0;
            for (CDXObject bra = bgr.firstChild(); bra != null; bra = bra.Next()) {
                if (bra.Type() != 32792) continue;
                CDXObject crb = bra.firstChild();
                int cbNum = braNum;
                for (crb = bra.firstChild(); crb != null; crb = crb.Next()) {
                    if (crb.Type() != 32793 || cbNum >= 4) continue;
                    crbs[cbNum] = (MolBond)this.id.get((String)crb.getProperty("BondID"));
                    cbNum += 2;
                }
                ++braNum;
            }
            boolean hasCrB = true;
            for (int i3 = 0; i3 < crbs.length; ++i3) {
                if (crbs[i3] != null) continue;
                hasCrB = false;
                break;
            }
            if (hasCrB) {
                rsg.setBondCorrespondence(crbs);
            }
            if ((flip = (String)bgr.getProperty("PolymerFlipType")) != null && flip.equalsIgnoreCase("Flip")) {
                rsg.setFlipped(true);
            }
            ((RepeatingUnitSgroup)sg).addStarAtoms();
            String srulabel = (String)bgr.getProperty("SRULabel");
            if (srulabel != null) {
                sg.setSubscript(srulabel);
            }
        } else if (sg instanceof MultipleSgroup) {
            for (i = 0; i < idarr.length; ++i) {
                ma = (MolAtom)this.id.get(idarr[i]);
                ((MultipleSgroup)sg).setRepeatingUnitAtom(ma, true);
            }
            String repeatC = (String)bgr.getProperty("RepeatCount");
            double rc = Double.parseDouble(repeatC);
            if (rc != 0.0) {
                ((MultipleSgroup)sg).setMultiplier((int)rc);
            }
        }
        String cOrder = (String)bgr.getProperty("ComponentOrder");
        if (cOrder != null) {
            sg.setSubscript("c" + cOrder);
        }
        if ((patt = (String)bgr.getProperty("PolymerRepeatPattern")) != null) {
            if (patt.equals("EitherUnknown")) {
                sg.setConnectivity(0);
            } else if (patt.equals("HeadToHead")) {
                sg.setConnectivity(1);
            } else {
                sg.setConnectivity(2);
            }
        } else {
            sg.setConnectivity(2);
        }
        int braNum = 0;
        String[] braID = new String[2];
        for (CDXObject bra = bgr.firstChild(); bra != null; bra = bra.Next()) {
            if (bra.Type() != 32792) continue;
            braID[braNum] = (String)bra.getProperty("GraphicID");
            if (++braNum != 2) continue;
            braNum = 0;
            this.addBracket(braID, mol, sg, xShift, yShift);
        }
    }

    private void processStep(CDXObject step, Molecule m) throws MolFormatException {
        String arrows;
        String atomMap;
        String p;
        if (this.reactionArrows == null) {
            this.reactionArrows = new Vector();
        }
        boolean stepCounted = false;
        String r = (String)step.getProperty("ReactionStepReactants");
        if (r != null) {
            if (this.stepNum != 0) {
                this.grapArrows = true;
                ++this.stepNum;
                return;
            }
            ++this.stepNum;
            stepCounted = true;
            String[] rarr = r.trim().split(" ");
            if (this.reactants == null) {
                this.reactants = new IntVector();
            }
            for (int i = 0; i < rarr.length; ++i) {
                this.reactants.add(Integer.parseInt(rarr[i]));
            }
        }
        if ((p = (String)step.getProperty("ReactionStepProducts")) != null) {
            if (!stepCounted) {
                ++this.stepNum;
                stepCounted = true;
            }
            String[] parr = p.trim().split(" ");
            if (this.products == null) {
                this.products = new IntVector();
            }
            for (int i = 0; i < parr.length; ++i) {
                this.products.add(Integer.parseInt(parr[i]));
            }
        }
        if ((atomMap = (String)step.getProperty("ReactionStepAtomMap")) != null) {
            String[] marr = atomMap.trim().split(" ");
            int start = 0;
            if (this.atomMapP == null) {
                this.atomMapP = new int[marr.length / 2];
                this.atomMapR = new int[marr.length / 2];
            } else {
                int[] tmp = (int[])this.atomMapP.clone();
                int[] tmp2 = (int[])this.atomMapR.clone();
                this.atomMapP = new int[marr.length / 2 + tmp.length];
                this.atomMapR = new int[marr.length / 2 + tmp.length];
                for (int i = 0; i < tmp.length; ++i) {
                    this.atomMapP[i] = tmp[i];
                    this.atomMapR[i] = tmp2[i];
                }
                start = tmp.length;
            }
            for (int i = start; i < marr.length / 2; ++i) {
                this.atomMapP[i] = Integer.parseInt(marr[2 * (i - start)]);
                this.atomMapR[i] = Integer.parseInt(marr[1 + 2 * (i - start)]);
            }
        }
        if ((arrows = (String)step.getProperty("ReactionStepArrows")) != null) {
            String[] arrowIndexes;
            for (String ai : arrowIndexes = arrows.trim().split(" ")) {
                this.reactionArrows.add(ai);
            }
        }
    }

    private void processScheme(CDXObject scheme, Molecule m) throws MolFormatException {
        if (this.reactionArrows == null) {
            this.reactionArrows = new Vector();
        }
        for (CDXObject curr = scheme.firstChild(); curr != null; curr = curr.Next()) {
            if (curr.Type() != 32782) continue;
            this.processStep(curr, m);
        }
    }

    private void processFragment(CDXObject fr, Molecule m, double xShift, double yShift, boolean inSgroup) throws MolFormatException {
        if (!fr.hasProp("BoundingBox")) {
            fr.setProperty("BoundingBox", this.getBoundingBox(fr));
        }
        Molecule mol = m;
        boolean rg = false;
        int rp = -1;
        int rgnum = this.isInRgroup(fr);
        if (!this.altgr.isEmpty() && rgnum >= 0) {
            mol = new Molecule();
            rg = true;
        } else if (!this.grapArrows && this.reactants != null && this.products != null) {
            if (this.reactants.contains(fr.getID())) {
                rp = 0;
                mol = new Molecule();
            } else if (this.products.contains(fr.getID())) {
                rp = 1;
                mol = new Molecule();
            }
        }
        CDXObject curr = fr.firstChild();
        block13: while (curr != null) {
            switch (curr.Type()) {
                case 32772: {
                    this.processNode(curr, mol, xShift, yShift, inSgroup);
                    curr = curr.Next();
                    continue block13;
                }
            }
            curr = curr.Next();
        }
        for (curr = fr.firstChild(); curr != null; curr = curr.Next()) {
            if (curr.Type() == 32773) {
                this.processBond(curr, mol, inSgroup);
                continue;
            }
            if (curr.Type() != 32775) continue;
            this.processGraphic(curr, mol, xShift, yShift);
        }
        if (rg) {
            if (!(m.getParent() instanceof RgMolecule)) {
                throw new MolFormatException("importig rgroup to a non RgMolecule");
            }
            RgMolecule rgm = (RgMolecule)m.getParent();
            rgm.addRgroup(rgnum, mol);
        }
        if (rp != -1) {
            if (!(m instanceof RxnMolecule)) {
                throw new MolFormatException("reading reaction into non reaction molecule.");
            }
            RxnMolecule rxn = (RxnMolecule)m;
            rxn.addComponent(mol, rp);
        }
        if (!inSgroup) {
            MolAtom con;
            int order;
            String orderS;
            String tmpConnections = (String)fr.getProperty("ConnectionOrder");
            if (tmpConnections != null) {
                String[] connections = tmpConnections.split(" ");
                for (int i = 0; i < connections.length; ++i) {
                    MolAtom ma = (MolAtom)this.id.get(connections[i]);
                    CDXObject externalConnectionPoint = this.connectionPoints.get(connections[i]);
                    orderS = (String)externalConnectionPoint.getProperty("ConnectionPointOrder");
                    order = 1;
                    try {
                        order = Integer.parseInt(orderS);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    con = ma.addRgroupAttachmentPoint(i + 1, order);
                    this.setAtomProperties(externalConnectionPoint, con, xShift, yShift);
                }
                this.connectionPoints.clear();
            }
            if (!this.connectionPoints.isEmpty()) {
                for (String cp : this.connectionPoints.keySet()) {
                    CDXObject externalConnectionPoint = this.connectionPoints.get(cp);
                    MolAtom ma = (MolAtom)this.id.get(cp);
                    orderS = (String)externalConnectionPoint.getProperty("ConnectionPointOrder");
                    order = 1;
                    try {
                        order = Integer.parseInt(orderS);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    con = ma.addRgroupAttachmentPoint(1, order);
                    this.setAtomProperties(externalConnectionPoint, con, xShift, yShift);
                }
                this.connectionPoints.clear();
            }
        }
        for (CDXObject node = fr.firstChild(); node != null; node = node.Next()) {
            MolAtom ma2;
            int i;
            MolAtom[] mas;
            Object o;
            if (node.Type() != 32772 || !((o = this.id.get(node.ID())) instanceof MolAtom)) continue;
            MolAtom ma = (MolAtom)o;
            if (node.hasProp("HDash") && Boolean.parseBoolean((String)node.getProperty("HDash"))) {
                mas = new MolAtom[]{ma};
                mol.addExplicitHydrogens(0, mas);
                int bc = ma.getBondCount();
                for (i = 0; i < bc; ++i) {
                    MolBond mb = ma.getBond(i);
                    ma2 = mb.getOtherAtom(ma);
                    if (ma2.getAtno() != 1) continue;
                    mb.setFlags(32, 48);
                    break;
                }
            }
            if (node.hasProp("HDot") && Boolean.parseBoolean((String)node.getProperty("HDot"))) {
                mas = new MolAtom[]{ma};
                mol.addExplicitHydrogens(0, mas);
                int bc = ma.getBondCount();
                for (i = 0; i < bc; ++i) {
                    MolBond mb = ma.getBond(i);
                    ma2 = mb.getOtherAtom(ma);
                    if (ma2.getAtno() != 1) continue;
                    mb.setFlags(16, 48);
                    break;
                }
            }
            if (node.hasProp("LinkCountLow") || node.hasProp("LinkCountHigh")) {
                int lcl = 1;
                int lch = 1;
                try {
                    lcl = Integer.parseInt((String)node.getProperty("LinkCountLow"));
                }
                catch (NumberFormatException ex) {
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                try {
                    lch = Integer.parseInt((String)node.getProperty("LinkCountHigh"));
                }
                catch (NumberFormatException ex) {
                }
                catch (NullPointerException ex) {
                    // empty catch block
                }
                ma.setMinRepetitions(lcl);
                ma.setMaxRepetitions(lch);
                ma.setLinkNodeDefaultOuters();
            }
            if (!node.hasProp("NodeType") || !((String)node.getProperty("NodeType")).equals("NamedAlternativeGroup")) continue;
            MolAtom Ratom = (MolAtom)this.id.get(node.ID());
            String bondOrder = (String)node.getProperty("BondOrdering");
            if (bondOrder == null) continue;
            String[] ordering = bondOrder.split(" ");
            for (int i2 = 0; i2 < ordering.length; ++i2) {
                MolBond mb = (MolBond)this.id.get(ordering[i2]);
                Ratom.setLigandOrder(i2 + 1, mb.getOtherAtom(Ratom));
            }
        }
        for (int i = 0; i < m.getAtomCount(); ++i) {
            int cip = m.getAtom(i).getFlags() & 0x18;
            int mcip = m.getChirality(i) & 0x18;
            if (cip != 0 && mcip != 0) continue;
        }
    }

    private int isInRgroup(CDXObject fr) {
        Set<String> keys = this.altgr.keySet();
        for (String key : keys) {
            String bb = (String)this.altgr.get(key);
            String[] tarr = bb.split(" ");
            String rgname = tarr[0];
            double altg_left = Double.parseDouble(tarr[1]);
            double altg_top = -Double.parseDouble(tarr[2]);
            double altg_right = Double.parseDouble(tarr[3]);
            double altg_bottom = -Double.parseDouble(tarr[4]);
            bb = (String)fr.getProperty("BoundingBox");
            tarr = bb.split(" ");
            double left = Double.parseDouble(tarr[0]);
            double top = -Double.parseDouble(tarr[1]);
            double right = Double.parseDouble(tarr[2]);
            double bottom = -Double.parseDouble(tarr[3]);
            String rgnumber = rgname.substring(1);
            if (!(altg_left <= left) || !(altg_top >= top) || !(altg_bottom <= bottom) || !(altg_right >= right)) continue;
            try {
                return Integer.parseInt(rgnumber);
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }
        return -1;
    }

    private void processText(CDXObject text, Molecule mol, double xShift, double yShift) {
        MDocument md = mol.getDocument();
        if (md == null) {
            md = new MDocument(mol);
        }
        MTextBox textbox = new MTextBox();
        String tmp = (String)text.getProperty("BoundingBox");
        String[] tarr = tmp.split(" ");
        double left = this.addCoord(Double.parseDouble(tarr[0]), xShift);
        double top = this.addCoord(-Double.parseDouble(tarr[1]), yShift);
        double right = this.addCoord(Double.parseDouble(tarr[2]), xShift);
        double bottom = this.addCoord(-Double.parseDouble(tarr[3]), yShift);
        String t2 = (String)text.getProperty("Text");
        if (t2 == null || t2.equals("+") && !this.grapArrows) {
            return;
        }
        if (t2.contains("\r") && !t2.contains("\r\n")) {
            t2 = t2.replaceAll("\r", "\n");
        }
        MPoint tL = new MPoint(left, top);
        MPoint bR = new MPoint(right, bottom);
        textbox.setCorners(tL, bR);
        if (text.hasProp("RotationAngle")) {
            double angle = -Double.parseDouble((String)text.getProperty("RotationAngle")) / 65536.0;
            CTransform3D rotation = new CTransform3D();
            rotation.setRotation(1.0, 1.0, 1.0, Math.toRadians(angle));
            DPoint3 center = new DPoint3();
            textbox.calcCenter(center, null);
            rotation.setRotationCenter(center);
            textbox.transform(rotation, 0, null);
        }
        textbox.setAutoSize(true);
        CDXObject style = text.firstChild();
        StringBuffer formattedText = new StringBuffer();
        int begin = 0;
        int end = 0;
        boolean wasBold = false;
        boolean wasItalic = false;
        boolean wasSub = false;
        boolean wasSuper = false;
        while (style != null) {
            if (style.Type() != 258) {
                style = style.Next();
                continue;
            }
            try {
                String currentText;
                int face;
                StringBuffer styleOpts = new StringBuffer("{");
                String strFace = (String)style.getProperty("face");
                if (strFace == null || strFace.equals("")) {
                    strFace = "0";
                }
                if (((face = Integer.parseInt(strFace)) & 0x20) != 0) {
                    if (!wasSub) {
                        styleOpts.append("subL=-1,");
                        styleOpts.append("scale=0.7,");
                        styleOpts.append("dy=-0.4,");
                        wasSub = true;
                    }
                } else if (wasSub) {
                    styleOpts.append("subL=0,");
                    styleOpts.append("scale=1,");
                    wasSub = false;
                }
                if ((face & 0x40) != 0) {
                    if (!wasSuper) {
                        styleOpts.append("subL=1,");
                        styleOpts.append("scale=0.7,");
                        styleOpts.append("dy=0.6,");
                        wasSuper = true;
                    }
                } else if (wasSuper) {
                    styleOpts.append("subL=0,");
                    styleOpts.append("scale=1,");
                    wasSuper = false;
                }
                if ((face & 1) != 0) {
                    styleOpts.append("bold,");
                    wasBold = true;
                } else if (wasBold) {
                    styleOpts.append("nobold,");
                    wasBold = false;
                }
                if ((face & 2) != 0) {
                    styleOpts.append("italic,");
                    wasItalic = true;
                } else if (wasItalic) {
                    styleOpts.append("noitalic,");
                    wasItalic = false;
                }
                String fontId = (String)style.getProperty("font");
                CDXObject font = this.fonts.get(fontId);
                String fontName = "SansSerif";
                if (font != null) {
                    fontName = (String)font.getProperty("name");
                }
                styleOpts.append("font=" + fontName + ",");
                String strSize = (String)style.getProperty("size");
                double size = Double.parseDouble(strSize);
                size *= 0.8;
                if (this.fromCDX) {
                    size /= 20.0;
                }
                styleOpts.append("size=" + size + ",");
                String strColorId = (String)style.getProperty("color");
                if (strColorId == null || strColorId.equals("")) {
                    strColorId = "0";
                }
                int colorId = Integer.parseInt(strColorId);
                String rgb = Integer.toHexString(this.color[colorId].getRGB());
                rgb = rgb.substring(2, rgb.length());
                styleOpts.append("fg=#" + rgb + "}");
                if (this.fromCDX) {
                    String strEnd = style.Next() != null ? (String)style.Next().getProperty("charstart") : Integer.toString(t2.length());
                    end = Integer.parseInt(strEnd);
                    currentText = t2.substring(begin, end);
                    begin = end;
                } else {
                    currentText = (String)style.getProperty("Text");
                }
                formattedText.append(styleOpts.toString() + currentText);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            style = style.Next();
        }
        String haling = (String)text.getProperty("Justification");
        if (haling != null) {
            textbox.setAttribute("halign", haling);
        }
        textbox.setAttribute("text", formattedText.toString());
        md.addObject(textbox);
    }

    private void printToErr(CDXObject obj) {
        System.err.println(obj.toString());
        for (CDXObject c = obj.firstChild(); c != null; c = c.Next()) {
            this.printToErr(c);
        }
    }

    public boolean readMol(CDXObject root, Molecule mol) throws MolFormatException {
        int i;
        String lw;
        String comment;
        if (root == null) {
            return false;
        }
        RgMolecule rgmol = null;
        if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
        } else {
            rgmol = new RgMolecule();
            rgmol.setRoot(mol);
        }
        RgMolecule m = rgmol;
        MDocument md = m.getDocument();
        if (md == null) {
            md = new MDocument(m);
        }
        if (root.hasProp("FromCDX")) {
            this.fromCDX = true;
        }
        double cdxBondLength = 1966080.0;
        if (root.hasProp("BondLength")) {
            cdxBondLength = Double.parseDouble((String)root.Prop("BondLength"));
        }
        this.cdxUnitsToMarvin = 1.54 / cdxBondLength;
        String name = (String)root.getProperty("Name");
        if (name != null) {
            ((Molecule)m).setName(name);
        }
        if ((comment = (String)root.getProperty("Comment")) != null) {
            ((Molecule)m).setComment(comment);
        }
        if ((lw = (String)root.getProperty("LineWidth")) != null) {
            this.lineWidth = Double.parseDouble(lw);
        }
        CDXObject fontTable = null;
        if (this.fromCDX) {
            fontTable = (CDXObject)root.getProperty("fonttable");
        } else {
            for (fontTable = root.firstChild(); fontTable != null && fontTable.Type() != 256; fontTable = fontTable.Next()) {
            }
        }
        if (fontTable != null) {
            for (CDXObject font = fontTable.firstChild(); font != null; font = font.Next()) {
                this.fonts.put(font.ID(), font);
            }
        }
        if (this.fromCDX) {
            this.color = (Color[])root.getProperty("colors");
        } else {
            CDXObject icolor;
            for (CDXObject colorTable = root.firstChild(); colorTable != null && colorTable.Type() != 768; colorTable = colorTable.Next()) {
            }
            int colornum = 0;
            for (icolor = colorTable.firstChild(); icolor != null; icolor = icolor.Next()) {
                ++colornum;
            }
            this.color = new Color[colornum + 1];
            this.color[0] = Color.black;
            this.color[1] = Color.white;
            colornum = 2;
            for (icolor = colorTable.firstChild(); icolor != null; icolor = icolor.Next()) {
                if (icolor.Type() != 769) continue;
                this.color[colornum] = new Color(Float.parseFloat((String)icolor.getProperty("r")), Float.parseFloat((String)icolor.getProperty("g")), Float.parseFloat((String)icolor.getProperty("b")));
                ++colornum;
            }
        }
        this.preprocessCDX(root, m, 0.0, 0.0);
        if (this.products != null && this.reactants != null) {
            CDXObject frag;
            int i2;
            for (i2 = 0; i2 < this.products.size(); ++i2) {
                int pi = this.products.get(i2);
                CDXObject product = (CDXObject)this.id.get(pi);
                if (product == null || product.Type() != 32770) continue;
                this.products.removeElement(pi);
                for (frag = product.firstChild(); frag != null; frag = frag.Next()) {
                    if (frag.Type() != 32771) continue;
                    this.products.add(frag.getID());
                }
            }
            for (i2 = 0; i2 < this.reactants.size(); ++i2) {
                int pi = this.reactants.get(i2);
                CDXObject reactant = (CDXObject)this.id.get(pi);
                if (reactant == null || reactant.Type() != 32770) continue;
                this.reactants.removeElement(pi);
                for (frag = reactant.firstChild(); frag != null; frag = frag.Next()) {
                    if (frag.Type() != 32771) continue;
                    this.reactants.add(frag.getID());
                }
            }
        }
        if (m instanceof RgMolecule) {
            RgMolecule rg = m;
            Molecule rootMol = rg.getRoot();
            if (!this.grapArrows && (this.stepNum == 1 || this.stepNum == 0 && this.arrowNum == 1) && !(rootMol instanceof RxnMolecule)) {
                rg.setRoot(new RxnMolecule());
            }
        }
        CDXObject curr = root.firstChild();
        block12: while (curr != null) {
            switch (curr.Type()) {
                case 32769: {
                    this.processPage(curr, rgmol, 0.0, 0.0);
                    curr = curr.Next();
                    continue block12;
                }
            }
            curr = curr.Next();
        }
        if (!this.grapArrows && this.atomMapP != null) {
            for (int i3 = 0; i3 < this.atomMapP.length; ++i3) {
                MolAtom r = (MolAtom)this.id.get(Integer.toString(this.atomMapP[i3]));
                MolAtom p = (MolAtom)this.id.get(Integer.toString(this.atomMapR[i3]));
                r.setAtomMap(i3 + 1);
                p.setAtomMap(i3 + 1);
            }
        }
        boolean wasChange = true;
        while (wasChange) {
            wasChange = false;
            for (i = 1; i < this.sgNumber; ++i) {
                if (this.sgANum[i - 1] <= this.sgANum[i]) continue;
                int tmp = this.sgANum[i];
                this.sgANum[i] = this.sgANum[i - 1];
                this.sgANum[i - 1] = tmp;
                CDXObject tmpcdx = this.bracketedGroup[i];
                this.bracketedGroup[i] = this.bracketedGroup[i - 1];
                this.bracketedGroup[i - 1] = tmpcdx;
                wasChange = true;
            }
        }
        for (i = 0; i < this.sgNumber; ++i) {
            this.postprocessBracketedGroup(this.bracketedGroup[i], m, 0.0, 0.0);
        }
        if (this.cleanFrags && m instanceof RgMolecule) {
            RgMolecule rg = m;
            GeomUtil.arrangeRgoups(rg);
        }
        return !m.getDocument().isEmpty();
    }

    private void preprocessCDX(CDXObject root, Molecule m, double xShift, double yShift) throws MolFormatException {
        CDXObject curr = root.firstChild();
        block3: while (curr != null) {
            switch (curr.Type()) {
                case 32769: {
                    this.preprocessPage(curr, m, xShift, yShift);
                    curr = curr.Next();
                    continue block3;
                }
            }
            curr = curr.Next();
        }
    }

    private void preprocessPage(CDXObject page, Molecule mol, double xShift, double yShift) throws MolFormatException {
        block8: for (CDXObject curr = page.firstChild(); curr != null; curr = curr.Next()) {
            switch (curr.Type()) {
                case 32778: {
                    this.preprocessAltGroup(curr, mol, xShift, yShift);
                    continue block8;
                }
                case 32781: {
                    this.processScheme(curr, mol);
                    continue block8;
                }
                case 32782: {
                    this.processStep(curr, mol);
                    continue block8;
                }
                case 32770: {
                    this.preprocessGroup(curr, mol, xShift, yShift);
                    continue block8;
                }
                case 32775: {
                    this.preprocessGraphic(curr, mol);
                    continue block8;
                }
                case 32771: {
                    this.preprocessFragment(curr, mol, xShift, yShift);
                    continue block8;
                }
            }
        }
    }

    private void processAltGroup(CDXObject altg, Molecule m, double xShift, double yShift) throws MolFormatException {
        block4: for (CDXObject curr = altg.firstChild(); curr != null; curr = curr.Next()) {
            switch (curr.Type()) {
                case 32771: {
                    this.processFragment(curr, m, xShift, yShift, false);
                    continue block4;
                }
                case 32770: {
                    this.processGroup(curr, m, xShift, yShift, false);
                    continue block4;
                }
            }
        }
    }

    private void processGroup(CDXObject g, Molecule mol, double xShift, double yShift, boolean inSgroup) throws MolFormatException {
        CDXObject curr = g.firstChild();
        block6: while (curr != null) {
            switch (curr.Type()) {
                case 32771: {
                    this.processFragment(curr, mol, xShift, yShift, inSgroup);
                    curr = curr.Next();
                    continue block6;
                }
                case 32774: {
                    this.processText(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block6;
                }
                case 32775: {
                    this.processGraphic(curr, mol, xShift, yShift);
                    curr = curr.Next();
                    continue block6;
                }
                case 32770: {
                    this.processGroup(curr, mol, xShift, yShift, inSgroup);
                    curr = curr.Next();
                    continue block6;
                }
            }
            curr = curr.Next();
        }
    }

    public Molecule createMol() {
        RgMolecule mol = new RgMolecule();
        return mol;
    }

    public MDocument readDocument(CDXObject root, MDocument md) throws MolFormatException {
        this.readMol(root, (Molecule)md.getMainMoleculeGraph());
        return md;
    }

    private void addBracket(String[] braID, Molecule mol, Sgroup sg, double xShift, double yShift) {
        CDXObject b0 = this.graphics.get(braID[0]);
        CDXObject b1 = this.graphics.get(braID[1]);
        MPoint[] points = this.getBracketPoints(b0, b1, xShift, yShift);
        MBracket mb = new MBracket();
        mb.setPoints(points);
        String braType = (String)b0.getProperty("BracketType");
        if (braType.indexOf("Curly") > -1) {
            mb.setType(2);
        } else if (braType.indexOf("Round") > -1) {
            mb.setType(0);
        } else {
            mb.setType(1);
        }
        sg.addBracket(mb);
    }

    private MPoint[] getBracketPoints(CDXObject b0, CDXObject b1, double xShift, double yShift) {
        String bb0 = (String)b0.getProperty("BoundingBox");
        String bb1 = (String)b1.getProperty("BoundingBox");
        String[] tmp = bb0.split(" ");
        MPoint mp1 = new MPoint(this.addCoord(Double.parseDouble(tmp[0]), xShift), this.addCoord(-Double.parseDouble(tmp[1]), yShift), 0.0);
        MPoint mp2 = new MPoint(this.addCoord(Double.parseDouble(tmp[2]), xShift), this.addCoord(-Double.parseDouble(tmp[3]), yShift), 0.0);
        tmp = bb1.split(" ");
        MPoint mp3 = new MPoint(this.addCoord(Double.parseDouble(tmp[0]), xShift), this.addCoord(-Double.parseDouble(tmp[1]), yShift), 0.0);
        MPoint mp4 = new MPoint(this.addCoord(Double.parseDouble(tmp[2]), xShift), this.addCoord(-Double.parseDouble(tmp[3]), yShift), 0.0);
        if (mp1.getLocation().x < mp3.getLocation().x) {
            return new MPoint[]{mp2, mp3, mp4, mp1};
        }
        return new MPoint[]{mp4, mp1, mp2, mp3};
    }

    private boolean isInARing(MPoint[] points, Molecule m) {
        for (int i = 0; i < points.length; ++i) {
            if (this.isInARing(points[i], m)) continue;
            return false;
        }
        return true;
    }

    private boolean isInARing(MPoint mPoint, Molecule mol) {
        int[][] sssr = mol.getSSSR();
        for (int i = 0; i < sssr.length; ++i) {
            DPoint3 center = this.calcCenter(sssr[i], mol);
            double radius = this.calcRadius(sssr[i], mol, center);
            for (int j = 0; j < sssr[i].length; ++j) {
                double distance = Math.sqrt(Math.pow(mPoint.getLocation().x - center.x, 2.0) + Math.pow(mPoint.getLocation().y - center.y, 2.0) + Math.pow(mPoint.getLocation().z - center.z, 2.0));
                if (!(distance <= radius + 1.0E-7)) continue;
                return true;
            }
        }
        return false;
    }

    private DPoint3 calcCenter(int[] ring, Molecule mol) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < ring.length; ++i) {
            MolAtom ma = mol.getAtom(ring[i]);
            x += ma.getX();
            y += ma.getY();
            z += ma.getZ();
        }
        return new DPoint3(x /= (double)ring.length, y /= (double)ring.length, z /= (double)ring.length);
    }

    private double calcRadius(int[] ring, Molecule mol, DPoint3 center) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < ring.length; ++i) {
            MolAtom ma = mol.getAtom(ring[i]);
            x = Math.max(x, Math.abs(ma.getX() - center.x));
            y = Math.max(y, Math.abs(ma.getY() - center.y));
            z = Math.max(z, Math.abs(ma.getZ() - center.z));
        }
        return Math.sqrt(2.0) * Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
    }

    private void processRLogic(CDXObject rlog, Molecule mol) throws MolFormatException {
        if (!(mol instanceof RgMolecule)) {
            throw new MolFormatException("Reading R-Logic to a Molecule");
        }
        block3: for (CDXObject child = rlog.firstChild(); child != null; child = child.Next()) {
            int type = child.Type();
            switch (type) {
                case 32810: {
                    this.processRLogicItem(child, mol);
                    continue block3;
                }
            }
        }
    }

    private void processRLogicItem(CDXObject rlogItem, Molecule mol) {
        RgMolecule rmol = (RgMolecule)mol;
        String tmp = (String)rlogItem.getProperty("RLogicGroup");
        int rgid = Integer.parseInt(tmp.substring(tmp.indexOf("R") + 1));
        boolean restH = rlogItem.hasProp("RLogicRestH") ? Boolean.parseBoolean((String)rlogItem.getProperty("RLogicRestH")) : false;
        String occur = (String)rlogItem.getProperty("RLogicOccurrence");
        tmp = (String)rlogItem.getProperty("RLogicIfThenGroup");
        int otherGroup = -1;
        try {
            otherGroup = Integer.parseInt(tmp.substring(tmp.indexOf("R") + 1));
        }
        catch (Exception e) {
            // empty catch block
        }
        int f = rgid;
        if (otherGroup > -1) {
            f |= 0x8000 | otherGroup << 16;
        }
        if (restH) {
            f |= Integer.MIN_VALUE;
        }
        int rgIndex = rgid - 1;
        rmol.setRlogic(rgIndex, f);
        if (occur != null) {
            rmol.setRlogicRange(rgIndex, occur);
        }
    }

    private void addCircle(MPoint mp, double r, Color c, MDocument md) {
        this.addEllipse(mp, r, r, c, md);
    }

    private void addEllipse(MPoint mp, double r1, double r2, Color c, MDocument md) {
        MPoint mp1 = new MPoint(mp.getLocation().x - r1, mp.getLocation().y - r2);
        MPoint mp2 = new MPoint(mp.getLocation().x + r1, mp.getLocation().y + r2);
        MEllipse me = new MEllipse(mp1, mp2, c);
        md.addObject(me);
    }

    private void processTLCPlate(CDXObject plate, RgMolecule mol, double xShift, double yShift) {
        String tmp = (String)plate.getProperty("TopLeft");
        String[] tarr = tmp.split(" ");
        MPoint topleft = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
        tmp = (String)plate.getProperty("TopRight");
        tarr = tmp.split(" ");
        MPoint topright = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
        tmp = (String)plate.getProperty("BottomRight");
        tarr = tmp.split(" ");
        MPoint bottomleft = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
        tmp = (String)plate.getProperty("BottomLeft");
        tarr = tmp.split(" ");
        MPoint bottomright = new MPoint(this.addCoord(Double.parseDouble(tarr[0]), xShift), this.addCoord(-Double.parseDouble(tarr[1]), yShift));
        MDocument md = mol.getDocument();
        if (!plate.hasProp("ShowBorders") || plate.hasProp("ShowBorders") && Boolean.parseBoolean((String)plate.getProperty("ShowBorders"))) {
            MRectangle mr = new MRectangle();
            mr.setPoints(new MPoint[]{topleft, topright, bottomright, bottomleft});
            md.addObject(mr);
        }
        double origin = 0.1;
        if (plate.hasProp("OriginFraction") && ((origin = Double.parseDouble((String)plate.getProperty("OriginFraction"))) < 0.0 || origin > 1.0)) {
            origin = 0.1;
        }
        if (!plate.hasProp("ShowOrigin") || plate.hasProp("ShowOrigin") && Boolean.parseBoolean((String)plate.getProperty("ShowOrigin"))) {
            this.addFractionLine(topleft, bottomleft, bottomright, origin, md);
        }
        double solvent = 0.1;
        if (plate.hasProp("SolventFraction") && ((solvent = Double.parseDouble((String)plate.getProperty("SolventFraction"))) < 0.0 || solvent > 1.0)) {
            solvent = 0.1;
        }
        solvent = 1.0 - solvent;
        if (!plate.hasProp("ShowSolventFront") || plate.hasProp("ShowSolventFront") && Boolean.parseBoolean((String)plate.getProperty("ShowSolventFront"))) {
            this.addFractionLine(topleft, bottomleft, bottomright, solvent, md);
        }
        int lineNum = this.getLineCount(plate);
        double lineShiftX = (bottomright.getLocation().x - bottomleft.getLocation().x) / (double)(lineNum + 1);
        double lineShiftY = (bottomright.getLocation().y - bottomleft.getLocation().y) / (double)(lineNum + 1);
        DPoint3 UP = new DPoint3(bottomright.getLocation().x - topright.getLocation().x, bottomright.getLocation().y - topright.getLocation().y, 0.0);
        DPoint3 RIGHT = new DPoint3(bottomright.getLocation().x - bottomleft.getLocation().x, bottomright.getLocation().y - bottomleft.getLocation().y, 0.0);
        this.setToUnitLength(UP);
        this.setToUnitLength(RIGHT);
        lineNum = 1;
        for (CDXObject line = plate.firstChild(); line != null; line = line.Next()) {
            if (line.Type() != 32798) continue;
            if (!plate.hasProp("Visible") || plate.hasProp("Visible") && Boolean.parseBoolean((String)plate.getProperty("Visible"))) {
                double Dy = (topleft.getLocation().y - bottomleft.getLocation().y) * origin;
                double Dx = (topleft.getLocation().x - bottomleft.getLocation().x) * origin;
                DPoint3 lineStart = new DPoint3(bottomleft.getLocation().x + Dx + lineShiftX * (double)lineNum, bottomleft.getLocation().y + Dy + lineShiftY * (double)lineNum, 0.0);
                MPolyline startMark = new MPolyline(new MPoint(lineStart.x - UP.x * 0.15, lineStart.y - UP.y * 0.15), new MPoint(lineStart.x + UP.x * 0.15, lineStart.y + UP.y * 0.15));
                md.addObject(startMark);
                Dy = (topleft.getLocation().y - bottomleft.getLocation().y) * solvent;
                Dx = (topleft.getLocation().x - bottomleft.getLocation().x) * solvent;
                DPoint3 lineEnd = new DPoint3(bottomleft.getLocation().x + Dx + lineShiftX * (double)lineNum, bottomleft.getLocation().y + Dy + lineShiftY * (double)lineNum, 0.0);
                for (CDXObject spot = line.firstChild(); spot != null; spot = spot.Next()) {
                    if (spot.Type() != 32799 || spot.hasProp("Visible") && (!spot.hasProp("Visible") || !Boolean.parseBoolean((String)spot.getProperty("Visible")))) continue;
                    double rf = Double.parseDouble((String)spot.getProperty("Rf"));
                    DPoint3 center = new DPoint3(lineStart.x * (1.0 - rf) + lineEnd.x * rf, lineStart.y * (1.0 - rf) + lineEnd.y * rf, 0.0);
                    double halfSpotWidth = this.addCoord(Double.parseDouble((String)spot.getProperty("Width")) / 2.0, 0.0);
                    double halfSpotHeight = this.addCoord(Double.parseDouble((String)spot.getProperty("Height")) / 2.0, 0.0);
                    double tail = this.addCoord(Double.parseDouble((String)spot.getProperty("Tail")), 0.0);
                    int colorId = Integer.parseInt(spot.hasProp("color") ? (String)spot.getProperty("color") : "3");
                    MPoint[] spotPoints = new MPoint[]{new MPoint(center.x - UP.x * halfSpotWidth - RIGHT.x * halfSpotWidth, center.y - UP.y * (halfSpotHeight += tail / 2.0) - RIGHT.y * halfSpotHeight), new MPoint(center.x + UP.x * halfSpotWidth - RIGHT.x * halfSpotWidth, center.y + UP.y * halfSpotHeight - RIGHT.y * halfSpotHeight), new MPoint(center.x + UP.x * halfSpotWidth + RIGHT.x * halfSpotWidth, center.y + UP.y * halfSpotHeight + RIGHT.y * halfSpotHeight), new MPoint(center.x - UP.x * halfSpotWidth + RIGHT.x * halfSpotWidth, center.y - UP.y * halfSpotHeight + RIGHT.y * halfSpotHeight)};
                    MEllipse me = new MEllipse();
                    int ct = 0;
                    if (spot.hasProp("CurveType")) {
                        try {
                            ct = Integer.parseInt((String)spot.getProperty("CurveType"));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (ct == 0) {
                        me.setColor(this.color[colorId]);
                    }
                    if ((ct & 4) != 0) {
                        me.setThickness(me.getThickness() * 2.0);
                    }
                    if ((ct & 0x80) != 0) {
                        me.setBackground(this.color[colorId]);
                        me.setColor(this.color[colorId]);
                    }
                    me.setPoints(spotPoints);
                    md.addObject(me);
                    if ((ct & 0x200) != 0) {
                        spotPoints = new MPoint[]{new MPoint(center.x - UP.x * (halfSpotWidth += 0.2) - RIGHT.x * halfSpotWidth, center.y - UP.y * (halfSpotHeight += 0.2) - RIGHT.y * halfSpotHeight), new MPoint(center.x + UP.x * halfSpotWidth - RIGHT.x * halfSpotWidth, center.y + UP.y * halfSpotHeight - RIGHT.y * halfSpotHeight), new MPoint(center.x + UP.x * halfSpotWidth + RIGHT.x * halfSpotWidth, center.y + UP.y * halfSpotHeight + RIGHT.y * halfSpotHeight), new MPoint(center.x - UP.x * halfSpotWidth + RIGHT.x * halfSpotWidth, center.y - UP.y * halfSpotHeight + RIGHT.y * halfSpotHeight)};
                        me = new MEllipse();
                        me.setPoints(spotPoints);
                        me.setColor(this.color[colorId]);
                        md.addObject(me);
                    }
                    if (!spot.hasProp("ShowRf") || !Boolean.parseBoolean((String)spot.getProperty("ShowRf"))) continue;
                    CDXObject textBox = spot.firstChild().firstChild();
                    this.processText(textBox, mol, xShift, yShift);
                }
            }
            ++lineNum;
        }
    }

    private int getLineCount(CDXObject plate) {
        int lineNum = 0;
        for (CDXObject line = plate.firstChild(); line != null; line = line.Next()) {
            if (line.Type() != 32798) continue;
            ++lineNum;
        }
        return lineNum;
    }

    private void addFractionLine(MPoint topleft, MPoint bottomleft, MPoint bottomright, double fraction, MDocument md) {
        double Dy = (topleft.getLocation().y - bottomleft.getLocation().y) * fraction;
        double Dx = (topleft.getLocation().x - bottomleft.getLocation().x) * fraction;
        MPoint fractionStart = new MPoint(bottomleft.getLocation().x + Dx, bottomleft.getLocation().y + Dy);
        MPoint fractionEnd = new MPoint(bottomright.getLocation().x + Dx, bottomright.getLocation().y + Dy);
        this.addDashedLine(fractionStart, fractionEnd, md, 10);
    }

    private void addDashedLine(MPoint start, MPoint end, MDocument md, int numberOfLines) {
        double dx = end.getLocation().x - start.getLocation().x;
        double dy = end.getLocation().y - start.getLocation().y;
        double dd = 1.0 / (double)numberOfLines;
        double skip = Math.sqrt(dx * dx + dy * dy) / (double)(2 * numberOfLines);
        MPoint mp1 = start;
        for (double i = 0.0; i <= 1.000001; i += dd) {
            MPoint mp2 = new MPoint(start.getLocation().x + dx * i, start.getLocation().y + dy * i);
            MPolyline mpline = new MPolyline(mp1, mp2);
            mpline.setSkip(MPolyline.HEAD, skip);
            mp1 = mp2;
            md.addObject(mpline);
        }
    }

    private void setToUnitLength(DPoint3 point) {
        double length = Math.sqrt(point.x * point.x + point.y * point.y + point.z * point.z);
        point.x /= length;
        point.y /= length;
        point.z /= length;
    }

    private int roundToCDValues(double angleToRound) {
        int angle = 90;
        if (angleToRound > 135.0) {
            angle = 180;
        }
        if (angleToRound > 225.0) {
            angle = 270;
        }
        return angle;
    }
}

