/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.common.util.IntVector;
import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.QueryBond;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BondReader {
    static IntVector readBondList(String elem) throws MolFormatException {
        IntVector blist = new IntVector();
        if (elem != null) {
            StringTokenizer st = new StringTokenizer(elem);
            while (st.hasMoreTokens()) {
                String sid = st.nextToken();
                int id = -1;
                try {
                    id = Integer.parseInt(sid.substring(1));
                }
                catch (NumberFormatException ex) {
                    throw new MolFormatException("unknown bond ID \"" + sid + "\"");
                }
                blist.add(id - 1);
            }
        }
        return blist;
    }

    static int readReactingCenterProperty(String rcValue, int flags) {
        int rcFlags = Integer.parseInt(rcValue);
        switch (rcFlags) {
            case -1: 
            case 15: {
                flags |= 0x5000;
                break;
            }
            case 1: {
                flags |= 0x1000;
                break;
            }
            case 2: {
                flags |= 0x6000;
                break;
            }
            case 4: {
                flags |= 0x2000;
                break;
            }
            case 8: {
                flags |= 0x3000;
                break;
            }
            case 12: {
                flags |= 0x4000;
                break;
            }
            case 0: {
                flags |= 0x7000;
                break;
            }
        }
        return flags;
    }

    static int readBondTopology(String val, int flags) throws MolFormatException {
        int flags0 = flags & 0xFFFFF3FF;
        if (val.equals("ring")) {
            return flags0 | 0x400;
        }
        if (val.equals("chain")) {
            return flags0 | 0x800;
        }
        throw new MolFormatException("unknown topology \"" + val + "\", must be \"ring\" or \"chain\"");
    }

    static int readBondQueryType(String val, int flags) throws MolFormatException {
        int flags0 = flags & 0xFFFFFFF0;
        if (val.equals("SD")) {
            return flags0 | 5;
        }
        if (val.equals("SA")) {
            return flags0 | 6;
        }
        if (val.equals("DA")) {
            return flags0 | 7;
        }
        if (val.equals("Any")) {
            return flags0 | 0;
        }
        try {
            int v = Integer.parseInt(val);
            if (v >= 0) {
                return flags0 | v;
            }
            throw new MolFormatException("Bond query type must be non negative number");
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Unknown query type in bond \"" + val + "\", must be SD, SA, DA, Any or an integer");
        }
    }

    static int readBondConvention(String val, int flags) throws MolFormatException {
        int flags0 = flags & 0xFFFFFFF0;
        if (val.equals("cxn:coord")) {
            return flags0 | 9;
        }
        try {
            int v = Integer.parseInt(val);
            return flags0 | v;
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Bond convention must be cxn:coord");
        }
    }

    static int readBondOrder(String val, int flags) throws MolFormatException {
        int flags0 = flags & 0xFFFFFFF0;
        if (val.equals("S")) {
            return flags0 | 1;
        }
        if (val.equals("D")) {
            return flags0 | 2;
        }
        if (val.equals("T")) {
            return flags0 | 3;
        }
        if (val.equals("A")) {
            return flags0 | 4;
        }
        if (val.equals("COORD")) {
            return flags0 | 9;
        }
        try {
            int v = Integer.parseInt(val);
            if (v >= 0) {
                return flags0 | v;
            }
            throw new MolFormatException("Bond order must be non negative number");
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Bond order must be S, D, T, A, COORD or an integer");
        }
    }

    static boolean readAtomRefs1(String array, List<String> bondAtomRefs1Array) {
        if (array != null) {
            StringTokenizer st = new StringTokenizer(array);
            List<String> h = bondAtomRefs1Array;
            while (st.hasMoreTokens()) {
                String ref1 = st.nextToken();
                h.add(ref1);
            }
            return true;
        }
        return false;
    }

    static boolean readOrder(String array, ParsedData parsedData) throws MolFormatException {
        if (array != null) {
            StringTokenizer st = new StringTokenizer(array);
            IntVector h = parsedData.bondFlagsArray;
            List<Object[]> h1 = parsedData.bondXPropsArray;
            while (st.hasMoreTokens()) {
                String ord = st.nextToken();
                h.add(BondReader.readBondOrder(ord, 0));
                h1.add(new Object[1]);
            }
            return true;
        }
        return false;
    }

    static int convertChemaxonStereo2ToFlags(String val) {
        int f = 0;
        StringTokenizer st = new StringTokenizer(val, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("C")) {
                f |= 0x80;
                continue;
            }
            if (s.equals("T")) {
                f |= 0x40;
                continue;
            }
            if (s.equals("CTUnspec")) {
                f |= 0x100;
                continue;
            }
            if (!s.equals("CARE")) continue;
            f |= 0x200;
        }
        return f;
    }

    static int convertMDLStereoToFlags(int stereo) {
        if (stereo == 1) {
            return 16;
        }
        if (stereo == 6) {
            return 32;
        }
        if (stereo == 4) {
            return 48;
        }
        if (stereo == 3) {
            return 192;
        }
        return 0;
    }

    static int readStereoValue(int flags, String conv, String val) {
        if (conv.equalsIgnoreCase("mdl")) {
            try {
                int v = Integer.parseInt(val);
                v = BondReader.convertMDLStereoToFlags(v);
                if (v == (v & 0x30)) {
                    flags = flags & 0xFFFFFFCF | v;
                } else if (v == (v & 0x1C0)) {
                    flags = flags & 0xFFFFFE3F | v;
                }
            }
            catch (NumberFormatException ex) {}
        } else if (conv.equalsIgnoreCase("ChemAxon")) {
            int v = BondReader.convertChemaxonStereo2ToFlags(val);
            flags = flags & 0xFFFFFC0F | v;
        }
        return flags;
    }

    static int setStereoValue(int flags, String s) throws MolFormatException {
        if (s == null) {
            throw new MolFormatException("empty <bondStereo> element");
        }
        if (s.equals("W")) {
            flags = flags & 0xFFFFFFCF | 0x10;
        } else if (s.equals("H")) {
            flags = flags & 0xFFFFFFCF | 0x20;
        } else if (s.equals("C")) {
            flags = flags & 0xFFFFFFBF | 0x80;
        } else if (s.equals("T")) {
            flags = flags & 0xFFFFFF7F | 0x40;
        }
        return flags;
    }

    static String[] readDbBondStereo(String[] reference, String s) throws MolFormatException {
        if (s == null) {
            throw new MolFormatException("empty <bondStereo> element");
        }
        reference[reference.length - 1] = s;
        return reference;
    }

    public static boolean processBondArrays(Molecule mol, ParsedData parsedData) throws MolFormatException {
        int i;
        List<String> refs1 = parsedData.bondAtomRefs1Array;
        List<String> refs2 = parsedData.bondAtomRefs2Array;
        IntVector flagsv = parsedData.bondFlagsArray;
        List<Object[]> xpropsv = parsedData.bondXPropsArray;
        int nb = refs1.size();
        if (nb == 0) {
            return false;
        }
        if (refs2.size() != nb || flagsv.size() != nb || xpropsv.size() != nb) {
            throw new MolFormatException("Bond arrays must have equal size");
        }
        Map<String, MolAtom> h = parsedData.idAtomHash;
        for (i = 0; i < nb; ++i) {
            int h1;
            int h2;
            String ref1 = refs1.get(i);
            String ref2 = refs2.get(i);
            MolAtom a1 = h.get(ref1);
            MolAtom a2 = h.get(ref2);
            if (a1 == null || a2 == null) {
                throw new MolFormatException("Atom " + (a1 == null ? ref1 : ref2) + " does not exist in bond definition " + ref1 + "-" + ref2);
            }
            int f = flagsv.get(i);
            Object[] xprops = xpropsv.get(i);
            String qprops = (String)xprops[0];
            MolBond b = qprops != null && !qprops.equals("0") ? BondReader.createQueryBond(a1, a2, qprops) : new MolBond(a1, a2, f);
            if (a1.getAtno() == 1 && (h2 = a2.getNonQueryImplicitHcount()) > 0) {
                a2.setNonQueryImplicitHcount(h2 - 1);
            }
            if (a2.getAtno() == 1 && (h1 = a1.getNonQueryImplicitHcount()) > 0) {
                a1.setNonQueryImplicitHcount(h1 - 1);
            }
            mol.add(b);
        }
        for (i = 0; i < nb; ++i) {
            Object[] xprops = xpropsv.get(i);
            if (xprops.length <= 1) continue;
            String[] dbBondStereoProps = (String[])xprops[1];
            MolBond b = mol.getBond(i);
            int f = BondReader.processDbStereo(b, dbBondStereoProps, h);
            b.setFlags(f);
        }
        refs1.clear();
        refs2.clear();
        flagsv.clear();
        xpropsv.clear();
        return true;
    }

    static int processDbStereo(MolBond b, String[] dbBondStereoProps, Map<String, MolAtom> atomHash) {
        int f = b.getFlags();
        if (dbBondStereoProps != null) {
            int stereo;
            String[] refs = dbBondStereoProps;
            int n = refs[4].equals("C") ? 128 : (stereo = refs[4].equals("T") ? 64 : 0);
            if (stereo != 0) {
                MolAtom a1 = atomHash.get(refs[0]);
                MolAtom a4 = atomHash.get(refs[3]);
                int stereoFlag = b.transformCT(a1, a4, stereo);
                f = f & 0xFFFFFE3F | stereoFlag;
            }
        }
        return f;
    }

    public static void processBondCorrespondence(Molecule mol, ParsedData parsedData) throws MolFormatException {
        Map<String, Sgroup> sghash = parsedData.atomSgroupRefHash;
        Map<String, IntVector> bondListHash = parsedData.bondListIdHash;
        Map<String, IntVector> correspondenceHash = parsedData.correspondenceIdHash;
        for (String key : sghash.keySet()) {
            Sgroup sg = sghash.get(key);
            if (!(sg instanceof RepeatingUnitSgroup)) continue;
            RepeatingUnitSgroup srusg = (RepeatingUnitSgroup)sg;
            IntVector crsList = correspondenceHash.get(key);
            IntVector bondList = bondListHash.get(key);
            if (crsList == null || bondList == null) continue;
            if (crsList.size() != 0) {
                srusg.addCrossingBonds(BondReader.convert(crsList, mol), BondReader.convert(bondList, mol));
                continue;
            }
            if (bondList.size() != 4) continue;
            List<MolBond> l = BondReader.convert(bondList, mol);
            MolBond[] head = new MolBond[]{l.get(0), l.get(1)};
            srusg.setHeadCrossingBonds(head);
            MolBond[] tail = new MolBond[]{l.get(2), l.get(3)};
            srusg.setTailCrossingBonds(tail);
        }
    }

    static List<MolBond> convert(IntVector bondList, Molecule mol) throws MolFormatException {
        ArrayList<MolBond> convertedList = new ArrayList<MolBond>();
        int nb = bondList.size();
        try {
            for (int i = 0; i < nb; ++i) {
                int id = bondList.get(i);
                convertedList.add(mol.getBond(id));
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing bond index in input in bond reference list", e);
        }
        return convertedList;
    }

    static MolBond createQueryBond(MolAtom a1, MolAtom a2, String qprops) throws MolFormatException {
        if (qprops.startsWith("str:")) {
            return new QueryBond(a1, a2, qprops.substring(4));
        }
        throw new MolFormatException("Error in bond definition: invalid mrvQueryProps \"" + qprops + "\"");
    }
}

