/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.common.util.IntVector;
import chemaxon.common.util.LongVector;
import chemaxon.common.util.MProgressMonitor;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MHeaderReader;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.MRecordReader;
import chemaxon.marvin.io.PositionedInputStream;
import chemaxon.marvin.io.formats.XmlImport;
import chemaxon.marvin.io.formats.cml.MHeader;
import chemaxon.struc.MPropertyContainer;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class CMLRecordReader
extends XmlImport
implements MRecordReader,
MHeaderReader {
    private static final String REGEX = "^[ \\t]*mrv(Alias|Pseudo|ExtraLabel)=.*";
    private static final Pattern PATTERN = Pattern.compile("^[ \\t]*mrv(Alias|Pseudo|ExtraLabel)=.*");
    private String importOptions;
    private IntVector lineNumberMap;
    private boolean beforeParsing;
    private String rootElement;
    private String rootElementString;
    private boolean inputIsMrv;
    private boolean propertyRecord;
    private int recordCount;
    private MHeader header;
    private String trashstr = null;

    public CMLRecordReader(InputStream istr, String opts) throws IOException, MRecordParseException {
        MolInputStream mis;
        if (istr instanceof MolInputStream) {
            mis = (MolInputStream)istr;
            this.importOptions = null;
        } else {
            String[] fmtopts = MFileFormatUtil.splitFormatAndOptions(opts);
            mis = new MolInputStream(istr, fmtopts[0]);
            this.importOptions = fmtopts[1];
        }
        this.recordCount = 0;
        this.lineNumberMap = new IntVector();
        this.initImport(mis);
        this.beforeParsing = true;
        this.rootElement = null;
        this.rootElementString = null;
        this.inputIsMrv = false;
        this.propertyRecord = false;
        this.initHeader();
    }

    private void initHeader() throws MolFormatException, IOException, MRecordParseException {
        boolean unformated = false;
        String tagname0 = this.readTillNextTag(null, null);
        if (tagname0 == null) {
            throw new MolFormatException("Invalid CML file, starting XML tag not found");
        }
        String line = this.getCurrentLine();
        int column = this.getCurrentTagColumn();
        String s = line.substring(column).trim();
        String firsttag = null;
        String tagname = null;
        if (s.charAt(0) == '<') {
            StringTokenizer stk = new StringTokenizer(s, ">");
            if (stk.countTokens() > 1) {
                unformated = true;
                firsttag = stk.nextToken() + ">";
            } else {
                firsttag = s;
            }
            int x = firsttag.indexOf(32);
            tagname = x > -1 ? firsttag.substring(1, x).toLowerCase() : (firsttag.endsWith("/>") ? firsttag.substring(1, firsttag.lastIndexOf(47)).toLowerCase() : firsttag.substring(1, firsttag.length() - 1));
            if (this.rootElement == null && !CMLRecordReader.isChemicalStructureTag(tagname)) {
                this.rootElement = tagname;
                this.rootElementString = firsttag;
            }
        }
        if (CMLRecordReader.isMDocumentTag(tagname)) {
            this.inputIsMrv = true;
        }
        MRecord rec = null;
        if (!unformated && !CMLRecordReader.isChemicalStructureTag(tagname)) {
            StringBuilder sb = new StringBuilder();
            StringBuilder restLine = new StringBuilder();
            String nt = this.readTillNextTag(sb, restLine);
            this.trashstr = restLine.toString();
            this.putBackLine();
            if (nt.equalsIgnoreCase("MHead") || nt.equalsIgnoreCase("propertyList")) {
                this.inputIsMrv = true;
                rec = this.searchHeader();
            } else if (CMLRecordReader.isMDocumentTag(nt)) {
                this.inputIsMrv = true;
            }
        } else {
            this.putBackLine(column);
        }
        if (rec instanceof MHeader) {
            this.header = (MHeader)rec;
            this.beforeParsing = false;
        }
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private static boolean isChemicalStructureTag(String tagname) {
        return tagname != null && (tagname.equalsIgnoreCase("molecule") || tagname.equalsIgnoreCase("reaction") || tagname.equalsIgnoreCase("MDocument"));
    }

    private static boolean isMDocumentTag(String tagname) {
        return tagname != null && tagname.equalsIgnoreCase("MDocument");
    }

    private MRecord searchHeader() throws MRecordParseException, IOException {
        StringBuilder grabsb = new StringBuilder();
        String xmlhdr = this.getGrabbedHeader();
        if (xmlhdr != null && xmlhdr.length() != 0) {
            grabsb.append(xmlhdr);
            if (xmlhdr.charAt(xmlhdr.length() - 1) != '\n') {
                grabsb.append('\n');
            }
            this.lineNumberMap.add(this.inputStream.getLineCount());
        }
        String s = null;
        ByteArrayOutputStream boutstr = new ByteArrayOutputStream();
        MHeader h = null;
        boolean firstIsRootTag = true;
        int startlineno = 0;
        while (firstIsRootTag && this.rootElement == null || !CMLRecordReader.isChemicalStructureTag(s)) {
            long startpos = this.getCurrentTagFilePos();
            startlineno = this.getLineCount();
            grabsb = new StringBuilder();
            s = this.readNextTag(grabsb);
            if (this.trashstr != null && grabsb.toString().startsWith(this.trashstr)) {
                grabsb.delete(0, this.trashstr.length() - 1);
                this.trashstr = null;
            }
            if (s == null) {
                if (this.rootElement != null) {
                    throw new MRecordParseException(this.getPosition(), "unexpected end of file");
                }
                return null;
            }
            if (CMLRecordReader.isMDocumentTag(s)) {
                this.inputIsMrv = true;
            }
            if (this.isTagClosing()) {
                if (s != null && this.rootElement != null && s.equals(this.rootElement)) {
                    return null;
                }
                throw new MRecordParseException(this.getPosition(), "unexpected </" + s + ">");
            }
            if (firstIsRootTag && this.rootElement == null) {
                if (!CMLRecordReader.isChemicalStructureTag(s)) {
                    this.rootElement = s;
                    this.rootElementString = grabsb.toString();
                    continue;
                }
                firstIsRootTag = false;
                boutstr.write(grabsb.toString().getBytes());
                boutstr.close();
                h = new MHeader(startpos, startpos, startlineno, startlineno, boutstr);
                continue;
            }
            if (!s.equalsIgnoreCase("MHead") && !s.equalsIgnoreCase("propertyList")) continue;
            this.inputIsMrv = true;
            this.skipTag(s, grabsb);
            long endpos = this.getCurrentTagFilePos();
            boutstr.write(grabsb.toString().getBytes());
            h = new MHeader(startpos, endpos, startlineno, this.getLineCount(), boutstr);
            return h;
        }
        if (CMLRecordReader.isChemicalStructureTag(s)) {
            int endlineno = this.getLineCount();
            for (int i = 0; i < endlineno - startlineno; ++i) {
                this.putBackLine();
            }
        }
        return h;
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        int x;
        StringBuilder grabsb = new StringBuilder();
        String xmlhdr = this.getGrabbedHeader();
        int xmlhdrlen = 0;
        if (xmlhdr != null && xmlhdr.length() != 0) {
            grabsb.append(xmlhdr);
            xmlhdrlen = xmlhdr.length();
            if (xmlhdr.charAt(xmlhdrlen - 1) != '\n') {
                grabsb.append('\n');
                ++xmlhdrlen;
            }
            this.lineNumberMap.add(this.inputStream.getLineCount());
        }
        long startpos = this.getCurrentTagFilePos();
        int startlineno = this.getLineCount();
        StringBuilder tsb = new StringBuilder();
        String s = this.readNextTag(tsb);
        if (this.trashstr != null && this.trashstr.length() > 0 && tsb.toString().startsWith(this.trashstr)) {
            tsb.delete(0, this.trashstr.length() - 1);
            this.trashstr = null;
        }
        grabsb.append((CharSequence)tsb);
        if (s == null) {
            if (this.rootElement != null) {
                EOFException ex = new EOFException("unexpected end of file");
                throw new MRecordParseException(this.getPosition(), (Throwable)ex);
            }
            return null;
        }
        if (this.isTagClosing() && !this.getCurrentLine().startsWith("<MDocument/>")) {
            if (s != null && this.rootElement != null && s.equals(this.rootElement)) {
                return null;
            }
            throw new MRecordParseException(this.getPosition(), "unexpected </" + s + ">");
        }
        if (this.recordCount == 0) {
            boolean cml_or_mrv_record = CMLRecordReader.isChemicalStructureTag(s);
            if (cml_or_mrv_record) {
                startpos = this.getCurrentTagFilePos();
            } else {
                if (this.beforeParsing) {
                    this.rootElement = s;
                    this.rootElementString = grabsb.toString().substring(xmlhdrlen);
                }
                grabsb.setLength(xmlhdrlen);
                startpos = this.getCurrentTagFilePos();
                if (s.equals(this.rootElement)) {
                    startpos += (long)(this.rootElementString.length() + 1);
                }
                startlineno = this.getLineCount();
                s = this.readNextTag(skip ? null : grabsb);
                this.beforeParsing = false;
            }
        }
        if (s == null) {
            return null;
        }
        if (this.rootElement != null && s.equals(this.rootElement) && this.isTagClosing() && !this.isTagSingle()) {
            return null;
        }
        if (skip) {
            if (s.equalsIgnoreCase("MDocument")) {
                this.inputIsMrv = true;
                this.propertyRecord = false;
            } else if (s.equalsIgnoreCase("propertyList")) {
                this.propertyRecord = true;
            }
            this.skipTag(s, null);
            long endpos = this.getCurrentTagFilePos();
            return new MRecord(startpos, endpos, startlineno, null, null, null);
        }
        MPropertyContainer props = new MPropertyContainer();
        if (s.equalsIgnoreCase("molecule") || s.equalsIgnoreCase("reaction")) {
            this.readMoleculeOrReaction(s, props, grabsb);
        } else if (s.equalsIgnoreCase("MDocument")) {
            this.inputIsMrv = true;
            this.propertyRecord = false;
            if (!this.getCurrentLine().startsWith("<MDocument/>")) {
                this.readMDocument(props, grabsb);
            }
        } else if (s.equalsIgnoreCase("propertyList")) {
            this.propertyRecord = true;
        } else {
            this.skipTag(s, grabsb);
        }
        long endpos = this.getCurrentTagFilePos();
        int[] map = this.endRecord();
        if (grabsb.length() != 0 && grabsb.charAt(grabsb.length() - 1) != '\n') {
            grabsb.append('\n');
        }
        for (x = xmlhdrlen; x < grabsb.length() && grabsb.charAt(x) == '\n'; ++x) {
        }
        String recString = x < grabsb.length() ? grabsb.substring(x) : grabsb.substring(xmlhdrlen);
        return new MRecord(startpos, endpos, startlineno, recString, props, map);
    }

    @Override
    public String getRecognizedFormat() {
        return this.inputIsMrv ? "mrv" : "cml";
    }

    @Override
    public String getHeaderAsString() {
        StringBuffer sb = new StringBuffer();
        String hdr = this.getGrabbedHeader();
        if (hdr != null) {
            sb.append(CMLRecordReader.closeLine(hdr));
        }
        if (this.rootElementString != null) {
            sb.append(CMLRecordReader.closeLine(this.rootElementString));
            if (this.header != null) {
                String mrvH = this.header.getString();
                if (mrvH != null) {
                    sb.append(CMLRecordReader.closeLine(mrvH));
                }
                if (this.header.getHeaderStream() != null) {
                    sb.append(CMLRecordReader.closeLine(this.header.getHeaderStream().toString()));
                }
            }
        } else {
            sb.append("<cml>\n");
        }
        return sb.toString();
    }

    private static String closeLine(String s) {
        if (s != null && s.length() > 0 && !s.endsWith("\n")) {
            return s + "\n";
        }
        return s;
    }

    @Override
    public String getFooterAsString() {
        return this.rootElement != null ? "</" + this.rootElement + ">\n" : "</cml>\n";
    }

    @Override
    public String getOptions() {
        return this.importOptions;
    }

    private void readMDocument(MPropertyContainer props, StringBuilder grabsb) throws MRecordParseException, IOException {
        String s;
        while ((s = this.readNextTag(grabsb)) != null) {
            if (s.equalsIgnoreCase("MDocument") && this.isTagClosing() && !this.isTagSingle()) {
                return;
            }
            if (this.isTagClosing()) {
                if (this.isTagSingle()) continue;
                throw new MRecordParseException(this.getPosition(), "invalid XML");
            }
            if (s.equalsIgnoreCase("MChemicalStruct")) {
                this.readMChemicalStruct(props, grabsb);
                continue;
            }
            this.skipTag(s, grabsb);
        }
    }

    private void readMChemicalStruct(MPropertyContainer props, StringBuilder grabsb) throws MRecordParseException, IOException {
        String s;
        while ((s = this.readNextTag(grabsb)) != null) {
            if (s.equalsIgnoreCase("MChemicalStruct") && this.isTagClosing() && !this.isTagSingle()) {
                return;
            }
            if (this.isTagClosing()) {
                if (this.isTagSingle()) continue;
                throw new MRecordParseException(this.getPosition(), "invalid XML");
            }
            if (s.equalsIgnoreCase("molecule") || s.equalsIgnoreCase("reaction")) {
                this.readMoleculeOrReaction(s, props, grabsb);
                continue;
            }
            this.skipTag(s, grabsb);
        }
    }

    private void readMoleculeOrReaction(String element, MPropertyContainer props, StringBuilder grabsb) throws MRecordParseException, IOException {
        String s;
        int prevgrablen = grabsb.length();
        while ((s = this.readNextTag(grabsb)) != null) {
            if (s.equalsIgnoreCase(element) && this.isTagClosing() && !this.isTagSingle()) {
                return;
            }
            if (this.isTagClosing()) {
                if (!this.isTagSingle()) {
                    throw new MRecordParseException(this.getPosition(), "invalid XML");
                }
            } else if (s.equalsIgnoreCase("propertyList") && !this.isTagSingle()) {
                grabsb.setLength(prevgrablen);
                this.readPropertyList(props);
            } else {
                this.skipTag(s, grabsb);
            }
            prevgrablen = grabsb.length();
        }
    }

    protected void readPropertyList(MPropertyContainer props) throws MRecordParseException, IOException {
        String s;
        while ((s = this.readNextTag(null)) != null) {
            if (s.equalsIgnoreCase("property")) {
                if (this.isTagClosing()) continue;
                this.readProperty(s, props);
                continue;
            }
            if (s.equalsIgnoreCase("propertyList") && this.isTagClosing() && !this.isTagSingle()) {
                return;
            }
            if (this.isTagClosing()) continue;
            this.skipTag(s, null);
        }
    }

    private void readProperty(String s, MPropertyContainer props) throws MRecordParseException, IOException {
        String key = this.getTagProperty("dictRef");
        if (key == null) {
            key = this.getTagProperty("title");
        }
        int plevel = 1;
        int slevel = 0;
        while ((s = this.readNextTag(null)) != null) {
            if (s.equalsIgnoreCase("property")) {
                if (this.isTagClosing()) {
                    if (--plevel != 0) continue;
                    return;
                }
                ++plevel;
                continue;
            }
            if (s.equalsIgnoreCase("scalar")) {
                if (this.isTagClosing()) {
                    --slevel;
                    continue;
                }
                if (++slevel != 1) continue;
                String v = this.readData(null);
                String xsdtype = this.getTagProperty("dataType");
                if (key == null) continue;
                props.set(key, MPropHandler.stringToScalar(xsdtype, v));
                continue;
            }
            if (!s.equalsIgnoreCase("array")) continue;
            if (this.isTagClosing()) {
                --slevel;
                continue;
            }
            if (++slevel != 1) continue;
            String xsdtype = this.getTagProperty("dataType");
            String delim = this.getTagProperty("delimiter");
            char delimc = delim != null && delim.length() != 0 ? (char)delim.charAt(0) : (char)' ';
            Integer sizeo = this.getTagPropertyAsInteger("size");
            int size = sizeo != null ? sizeo : -1;
            StringBuffer sb = new StringBuffer();
            String v = this.readData(null);
            while (v.length() != 0) {
                if (sb.length() != 0) {
                    sb.append(delimc);
                }
                sb.append(v);
                v = this.readData(null);
            }
            if (key == null) continue;
            props.set(key, MPropHandler.stringToArray(xsdtype, sb.toString(), size, delim != null ? (int)delim.charAt(0) : -1));
        }
    }

    @Override
    public void close() {
        PositionedInputStream is = this.inputStream;
        if (this.inputStream != null) {
            try {
                is.close();
            }
            catch (IOException ex) {
                this.inputStream = null;
            }
        }
    }

    @Override
    public MRecordReader getEncapsulatedReader() {
        return null;
    }

    @Override
    public MolInputStream getMolInputStream() {
        return (MolInputStream)this.inputStream;
    }

    @Override
    public boolean isSeekable() {
        return this.inputStream.isSeekable();
    }

    @Override
    public long getFilePointer() {
        return this.getCurrentTagFilePos();
    }

    @Override
    public int getLineCount() {
        return this.inputStream.getLineCount();
    }

    @Override
    public void seek(long p, int lcount, int k) throws IOException {
        this.inputStream.seek(p, lcount);
        this.recordCount = k;
    }

    @Override
    public boolean isPropertyRecord() {
        return this.propertyRecord;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    private MRecordReader.Position getPosition() {
        return new MRecordReader.Position(this.recordCount + 1, this.inputStream.getLineCount());
    }

    @Override
    protected String readLine() throws IOException {
        if (this.inputStream != null) {
            String s = super.readLine();
            if (s != null && PATTERN.matcher(s).matches()) {
                s = s.replaceAll("&#32;", "\\\\u0020");
                s = s.replaceAll("&#46;", "\\\\u002e");
                s = s.replaceAll("&#48;", "\\\\u0030");
            }
            return s;
        }
        return null;
    }

    protected int[] endRecord() {
        int n = this.lineNumberMap.size();
        int[] map = new int[n + 1];
        map[0] = 0;
        for (int i = 0; i < n; ++i) {
            map[i + 1] = this.lineNumberMap.get(i);
        }
        this.lineNumberMap.clear();
        ++this.recordCount;
        return map;
    }

    @Override
    public LongVector detectRecordPositions(IntVector linenums) throws MolFormatException {
        LongVector positions = new LongVector();
        try {
            String entityName;
            if (CMLRecordReader.isChemicalStructureTag(this.rootElement)) {
                entityName = this.rootElement;
            } else {
                if (this.header != null && this.isSeekable()) {
                    this.seek(this.header.getEndPosition(), this.header.getEndLineCount(), 0);
                }
                String t = null;
                while (!CMLRecordReader.isChemicalStructureTag(t)) {
                    t = this.readNextTag(null);
                }
                entityName = t;
            }
            String s = entityName;
            long endpos = -1L;
            while (s != null && !this.isTagClosing()) {
                long startpos = this.getCurrentTagFilePos();
                int startlineno = this.getLineCount();
                try {
                    this.skipTag(s, null);
                }
                catch (MolFormatException mfex) {
                    mfex.printStackTrace();
                }
                long endlineno = this.getLineCount();
                endpos = this.getCurrentTagFilePos() - 1L;
                boolean store = false;
                if (s.equals(entityName) && (positions.size() == 0 || positions.get(positions.size() - 2) != startpos)) {
                    store = true;
                }
                s = this.readNextTag(null);
                if (!store) continue;
                long nextlineno = this.getLineCount();
                if (endlineno == nextlineno) {
                    ++endpos;
                }
                positions.add(startpos);
                positions.add(endpos);
                if (linenums == null) continue;
                linenums.add(startlineno);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return positions;
    }

    @Override
    public String getXmlDeclarationHeader() {
        return this.getGrabbedHeader();
    }

    @Override
    public String getRootElement() {
        return this.rootElement;
    }

    @Override
    public MPropertyContainer getMarvinProperties() {
        MPropertyContainer mpc;
        if (this.header != null && (mpc = this.header.getPropertyContainer()) != null && mpc.size() > 0) {
            return mpc;
        }
        return null;
    }
}

