/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.formats.cml.MrvReservedWords;
import chemaxon.struc.MPropertyContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class MHeader
extends MRecord
implements MrvReservedWords {
    private int endlineno = 0;
    private ByteArrayOutputStream headerStream = null;

    public MHeader(long start, long end, int lineno, int endlineno, ByteArrayOutputStream stream) {
        super(start, end, lineno, null, null, null);
        this.endlineno = endlineno;
        this.headerStream = stream;
    }

    public ByteArrayOutputStream getHeaderStream() {
        return this.headerStream;
    }

    @Override
    public int getEndLineCount() {
        return this.endlineno;
    }

    @Override
    public MPropertyContainer getPropertyContainer() {
        if (this.properties != null) {
            return (MPropertyContainer)this.properties.clone();
        }
        this.properties = new MPropertyContainer();
        DocumentBuilderFactory docBuildFactory = DocumentBuilderFactory.newInstance();
        Document xmldoc = null;
        try {
            DocumentBuilder builder = docBuildFactory.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(this.headerStream.toByteArray());
            xmldoc = builder.parse(bis);
            this.readMarvinHead(xmldoc.getDocumentElement(), this.properties);
        }
        catch (ParserConfigurationException pcex) {
            pcex.printStackTrace();
        }
        catch (SAXException saxex) {
            saxex.printStackTrace();
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        return (MPropertyContainer)this.properties.clone();
    }

    private void readMarvinHead(Element e, MPropertyContainer props) throws SAXException {
        if (!e.getTagName().equalsIgnoreCase("MHead")) {
            System.err.println("Missing \"MHead\" tag.");
            return;
        }
        NodeList nodes = e.getElementsByTagName("MarvinGUI");
        if (nodes.getLength() != 0) {
            this.readMarvinGUI(nodes.item(0), props);
            return;
        }
    }

    private void readMarvinGUI(Node nd, MPropertyContainer props) throws SAXException {
        NodeList nodes = nd.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            String s;
            Node item = nodes.item(i);
            if (item.getNodeType() != 1 || !(s = item.getNodeName()).equalsIgnoreCase("mprop")) continue;
            this.readMProp(item, props);
        }
    }

    private void readMProp(Node nd, MPropertyContainer props) throws SAXException {
        NamedNodeMap attrmap = nd.getAttributes();
        Node attr = attrmap.getNamedItem("name");
        if (attr == null) {
            throw new SAXException("Missing \"name\" attribute in \"mprop\" tag.");
        }
        String key = attr.getNodeValue();
        attr = attrmap.getNamedItem("dataType");
        String xdtype = null;
        if (attr != null) {
            xdtype = attr.getNodeValue();
        }
        attr = attrmap.getNamedItem("value");
        String value = null;
        if (attr == null) {
            throw new SAXException("Missing \"value\" attribute in \"mprop\" tag.");
        }
        value = attr.getNodeValue();
        if (value == null) {
            value = "";
        }
        try {
            props.set(key, MPropHandler.stringToScalar(xdtype, value));
        }
        catch (IOException ex) {
            throw new SAXException("Cannot convert \"" + value + "\" to " + xdtype + " type.");
        }
    }
}

