/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.common.util.ColorParser;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.cml.CMLExport;
import chemaxon.marvin.io.formats.cml.MrvReservedWords;
import chemaxon.marvin.modules.ResidueInfo;
import chemaxon.marvin.util.AttachmentConverter;
import chemaxon.marvin.util.OptionDescriptor;
import chemaxon.marvin.util.text.LocaleUtil;
import chemaxon.struc.BicycloStereoDescriptor;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MPoint;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.QueryBond;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.graphics.MAtomSetPoint;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlowBasePoint;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MMidPoint;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.graphics.MRArrow;
import chemaxon.struc.graphics.MRectanglePoint;
import chemaxon.struc.prop.MBooleanProp;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;

public class MrvExport
extends CMLExport
implements MrvReservedWords {
    private static String MRV_FILE_FORMAT_VERSION = "5.9.0";
    protected MPropertyContainer globalGUIProperties;
    private boolean exportSelection = false;

    public MrvExport() throws MolExportException {
        this.theFormat = "mrv";
        this.fileFormatVersion = MRV_FILE_FORMAT_VERSION;
    }

    public static String getFileFormatVersion() {
        return MRV_FILE_FORMAT_VERSION;
    }

    public boolean isExportSelection() {
        return this.exportSelection;
    }

    public void setExportSelection(boolean exportSelection) {
        this.exportSelection = exportSelection;
    }

    @Override
    protected void getOptionDescriptors(String fmtname, String optnames, List<OptionDescriptor> l) {
        super.getOptionDescriptors("cml", "a_gen a_bas -a H -H P C{1-9}", l);
        ResourceBundle rc = LocaleUtil.getResourceBundle(MrvExport.class.getName(), null);
        MrvExport.getOptionDescriptors(rc, fmtname, optnames, l);
    }

    @Override
    protected void writeFormatSpecificAttributes() throws XMLStreamException {
    }

    @Override
    public Object open(String fmtopts) throws MolExportException {
        String result = (String)super.open(fmtopts);
        this.useAtomArray = true;
        if (this.guiPropertiesToBeSaved()) {
            try {
                this.doSaveProperties();
                this.writeNewLineToStream();
            }
            catch (XMLStreamException e) {
                throw new MolExportException(e);
            }
        }
        return result + this.printToString();
    }

    @Override
    protected String modifyPropertyKeyCallback(String key) {
        return key;
    }

    private void doSaveProperties() throws XMLStreamException, MolExportException {
        this.xmlStreamWriter.writeStartElement("MHead");
        this.appendGlobalPropertyList(this.globalGUIProperties, "marvin");
        this.xmlStreamWriter.writeEndElement();
    }

    protected void appendGlobalPropertyList(MPropertyContainer props, String dictName) throws XMLStreamException, MolExportException {
        int nprop = props.size();
        if (nprop != 0) {
            this.xmlStreamWriter.writeStartElement("MarvinGUI");
            for (int i = 0; i < nprop; ++i) {
                String key = props.getKey(i);
                MProp val = props.get(key);
                if (!props.isValid(val)) continue;
                this.xmlStreamWriter.writeStartElement("mprop");
                this.xmlStreamWriter.writeAttribute("name", key);
                String xsdtype = val.getPropXSDType();
                if (!xsdtype.equalsIgnoreCase("string")) {
                    this.xmlStreamWriter.writeAttribute("dataType", "xsd:" + xsdtype);
                }
                this.xmlStreamWriter.writeAttribute("value", this.propertyToString(val, props));
                this.xmlStreamWriter.writeEndElement();
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private boolean guiPropertiesToBeSaved() {
        MBooleanProp doSave;
        boolean saveProps = false;
        if (this.globalGUIProperties != null && (doSave = (MBooleanProp)this.globalGUIProperties.get("saveproperties")) != null) {
            saveProps = doSave.booleanValue();
        }
        return saveProps;
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        mol = mol.cloneMoleculeWithDocument();
        MPropertyContainer props = mol.properties();
        boolean hierarchic = props.isHierarchic();
        boolean guicontracted = mol.isGUIContracted();
        if (hierarchic) {
            props.flatten();
        }
        boolean isValenceCheckOn = mol.isValenceCheckEnabled();
        mol.setValenceCheckEnabled(false);
        mol.sortSgroupXBonds();
        mol.setValenceCheckEnabled(isValenceCheckOn);
        if (!guicontracted) {
            mol.setGUIContracted(true);
        }
        try {
            this.convert0(mol);
        }
        catch (XMLStreamException e) {
            throw new MolExportException(e);
        }
        finally {
            if (!guicontracted) {
                mol.setGUIContracted(false);
            }
            if (hierarchic) {
                props.hierarchize();
            }
        }
        this.writeNewLineToStream();
        return this.printToString();
    }

    private void convert0(Molecule mol) throws MolExportException, XMLStreamException {
        MDocument doc = mol.getDocument();
        this.xmlStreamWriter.writeStartElement("MDocument");
        if (doc == null) {
            this.appendChemicalStruct(mol);
        } else {
            this.writeSetPaletteAttrs(doc);
            this.writePageSettingsAttrs(doc);
            this.appendPropertyList(doc.properties());
            for (int i = 0; i < doc.getObjectCount(); ++i) {
                MObject o = doc.getObject(i);
                if (o instanceof MChemicalStruct) {
                    MChemicalStruct mo = (MChemicalStruct)o;
                    Molecule m = (Molecule)mo.getMoleculeGraph();
                    if (m.isEmpty() && m.getPropertyCount() == 0 && m.getName().isEmpty()) continue;
                    this.appendChemicalStruct(m);
                    continue;
                }
                if (o instanceof MMoleculeMovie) {
                    MMoleculeMovie mmm = (MMoleculeMovie)o;
                    this.appendMoleculeMovie(mmm);
                    continue;
                }
                this.appendMObject(doc, o, i);
            }
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void appendMObject(MDocument doc, MObject o, int index) throws XMLStreamException, MolExportException {
        String s = o.getClass().getName();
        ArrayList<String> attrs = new ArrayList<String>();
        if (s.startsWith("chemaxon.struc.graphics.")) {
            s = s.substring("chemaxon.struc.graphics.".length());
        }
        this.xmlStreamWriter.writeStartElement(s);
        if (index != -1) {
            this.xmlStreamWriter.writeAttribute("id", "o" + (index + 1));
        }
        attrs.clear();
        o.addAttributeKeys(attrs);
        for (int j = 0; j < attrs.size(); ++j) {
            String key = (String)attrs.get(j);
            String v = o.getAttribute(key);
            if (key.equals("isSelected") && !this.exportSelection || v == null) continue;
            this.xmlStreamWriter.writeAttribute(key, v);
        }
        attrs.clear();
        o.addCdataAttributeKeys(attrs);
        int nc = attrs.size();
        int np = o.getPointCount();
        if (np == 0 && nc == 0) {
            this.xmlStreamWriter.writeEndElement();
        } else {
            int j;
            for (j = 0; j < nc; ++j) {
                String key = (String)attrs.get(j);
                String v = o.getAttribute(key);
                this.xmlStreamWriter.writeStartElement("Field");
                this.xmlStreamWriter.writeAttribute("name", key);
                this.writeData(v);
                this.xmlStreamWriter.writeEndElement();
            }
            for (j = 0; j < np; ++j) {
                MPoint p = o.getPoint(j);
                this.appendPoint(p, doc);
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    @Override
    public boolean isDocumentExport() {
        return true;
    }

    private int[] findMolAtomIds(MDocument doc, MolAtom a, String errtail) throws MolExportException {
        MoleculeGraph ma = a.getParent();
        if (ma == null) {
            throw new MolExportException("atom without parent: " + a);
        }
        int molcount = 0;
        int molId = -1;
        int atomId = ma.indexOf(a);
        for (int j = 0; j < doc.getObjectCount(); ++j) {
            MObject mo = doc.getObject(j);
            if (!(mo instanceof MChemicalStruct)) continue;
            MChemicalStruct mcs = (MChemicalStruct)mo;
            MoleculeGraph m = mcs.getMoleculeGraph();
            if (!mcs.containsAtom(a)) continue;
            int k = MrvExport.getMoleculeId(m, ma);
            molId = molcount + k;
            break;
        }
        if (atomId < 0 || molId < 0) {
            throw new MolExportException("document does not contain " + a + " " + errtail);
        }
        return new int[]{molId, atomId};
    }

    private static int countMolecules(MoleculeGraph main) {
        int count = 0;
        RxnMolecule rxn = (RxnMolecule)main;
        for (int i = 0; i < REACTION_LIST_IDS.length; ++i) {
            int f = REACTION_LIST_IDS[i];
            count += rxn.getComponentCount(f);
        }
        return count;
    }

    private static int getMoleculeId(MoleculeGraph main, MoleculeGraph m) {
        int count = 0;
        if (main instanceof RxnMolecule) {
            RxnMolecule rxn = (RxnMolecule)main;
            for (int i = 0; i < REACTION_LIST_IDS.length; ++i) {
                int f = REACTION_LIST_IDS[i];
                int n = rxn.getComponentCount(f);
                for (int j = 0; j < n; ++j) {
                    Molecule mj = rxn.getComponent(f, j);
                    if (mj == m) {
                        return count;
                    }
                    ++count;
                }
            }
        } else if (main instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)main;
            Molecule root = rgmol.getRoot();
            if (root == m) {
                return count;
            }
            if (root instanceof RxnMolecule) {
                RxnMolecule rxn = (RxnMolecule)root;
                int i = MrvExport.getMoleculeId(root, m);
                if (i >= 0) {
                    return i;
                }
                count += MrvExport.countMolecules(rxn);
            } else {
                ++count;
            }
            for (int i = 0; i < rgmol.getRgroupCount(); ++i) {
                for (int j = 0; j < rgmol.getRgroupMemberCount(i); ++j) {
                    Molecule rg = rgmol.getRgroupMember(i, j);
                    if (rg == m) {
                        return count;
                    }
                    ++count;
                }
            }
        } else {
            return 0;
        }
        return -1;
    }

    private void appendPoint(MPoint p, MDocument doc) throws XMLStreamException, MolExportException {
        if (p instanceof MAtomSetPoint) {
            MAtomSetPoint acp = (MAtomSetPoint)p;
            MolAtom[] atoms = acp.getAtoms();
            double[] weights = acp.getWeights();
            this.xmlStreamWriter.writeStartElement("MAtomSetPoint");
            StringBuilder atomSbuf = new StringBuilder();
            for (int i = 0; i < atoms.length; ++i) {
                MolAtom a = atoms[i];
                if (i > 0) {
                    atomSbuf.append(' ');
                }
                int[] ids = this.findMolAtomIds(doc, a, "(" + i + ") in MAtomSetPoint");
                atomSbuf.append('m');
                atomSbuf.append(ids[0] + 1);
                atomSbuf.append(".a");
                atomSbuf.append(ids[1] + 1);
            }
            this.xmlStreamWriter.writeAttribute("atomRefs", atomSbuf.toString());
            this.appendWeights(weights);
            this.xmlStreamWriter.writeEndElement();
        } else if (p instanceof MMidPoint.Sticky && doc.indexOf(((MMidPoint)p).getParentLine()) > 0) {
            MMidPoint mp = (MMidPoint)p;
            this.xmlStreamWriter.writeStartElement("MMidPoint");
            int pos = mp.getPositionInPolyline();
            if (pos != 0) {
                this.xmlStreamWriter.writeAttribute("pos", String.valueOf(pos));
            }
            int index = doc.indexOf(mp.getParentLine());
            this.xmlStreamWriter.writeAttribute("lineRef", "o" + (index + 1));
            this.xmlStreamWriter.writeEndElement();
        } else if (p instanceof MRectanglePoint.Sticky && doc.indexOf(((MRectanglePoint)p).getParentRect()) > 0) {
            MRectanglePoint rp = (MRectanglePoint)p;
            this.xmlStreamWriter.writeStartElement("MRectanglePoint");
            this.xmlStreamWriter.writeAttribute("pos", String.valueOf(rp.getPositionInRect()));
            int index = doc.indexOf(rp.getParentRect());
            this.xmlStreamWriter.writeAttribute("rectRef", "o" + (index + 1));
            this.xmlStreamWriter.writeEndElement();
        } else if (p instanceof MEFlowBasePoint) {
            MEFlowBasePoint mp = (MEFlowBasePoint)p;
            this.xmlStreamWriter.writeStartElement("MEFlowBasePoint");
            StringBuilder atomSbuf = new StringBuilder();
            int[] ids = this.findMolAtomIds(doc, mp.getAtom(), "in MEFlowBasePoint");
            atomSbuf.append('m');
            atomSbuf.append(ids[0] + 1);
            atomSbuf.append(".a");
            atomSbuf.append(ids[1] + 1);
            this.xmlStreamWriter.writeAttribute("atomRef", atomSbuf.toString());
            this.xmlStreamWriter.writeEndElement();
        } else {
            this.xmlStreamWriter.writeStartElement("MPoint");
            DPoint3 q = p.getLocation();
            this.xmlStreamWriter.writeAttribute("x", this.truncateNumber(q.x));
            this.xmlStreamWriter.writeAttribute("y", this.truncateNumber(q.y));
            if (q.z != 0.0) {
                this.xmlStreamWriter.writeAttribute("z", this.truncateNumber(q.z));
            }
            this.xmlStreamWriter.writeEndElement();
        }
    }

    private void appendWeights(double[] weights) throws XMLStreamException {
        if (weights != null) {
            String value = "";
            for (int i = 0; i < weights.length; ++i) {
                value = value.concat(Double.toString(weights[i]));
                if (i == weights.length - 1) continue;
                value = value.concat(" ");
            }
            this.xmlStreamWriter.writeAttribute("weights", value);
        }
    }

    private void appendMoleculeMovie(MMoleculeMovie mmm) throws XMLStreamException, MolExportException {
        this.xmlStreamWriter.writeStartElement("MMoleculeMovie");
        for (int i = 0; i < mmm.getMoleculeCount(); ++i) {
            this.appendChemicalStruct(mmm.getMolecule(i));
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void writePageSettingsAttrs(MDocument doc) throws XMLStreamException {
        PageSettings ps = doc.getPageSettings();
        if (ps != null && ps.isEnabled()) {
            this.xmlStreamWriter.writeAttribute("multipageEnabled", String.valueOf(ps.isEnabled()));
            this.xmlStreamWriter.writeAttribute("multipageSelectedPage", String.valueOf(ps.getSelectedPage() + 1));
            this.xmlStreamWriter.writeAttribute("multipageColumnCount", String.valueOf(ps.getColumnCount()));
            this.xmlStreamWriter.writeAttribute("multipageRowCount", String.valueOf(ps.getRowCount()));
            this.xmlStreamWriter.writeAttribute("multipageWidth", String.valueOf(ps.getWidth()));
            this.xmlStreamWriter.writeAttribute("multipageHeight", String.valueOf(ps.getHeight()));
            this.xmlStreamWriter.writeAttribute("multipageLeft", String.valueOf(ps.getLeftMargin()));
            this.xmlStreamWriter.writeAttribute("multipageRight", String.valueOf(ps.getRightMargin()));
            this.xmlStreamWriter.writeAttribute("multipageTop", String.valueOf(ps.getTopMargin()));
            this.xmlStreamWriter.writeAttribute("multipageBottom", String.valueOf(ps.getBottomMargin()));
        }
    }

    private static String makeColorString(int i, int rgb) {
        return String.valueOf(i) + ":" + ColorParser.toString(rgb);
    }

    private static String makeColorString(int i, long rgbs) {
        int rgb1 = MolAtom.getExtraLabelColor(rgbs, 0);
        int rgb2 = MolAtom.getExtraLabelColor(rgbs, 1);
        String res = String.valueOf(i) + ":" + ColorParser.toString(rgb1);
        if (rgb2 != 0) {
            res = res + "|" + ColorParser.toString(rgb2);
        }
        return res;
    }

    private static String makeFontString(int i, MFont f) {
        String s = String.valueOf(i) + ":" + f.getFamily() + "-";
        int style = f.getStyle();
        String st = "";
        if (style >= 0 && style <= 3) {
            st = style == 0 ? "PLAIN" : (style == 1 ? "BOLD" : (style == 2 ? "ITALIC" : "BOLDITALIC"));
        }
        s = s + st + "-" + (int)f.getSizeDouble();
        return s;
    }

    private boolean[] findExtraLabelSets(MoleculeGraph m, boolean[] els) {
        MoleculeGraph u = m.getGraphUnion();
        for (int i = 0; i < u.getAtomCount(); ++i) {
            int seq = u.getAtom(i).getExtraLabelSetSeq();
            if (els == null) {
                els = new boolean[64];
            }
            els[seq] = true;
        }
        return els;
    }

    private boolean[][] findAtomAndBondSets(MoleculeGraph m, boolean[] atomsets, boolean[] bondsets) {
        int seq;
        int j;
        MoleculeGraph u = m.getGraphUnion();
        for (j = 0; j < u.getAtomCount(); ++j) {
            seq = u.getAtom(j).getSetSeq();
            if (atomsets == null) {
                atomsets = new boolean[64];
            }
            atomsets[seq] = true;
        }
        for (j = 0; j < u.getBondCount(); ++j) {
            seq = u.getBond(j).getSetSeq();
            if (bondsets == null) {
                bondsets = new boolean[64];
            }
            bondsets[seq] = true;
        }
        boolean[][] res = new boolean[][]{atomsets, bondsets};
        return res;
    }

    private void writeSetPaletteAttrs(MDocument doc) throws XMLStreamException {
        int cmode;
        StringBuilder sbf;
        boolean[] atomsets = null;
        boolean[] bondsets = null;
        boolean[] extraLabelSets = null;
        for (int i = 0; i < doc.getObjectCount(); ++i) {
            MObject mo = doc.getObject(i);
            if (mo instanceof MChemicalStruct) {
                MoleculeGraph m = ((MChemicalStruct)mo).getMoleculeGraph();
                if (!m.hasAtomSet() && !m.hasBondSet() && !m.hasExtraLabelSet()) continue;
                if (m.hasAtomSet() || m.hasBondSet()) {
                    boolean[][] s = this.findAtomAndBondSets(m, atomsets, bondsets);
                    atomsets = s[0];
                    bondsets = s[1];
                }
                if (!m.hasExtraLabelSet()) continue;
                extraLabelSets = this.findExtraLabelSets(m, extraLabelSets);
                continue;
            }
            if (!(mo instanceof MMoleculeMovie)) continue;
            MMoleculeMovie mmm = (MMoleculeMovie)mo;
            for (int j = 0; j < mmm.getMoleculeCount(); ++j) {
                Molecule m = mmm.getMolecule(j);
                if (!m.hasAtomSet() && !m.hasBondSet() && !m.hasExtraLabelSet()) continue;
                if (m.hasAtomSet() || m.hasBondSet()) {
                    boolean[][] s = this.findAtomAndBondSets(m, atomsets, bondsets);
                    atomsets = s[0];
                    bondsets = s[1];
                }
                if (!m.hasExtraLabelSet()) continue;
                extraLabelSets = this.findExtraLabelSets(m, extraLabelSets);
            }
        }
        if (atomsets != null || doc.getAtomSetColorMode(0) == 1 || doc.getAtomSetFont(0) != null) {
            StringBuilder sb1 = new StringBuilder();
            sbf = new StringBuilder();
            if (atomsets != null) {
                boolean first = true;
                boolean firstf = true;
                for (int i = 0; i < atomsets.length; ++i) {
                    if (atomsets[i] == false) continue;
                    int rgb = doc.getAtomSetRGB(i);
                    cmode = doc.getAtomSetColorMode(i);
                    MFont f = doc.getAtomSetFont(i);
                    if (!first) {
                        sb1.append(',');
                    }
                    first = false;
                    if (cmode == 1) {
                        sb1.append(MrvExport.makeColorString(i, rgb));
                    } else if (cmode == 0) {
                        sb1.append(String.valueOf(i));
                        sb1.append(":D");
                    } else if (cmode == 2) {
                        sb1.append(String.valueOf(i));
                        sb1.append(":N");
                    }
                    if (!firstf) {
                        sbf.append(',');
                    }
                    if (f == null) continue;
                    sbf.append(MrvExport.makeFontString(i, f));
                    firstf = false;
                }
            } else {
                int cmode2 = doc.getAtomSetColorMode(0);
                int rgb = doc.getAtomSetRGB(0);
                MFont f = doc.getAtomSetFont(0);
                if (cmode2 == 1) {
                    sb1.append(MrvExport.makeColorString(0, rgb));
                }
                if (f != null) {
                    sbf.append(MrvExport.makeFontString(0, f));
                }
            }
            if (sb1.length() > 0) {
                this.xmlStreamWriter.writeAttribute("atomSetRGB", sb1.toString());
            }
            if (sbf.length() > 0) {
                this.xmlStreamWriter.writeAttribute("atomSetFont", sbf.toString());
            }
        }
        if (bondsets != null || doc.getBondSetColorMode(0) == 1 || doc.getBondSetThickness(0) != 0.0) {
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sbt = new StringBuilder();
            if (bondsets != null) {
                boolean first = true;
                boolean firstt = true;
                for (int i = 0; i < bondsets.length; ++i) {
                    if (!bondsets[i]) continue;
                    int rgb = doc.getBondSetRGB(i);
                    cmode = doc.getBondSetColorMode(i);
                    double thickness = doc.getBondSetThickness(i);
                    if (!first) {
                        sb1.append(',');
                    }
                    first = false;
                    if (cmode == 1) {
                        sb1.append(MrvExport.makeColorString(i, rgb));
                    } else {
                        sb1.append(String.valueOf(i));
                        sb1.append(":N");
                    }
                    if (!(thickness > 0.0)) continue;
                    if (!firstt) {
                        sbt.append(',');
                    }
                    sbt.append(String.valueOf(i));
                    sbt.append(':');
                    sbt.append(thickness);
                    firstt = false;
                }
            } else {
                int cmode3 = doc.getBondSetColorMode(0);
                int rgb = doc.getBondSetRGB(0);
                double thickness = doc.getBondSetThickness(0);
                if (cmode3 == 1) {
                    sb1.append(MrvExport.makeColorString(0, rgb));
                }
                if (thickness > 0.0) {
                    sbt.append(String.valueOf(0));
                    sbt.append(':');
                    sbt.append(thickness);
                }
            }
            if (sb1.length() > 0) {
                this.xmlStreamWriter.writeAttribute("bondSetRGB", sb1.toString());
            }
            if (sbt.length() > 0) {
                this.xmlStreamWriter.writeAttribute("bondSetLineThickness", sbt.toString());
            }
        }
        if (extraLabelSets != null || doc.getExtraLabelSetColorMode(0) == 1 || doc.getExtraLabelSetFont(0) == null) {
            StringBuilder sb1 = new StringBuilder();
            sbf = new StringBuilder();
            if (extraLabelSets != null) {
                boolean first = true;
                boolean firstf = true;
                for (int i = 0; i < extraLabelSets.length; ++i) {
                    if (!extraLabelSets[i]) continue;
                    long rgb = doc.getExtraLabelSetRGBs(i);
                    int cmode4 = doc.getExtraLabelSetColorMode(i);
                    MFont f = doc.getExtraLabelSetFont(i);
                    if (!first) {
                        sb1.append(',');
                    }
                    first = false;
                    if (cmode4 == 1) {
                        sb1.append(MrvExport.makeColorString(i, rgb));
                    } else if (cmode4 == 0 || rgb == 0L) {
                        sb1.append(String.valueOf(i));
                        sb1.append(":D");
                    } else if (cmode4 == 2) {
                        sb1.append(String.valueOf(i));
                        sb1.append(":N");
                    }
                    if (!firstf) {
                        sbf.append(',');
                    }
                    if (f == null) continue;
                    sbf.append(MrvExport.makeFontString(i, f));
                    firstf = false;
                }
            } else {
                int cmode5 = doc.getExtraLabelSetColorMode(0);
                long rgb = doc.getExtraLabelSetRGBs(0);
                MFont f = doc.getExtraLabelSetFont(0);
                if (cmode5 == 1) {
                    sb1.append(MrvExport.makeColorString(0, rgb));
                }
                if (f != null) {
                    sbf.append(MrvExport.makeFontString(0, f));
                }
            }
            if (sb1.length() > 0 && !sb1.toString().equals("0:D")) {
                this.xmlStreamWriter.writeAttribute("extraLabelSetRGB", sb1.toString());
            }
            if (sbf.length() > 0) {
                this.xmlStreamWriter.writeAttribute("extraLabelSetFont", sbf.toString());
            }
        }
    }

    private void appendChemicalStruct(Molecule mol) throws XMLStreamException, MolExportException {
        this.xmlStreamWriter.writeStartElement("MChemicalStruct");
        this.appendMolecule(mol);
        if (mol instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)mol;
            for (int i = 0; i < rgmol.getRgroupCount(); ++i) {
                String range;
                int k = rgmol.getRgroupId(i);
                this.xmlStreamWriter.writeStartElement("Rgroup");
                this.xmlStreamWriter.writeAttribute("rgroupID", String.valueOf(k));
                int f = rgmol.getRlogic(i);
                if ((f & 0x8000) != 0) {
                    int thenR = f >> 16 & Short.MAX_VALUE;
                    this.xmlStreamWriter.writeAttribute("thenR", String.valueOf(thenR));
                }
                if ((f & Integer.MIN_VALUE) != 0) {
                    this.xmlStreamWriter.writeAttribute("restH", "on");
                }
                if (!(range = rgmol.getRlogicRange(i)).equals("") && !range.equals(">0")) {
                    this.xmlStreamWriter.writeAttribute("rlogicRange", range);
                }
                int n = rgmol.getRgroupMemberCount(i);
                for (int j = 0; j < n; ++j) {
                    Molecule m = rgmol.getRgroupMember(i, j);
                    this.appendMolecule(m);
                }
                this.xmlStreamWriter.writeEndElement();
            }
        }
        this.xmlStreamWriter.writeEndElement();
    }

    @Override
    protected void extendReactionTag(RxnMolecule rxn) throws XMLStreamException {
        this.writeAbsStereo(rxn);
    }

    private void writeAbsStereo(Molecule mol) throws XMLStreamException {
        if (mol.isAbsStereo()) {
            this.xmlStreamWriter.writeAttribute("absStereo", "true");
        }
    }

    @Override
    protected void reactionListExtension(RxnMolecule rxn, int sCount) throws XMLStreamException, MolExportException {
        this.xmlStreamWriter.writeStartElement("agentList");
        for (int j = 0; j < sCount; ++j) {
            Molecule m = rxn.getComponent(2, j);
            this.appendMolecule0(m, m.properties());
        }
        this.xmlStreamWriter.writeEndElement();
    }

    @Override
    protected void extendMoleculeTag(Molecule mol) throws XMLStreamException {
        this.writeAbsStereo(mol);
    }

    @Override
    protected void sgroupExtension(Molecule mol, HashMap<MolAtom, String> atomHash) throws XMLStreamException, MolExportException {
        for (int i = 0; i < mol.getSgroupCount(); ++i) {
            Sgroup sg = mol.getSgroup(i);
            if (sg.getParentSgroup() != null) continue;
            this.appendSgroup(sg, atomHash);
        }
    }

    private boolean isPolymer(int type) {
        return type == 11 || type == 5 || type == 6 || type == 15 || type == 7 || type == 2;
    }

    private String getPolymerGroupName(Sgroup sg) {
        switch (sg.getType()) {
            case 11: {
                return "AnyPolymerSgroup";
            }
            case 5: {
                if (sg.getSubType() == 1) {
                    return "AlternatingCopolymerSgroup";
                }
                if (sg.getSubType() == 3) {
                    return "BlockCopolymerSgroup";
                }
                if (sg.getSubType() == 2) {
                    return "RandomCopolymerSgroup";
                }
                if (sg.getSubType() == 0) {
                    return "CopolymerSgroup";
                }
            }
            case 6: {
                return "CrosslinkSgroup";
            }
            case 15: {
                return "GraftSgroup";
            }
            case 7: {
                return "ModificationSgroup";
            }
            case 2: {
                return "SruSgroup";
            }
        }
        return null;
    }

    private boolean canHaveCharge(int id) {
        return id == 13 || id == 12 || id == 4 || id == 3;
    }

    private void appendSgroup(Sgroup sg, HashMap<MolAtom, String> atomHash) throws XMLStreamException, MolExportException {
        Molecule pmol = sg.getParentMolecule();
        this.xmlStreamWriter.writeStartElement("molecule");
        this.writeGeneralAttributes(sg, pmol);
        if (sg.getType() == 0) {
            this.writeSuperatomSgroup((SuperatomSgroup)sg);
        }
        ++this.currentMoleculeCount;
        this.xmlStreamWriter.writeAttribute("molID", "m" + this.currentMoleculeCount);
        int nchildren = sg.getChildSgroupCount();
        if (sg.getType() == 0 && !((Expandable)((Object)sg)).isExpanded()) {
            this.writeContractedSuperatomSgroup(sg, sg.getSgroupGraph(), atomHash, nchildren);
        } else if (sg.getType() == 1) {
            this.writeMultipleSgroup((MultipleSgroup)sg, pmol, nchildren);
        } else if (sg.getType() == 10) {
            this.writeDataSgroup((DataSgroup)sg, atomHash, nchildren);
        } else if (sg.getType() == 13 || sg.getType() == 9 || sg.getType() == 8 || sg.getType() == 12 || sg.getType() == 4 || sg.getType() == 3) {
            this.writeSimpleSgroup(sg, pmol, atomHash);
        } else if (this.isPolymer(sg.getType()) && sg instanceof RepeatingUnitSgroup) {
            this.writeSruSgroup(sg, pmol, atomHash, nchildren);
        } else if (sg.getType() == 14) {
            this.writeMulticenterSgroup(sg, atomHash, nchildren);
        }
        for (int j = 0; j < sg.getChildSgroupCount(); ++j) {
            Sgroup child = sg.getChildSgroup(j);
            this.appendSgroup(child, atomHash);
        }
        this.xmlStreamWriter.writeEndElement();
    }

    private void writeMulticenterSgroup(Sgroup sg, HashMap<MolAtom, String> atomHash, int nchildren) throws XMLStreamException {
        MulticenterSgroup msg = (MulticenterSgroup)sg;
        this.appendAtomRefs(msg, atomHash);
        String id = MrvExport.getAtomId(msg.getCentralAtom(), atomHash);
        this.xmlStreamWriter.writeAttribute("center", id);
        this.appendAtom(msg.getCentralAtom(), atomHash);
    }

    private void appendAtom(MolAtom centralAtom, HashMap<MolAtom, String> atomHash) {
    }

    private void writeSruSgroup(Sgroup sg, Molecule pmol, HashMap<MolAtom, String> atomHash, int nchildren) throws XMLStreamException, MolExportException {
        RepeatingUnitSgroup srusg = (RepeatingUnitSgroup)sg;
        this.appendAtomRefs(srusg, atomHash);
        this.appendRefsList(srusg.getBondConnectionInfo(), "correspondence", pmol);
        MolBond[] bonds = this.getBondList(srusg);
        this.appendRefsList(bonds, "bondList", pmol);
        String superscript = srusg.getSuperscript();
        this.xmlStreamWriter.writeAttribute("connect", superscript.substring(0, 2));
        this.appendDisplayInfo(sg, pmol.getDocument());
    }

    private MolBond[] getBondList(RepeatingUnitSgroup srusg) {
        MolBond[] bonds = null;
        if (srusg.containsLadderTypePolymer()) {
            bonds = new MolBond[4];
            MolBond[] b = srusg.getHeadCrossingBonds();
            bonds[0] = b[0];
            bonds[1] = b[1];
            b = srusg.getTailCrossingBonds();
            bonds[2] = b[0];
            bonds[3] = b[1];
        }
        return bonds;
    }

    private void appendRefsList(MolBond[] blist, String listName, Molecule pmol) throws XMLStreamException, MolExportException {
        StringBuilder sb = new StringBuilder();
        if (blist != null) {
            for (int j = 0; j < blist.length; ++j) {
                int k = pmol.indexOf(blist[j]);
                if (k < 0) {
                    throw new MolExportException("invalid Sgroup bond");
                }
                String id = "b" + (k + 1);
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(id);
            }
        }
        this.xmlStreamWriter.writeAttribute(listName, sb.toString());
    }

    private void writeSimpleSgroup(Sgroup sg, Molecule pmol, HashMap<MolAtom, String> atomHash) throws XMLStreamException, MolExportException {
        this.appendAtomRefs(sg, atomHash);
        this.appendDisplayInfo(sg, pmol.getDocument());
    }

    private void appendDisplayInfo(Sgroup sg, MDocument doc) throws MolExportException, XMLStreamException {
        ArrayList<MBracket> brackets = sg.getBrackets();
        if (sg.getBracketCount() != 0) {
            for (int i = 0; i < brackets.size(); ++i) {
                this.appendMObject(doc, brackets.get(i), -1);
            }
        }
    }

    private void appendAtomRefs(Sgroup sg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < sg.getAtomCount(); ++j) {
            MolAtom a = sg.getAtom(j);
            String id = MrvExport.getAtomId(a, atomHash);
            if (j > 0) {
                sb.append(' ');
            }
            sb.append(id);
        }
        this.xmlStreamWriter.writeAttribute("atomRefs", sb.toString());
    }

    private void writeDataSgroup(DataSgroup dsg, HashMap<MolAtom, String> atomHash, int nchildren) throws XMLStreamException {
        int dispChars;
        String units;
        this.appendAtomRefs(dsg, atomHash);
        this.xmlStreamWriter.writeAttribute("fieldName", dsg.getFieldName());
        String typeS = "";
        if (dsg.getFieldType() == 1) {
            typeS = "F";
        } else if (dsg.getFieldType() == 2) {
            typeS = "N";
        } else if (dsg.getFieldType() == 3) {
            typeS = "T";
        } else if (dsg.getFieldType() == 4) {
            typeS = "U";
        }
        if (typeS.length() > 0) {
            this.xmlStreamWriter.writeAttribute("fieldType", typeS);
        }
        if ((units = dsg.getUnits()) != null && units.length() > 0) {
            this.xmlStreamWriter.writeAttribute("units", units);
        }
        this.xmlStreamWriter.writeAttribute("x", this.formatNumber(dsg.getX()));
        this.xmlStreamWriter.writeAttribute("y", this.formatNumber(dsg.getY()));
        if (!dsg.isDataDetached()) {
            this.xmlStreamWriter.writeAttribute("dataDetached", "false");
        }
        if (!dsg.isAbsolutePlacement()) {
            this.xmlStreamWriter.writeAttribute("placement", "Relative");
        }
        if (dsg.isUnitDisplayed()) {
            this.xmlStreamWriter.writeAttribute("unitsDisplayed", "Unit displayed");
        }
        if ((dispChars = dsg.getDisplayedChars()) > 0) {
            this.xmlStreamWriter.writeAttribute("displayedChars", Integer.toString(dispChars));
        }
        if (dsg.getDisplayedLines() != 0) {
            this.xmlStreamWriter.writeAttribute("displayedLines", Integer.toString(dsg.getDisplayedLines()));
        }
        if (dsg.getTag() != ' ') {
            Character tag = Character.valueOf(dsg.getTag());
            this.xmlStreamWriter.writeAttribute("tag", tag.toString());
        }
        if (dsg.getPos() != 0) {
            this.xmlStreamWriter.writeAttribute("pos", Integer.toString(dsg.getPos()));
        }
        if (dsg.getQueryCode() != null) {
            this.xmlStreamWriter.writeAttribute("queryType", dsg.getQueryCode());
        }
        if (dsg.getQueryOp() != null) {
            this.xmlStreamWriter.writeAttribute("queryOp", dsg.getQueryOp());
        }
        if (dsg.getContext() != null) {
            this.xmlStreamWriter.writeAttribute("context", dsg.getContext());
        }
        for (int j = 0; j < dsg.getDataLineCount(); ++j) {
            String lNoS = j == 0 ? "" : Integer.toString(j);
            this.xmlStreamWriter.writeAttribute("fieldData" + lNoS, dsg.getDataLine(j));
        }
    }

    private void writeMultipleSgroup(MultipleSgroup mulsg, Molecule pmol, int nchildren) throws XMLStreamException, MolExportException {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < mulsg.getRepeatingUnitAtomCount(); ++j) {
            MolAtom a = mulsg.getRepeatingUnitAtom(j);
            int k = pmol.indexOf(a);
            if (k < 0) {
                throw new MolExportException("invalid Sgroup atom");
            }
            String id = "a" + (k + 1);
            if (j > 0) {
                sb.append(' ');
            }
            sb.append(id);
        }
        this.xmlStreamWriter.writeAttribute("atomRefs", sb.toString());
        this.appendDisplayInfo(mulsg, pmol.getDocument());
    }

    private void writeContractedSuperatomSgroup(Sgroup sg, MoleculeGraph mg, HashMap<MolAtom, String> atomHash, int nchildren) throws XMLStreamException {
        this.appendMoleculeGraph(mg, sg, atomHash);
    }

    private void writeSuperatomSgroup(SuperatomSgroup sg) throws XMLStreamException {
        int labelCenter;
        String rightName;
        SgroupAtom supat = sg.getSuperAtom();
        String leftName = supat.getLeftName();
        if (leftName != null) {
            this.xmlStreamWriter.writeAttribute("leftName", leftName);
        }
        if ((rightName = supat.getRightName()) != null) {
            this.xmlStreamWriter.writeAttribute("rightName", rightName);
        }
        if ((labelCenter = supat.getLabelCenter()) != 0) {
            if (labelCenter == -1) {
                this.xmlStreamWriter.writeAttribute("labelCenter", "AUTO");
            } else {
                this.xmlStreamWriter.writeAttribute("labelCenter", String.valueOf(labelCenter));
            }
        }
        SuperatomSgroup superAtomParent = null;
        for (Sgroup psg = sg.getParentSgroup(); superAtomParent == null && psg != null; psg = psg.getParentSgroup()) {
            if (psg.getType() != 0) continue;
            superAtomParent = (SuperatomSgroup)psg;
        }
        if (superAtomParent != null && sg.getXState() == 2 && superAtomParent.getXState() == 2) {
            this.updateAttachmentPoints(sg.getAttachAtoms());
        }
    }

    private void updateAttachmentPoints(MolAtom[] attachAtoms) {
        if (attachAtoms.length == 1 && attachAtoms[0].getAttach() == 0) {
            attachAtoms[0].setAttach(1);
        }
        if (attachAtoms.length == 2) {
            if (attachAtoms[0] == attachAtoms[1] && attachAtoms[0].getAttach() == 0) {
                attachAtoms[0].setAttach(3);
            } else {
                if (attachAtoms[0].getAttach() == 0) {
                    attachAtoms[0].setAttach(1);
                }
                if (attachAtoms[1].getAttach() == 0) {
                    attachAtoms[1].setAttach(2);
                }
            }
        }
    }

    private void writeGeneralAttributes(Sgroup sg, Molecule pmol) throws XMLStreamException {
        int i = pmol.indexOf(sg);
        this.xmlStreamWriter.writeAttribute("id", "sg" + (i + 1));
        String role = "Sgroup";
        if (sg instanceof SuperatomSgroup) {
            role = "SuperatomSgroup";
        } else if (sg instanceof MultipleSgroup) {
            role = "MultipleSgroup";
        } else if (sg instanceof DataSgroup) {
            role = "DataSgroup";
        } else if (sg.getType() == 13) {
            role = "ComponentSgroup";
        } else if (sg.getType() == 8) {
            role = "MixtureSgroup";
        } else if (sg.getType() == 9) {
            role = "FormulationSgroup";
        } else if (this.isPolymer(sg.getType())) {
            role = this.getPolymerGroupName(sg);
        } else if (sg.getType() == 14) {
            role = "MulticenterSgroup";
        } else if (sg.getType() == 12) {
            role = "GenericSgroup";
        } else if (sg.getType() == 4) {
            role = "MerSgroup";
        } else if (sg.getType() == 3) {
            role = "MonomerSgroup";
        }
        this.xmlStreamWriter.writeAttribute("role", role);
        String subscript = sg.getSubscript();
        if (subscript.length() != 0 && !(sg instanceof DataSgroup)) {
            this.xmlStreamWriter.writeAttribute("title", subscript);
        }
        if (this.canHaveCharge(sg.getType())) {
            this.xmlStreamWriter.writeAttribute("charge", sg.getChargeLocation() == 1 ? "onAtoms" : "onBracket");
        }
    }

    @Override
    protected void writeAtomExtensions(MoleculeGraph molg, Sgroup psg, int i, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        Sgroup sg;
        MolAtom a = molg.getAtom(i);
        int valence = a.getValenceProp();
        int residueType = a.getResidueType();
        int residueId = a.getResidueSeq();
        int residueAtomId = a.getResidueAtomId();
        int mrvAtomMap = a.getAtomMap();
        int reactionStereo = a.getReactionStereo();
        int mrvStereoGroup = a.getStereoGroupType();
        boolean mrvSpecIsoSym = a.isSpecIsotopeSymbolPreferred();
        if (MrvExport.isImplicitHcountImportant(a)) {
            int h = a.getNonQueryImplicitHcount() + a.getExplicitHcount();
            this.xmlStreamWriter.writeAttribute("hydrogenCount", String.valueOf(h));
        }
        if (valence != -1) {
            this.xmlStreamWriter.writeAttribute("mrvValence", String.valueOf(valence));
        }
        if (residueType != 0 || residueId != 0 || residueAtomId != 0) {
            String sym = MolAtom.residueSymbolOf(residueType);
            if (sym == null) {
                sym = "UNK" + residueType;
            }
            this.xmlStreamWriter.writeAttribute("residueType", sym);
            this.xmlStreamWriter.writeAttribute("residueId", "r" + residueId);
            if (residueAtomId != 0) {
                String v = ResidueInfo.getAtomName(residueType, residueAtomId);
                if (v == null) {
                    v = String.valueOf(residueAtomId);
                }
                this.xmlStreamWriter.writeAttribute("residueAtomName", v);
            }
        }
        Molecule mol = psg != null ? psg.getParentMolecule() : (molg instanceof Molecule ? (Molecule)molg : null);
        Sgroup sgroup = sg = mol != null ? mol.findSgroupOf(a) : null;
        if (sg != null && sg != psg) {
            this.xmlStreamWriter.writeAttribute("sgroupRef", MrvExport.getAtomSgroupRef(sg, mol));
        }
        if (mrvAtomMap != 0) {
            this.xmlStreamWriter.writeAttribute("mrvMap", String.valueOf(mrvAtomMap));
        }
        if (reactionStereo != 0) {
            this.xmlStreamWriter.writeAttribute("reactionStereo", MrvExport.getAtomRxnStereo(reactionStereo));
        }
        if (mrvStereoGroup != 0) {
            this.xmlStreamWriter.writeAttribute("mrvStereoGroup", MrvExport.getAtomStereoGroup(a));
        }
        if (mrvSpecIsoSym) {
            this.xmlStreamWriter.writeAttribute("mrvSpecIsotopeSymbolPreferred", "1");
        }
        if (a.getRadical() != 0) {
            this.xmlStreamWriter.writeAttribute("radical", MrvExport.getAtomRadical(a));
        }
        if (a.getElectronProp() > 0) {
            this.xmlStreamWriter.writeAttribute("lonePair", String.valueOf(a.getElectronProp()));
        }
        if (a.getAtno() == 134) {
            this.xmlStreamWriter.writeAttribute("rgroupRef", MrvExport.getAtomRgroupRef(a));
        }
        if (a.getAttach() != 0) {
            this.xmlStreamWriter.writeAttribute("attachmentPoint", MrvExport.getAtomAttachmentPoint(a));
            this.xmlStreamWriter.writeAttribute("sgroupAttachmentPoint", MrvExport.getAtomAttachmentPoint(a));
        }
        if (this.hasRgroupAttachmentPoint(a) && a.getAttach() == 0) {
            this.xmlStreamWriter.writeAttribute("attachmentPoint", this.getAttachmentPointString(a));
            this.xmlStreamWriter.writeAttribute("sgroupAttachmentPoint", "0");
        }
        if (MrvExport.isQuery(a)) {
            this.xmlStreamWriter.writeAttribute("mrvQueryProps", MrvExport.getAtomQueryProps(a));
        }
        if (a.getAtno() != 136 && a.getAliasstr() != null) {
            this.xmlStreamWriter.writeAttribute("mrvAlias", MrvExport.getAtomAlias(a, false));
        }
        if (a.getAtno() != 136 && a.getExtraLabel() != null) {
            this.xmlStreamWriter.writeAttribute("mrvExtraLabel", MrvExport.getAtomExtraLabel(a, false));
            if (a.getExtraLabelSetSeq() != 0) {
                this.xmlStreamWriter.writeAttribute("mrvSetExtraLabelSeq", String.valueOf(a.getExtraLabelSetSeq()));
            }
        }
        if (a.getAtno() == 136) {
            this.xmlStreamWriter.writeAttribute("mrvPseudo", MrvExport.getPseudoAtomName(a, false));
        }
        if (a.getSetSeq() != 0) {
            this.xmlStreamWriter.writeAttribute("mrvSetSeq", String.valueOf(a.getSetSeq()));
        }
        if (a.getMinRepetitions() != 1 || a.getMaxRepetitions() != 1) {
            this.xmlStreamWriter.writeAttribute("mrvLinkNodeRep", MrvExport.getRepetitions(a));
            this.xmlStreamWriter.writeAttribute("mrvLinkNodeOut", MrvExport.getLinkNodeOutAtoms(a, atomHash));
        }
    }

    @Override
    protected void extendAtomArrayAttributes(MoleculeGraph molg, Sgroup psg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        int j;
        StringBuilder sb;
        Molecule m;
        boolean hasSgroupRef;
        boolean hasValenceProp = false;
        boolean hasResidue = false;
        boolean hasMap = false;
        boolean hasRxnStereo = false;
        boolean hasStereoGroup = false;
        boolean hasSpecIsoSym = false;
        boolean hasRadical = false;
        boolean hasLonePair = false;
        boolean hasRgroupRef = false;
        boolean hasSgroupAttach = false;
        boolean hasAttach = false;
        boolean hasQuery = false;
        boolean hasAlias = false;
        boolean hasExtraLabel = false;
        boolean hasPseudo = false;
        boolean hasSetSeq = false;
        boolean hasRepetitions = false;
        boolean hasExtraLabelSetSeq = false;
        int na = molg.getAtomCount();
        for (int i = 0; i < na; ++i) {
            MolAtom a = molg.getAtom(i);
            int atno = a.getAtno();
            boolean pseudo = atno == 136;
            hasValenceProp |= a.getValenceProp() >= 0;
            hasResidue |= a.getResidueType() != 0 || a.getResidueSeq() != 0;
            hasMap |= a.getAtomMap() != 0;
            hasRxnStereo |= a.getReactionStereo() != 0;
            hasStereoGroup |= a.getStereoGroupType() != 0;
            hasSpecIsoSym |= a.isSpecIsotopeSymbolPreferred();
            hasRadical |= a.getRadical() != 0;
            hasLonePair |= a.getElectronProp() > 0;
            hasRgroupRef |= atno == 134;
            hasSgroupAttach |= a.getAttach() != 0;
            hasAttach |= a.getAttach() != 0 || this.hasRgroupAttachmentPoint(a);
            hasQuery |= MrvExport.isQuery(a);
            hasAlias |= !pseudo && a.getAliasstr() != null;
            hasExtraLabel |= a.getExtraLabel() != null;
            hasPseudo |= pseudo;
            hasSetSeq |= a.getSetSeq() != 0;
            hasExtraLabelSetSeq |= a.getExtraLabelSetSeq() != 0;
            hasRepetitions |= a.getMinRepetitions() != 1 || a.getMaxRepetitions() != 1;
        }
        boolean bl = hasSgroupRef = psg != null && psg.getChildSgroupCount() != 0;
        if (psg == null && molg instanceof Molecule) {
            m = (Molecule)molg;
            for (int i = 0; i < na; ++i) {
                MolAtom a = m.getAtom(i);
                hasSgroupRef |= m.findSgroupOf(a) != null;
            }
        }
        if (hasValenceProp) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                MolAtom a = molg.getAtom(j);
                int v = a.getValenceProp();
                if (j > 0) {
                    sb.append(' ');
                }
                if (v < 0) {
                    sb.append('-');
                    continue;
                }
                sb.append(v);
            }
            this.xmlStreamWriter.writeAttribute("mrvValence", sb.toString());
        }
        if (hasResidue) {
            int r;
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                MolAtom a = molg.getAtom(j);
                int residueType = a.getResidueType();
                String sym = Molecule.residueSymbolOf(residueType);
                if (sym == null) {
                    sym = "UNK" + residueType;
                }
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(sym);
            }
            this.xmlStreamWriter.writeAttribute("residueType", sb.toString());
            sb.setLength(0);
            for (j = 0; j < na; ++j) {
                MolAtom a = molg.getAtom(j);
                r = a.getResidueSeq();
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append('r');
                sb.append(r);
            }
            this.xmlStreamWriter.writeAttribute("residueId", sb.toString());
            sb.setLength(0);
            for (j = 0; j < na; ++j) {
                MolAtom a = molg.getAtom(j);
                r = a.getResidueAtomId();
                if (j > 0) {
                    sb.append(' ');
                }
                if (r != 0) {
                    int t = a.getResidueType();
                    String v = ResidueInfo.getAtomName(t, r);
                    if (v == null) {
                        v = String.valueOf(r);
                    }
                    sb.append(v);
                    continue;
                }
                sb.append('0');
            }
            this.xmlStreamWriter.writeAttribute("residueAtomName", sb.toString());
        }
        if (hasMap) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                int map = molg.getAtom(j).getAtomMap();
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(map);
            }
            this.xmlStreamWriter.writeAttribute("mrvMap", sb.toString());
        }
        if (hasRxnStereo) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                int r = molg.getAtom(j).getReactionStereo();
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomRxnStereo(r));
            }
            this.xmlStreamWriter.writeAttribute("reactionStereo", sb.toString());
        }
        if (hasStereoGroup) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomStereoGroup(molg.getAtom(j)));
            }
            this.xmlStreamWriter.writeAttribute("mrvStereoGroup", sb.toString());
        }
        if (hasSpecIsoSym) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getSpecIsotopeSymbolPreferred(molg.getAtom(j)));
            }
            this.xmlStreamWriter.writeAttribute("mrvSpecIsotopeSymbolPreferred", sb.toString());
        }
        if (hasRadical) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomRadical(molg.getAtom(j)));
            }
            this.xmlStreamWriter.writeAttribute("radical", sb.toString());
        }
        if (hasLonePair) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(String.valueOf(molg.getAtom(j).getElectronProp() > 0 ? molg.getAtom(j).getElectronProp() : 0));
            }
            this.xmlStreamWriter.writeAttribute("lonePair", sb.toString());
        }
        if (hasRgroupRef) {
            sb = new StringBuilder();
            for (j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomRgroupRef(molg.getAtom(j)));
            }
            this.xmlStreamWriter.writeAttribute("rgroupRef", sb.toString());
        }
        if (hasSgroupRef) {
            m = psg != null ? psg.getParentMolecule() : (Molecule)molg;
            StringBuilder sb2 = new StringBuilder();
            for (int j2 = 0; j2 < na; ++j2) {
                MolAtom a = molg.getAtom(j2);
                if (j2 > 0) {
                    sb2.append(' ');
                }
                if (psg == null) {
                    sb2.append(MrvExport.getAtomSgroupRef(m.findSgroupOf(a), m));
                    continue;
                }
                Sgroup sg = psg.getParentMolecule().findSgroupOf(a);
                if (sg != null && sg != psg) {
                    sb2.append(MrvExport.getAtomSgroupRef(sg, m));
                    continue;
                }
                sb2.append('0');
            }
            this.xmlStreamWriter.writeAttribute("sgroupRef", sb2.toString());
        }
        if (hasAttach) {
            sb = new StringBuilder();
            for (int j3 = 0; j3 < na; ++j3) {
                if (j3 > 0) {
                    sb.append(' ');
                }
                if (molg.getAtom(j3).getAttach() != 0) {
                    sb.append(MrvExport.getAtomAttachmentPoint(molg.getAtom(j3)));
                    continue;
                }
                sb.append(this.getAttachmentPointString(molg.getAtom(j3)));
            }
            this.xmlStreamWriter.writeAttribute("attachmentPoint", sb.toString());
        }
        if (hasAttach) {
            sb = new StringBuilder();
            for (int j4 = 0; j4 < na; ++j4) {
                if (j4 > 0) {
                    sb.append(' ');
                }
                if (molg.getAtom(j4).getAttach() != 0) {
                    sb.append(MrvExport.getAtomAttachmentPoint(molg.getAtom(j4)));
                    continue;
                }
                sb.append('0');
            }
            this.xmlStreamWriter.writeAttribute("sgroupAttachmentPoint", sb.toString());
        }
        if (hasQuery) {
            sb = new StringBuilder();
            for (int j5 = 0; j5 < na; ++j5) {
                if (j5 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomQueryProps(molg.getAtom(j5)));
            }
            this.xmlStreamWriter.writeAttribute("mrvQueryProps", sb.toString());
        }
        if (hasAlias) {
            sb = new StringBuilder();
            for (int j6 = 0; j6 < na; ++j6) {
                if (j6 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomAlias(molg.getAtom(j6), true));
            }
            this.xmlStreamWriter.writeAttribute("mrvAlias", sb.toString());
        }
        if (hasExtraLabel) {
            sb = new StringBuilder();
            for (int j7 = 0; j7 < na; ++j7) {
                if (j7 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getAtomExtraLabel(molg.getAtom(j7), true));
            }
            this.xmlStreamWriter.writeAttribute("mrvExtraLabel", sb.toString());
        }
        if (hasExtraLabelSetSeq) {
            sb = new StringBuilder();
            for (int j8 = 0; j8 < na; ++j8) {
                if (j8 > 0) {
                    sb.append(' ');
                }
                sb.append(molg.getAtom(j8).getExtraLabelSetSeq());
            }
            this.xmlStreamWriter.writeAttribute("mrvSetExtraLabelSeq", sb.toString());
        }
        if (hasPseudo) {
            sb = new StringBuilder();
            for (int j9 = 0; j9 < na; ++j9) {
                if (j9 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getPseudoAtomName(molg.getAtom(j9), true));
            }
            this.xmlStreamWriter.writeAttribute("mrvPseudo", sb.toString());
        }
        if (hasSetSeq) {
            sb = new StringBuilder();
            for (int j10 = 0; j10 < na; ++j10) {
                if (j10 > 0) {
                    sb.append(' ');
                }
                sb.append(molg.getAtom(j10).getSetSeq());
            }
            this.xmlStreamWriter.writeAttribute("mrvSetSeq", sb.toString());
        }
        if (hasRepetitions) {
            int j11;
            sb = new StringBuilder();
            for (j11 = 0; j11 < na; ++j11) {
                MolAtom a = molg.getAtom(j11);
                if (j11 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getRepetitions(a));
            }
            this.xmlStreamWriter.writeAttribute("mrvLinkNodeRep", sb.toString());
            sb.setLength(0);
            for (j11 = 0; j11 < na; ++j11) {
                MolAtom a = molg.getAtom(j11);
                if (j11 > 0) {
                    sb.append(' ');
                }
                sb.append(MrvExport.getLinkNodeOutAtoms(a, atomHash));
            }
            this.xmlStreamWriter.writeAttribute("mrvLinkNodeOut", sb.toString());
        }
    }

    private static String getSpecIsotopeSymbolPreferred(MolAtom atom) {
        return atom.isSpecIsotopeSymbolPreferred() ? "1" : "0";
    }

    private static String getLinkNodeOutAtoms(MolAtom a, HashMap<MolAtom, String> atomHash) {
        StringBuilder sb = new StringBuilder();
        int written = 0;
        for (int i = 0; i < 2; ++i) {
            int outerIdx = a.getLinkNodeOuterAtom(i);
            if (outerIdx == -1 || outerIdx >= a.getBondCount()) continue;
            MolAtom outer = a.getLigand(outerIdx);
            String ref = MrvExport.getAtomId(outer, atomHash);
            if (written > 0) {
                sb.append(',');
            }
            sb.append(ref);
            ++written;
        }
        if (written == 0) {
            sb.append('-');
        }
        return sb.toString();
    }

    private static String getRepetitions(MolAtom a) {
        StringBuilder sb = new StringBuilder();
        int min = a.getMinRepetitions();
        if (min != 1) {
            sb.append(min);
            sb.append('-');
        }
        sb.append(a.getMaxRepetitions());
        return sb.toString();
    }

    @Override
    protected void writeBondExtension0(MolBond b, String sq) throws XMLStreamException {
        String s;
        this.xmlStreamWriter.writeAttribute("queryType", sq);
        if (b instanceof QueryBond && !(s = MrvExport.getBondQueryProps(b)).equals("0")) {
            this.xmlStreamWriter.writeAttribute("mrvQueryProps", s);
        }
    }

    private static String getBondQueryProps(MolBond b) {
        String querystr = b.getQuerystr();
        if (querystr != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("str:");
            sb.append(querystr);
            return sb.toString();
        }
        return "0";
    }

    @Override
    protected void writeBondExtension1(MolBond b) throws XMLStreamException {
        int rcFlags;
        int setseq;
        int flags = b.getFlags();
        int topo = flags & 0xC00;
        if (topo != 0) {
            this.xmlStreamWriter.writeAttribute("topology", topo == 1024 ? "ring" : "chain");
        }
        if ((setseq = flags >>> 24 & 0x3F) != 0) {
            this.xmlStreamWriter.writeAttribute("mrvSetSeq", String.valueOf(setseq));
        }
        if (b.isBold()) {
            this.xmlStreamWriter.writeAttribute("mrvBold", String.valueOf(true));
        }
        if (b.isHashed()) {
            this.xmlStreamWriter.writeAttribute("mrvHashed", String.valueOf(true));
        }
        if ((rcFlags = flags & 0xF000) != 0) {
            String rcValue = "0";
            switch (rcFlags) {
                case 20480: {
                    rcValue = "-1";
                    break;
                }
                case 4096: {
                    rcValue = "1";
                    break;
                }
                case 24576: {
                    rcValue = "2";
                    break;
                }
                case 8192: {
                    rcValue = "4";
                    break;
                }
                case 12288: {
                    rcValue = "8";
                    break;
                }
                case 16384: {
                    rcValue = "12";
                    break;
                }
            }
            this.xmlStreamWriter.writeAttribute("mrvReactingCenter", rcValue);
        }
    }

    private static String getPseudoAtomName(MolAtom a, boolean escapews) {
        String s = a.getAtno() == 136 ? a.getAliasstr() : null;
        return MrvExport.getEscapedProperty(s, escapews);
    }

    private static String getAtomExtraLabel(MolAtom a, boolean escapews) {
        return MrvExport.getEscapedProperty(a.getExtraLabel(), escapews);
    }

    private static String getEscapedProperty(String s, boolean escapews) {
        if (s == null) {
            return "0";
        }
        if (s.equals("0")) {
            return "\\u0030";
        }
        if (s.equals("")) {
            return ".";
        }
        if (s.equals(".")) {
            return "\\u002e";
        }
        s = s.replaceAll(" ", "\\\\u0020").replaceAll("(\r\n|\r|\n)", "\\\\n");
        return s;
    }

    private static String getAtomAlias(MolAtom a, boolean escapews) {
        return MrvExport.getEscapedProperty(a.getAliasstr(), escapews);
    }

    private static String getAtomQueryProps(MolAtom a) {
        if (MrvExport.isQuery(a)) {
            StringBuilder sb = new StringBuilder();
            boolean found = false;
            int z = a.getAtno();
            if (z == 128 || z == 129) {
                sb.append('L');
                int[] list = a.getList();
                if (list != null) {
                    for (int i = 0; i < list.length; ++i) {
                        sb.append(z == 128 ? (char)',' : '!');
                        sb.append(MolAtom.symbolOf(list[i]));
                    }
                }
                sb.append(':');
                found = true;
            } else if (z == 132) {
                sb.append("Q:");
                found = true;
            } else if (z == 131) {
                sb.append("A:");
                found = true;
            }
            boolean foundprop = false;
            String[] qpropNames = a.getQPropNames();
            for (int k = 0; k < qpropNames.length; ++k) {
                Object o;
                String key = qpropNames[k];
                if (key.equals("rb") || key.equals("s")) {
                    if (foundprop) {
                        sb.append(';');
                    }
                    sb.append(key);
                    int i = a.getQPropAsInt(key);
                    if (i == -2) {
                        sb.append('*');
                    } else {
                        sb.append(i);
                    }
                    foundprop = true;
                    found = true;
                    continue;
                }
                if (key.equals("str") || !((o = a.getQProp(key)) instanceof Integer)) continue;
                int i = (Integer)o;
                if (foundprop) {
                    sb.append(';');
                }
                sb.append(key);
                sb.append(i);
                foundprop = true;
                found = true;
            }
            String querystr = a.getQueryString();
            if (querystr != null) {
                if (foundprop) {
                    sb.append(';');
                }
                sb.append("str:");
                sb.append(querystr);
                found = true;
            }
            if (found) {
                return sb.toString();
            }
        }
        return "0";
    }

    private static boolean isQuery(MolAtom a) {
        return a.isQuery() && a.getAtno() != 134 || MrvExport.hasIntegerAttribute(a);
    }

    private static boolean hasIntegerAttribute(MolAtom a) {
        String[] qpropNames;
        for (String key : qpropNames = a.getQPropNames()) {
            Object o;
            if (key.equals("str") || !((o = a.getQProp(key)) instanceof Integer)) continue;
            return true;
        }
        return false;
    }

    private String getAttachmentPointString(MolAtom a) {
        int apo = AttachmentConverter.getRgroupAttachmentPoint(a, null);
        return apo == 3 ? "both" : String.valueOf(apo);
    }

    private boolean hasRgroupAttachmentPoint(MolAtom atom) {
        for (int i = 0; i < atom.getBondCount(); ++i) {
            if (atom.getLigand(i).getAtno() != 138) continue;
            return true;
        }
        return false;
    }

    private static String getAtomAttachmentPoint(MolAtom a) {
        int r = a.getAttach();
        if (r == 3) {
            return "both";
        }
        return String.valueOf(r);
    }

    private static String getAtomRgroupRef(MolAtom a) {
        if (a.getAtno() == 134) {
            return String.valueOf(a.getRgroup());
        }
        return "0";
    }

    private static String getAtomStereoGroup(MolAtom a) {
        int g = a.getStereoGroupType();
        if (g == 1) {
            return "abs";
        }
        if (g == 3) {
            return "and" + a.getStereoGroupNumber();
        }
        if (g == 2) {
            return "or" + a.getStereoGroupNumber();
        }
        return "0";
    }

    private static String getAtomRadical(MolAtom a) {
        int r = a.getRadical();
        if (r == 1) {
            return "monovalent";
        }
        if (r == 2) {
            return "divalent";
        }
        if (r == 6) {
            return "divalent1";
        }
        if (r == 10) {
            return "divalent3";
        }
        if (r == 3) {
            return "trivalent";
        }
        if (r == 7) {
            return "trivalent2";
        }
        if (r == 11) {
            return "trivalent4";
        }
        return String.valueOf(r);
    }

    private static String getAtomRxnStereo(int r) {
        if (r == 1) {
            return "Inv";
        }
        if (r == 2) {
            return "Ret";
        }
        return "0";
    }

    private static String getAtomSgroupRef(Sgroup sg, Molecule m) {
        if (sg != null) {
            int k = m.indexOf(sg);
            return "sg" + (k + 1);
        }
        return "0";
    }

    @Override
    protected String getMolIDString() {
        return "molID";
    }

    @Override
    public Object close() throws MolExportException {
        return super.close();
    }

    public void setGlobalGUIProperties(MPropertyContainer ggp) {
        this.globalGUIProperties = ggp;
    }

    public MPropertyContainer getGlobalGUIProperties() {
        return this.globalGUIProperties;
    }

    @Override
    protected void appendArrow(RxnMolecule step) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement("arrow");
        MRArrow arrow = step.getItsArrow();
        String type = step.getReactionArrowTypeName();
        this.xmlStreamWriter.writeAttribute("type", type);
        MPoint[] aPoints = arrow.getPoints();
        DPoint3 loc1 = aPoints[0].getLocation();
        DPoint3 loc2 = aPoints[1].getLocation();
        this.xmlStreamWriter.writeAttribute("x1", String.valueOf(loc1.x));
        this.xmlStreamWriter.writeAttribute("y1", String.valueOf(loc1.y));
        if (step.getDim() == 3) {
            this.xmlStreamWriter.writeAttribute("z1", String.valueOf(loc1.z));
        }
        this.xmlStreamWriter.writeAttribute("x2", String.valueOf(loc2.x));
        this.xmlStreamWriter.writeAttribute("y2", String.valueOf(loc2.y));
        if (step.getDim() == 3) {
            this.xmlStreamWriter.writeAttribute("z2", String.valueOf(loc2.z));
        }
        this.xmlStreamWriter.writeEndElement();
    }

    @Override
    protected void writeBicycloStereoInformation(MolAtom a, HashMap<MolAtom, String> atomHash, MoleculeGraph molg) throws XMLStreamException {
        BicycloStereoDescriptor[] descriptors;
        for (BicycloStereoDescriptor descriptor : descriptors = a.getBicycloStereo()) {
            this.xmlStreamWriter.writeStartElement("atomBicycloStereo");
            this.xmlStreamWriter.writeAttribute("connectionAtom", MrvExport.getAtomId(descriptor.getConnectionAtom(), atomHash));
            this.xmlStreamWriter.writeAttribute("lowBridge", this.getAtomIndexRefs(descriptor.getLowBridgeAtoms(), molg, atomHash));
            this.xmlStreamWriter.writeAttribute("highBridge", this.getAtomIndexRefs(descriptor.getHighBridgeAtoms(), molg, atomHash));
            this.xmlStreamWriter.writeCharacters(this.getStereoString(descriptor.getStereoValue()));
            this.xmlStreamWriter.writeEndElement();
        }
    }

    protected String getStereoString(int stereoValue) {
        if (stereoValue == 6) {
            return "either";
        }
        if (stereoValue == 5) {
            return "lower";
        }
        if (stereoValue == 4) {
            return "higher";
        }
        return "";
    }

    @Override
    protected boolean hasBicycloStereoInformation(boolean is0D, MolAtom atom, MoleculeGraph molg) {
        if (molg != null && atom.getBicycloStereo() != null) {
            return atom.getBicycloStereo().length > 0 && is0D;
        }
        return false;
    }

    @Override
    protected void writeRGroupAttachmentPointInformation(MolAtom a, MoleculeGraph molg, HashMap<MolAtom, String> atomHash) throws XMLStreamException {
        if (a.getAtno() == 138) {
            this.xmlStreamWriter.writeAttribute("attachmentOrder", String.valueOf(a.getRgroupAttachmentPointOrder()));
        }
        if (a.getAtno() == 134) {
            this.xmlStreamWriter.writeAttribute("ligandOrder", this.getAtomIndexRefs(a, molg, atomHash));
        }
    }

    @Override
    protected Molecule prepareForImport(Molecule mol) {
        Molecule pmol = this.preconvert(mol, false);
        if (mol.getSgroupCount() != 0) {
            pmol.setGUIContracted(true);
        }
        return pmol;
    }

    @Override
    protected void writeSelectionInformation(MolAtom atom) throws XMLStreamException {
        if (atom.isSelected() && this.exportSelection) {
            this.xmlStreamWriter.writeAttribute("isSelected", String.valueOf(true));
        }
    }

    @Override
    protected void writeSelectionInformation(MoleculeGraph molg, int na) throws XMLStreamException {
        if (this.exportSelection) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < na; ++j) {
                if (j > 0) {
                    sb.append(' ');
                }
                sb.append(String.valueOf(molg.getAtom(j).isSelected()));
            }
            this.xmlStreamWriter.writeAttribute("isSelected", sb.toString());
        }
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        if ((i = this.parseCharIfOptionSign(opts, i)) >= opts.length()) {
            return i;
        }
        int ii = super.parseOption(opts, i);
        if (ii != i) {
            return ii;
        }
        char c = opts.charAt(i);
        if (c == 'S') {
            this.exportSelection = true;
            ++i;
        }
        return i;
    }

    @Override
    protected CMLExport initExporterWithSameOptions() throws MolExportException {
        MrvExport toReturn = new MrvExport();
        toReturn.useAtomArray = this.useAtomArray;
        toReturn.prettyPrinting = this.prettyPrinting;
        toReturn.exportSelection = this.exportSelection;
        return toReturn;
    }
}

