/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MFileFormatUtil;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.formats.cml.CMLImport;
import chemaxon.marvin.io.formats.cml.DocumentReader;
import chemaxon.marvin.io.formats.cml.MoleculeReader;
import chemaxon.marvin.io.formats.cml.PropertyReader;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MProp;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.prop.MDoubleArrayProp;
import chemaxon.struc.prop.MDoubleProp;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MrvImport
extends CMLImport {
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();

    @Override
    public boolean isDocumentImporter() {
        return true;
    }

    @Override
    public MDocument readDocument(MDocument doc) throws MolFormatException, IOException {
        Document xmldoc;
        this.useSgroupAPO = false;
        try {
            DocumentBuilder builder = this.docBuilderFactory.newDocumentBuilder();
            xmldoc = builder.parse(this.getMolInputStream());
        }
        catch (ParserConfigurationException ex) {
            throw new MolFormatException(ex);
        }
        catch (SAXException ex) {
            throw new MolFormatException(ex);
        }
        if (doc == null) {
            doc = new MDocument(new Molecule());
        } else {
            doc.clear();
        }
        doc.setInputFormat("mrv");
        this.readMRV(xmldoc.getDocumentElement(), doc);
        DocumentReader.postProcessDocument(doc, this.useSgroupAPO);
        return doc;
    }

    private void readHeadlessMRV(Element e, MDocument doc) throws MolFormatException {
        String tagname = e.getTagName().toLowerCase();
        Element node = e;
        if (tagname.equals("mdocument")) {
            this.readMDocument(node, doc);
            return;
        }
        Molecule mol = (Molecule)doc.getMainMoleculeGraph();
        if (tagname.equals("molecule")) {
            if (mol instanceof RxnMolecule) {
                mol = new Molecule();
                doc.setMainMoleculeGraph(mol);
            }
            this.readMolecule(node, mol);
            return;
        }
        Hashtable molMap = new Hashtable();
        if (tagname.equals("reactionscheme")) {
            if (!(mol instanceof RxnMolecule)) {
                mol = new RxnMolecule();
                doc.setMainMoleculeGraph(mol);
            }
            this.readReactionScheme(node, (RxnMolecule)mol);
            return;
        }
        if (tagname.equals("reaction")) {
            if (!(mol instanceof RxnMolecule)) {
                mol = new RxnMolecule();
                doc.setMainMoleculeGraph(mol);
            }
            this.readReaction(node, (RxnMolecule)mol);
            return;
        }
    }

    private void readMRV(Element e, MDocument doc) throws MolFormatException {
        if (!e.getTagName().equals("cml")) {
            this.readHeadlessMRV(e, doc);
            return;
        }
        this.readHeader(e);
        NodeList nodes = e.getChildNodes();
        if (nodes.getLength() != 0) {
            Node item;
            for (item = nodes.item(0); !(item == null || item.getNodeName().equals("MDocument") || item.getNodeName().equals("molecule") || item.getNodeName().startsWith("reaction")); item = item.getNextSibling()) {
            }
            if (item == null) {
                return;
            }
            if (item.getNodeName().equals("MDocument")) {
                this.readMDocument(item, doc);
                return;
            }
            Molecule mol = (Molecule)doc.getMainMoleculeGraph();
            if (item.getNodeName().equals("molecule")) {
                if (mol instanceof RxnMolecule) {
                    mol = new Molecule();
                    doc.setMainMoleculeGraph(mol);
                }
                this.readMolecule(item, mol);
                return;
            }
            if (item.getNodeName().equals("reactionScheme")) {
                if (!(mol instanceof RxnMolecule)) {
                    mol = new RxnMolecule();
                    doc.setMainMoleculeGraph(mol);
                }
                this.readReactionScheme(item, mol);
                return;
            }
            if (item.getNodeName().equals("reaction")) {
                if (!(mol instanceof RxnMolecule)) {
                    mol = new RxnMolecule();
                    doc.setMainMoleculeGraph(mol);
                }
                this.readReaction(item, mol);
                return;
            }
        }
    }

    private void readMDocument(Node node, MDocument doc) throws MolFormatException {
        boolean mainadded = false;
        boolean mainmmmadded = false;
        this.atomSetPointVector = null;
        this.eflowBasePointVector = null;
        this.readMDocumentSettings(node, doc);
        int nmcs = 0;
        NodeList nodes = node.getChildNodes();
        HashMap<String, MObject> objHash = new HashMap<String, MObject>();
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node item = nodes.item(i);
                if (item.getNodeType() != 1) continue;
                MObject mo = null;
                Molecule mol = null;
                MMoleculeMovie mmm = null;
                String s = item.getNodeName();
                if (s.equals("MChemicalStruct")) {
                    MoleculeGraph m;
                    MoleculeGraph moleculeGraph = m = nmcs == 0 ? doc.getMainMoleculeGraph() : null;
                    if (!(m instanceof Molecule)) {
                        m = null;
                    }
                    ++nmcs;
                    MChemicalStruct mcs = this.readChemicalStruct(item, (Molecule)m);
                    mo = mcs;
                    if (mcs != null) {
                        mol = (Molecule)mcs.getMoleculeGraph();
                    }
                    MolImportUtil.fixBeilsteinRDF(mol);
                } else if (s.equals("propertyList")) {
                    NodeList props = item.getChildNodes();
                    MProp prop = null;
                    for (int j = 0; j < props.getLength(); ++j) {
                        Node icns1;
                        if (!props.item(j).getNodeName().equals("property")) continue;
                        if (props.item(j).getAttributes().getNamedItem("dictRef") == null) {
                            throw new MolFormatException("No valid property found");
                        }
                        String key = props.item(j).getAttributes().getNamedItem("dictRef").getNodeValue();
                        if (key.equals("viewEulerAngles")) {
                            icns1 = this.getNodeWithName(props.item(j).getChildNodes(), "array");
                            if (icns1.getAttributes().getNamedItem("size") == null) {
                                throw new MolFormatException("No valid \"size\" attribute for viewEulerAngles property");
                            }
                            Integer size = new Integer(icns1.getAttributes().getNamedItem("size").getNodeValue());
                            prop = new MDoubleArrayProp(icns1.getFirstChild().getNodeValue(), size, -1);
                            doc.properties().set(key, prop);
                        }
                        if (!key.equals("scale")) continue;
                        icns1 = this.getNodeWithName(props.item(j).getChildNodes(), "scalar");
                        prop = new MDoubleProp(icns1.getFirstChild().getNodeValue());
                        doc.properties().set("scale", prop);
                    }
                } else if (s.equals("MMoleculeMovie")) {
                    mo = mmm = this.readMoleculeMovie(item);
                } else if (s.equals("MPolyline")) {
                    mo = new MPolyline();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MEFlow")) {
                    mo = new MEFlow();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MRectangle")) {
                    mo = new MRectangle();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MTextBox")) {
                    mo = new MTextBox();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MBracket")) {
                    mo = new MBracket();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MNameTextBox")) {
                    mo = new MNameTextBox();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MRoundedRectangle")) {
                    mo = new MRoundedRectangle();
                    this.initGraphicsObject(item, mo, objHash);
                } else if (s.equals("MEllipse")) {
                    mo = new MEllipse();
                    this.initGraphicsObject(item, mo, objHash);
                }
                if (mo == null) continue;
                if (mol != null && !mainadded) {
                    doc.setMainMoleculeGraph(mol);
                    doc.moveMainMoleculeGraphToFront();
                    mainadded = true;
                    continue;
                }
                if (mmm != null && !mainmmmadded) {
                    doc.setMoleculeMovie(mmm);
                    doc.moveMoleculeMovieToFront();
                    mainmmmadded = true;
                    continue;
                }
                doc.addObject(mo);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MolFormatException(ex);
        }
        DocumentReader.endObjectReading(doc, objHash, this.atomSetPointVector, this.eflowBasePointVector);
    }

    private Node getNodeWithName(NodeList nodeList, String nodeName) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node actNode = nodeList.item(i);
            if (!actNode.getNodeName().equals(nodeName)) continue;
            return actNode;
        }
        return null;
    }

    private void readMDocumentSettings(Node elem, MDocument doc) throws MolFormatException {
        int[][] atomSetRGB = DocumentReader.readSetRGB(MrvImport.getTagProperty(elem, "atomSetRGB"), "atomSetRGB", 1);
        DocumentReader.setAtomSetRGB(doc, atomSetRGB);
        Map<Integer, MFont> atomSetFont = PropertyReader.readSetFont(MrvImport.getTagProperty(elem, "atomSetFont"), "atomSetFont");
        DocumentReader.setAtomSetFont(doc, atomSetFont);
        int[][] bondSetRGB = DocumentReader.readSetRGB(MrvImport.getTagProperty(elem, "bondSetRGB"), "bondSetRGB", 1);
        DocumentReader.setBondSetRGB(doc, bondSetRGB);
        int[][] extraLabelSetRGB = DocumentReader.readSetRGB(MrvImport.getTagProperty(elem, "extraLabelSetRGB"), "extraLabelSetRGB", 2);
        DocumentReader.setExtraLabelSetRGB(doc, extraLabelSetRGB);
        Map<Integer, Double> bondSetLT = PropertyReader.readSetLT(MrvImport.getTagProperty(elem, "bondSetLineThickness"), "bondSetLineThickness");
        DocumentReader.setBondSetThickness(doc, bondSetLT);
        MrvImport.readPageSetting(elem, doc.getPageSettings());
    }

    private MChemicalStruct readChemicalStruct(Node elem, Molecule m) throws MolFormatException {
        MChemicalStruct mcs = null;
        MoleculeGraph mol = null;
        NodeList nodes = elem.getChildNodes();
        Hashtable molMap = new Hashtable();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String s = node.getNodeName();
            if (s.equals("molecule")) {
                if (mol != null) continue;
                mol = m == null || m instanceof RxnMolecule ? new Molecule() : m;
                ((Molecule)mol).clearForImport("mrv");
                this.readMolecule(node, (Molecule)mol);
                mcs = new MChemicalStruct(mol);
                continue;
            }
            if (s.equals("reaction") || s.equals("reactionScheme")) {
                RxnMolecule rxn;
                if (mol != null) continue;
                if (m == null) {
                    rxn = new RxnMolecule();
                    rxn.clearForImport("mrv");
                } else if (m instanceof RxnMolecule) {
                    rxn = (RxnMolecule)m;
                    rxn.clearForImport("mrv");
                } else if (m instanceof RgMolecule) {
                    RgMolecule rmol = (RgMolecule)m;
                    if (rmol.getRoot() instanceof RxnMolecule) {
                        rxn = (RxnMolecule)rmol.getRoot();
                    } else {
                        rxn = new RxnMolecule();
                        MolImportUtil.addProperties(rxn.properties(), rmol.getRoot().properties());
                        rmol.setRoot(rxn);
                    }
                    rmol.clearForImport("mrv");
                } else {
                    rxn = new RxnMolecule();
                    rxn.clearForImport("mrv");
                }
                if (s.equals("reactionScheme")) {
                    this.readReactionScheme(node, rxn);
                } else {
                    this.readReaction(node, rxn);
                }
                mol = rxn;
                mcs = new MChemicalStruct(mol);
                continue;
            }
            if (!s.equals("Rgroup")) continue;
            if (mcs == null) {
                throw new MolFormatException("<molecule> or <reaction> tag must precede <Rgroup>");
            }
            mcs = this.readRgroup(node, mcs);
            mol = (Molecule)mcs.getMoleculeGraph();
        }
        if (mol != null) {
            mol.revalidateCoordDependentProps();
        }
        return mcs;
    }

    private MMoleculeMovie readMoleculeMovie(Node elem) throws MolFormatException {
        ArrayList<MoleculeGraph> vmols = new ArrayList<MoleculeGraph>();
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String s = node.getNodeName();
            if (!s.equals("MChemicalStruct")) continue;
            MChemicalStruct mcs = this.readChemicalStruct(node, null);
            vmols.add(mcs.getMoleculeGraph());
        }
        Molecule[] mols = new Molecule[vmols.size()];
        vmols.toArray(mols);
        return new MMoleculeMovie(mols);
    }

    private MChemicalStruct readRgroup(Node elem, MChemicalStruct mcs) throws MolFormatException {
        RgMolecule rgmol;
        Molecule mol = (Molecule)mcs.getMoleculeGraph();
        if (mol instanceof RgMolecule) {
            rgmol = (RgMolecule)mol;
        } else {
            rgmol = new RgMolecule();
            rgmol.clearForImport("mrv");
            rgmol.setDim(mol.getDim());
            rgmol.setRoot(mol);
            mol = rgmol;
            mcs = new MChemicalStruct(mol);
        }
        String rgroupId = MrvImport.getTagProperty(elem, "rgroupID");
        int id = 0;
        try {
            id = Integer.parseInt(rgroupId);
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Rgroup ID \"" + rgroupId + "\" is not an integer");
        }
        String thenR = MrvImport.getTagProperty(elem, "thenR");
        String restH = MrvImport.getTagProperty(elem, "restH");
        String rlogicRange = MrvImport.getTagProperty(elem, "rlogicRange");
        NodeList nodes = elem.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            String s = node.getNodeName();
            if (s.equals("molecule")) {
                Molecule m = new Molecule();
                m.clearForImport("mrv");
                this.readMolecule(node, m);
                rgmol.addRgroup(id, m);
                MoleculeReader.setRlogic(rgmol, id, thenR, restH, rlogicRange);
                continue;
            }
            if (!s.equals("MTextBox")) continue;
        }
        return mcs;
    }

    @Override
    protected String modifyPropertyKeyCallback(String key) {
        return key;
    }

    @Override
    protected String getParityValue(String readParityValue) {
        if (this.fileFormatVersion == null) {
            return readParityValue.equals("1") ? "-1" : (readParityValue.equals("-1") ? "1" : "0");
        }
        return readParityValue;
    }

    private static void readPageSetting(Node elem, PageSettings pageSettings) throws MolFormatException {
        String val = MrvImport.getTagProperty(elem, "multipageEnabled");
        DocumentReader.setPageEnabled(pageSettings, val);
        val = MrvImport.getTagProperty(elem, "multipageSelectedPage");
        DocumentReader.setSelectedPage(pageSettings, val);
        val = MrvImport.getTagProperty(elem, "multipageColumnCount");
        DocumentReader.setColumnCount(pageSettings, val);
        val = MrvImport.getTagProperty(elem, "multipageRowCount");
        DocumentReader.setRowCount(pageSettings, val);
        val = MrvImport.getTagProperty(elem, "multipageWidth");
        if (val != null) {
            pageSettings.setWidth(PropertyReader.readDoubleValue(val, "multipageWidth"));
        }
        if ((val = MrvImport.getTagProperty(elem, "multipageHeight")) != null) {
            pageSettings.setHeight(PropertyReader.readDoubleValue(val, "multipageHeight"));
        }
        if ((val = MrvImport.getTagProperty(elem, "multipageLeft")) != null) {
            pageSettings.setLeftMargin(PropertyReader.readDoubleValue(val, "multipageLeft"));
        }
        if ((val = MrvImport.getTagProperty(elem, "multipageRight")) != null) {
            pageSettings.setRightMargin(PropertyReader.readDoubleValue(val, "multipageRight"));
        }
        if ((val = MrvImport.getTagProperty(elem, "multipageTop")) != null) {
            pageSettings.setTopMargin(PropertyReader.readDoubleValue(val, "multipageTop"));
        }
        if ((val = MrvImport.getTagProperty(elem, "multipageBottom")) != null) {
            pageSettings.setBottomMargin(PropertyReader.readDoubleValue(val, "multipageBottom"));
        }
    }

    public static void main(String[] args) throws Exception {
        String[] fileopts = MFileFormatUtil.splitFileAndOptions(args[0]);
        MolInputStream mis = new MolInputStream(new FileInputStream(new File(fileopts[0])));
        MrvImport mod = new MrvImport();
        mod.setOptions(fileopts[1]);
        mod.initMolImport(mis);
        MDocument doc = mod.readDocument(null);
        Molecule mol = (Molecule)doc.getMainMoleculeGraph();
        System.out.println(mol.toFormat("mrv"));
    }
}

