/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.formats.cml.CmlImportStax;
import chemaxon.marvin.io.formats.cml.DocumentReader;
import chemaxon.marvin.io.formats.cml.MoleculeReader;
import chemaxon.marvin.io.formats.cml.MrvInputStream;
import chemaxon.marvin.io.formats.cml.PropertyReader;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.MDocument;
import chemaxon.struc.MObject;
import chemaxon.struc.MProp;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PageSettings;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.graphics.MChemicalStruct;
import chemaxon.struc.graphics.MEFlow;
import chemaxon.struc.graphics.MEllipse;
import chemaxon.struc.graphics.MFont;
import chemaxon.struc.graphics.MMoleculeMovie;
import chemaxon.struc.graphics.MNameTextBox;
import chemaxon.struc.graphics.MPolyline;
import chemaxon.struc.graphics.MRectangle;
import chemaxon.struc.graphics.MRoundedRectangle;
import chemaxon.struc.graphics.MTextBox;
import chemaxon.struc.prop.MDoubleArrayProp;
import chemaxon.struc.prop.MDoubleProp;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;

public class MrvImportStax
extends CmlImportStax {
    private MPropertyContainer globalGUIProperties;
    protected static final String[] MHEAD_TAG = new String[]{"MHead"};
    protected static final String[] MARVINGUI_TAG = new String[]{"MarvinGUI"};
    protected static final String[] MPROP_TAG = new String[]{"mprop"};
    protected static final String[] MRV_START_TAGS = CML_START_TAGS;
    protected static final String[] MDOCUMENT_SUBTAGS = new String[]{"MChemicalStruct", "propertyList", "MMoleculeMovie", "MPolyline", "MEFlow", "MRectangle", "MTextBox", "MBracket", "MNameTextBox", "MRoundedRectangle", "MEllipse"};
    protected static final String[] MAIN_STRUCT_TAGS = new String[]{"molecule", "reaction", "Rgroup"};
    protected static final String[] RGROUP_PART_TAGS = new String[]{"molecule"};
    protected static final String[] MMOLECULEMOVIE_TAGS = new String[]{"MChemicalStruct"};
    protected static final String[] ARRAY_TAG = new String[]{"array"};
    protected static final String[] SCALAR_TAG = new String[]{"scalar"};

    public MrvImportStax(InputStream inputStream) throws IOException {
        super(new MrvInputStream(inputStream));
    }

    public MrvImportStax(InputStream inputStream, String encoding) throws IOException {
        super(new MrvInputStream(inputStream), encoding);
    }

    public boolean isDocumentImporter() {
        return true;
    }

    public MPropertyContainer getGlobalGUIProperties() throws IOException {
        if (this.readHeader) {
            try {
                this.readHeader();
            }
            catch (XMLStreamException e) {
                throw new IOException("Xml format error in input header", e);
            }
            this.readHeader = false;
        }
        return this.globalGUIProperties;
    }

    @Override
    public Molecule read() throws IOException {
        MDocument doc = this.readDocument();
        if (doc != null) {
            return (Molecule)doc.getMainMoleculeGraph();
        }
        return null;
    }

    @Override
    protected MolInputStream openInputStream(InputStream inputStream) throws IOException {
        MolInputStream mis = inputStream instanceof MolInputStream ? (MolInputStream)inputStream : new MolInputStream(inputStream, "mrv");
        return mis;
    }

    @Override
    protected void readHeader() throws XMLStreamException, IOException {
        super.readHeader();
        this.readMarvinHeader();
    }

    private void readMarvinHeader() throws XMLStreamException, IOException {
        if (this.isStartingTagOfArrayIgnoreCase(MHEAD_TAG)) {
            this.recordStartingTag = this.reader.getLocalName();
            this.nextTag();
            if (this.isStartingTagOfArrayIgnoreCase(MARVINGUI_TAG)) {
                this.readHeaderGUIProperties();
            } else {
                this.globalGUIProperties = null;
            }
            if (!this.isEndingTagOfArrayIgnoreCase(MHEAD_TAG)) {
                this.readUntilEndTagOfIgnoreCase(MHEAD_TAG[0]);
            }
        }
    }

    private void readHeaderGUIProperties() throws XMLStreamException, IOException {
        this.globalGUIProperties = new MPropertyContainer();
        int eventCode = this.nextInArray(MPROP_TAG);
        while (eventCode == 1) {
            this.readHeaderGUIProperty();
            this.readUntilEndTagOfIgnoreCase(MPROP_TAG[0]);
            eventCode = this.nextInArray(MPROP_TAG);
        }
    }

    private void readHeaderGUIProperty() throws XMLStreamException, IOException {
        String key = null;
        String xdType = null;
        String value = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            if (this.reader.getAttributeLocalName(i).equals("name")) {
                key = this.reader.getAttributeValue(i);
                continue;
            }
            if (this.reader.getAttributeLocalName(i).equals("dataType")) {
                xdType = this.reader.getAttributeValue(i);
                continue;
            }
            if (!this.reader.getAttributeLocalName(i).equals("value")) continue;
            value = this.reader.getAttributeValue(i);
        }
        if (key == null) {
            throw new MolFormatException("Missing name attribute in mprop tag in GUI description.");
        }
        if (value == null) {
            throw new MolFormatException("Missing value attribute in mprop tag in GUI description.");
        }
        this.globalGUIProperties.set(key, MPropHandler.stringToScalar(xdType, value));
    }

    MDocument readDocument() throws MolFormatException, IOException {
        try {
            if (this.readHeader) {
                this.readHeader();
                this.readHeader = false;
            }
            this.useSgroupAPO = false;
            MDocument doc = this.readMRV();
            if (doc != null) {
                DocumentReader.postProcessDocument(doc, this.useSgroupAPO);
                return doc;
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new IOException("Xml format error in MRV input.", e);
        }
        catch (NullPointerException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in MRV input.", eXml);
            }
            throw new MolFormatException("Error in MRV import: essential information not found in input.", e);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in MRV input.", eXml);
            }
            throw new MolFormatException("Error in MRV import: non-consistent arrays or indexing.", e);
        }
        catch (MolFormatException e) {
            try {
                this.readUntilEndTagOf(this.recordStartingTag);
            }
            catch (XMLStreamException eXml) {
                throw new IOException("Xml format error in MRV input.", eXml);
            }
            throw e;
        }
    }

    private MDocument readMRV() throws XMLStreamException, IOException {
        try {
            if (this.readUntilTag(MRV_START_TAGS)) {
                this.recordStartingTag = this.reader.getLocalName();
                if (this.reader.getLocalName().equals("MDocument")) {
                    return this.readMDocument();
                }
                Molecule mol = this.readCML();
                mol.setInputFormat("mrv");
                MDocument doc = new MDocument(mol);
                doc.setInputFormat("mrv");
                return doc;
            }
            return null;
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    private MDocument readMDocument() throws XMLStreamException, IOException {
        Molecule mol = new Molecule();
        mol.setInputFormat("mrv");
        MDocument doc = new MDocument(mol);
        doc.setInputFormat("mrv");
        boolean mainMolMovieAdded = false;
        boolean mainChemStructAdded = false;
        this.atomSetPointVector = null;
        this.eflowBasePointVector = null;
        this.readMDocumentSettings(doc);
        HashMap<String, MObject> objHash = new HashMap<String, MObject>();
        int eventCode = this.nextInArray(MDOCUMENT_SUBTAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("MChemicalStruct")) {
                MChemicalStruct mcs = this.readChemicalStruct();
                mainChemStructAdded = this.addChemStruct(doc, mcs, mainChemStructAdded);
            } else if (this.reader.getLocalName().equals("propertyList")) {
                this.readGUIProperties(doc);
            } else if (this.reader.getLocalName().equals("MMoleculeMovie")) {
                MMoleculeMovie mm = this.readMoleculeMovie();
                mainMolMovieAdded = this.addMoleculeMovie(doc, mm, mainMolMovieAdded);
            } else if (this.reader.getLocalName().equals("MPolyline")) {
                this.addGraphicsObject(doc, new MPolyline(), objHash);
            } else if (this.reader.getLocalName().equals("MEFlow")) {
                this.addGraphicsObject(doc, new MEFlow(), objHash);
            } else if (this.reader.getLocalName().equals("MRectangle")) {
                this.addGraphicsObject(doc, new MRectangle(), objHash);
            } else if (this.reader.getLocalName().equals("MTextBox")) {
                this.addGraphicsObject(doc, new MTextBox(), objHash);
            } else if (this.reader.getLocalName().equals("MBracket")) {
                this.addGraphicsObject(doc, new MBracket(), objHash);
            } else if (this.reader.getLocalName().equals("MNameTextBox")) {
                this.addGraphicsObject(doc, new MNameTextBox(), objHash);
            } else if (this.reader.getLocalName().equals("MRoundedRectangle")) {
                this.addGraphicsObject(doc, new MRoundedRectangle(), objHash);
            } else {
                this.addGraphicsObject(doc, new MEllipse(), objHash);
            }
            eventCode = this.nextInArray(MDOCUMENT_SUBTAGS);
        }
        DocumentReader.endObjectReading(doc, objHash, this.atomSetPointVector, this.eflowBasePointVector);
        return doc;
    }

    private boolean addChemStruct(MDocument doc, MChemicalStruct mcs, boolean isAlreadyAdded) {
        if (!isAlreadyAdded && mcs != null) {
            Molecule mol = (Molecule)mcs.getMoleculeGraph();
            doc.setMainMoleculeGraph(mol);
            doc.moveMainMoleculeGraphToFront();
            return true;
        }
        doc.addObject(mcs);
        return isAlreadyAdded;
    }

    private boolean addMoleculeMovie(MDocument doc, MMoleculeMovie mm, boolean isAlreadyAdded) {
        if (!isAlreadyAdded) {
            doc.setMoleculeMovie(mm);
            doc.moveMoleculeMovieToFront();
            return true;
        }
        doc.addObject(mm);
        return isAlreadyAdded;
    }

    private void addGraphicsObject(MDocument doc, MObject object, Map<String, MObject> objHash) throws MolFormatException, XMLStreamException {
        this.initGraphicsObject(object, objHash);
        doc.addObject(object);
    }

    private void readGUIProperties(MDocument doc) throws XMLStreamException {
        MProp prop = null;
        int eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        while (eventCode == 1) {
            if (this.modifyPropertyKeyCallback("viewEulerAngles").equals(this.reader.getAttributeValue(null, "dictRef"))) {
                if (this.nextInArray(ARRAY_TAG) == 1) {
                    if (this.reader.getAttributeValue(null, "size") != null) {
                        int size = Integer.valueOf(this.reader.getAttributeValue(null, "size"));
                        this.reader.next();
                        prop = new MDoubleArrayProp(this.reader.getText(), size, -1);
                        doc.properties().set("viewEulerAngles", prop);
                    }
                    this.readUntilEndTagOf(PROPERTYLIST_SUB_SUBTAGS[0]);
                }
            } else if (this.modifyPropertyKeyCallback("scale").equals(this.reader.getAttributeValue(null, "dictRef"))) {
                if (this.nextInArray(SCALAR_TAG) == 1) {
                    this.reader.next();
                    prop = new MDoubleProp(this.reader.getText());
                    doc.properties().set("scale", prop);
                    this.readUntilEndTagOf(PROPERTYLIST_SUB_SUBTAGS[0]);
                }
            } else {
                this.readUntilEndTagOf(PROPERTYLIST_SUB_SUBTAGS[0]);
            }
            eventCode = this.nextInArray(PROPERTYLIST_SUB_SUBTAGS);
        }
    }

    private MMoleculeMovie readMoleculeMovie() throws XMLStreamException, IOException {
        ArrayList<MoleculeGraph> vmols = new ArrayList<MoleculeGraph>();
        int eventCode = this.nextInArray(MMOLECULEMOVIE_TAGS);
        while (eventCode == 1) {
            MChemicalStruct mcs = this.readChemicalStruct();
            vmols.add(mcs.getMoleculeGraph());
            eventCode = this.nextInArray(MMOLECULEMOVIE_TAGS);
        }
        Molecule[] mols = new Molecule[vmols.size()];
        vmols.toArray(mols);
        return new MMoleculeMovie(mols);
    }

    private MChemicalStruct readChemicalStruct() throws XMLStreamException, IOException {
        MChemicalStruct mcs = null;
        MoleculeGraph mol = null;
        int eventCode = this.nextInArray(MAIN_STRUCT_TAGS);
        while (eventCode == 1) {
            if (this.reader.getLocalName().equals("molecule")) {
                mol = this.readMolecule();
                ((Molecule)mol).setInputFormat("mrv");
                mcs = new MChemicalStruct(mol);
            } else if (this.reader.getLocalName().equals("reaction")) {
                RxnMolecule rxn = this.readReaction();
                rxn.setInputFormat("mrv");
                mol = rxn;
                mcs = new MChemicalStruct(mol);
            } else {
                if (mcs == null) {
                    throw new MolFormatException("<molecule> or <reaction> tag must precede <Rgroup>");
                }
                mcs = this.readRgroup(mcs);
                mol = (Molecule)mcs.getMoleculeGraph();
            }
            eventCode = this.nextInArray(MAIN_STRUCT_TAGS);
        }
        if (mol != null) {
            mol.revalidateCoordDependentProps();
            MolImportUtil.fixBeilsteinRDF((Molecule)mol);
        }
        if (mcs == null) {
            mol = new Molecule();
            ((Molecule)mol).setInputFormat("mrv");
            return new MChemicalStruct(mol);
        }
        return mcs;
    }

    private MChemicalStruct readRgroup(MChemicalStruct mcs) throws XMLStreamException, IOException {
        mcs = this.initRgMolecule(mcs);
        RgMolecule rgmol = (RgMolecule)mcs.getMoleculeGraph();
        int id = this.readRgroupId(this.reader.getAttributeValue(null, "rgroupID"));
        String thenR = this.reader.getAttributeValue(null, "thenR");
        String restH = this.reader.getAttributeValue(null, "restH");
        String rlogicRange = this.reader.getAttributeValue(null, "rlogicRange");
        int eventCode = this.nextInArray(RGROUP_PART_TAGS);
        while (eventCode == 1) {
            Molecule m = this.readMolecule();
            m.setInputFormat("mrv");
            rgmol.addRgroup(id, m);
            MoleculeReader.setRlogic(rgmol, id, thenR, restH, rlogicRange);
            eventCode = this.nextInArray(RGROUP_PART_TAGS);
        }
        return mcs;
    }

    private int readRgroupId(String rgroupId) throws MolFormatException {
        int id = 0;
        try {
            id = Integer.parseInt(rgroupId);
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Rgroup ID \"" + rgroupId + "\" is not an integer");
        }
        return id;
    }

    private MChemicalStruct initRgMolecule(MChemicalStruct mcs) {
        Molecule mol = (Molecule)mcs.getMoleculeGraph();
        MChemicalStruct rgChemStruct = mcs;
        if (!(mol instanceof RgMolecule)) {
            RgMolecule rgmol = new RgMolecule();
            rgmol.setInputFormat("mrv");
            rgmol.setDim(mol.getDim());
            rgmol.setRoot(mol);
            rgChemStruct = new MChemicalStruct(rgmol);
        }
        return rgChemStruct;
    }

    private void readMDocumentSettings(MDocument doc) throws MolFormatException {
        int[][] atomSetRGB = DocumentReader.readSetRGB(this.reader.getAttributeValue(null, "atomSetRGB"), "atomSetRGB", 1);
        DocumentReader.setAtomSetRGB(doc, atomSetRGB);
        Map<Integer, MFont> atomSetFont = PropertyReader.readSetFont(this.reader.getAttributeValue(null, "atomSetFont"), "atomSetFont");
        DocumentReader.setAtomSetFont(doc, atomSetFont);
        int[][] bondSetRGB = DocumentReader.readSetRGB(this.reader.getAttributeValue(null, "bondSetRGB"), "bondSetRGB", 1);
        DocumentReader.setBondSetRGB(doc, bondSetRGB);
        int[][] extraLabelSetRGB = DocumentReader.readSetRGB(this.reader.getAttributeValue(null, "extraLabelSetRGB"), "extraLabelSetRGB", 2);
        DocumentReader.setExtraLabelSetRGB(doc, extraLabelSetRGB);
        Map<Integer, Double> bondSetLT = PropertyReader.readSetLT(this.reader.getAttributeValue(null, "bondSetLineThickness"), "bondSetLineThickness");
        DocumentReader.setBondSetThickness(doc, bondSetLT);
        this.readPageSetting(doc.getPageSettings());
    }

    private void readPageSetting(PageSettings pageSettings) throws MolFormatException {
        DocumentReader.setPageEnabled(pageSettings, this.reader.getAttributeValue(null, "multipageEnabled"));
        DocumentReader.setSelectedPage(pageSettings, this.reader.getAttributeValue(null, "multipageSelectedPage"));
        DocumentReader.setColumnCount(pageSettings, this.reader.getAttributeValue(null, "multipageColumnCount"));
        DocumentReader.setRowCount(pageSettings, this.reader.getAttributeValue(null, "multipageRowCount"));
        if (this.reader.getAttributeValue(null, "multipageWidth") != null) {
            pageSettings.setWidth(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageWidth"), "multipageWidth"));
        }
        if (this.reader.getAttributeValue(null, "multipageHeight") != null) {
            pageSettings.setHeight(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageHeight"), "multipageHeight"));
        }
        if (this.reader.getAttributeValue(null, "multipageLeft") != null) {
            pageSettings.setLeftMargin(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageLeft"), "multipageLeft"));
        }
        if (this.reader.getAttributeValue(null, "multipageRight") != null) {
            pageSettings.setRightMargin(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageRight"), "multipageRight"));
        }
        if (this.reader.getAttributeValue(null, "multipageTop") != null) {
            pageSettings.setTopMargin(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageTop"), "multipageTop"));
        }
        if (this.reader.getAttributeValue(null, "multipageBottom") != null) {
            pageSettings.setBottomMargin(PropertyReader.readDoubleValue(this.reader.getAttributeValue(null, "multipageBottom"), "multipageBottom"));
        }
    }

    @Override
    protected String modifyPropertyKeyCallback(String key) {
        return key;
    }

    @Override
    protected String getParityValue(String readParityValue) {
        if (this.fileFormatVersion == null) {
            return readParityValue.equals("1") ? "-1" : (readParityValue.equals("-1") ? "1" : readParityValue);
        }
        return readParityValue;
    }
}

