/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class MrvInputStream
extends BufferedInputStream {
    private byte[] stayedInBuf = null;
    static final byte[] newSpace = "\\u0020".getBytes();
    static final byte[] oldSpace = "&#32;".getBytes();

    public MrvInputStream(InputStream is) throws IOException {
        super(is);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.stayedInBuf == null) {
            int readByteCount = super.read(b, off, len);
            if (readByteCount == -1) {
                return -1;
            }
            int toReturn = this.convertSpecialSpaces(b, off, len, readByteCount);
            return toReturn;
        }
        if (this.stayedInBuf.length > len) {
            System.arraycopy(this.stayedInBuf, 0, b, off, len);
            byte[] newStayedInBuf = new byte[this.stayedInBuf.length - len];
            System.arraycopy(this.stayedInBuf, len, newStayedInBuf, 0, newStayedInBuf.length);
            this.stayedInBuf = newStayedInBuf;
            return len;
        }
        System.arraycopy(this.stayedInBuf, 0, b, off, this.stayedInBuf.length);
        int readFromStayedInBufCount = this.stayedInBuf.length;
        this.stayedInBuf = null;
        int readByteCount = super.read(b, off + readFromStayedInBufCount, len - readFromStayedInBufCount);
        if (readByteCount == -1) {
            return readFromStayedInBufCount;
        }
        return this.convertSpecialSpaces(b, off, len, readByteCount + readFromStayedInBufCount);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (this.stayedInBuf == null) {
            int b = super.read();
            if (b != oldSpace[0]) {
                return b;
            }
            this.stayedInBuf = new byte[oldSpace.length - 1];
            super.read(this.stayedInBuf, 0, this.stayedInBuf.length);
            if (this.isOldSpacePart(this.stayedInBuf, 0, 1, oldSpace.length - 1)) {
                this.stayedInBuf = new byte[newSpace.length - 1];
                System.arraycopy(newSpace, 1, this.stayedInBuf, 0, this.stayedInBuf.length);
                return newSpace[0];
            }
            return b;
        }
        byte b = this.stayedInBuf[0];
        if (this.stayedInBuf.length == 1) {
            this.stayedInBuf = null;
            return b;
        }
        byte[] newStayedInBuf = new byte[this.stayedInBuf.length - 1];
        System.arraycopy(this.stayedInBuf, 1, newStayedInBuf, 0, newStayedInBuf.length);
        this.stayedInBuf = newStayedInBuf;
        return b;
    }

    private int convertSpecialSpaces(byte[] buf, int startPos, int bufLength, int readLength) throws IOException {
        int firstSpacePos = this.seekSpecialSpace(buf, startPos, readLength);
        if (firstSpacePos == -1) {
            return this.checkForSpaceAtEnd(buf, startPos, bufLength, readLength);
        }
        int bufPos = firstSpacePos + oldSpace.length;
        byte[] innerBuf = new byte[(readLength - firstSpacePos) * 2];
        System.arraycopy(newSpace, 0, innerBuf, 0, newSpace.length);
        int innerBufPos = newSpace.length;
        int spacePos = this.seekSpecialSpace(buf, startPos + bufPos, readLength - bufPos);
        while (spacePos != -1) {
            System.arraycopy(buf, startPos + bufPos, innerBuf, innerBufPos, spacePos);
            System.arraycopy(newSpace, 0, innerBuf, innerBufPos += spacePos, newSpace.length);
            innerBufPos += newSpace.length;
            spacePos = this.seekSpecialSpace(buf, startPos + (bufPos += spacePos + oldSpace.length), readLength - bufPos);
        }
        System.arraycopy(buf, startPos + bufPos, innerBuf, innerBufPos, readLength - bufPos);
        spacePos = this.seekSpaceStartAtBufferEnd(buf, startPos, readLength);
        if (spacePos == -1) {
            return firstSpacePos + this.copyBufferToFit(innerBuf, 0, innerBufPos += readLength - bufPos, buf, startPos + firstSpacePos, bufLength - firstSpacePos);
        }
        innerBufPos += spacePos - bufPos;
        innerBufPos = this.rereadForSpaceFinish(innerBuf, 0, innerBufPos, innerBuf.length, readLength - spacePos);
        return firstSpacePos + this.copyBufferToFit(innerBuf, 0, innerBufPos, buf, startPos + firstSpacePos, bufLength - firstSpacePos);
    }

    private int checkForSpaceAtEnd(byte[] buf, int startPos, int bufLength, int readLength) throws IOException {
        int spacePos = this.seekSpaceStartAtBufferEnd(buf, startPos, readLength);
        if (spacePos == -1) {
            return readLength;
        }
        return this.rereadForSpaceFinish(buf, startPos, spacePos, bufLength, readLength - spacePos);
    }

    private int seekSpecialSpace(byte[] buf, int startPos, int length) {
        for (int i = 0; i <= length - oldSpace.length; ++i) {
            if (!this.isOldSpacePart(buf, startPos + i, 0, oldSpace.length)) continue;
            return i;
        }
        return -1;
    }

    private int copyNewSpace(byte[] buf, int startPos, int bufPos, int bufLength) {
        return bufPos + this.copyBufferToFit(newSpace, 0, newSpace.length, buf, startPos + bufPos, bufLength);
    }

    private int seekSpaceStartAtBufferEnd(byte[] buf, int startPos, int length) throws IOException {
        int bufPos;
        for (int i = bufPos = (lastBytesCount = length - oldSpace.length + 1) > 0 ? lastBytesCount : 0; i < length; ++i) {
            if (!this.isOldSpacePart(buf, startPos + i, 0, length - i)) continue;
            return i;
        }
        return -1;
    }

    private int rereadForSpaceFinish(byte[] buf, int startPos, int spacePos, int bufLength, int oldSpacePos) throws IOException {
        int bufPos = spacePos + oldSpacePos;
        byte[] innerBuf = new byte[oldSpace.length - oldSpacePos];
        int spaceReadCount = super.read(innerBuf, 0, innerBuf.length);
        if (spaceReadCount == -1) {
            return bufPos;
        }
        if (this.isOldSpacePart(innerBuf, 0, oldSpacePos, innerBuf.length)) {
            return this.copyNewSpace(buf, startPos, spacePos, bufLength);
        }
        int fitsInBufCount = bufLength - bufPos;
        if (spaceReadCount > fitsInBufCount) {
            this.stayedInBuf = new byte[spaceReadCount - fitsInBufCount];
            System.arraycopy(innerBuf, 0, buf, startPos + bufPos, fitsInBufCount);
            System.arraycopy(innerBuf, fitsInBufCount, this.stayedInBuf, 0, this.stayedInBuf.length);
            return bufLength;
        }
        System.arraycopy(innerBuf, 0, buf, startPos + bufPos, spaceReadCount);
        return bufPos + spaceReadCount;
    }

    private int copyBufferToFit(byte[] fromBuf, int fromBufStart, int fromBufLen, byte[] toBuf, int toBufPos, int toBufLen) {
        if (fromBufLen > toBufLen) {
            System.arraycopy(fromBuf, fromBufStart, toBuf, toBufPos, toBufLen);
            this.stayedInBuf = new byte[fromBufLen - toBufLen];
            System.arraycopy(fromBuf, fromBufStart + toBufLen, this.stayedInBuf, 0, this.stayedInBuf.length);
            return toBufLen;
        }
        System.arraycopy(fromBuf, fromBufStart, toBuf, toBufPos, fromBufLen);
        return fromBufLen;
    }

    private boolean isOldSpacePart(byte[] buf, int pos, int oldSpacePos, int length) {
        int i;
        for (i = 0; i < length && buf[pos + i] == oldSpace[oldSpacePos + i]; ++i) {
        }
        return i == length;
    }
}

