/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class MrvPrettyPrinter {
    private static TransformerFactory factory = null;
    private static Transformer transformer = null;
    private static boolean isInitialized = false;

    private static void init() throws TransformerConfigurationException {
        if (!isInitialized) {
            factory = TransformerFactory.newInstance();
            factory.setAttribute("indent-number", 2);
            transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            isInitialized = true;
        }
    }

    public static ByteArrayOutputStream prettyPrint(ByteArrayOutputStream bout) throws TransformerException {
        MrvPrettyPrinter.init();
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(resultStream);
        StreamSource source = new StreamSource(new ByteArrayInputStream(bout.toByteArray()));
        transformer.transform(source, result);
        return resultStream;
    }

    public static String prettyPrint(String mrv) throws TransformerException {
        MrvPrettyPrinter.init();
        ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(resultStream);
        StreamSource source = new StreamSource(new ByteArrayInputStream(mrv.getBytes()));
        transformer.transform(source, result);
        return resultStream.toString();
    }

    public static String prettyPrintWithoutXmlTag(String mrv) throws TransformerException {
        String first5 = mrv.substring(0, 5);
        String result = MrvPrettyPrinter.prettyPrint(mrv);
        int startsAt = result.indexOf(first5);
        return result.substring(startsAt);
    }
}

