/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.struc.MolAtom;
import chemaxon.struc.graphics.MFont;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PropertyReader {
    static Map<Integer, Double> readSetLT(String val, String propname) throws MolFormatException {
        if (val == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(val, ", \t\n\r");
        int n = st.countTokens();
        HashMap<Integer, Double> lth = new HashMap<Integer, Double>();
        for (int i = 0; i < n; ++i) {
            String s = st.nextToken();
            int k = s.indexOf(58);
            if (k < 0) {
                throw new MolFormatException("MDocument property \"" + propname + "\" is in bad format");
            }
            int setNo = Integer.parseInt(s.substring(0, k));
            lth.put(new Integer(setNo), Double.valueOf(s.substring(k + 1)));
        }
        return lth;
    }

    static double readDoubleValue(String val, String property) throws MolFormatException {
        double doubleVal = 0.0;
        try {
            doubleVal = Double.parseDouble(val);
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("MDocument property \"" + property + "\" is in bad format," + " double expected.");
        }
        return doubleVal;
    }

    static Map<Integer, MFont> readSetFont(String val, String propname) throws MolFormatException {
        if (val == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(val, ",\t\n\r");
        int n = st.countTokens();
        HashMap<Integer, MFont> fh = new HashMap<Integer, MFont>();
        for (int i = 0; i < n; ++i) {
            String s = st.nextToken();
            int k = s.indexOf(58);
            if (k < 0) {
                throw new MolFormatException("MDocument property \"" + propname + "\" is in bad format");
            }
            int setNo = Integer.parseInt(s.substring(0, k));
            fh.put(new Integer(setNo), new MFont(s.substring(k + 1)));
        }
        return fh;
    }

    static double[] getTagPropertyAsDoubleArray(String s) throws MolFormatException {
        if (s != null) {
            StringTokenizer st = new StringTokenizer(s);
            int n = st.countTokens();
            try {
                double[] x = new double[n];
                for (int i = 0; i < n; ++i) {
                    x[i] = Double.valueOf(st.nextToken());
                }
                return x;
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("invalid number in floating point array");
            }
        }
        return null;
    }

    static Object getValue(String value, String dataType) {
        if (dataType.equals("string")) {
            return value;
        }
        if (dataType.equals("integer")) {
            return Integer.valueOf(value);
        }
        if (dataType.equals("boolean")) {
            return Boolean.valueOf(value);
        }
        if (dataType.equals("double")) {
            return Double.valueOf(value);
        }
        if (dataType.equals("float")) {
            return Float.valueOf(value);
        }
        return null;
    }

    static void readAtomProperties(String key, String value, String dataType, MolAtom a) throws MolFormatException {
        if (key == null) {
            throw new MolFormatException("Missing title attribute in <scalar> tag of atom description");
        }
        if (value == null) {
            throw new MolFormatException("Missing value attribute in <scalar> tag of atom description");
        }
        if (dataType == null) {
            throw new MolFormatException("Missing dataType attribute in <scalar> tag of atom description");
        }
        if (dataType.startsWith("xsd:")) {
            dataType = dataType.substring(4);
            a.putProperty(key, PropertyReader.getValue(value, dataType));
        }
    }
}

