/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.cml;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.formats.cml.AtomReader;
import chemaxon.marvin.io.formats.cml.ParsedData;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.util.Map;
import java.util.StringTokenizer;

public class SgroupReader {
    static void readConnectivity(String connect, RepeatingUnitSgroup csg) {
        if (connect != null) {
            if (connect.equalsIgnoreCase("hh")) {
                csg.setConnectivity(1);
            } else if (connect.equalsIgnoreCase("ht")) {
                csg.setConnectivity(2);
            } else if (connect.equalsIgnoreCase("eu")) {
                csg.setConnectivity(0);
            }
        }
    }

    static void setParentSgroup(MolAtom[] patoms, RepeatingUnitSgroup csg, Sgroup sg) {
        if (patoms.length != 0 && patoms[0].getParent() instanceof Molecule) {
            int i;
            Molecule parentMol = (Molecule)patoms[0].getParent();
            for (i = 0; i < patoms.length; ++i) {
                parentMol.setSgroupParent(patoms[i], sg, false);
            }
            parentMol.ungroupSgroup(sg);
            for (i = 0; i < patoms.length; ++i) {
                parentMol.setSgroupParent(patoms[i], csg, true);
            }
        }
    }

    static int getSubTypeFromName(String name) {
        if (name.equals("AlternatingCopolymerSgroup")) {
            return 1;
        }
        if (name.equals("BlockCopolymerSgroup")) {
            return 3;
        }
        if (name.equals("RandomCopolymerSgroup")) {
            return 2;
        }
        return 0;
    }

    static RepeatingUnitSgroup createRUSgroup(Molecule parentMol, String role, Sgroup sg, SelectionMolecule smol) {
        RepeatingUnitSgroup csg = new RepeatingUnitSgroup(parentMol, SgroupReader.getPolymerFromName(role));
        csg.setSubType(SgroupReader.getSubTypeFromName(role));
        MolAtom[] patoms = smol.getAtomArray();
        SgroupReader.setParentSgroup(patoms, csg, sg);
        csg.setSubscript(sg.getSubscript());
        csg.setChargeLocation(sg.getChargeLocation());
        return csg;
    }

    static Sgroup createSimpleSgroup(Map<String, MolAtom> idAtomHash0, ParsedData parsedData, String atomRefs, String role, Sgroup sg, Molecule parentMol, String id, Sgroup psg, Map<String, Sgroup> sghash) throws MolFormatException {
        int i;
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(atomRefs, smol, parsedData, idAtomHash0);
        Sgroup csg = sg;
        if (role.equals("ComponentSgroup")) {
            if (csg.getType() != 13) {
                csg = new Sgroup(parentMol, 13);
            }
        } else if (role.equals("MixtureSgroup")) {
            if (csg.getType() != 8) {
                csg = new Sgroup(parentMol, 8);
            }
        } else if (role.equals("FormulationSgroup")) {
            if (csg.getType() != 9) {
                csg = new Sgroup(parentMol, 9);
            }
        } else if (role.equals("GenericSgroup")) {
            if (csg.getType() != 12) {
                csg = new Sgroup(parentMol, 12);
            }
        } else if (role.equals("MerSgroup")) {
            if (csg.getType() != 4) {
                csg = new Sgroup(parentMol, 4);
            }
        } else if (role.equals("MonomerSgroup") && csg.getType() != 3) {
            csg = new Sgroup(parentMol, 3);
        }
        MolAtom[] patoms = smol.getAtomArray();
        if (csg != sg) {
            for (i = 0; i < patoms.length; ++i) {
                parentMol.setSgroupParent(patoms[i], sg, false);
            }
            parentMol.ungroupSgroup(sg);
            csg.setSubscript(sg.getSubscript());
        }
        if (psg != null) {
            psg.addChildSgroup(csg);
        }
        for (i = 0; i < patoms.length; ++i) {
            parentMol.setSgroupParent(patoms[i], csg, true);
        }
        csg.setChargeLocation(sg.getChargeLocation());
        sghash.put(id, csg);
        return csg;
    }

    static DataSgroup createDataSgroup(Molecule parentMolecule, String atomRefs, Map<String, MolAtom> idAtomHash0, ParsedData parsedData, Sgroup sg) throws MolFormatException {
        int i;
        SelectionMolecule smol = new SelectionMolecule();
        MolAtom[] atoms = SgroupReader.readSelectionMol(atomRefs, smol, parsedData, idAtomHash0) ? smol.getAtomArray() : sg.getAtomArray();
        Molecule parentMol = atoms.length == 0 ? parentMolecule : (Molecule)atoms[0].getParent();
        DataSgroup dsg = new DataSgroup(parentMol);
        parentMol.addSgroup(dsg, true);
        for (i = 0; i < atoms.length; ++i) {
            parentMol.setSgroupParent(atoms[i], sg, false);
        }
        parentMol.ungroupSgroup(sg);
        for (i = 0; i < atoms.length; ++i) {
            parentMol.setSgroupParent(atoms[i], dsg, true);
        }
        return dsg;
    }

    static void addAtomsRecursively(SelectionMolecule target, Sgroup src) {
        int i;
        if (src instanceof Expandable) {
            if (((Expandable)((Object)src)).isExpanded()) {
                for (i = 0; i < src.getAtomCount(); ++i) {
                    if (target.indexOf(src.getAtom(i)) != -1) continue;
                    target.add(src.getAtom(i));
                }
            } else if (src instanceof SuperatomSgroup) {
                SgroupAtom a = ((SuperatomSgroup)src).getSuperAtom();
                if (target.indexOf(a) == -1) {
                    target.add(a);
                }
            } else if (src instanceof MultipleSgroup) {
                MultipleSgroup msg = (MultipleSgroup)src;
                for (int i2 = 0; i2 < msg.getRepeatingUnitAtomCount(); ++i2) {
                    MolAtom a = msg.getRepeatingUnitAtom(i2);
                    if (target.indexOf(a) != -1) continue;
                    target.add(a);
                }
            }
        } else {
            for (int i3 = 0; i3 < src.getAtomCount(); ++i3) {
                if (target.indexOf(src.getAtom(i3)) != -1) continue;
                target.add(src.getAtom(i3));
            }
        }
        if (!(src instanceof SuperatomSgroup) || !((SuperatomSgroup)src).isContracted()) {
            for (i = 0; i < src.getChildSgroupCount(); ++i) {
                SgroupReader.addAtomsRecursively(target, src.getChildSgroup(i));
            }
        }
    }

    static void readSuperatomSgroup(Sgroup sg, Molecule parentMol, Molecule smol0) {
        int i;
        SelectionMolecule smol = sg.getSgroupGraph();
        smol.fuse(smol0);
        for (i = 0; i < sg.getChildSgroupCount(); ++i) {
            SgroupReader.addAtomsRecursively(smol, sg.getChildSgroup(i));
        }
        sg.setSgroupGraph(smol);
        for (i = 0; i < sg.getChildSgroupCount(); ++i) {
            Sgroup child = sg.getChildSgroup(i);
            MolAtom[] patoms = child.getSgroupGraph().getAtomArray();
            for (int j = 0; j < patoms.length; ++j) {
                if (!parentMol.contains(patoms[j])) continue;
                parentMol.setSgroupParent(patoms[j], child, true);
                if (child instanceof SuperatomSgroup && !((SuperatomSgroup)child).isExpanded()) continue;
                parentMol.setSgroupParent(patoms[j], sg, true);
            }
        }
    }

    static MultipleSgroup readMultipleSgroup(Map<String, Sgroup> sghash, Sgroup sg, String title, Molecule parentMol, String id, Sgroup psg, SelectionMolecule smol) {
        int i;
        MolAtom[] atoms = sg.getAtomArray();
        MolAtom[] patoms = smol.getAtomArray();
        for (int i2 = 0; i2 < atoms.length; ++i2) {
            parentMol.setSgroupParent(atoms[i2], sg, false);
        }
        parentMol.ungroupSgroup(sg);
        MultipleSgroup mulsg = new MultipleSgroup(parentMol, title == null);
        if (title != null) {
            mulsg.setSubscript(title);
        } else {
            mulsg.setMultiplier(atoms.length / patoms.length);
        }
        for (i = 0; i < atoms.length; ++i) {
            parentMol.setSgroupParent(atoms[i], mulsg, true);
        }
        for (i = 0; i < patoms.length; ++i) {
            mulsg.setRepeatingUnitAtom(patoms[i], true);
        }
        sghash.put(id, mulsg);
        if (psg != null) {
            psg.addChildSgroup(mulsg);
        }
        return mulsg;
    }

    static void replaceSgroup(Sgroup sg, Molecule parentMol, String id, Sgroup psg, Map<String, Sgroup> sghash, SuperatomSgroup csg) throws MolFormatException {
        int i;
        MolAtom[] patoms = sg.getAtomArray();
        sg.getSgroupGraph();
        if (csg != sg) {
            for (i = 0; i < patoms.length; ++i) {
                if (parentMol.indexOf(patoms[i]) <= -1) continue;
                parentMol.setSgroupParent(patoms[i], sg, false);
            }
            parentMol.ungroupSgroup(sg);
            csg.setSubscript(sg.getSubscript());
        }
        if (psg != null) {
            // empty if block
        }
        for (i = 0; i < patoms.length; ++i) {
            if (parentMol.indexOf(patoms[i]) <= -1) continue;
            parentMol.setSgroupParent(patoms[i], csg, true);
        }
        sghash.put(id, csg);
    }

    static Sgroup createSgroup(Sgroup psg, Map<String, Sgroup> sghash, String role, String id, Molecule parentMol) throws MolFormatException {
        Sgroup sg = sghash.get(id);
        if (sg == null) {
            sg = SgroupReader.createSgroup(role, parentMol);
        } else if (role.equals("SuperatomSgroup") && !(sg instanceof SuperatomSgroup)) {
            SuperatomSgroup ssg = new SuperatomSgroup(sg.getParentMolecule());
            SgroupReader.replaceSgroup(sg, sg.getParentMolecule(), id, psg, sghash, ssg);
            sg = ssg;
        }
        return sg;
    }

    static boolean isAcceptableRole(String id, String role) {
        return id != null && role != null && (role.equals("Sgroup") || role.equals("SuperatomSgroup") || role.equals("MultipleSgroup") || role.equals("DataSgroup") || role.equals("ComponentSgroup") || role.equals("MixtureSgroup") || role.equals("FormulationSgroup") || role.equals("SruSgroup") || role.equals("MulticenterSgroup") || role.equals("GenericSgroup") || role.equals("MerSgroup") || role.equals("MonomerSgroup") || SgroupReader.getPolymerFromName(role) > -1);
    }

    static Sgroup createSgroup(String role, Molecule parentMol) throws MolFormatException {
        Sgroup sg = null;
        if (role.equals("SuperatomSgroup")) {
            sg = new SuperatomSgroup(parentMol);
        } else if (role.equals("MultipleSgroup")) {
            sg = new Sgroup(parentMol, 1);
        } else if (role.equals("DataSgroup")) {
            sg = new Sgroup(parentMol, 10);
        } else if (role.equals("ComponentSgroup")) {
            sg = new Sgroup(parentMol, 13);
        } else if (role.equals("MixtureSgroup")) {
            sg = new Sgroup(parentMol, 8);
        } else if (role.equals("FormulationSgroup")) {
            sg = new Sgroup(parentMol, 9);
        } else if (role.equals("SruSgroup")) {
            sg = new Sgroup(parentMol, 2);
        } else if (role.equals("MulticenterSgroup")) {
            sg = new Sgroup(parentMol, 14);
        } else if (role.equals("GenericSgroup")) {
            sg = new Sgroup(parentMol, 12);
        } else if (role.equals("MerSgroup")) {
            sg = new Sgroup(parentMol, 4);
        } else if (role.equals("MonomerSgroup")) {
            sg = new Sgroup(parentMol, 3);
        } else if (SgroupReader.getPolymerFromName(role) > -1) {
            sg = new Sgroup(parentMol, SgroupReader.getPolymerFromName(role));
        } else {
            throw new MolFormatException("Invalid Sgroup type");
        }
        return sg;
    }

    static String readGeneralSgroupAttributes(String title, String chargeLocation, Sgroup sg) {
        if (title != null) {
            sg.setSubscript(title);
        }
        if (chargeLocation != null) {
            if (chargeLocation.equals("onAtoms")) {
                sg.setChargeLocation(1);
            } else if (chargeLocation.equals("onBracket")) {
                sg.setChargeLocation(2);
            }
        }
        return title;
    }

    static int getPolymerFromName(String name) {
        if (name.equals("AnyPolymerSgroup")) {
            return 11;
        }
        if (name.equals("AlternatingCopolymerSgroup") || name.equals("BlockCopolymerSgroup") || name.equals("RandomCopolymerSgroup") || name.equals("CopolymerSgroup")) {
            return 5;
        }
        if (name.equals("CrosslinkSgroup")) {
            return 6;
        }
        if (name.equals("GraftSgroup")) {
            return 15;
        }
        if (name.equals("ModificationSgrop") || name.equals("ModificationSgroup")) {
            return 7;
        }
        if (name.equals("SruSgroup")) {
            return 2;
        }
        return -1;
    }

    static boolean readSelectionMol(String elem, SelectionMolecule smol, ParsedData parsedData, Map<String, MolAtom> idAtomHash0) throws MolFormatException {
        smol.removeAll();
        if (elem != null) {
            StringTokenizer st = new StringTokenizer(elem);
            while (st.hasMoreTokens()) {
                String sid = st.nextToken();
                MolAtom a = parsedData.idAtomHash.get(sid);
                if (a == null && (a = idAtomHash0.get(sid)) == null) {
                    throw new MolFormatException("unknown atom ID \"" + sid + "\"");
                }
                smol.add(a);
            }
            return true;
        }
        return false;
    }

    static MolAtom readCentralAtom(String elem, Map<String, MolAtom> idAtomHash, Map<String, MolAtom> idAtomHash0) throws MolFormatException {
        MolAtom a = null;
        if (elem != null && (a = idAtomHash.get(elem)) == null && (a = idAtomHash0.get(elem)) == null) {
            throw new MolFormatException("unknown atom ID \"" + elem + "\"");
        }
        return a;
    }

    static void readMulticenterSgroup(String atomRefs, String center, Sgroup sg, String id, Sgroup psg, Map<String, Sgroup> sghash, ParsedData parsedData, Map<String, MolAtom> idAtomHash0, Molecule parentMol) throws MolFormatException {
        int i;
        Molecule mol = parentMol;
        if (psg != null && psg instanceof Expandable && ((Expandable)((Object)psg)).isExpanded()) {
            mol = psg.getParentMolecule();
        }
        SelectionMolecule smol = new SelectionMolecule();
        SgroupReader.readSelectionMol(atomRefs, smol, parsedData, idAtomHash0);
        MulticenterSgroup csg = new MulticenterSgroup(mol);
        csg.setChargeLocation(sg.getChargeLocation());
        MolAtom[] patoms = smol.getAtomArray();
        for (i = 0; i < patoms.length; ++i) {
            mol.setSgroupParent(patoms[i], sg, false);
        }
        mol.ungroupSgroup(sg);
        for (i = 0; i < patoms.length; ++i) {
            mol.setSgroupParent(patoms[i], csg, true);
        }
        csg.setCentralAtom(SgroupReader.readCentralAtom(center, parsedData.idAtomHash, idAtomHash0));
        sghash.put(id, csg);
        if (psg != null) {
            psg.addChildSgroup(csg);
        }
    }

    public static void readSgroupReferences(Molecule mol, Sgroup psg, ParsedData parsedData, boolean[] isRgroup, String array) throws MolFormatException {
        StringTokenizer st = new StringTokenizer(array);
        int i = 0;
        try {
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                AtomReader.setAtomSgroupRef(mol, i, s, psg, isRgroup != null && isRgroup[i], parsedData);
                ++i;
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new MolFormatException("Reference to non-existing atom index in input in attribute sgroupRef", e);
        }
    }
}

