/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.d2s;

import chemaxon.formats.MolFormatException;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.d2s.D2SRecordReader;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class D2SImportModule
extends MolImportModule {
    private Molecule nextMolecule;

    @Override
    public void initMolImport(MRecord record, String fname) {
        this.nextMolecule = ((D2SRecordReader.LoadedMolRecord)record).molecule;
        this.nextMolecule.setProperty("document", fname);
    }

    @Override
    public boolean readMol(Molecule m) throws MolFormatException, IOException {
        if (this.nextMolecule != null) {
            this.nextMolecule.clonecopy(m);
            return true;
        }
        return false;
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    @Override
    public void setOptions(String options) throws IllegalArgumentException {
    }
}

