/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.d2s;

import chemaxon.common.util.LongVector;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.AbstractMRecordReader;
import chemaxon.marvin.io.formats.name.NameImport;
import chemaxon.marvin.io.formats.name.util.TextUtils;
import chemaxon.naming.document.D2S;
import chemaxon.struc.Molecule;
import chemaxon.util.LoggingUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class D2SRecordReader
extends AbstractMRecordReader {
    private D2S d2s;
    private ArrayList<Molecule> structures = new ArrayList();
    private LongVector filePositions = new LongVector();
    private int position;
    private static final Logger logger = LoggingUtil.getLogger(D2SRecordReader.class);

    public D2SRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        this.d2s = new D2S(istr, this.parseOptions(opts));
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        if (!this.ensure(this.position)) {
            return null;
        }
        Molecule next = this.structures.get(this.position);
        long filePos = this.filePositions.get(this.position);
        ++this.position;
        LoadedMolRecord res = new LoadedMolRecord(next, filePos);
        return res;
    }

    private boolean ensure(int target) {
        while (this.structures.size() <= target) {
            if (!this.d2s.hasNext()) {
                return false;
            }
            Molecule m = this.d2s.next();
            this.structures.add(m);
            Long filePos = (Long)m.properties().getObject("byte");
            m.properties().set("byte", null);
            if (filePos == null) {
                filePos = 0L;
            }
            this.filePositions.add(filePos);
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("Loaded structure #" + this.structures.size());
        }
        return true;
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord();
    }

    @Override
    public void seek(long p, int lcount, int k) throws IOException {
        this.position = k;
    }

    public D2S.Options parseOptions(String options) {
        String[] opts;
        D2S.Options res = new D2S.Options();
        if (options == null || options.length() == 0) {
            return res;
        }
        String[] arr$ = opts = TextUtils.split(options, ',');
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String opt;
            String originalOption = opt = arr$[i$];
            opt = opt.toLowerCase();
            boolean negative = false;
            if (opt.startsWith("-")) {
                negative = true;
                opt = opt.substring(1);
            } else if (opt.startsWith("+")) {
                opt = opt.substring(1);
            }
            if (opt.startsWith("cas")) {
                res.enableCAS(!negative);
                continue;
            }
            if (opt.startsWith("smiles")) {
                res.enableSmiles = !negative;
                continue;
            }
            if (opt.startsWith("inchi")) {
                res.enableInChI = !negative;
                continue;
            }
            if (opt.equals("osra")) {
                res.enableOSRA = !negative;
                continue;
            }
            if (opt.startsWith("insidetag=")) {
                String tag = opt.substring("insideTag=".length());
                res.insideTag(tag);
                continue;
            }
            if (NameImport.applyOption(originalOption, res.n2sOptions) || opt.equals("nod2s")) continue;
            System.err.println("Ignoring unknown option: " + opt);
        }
        return res;
    }

    static class LoadedMolRecord
    extends MRecord {
        final Molecule molecule;

        LoadedMolRecord(Molecule m, long fileEndPosition) {
            super(0L, fileEndPosition, 0, m.getName(), null, null);
            this.molecule = m;
        }
    }
}

