/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.marvin.io.formats.xyz.XYZImport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.io.IOException;

public class CubeImport
extends XYZImport {
    private static final double BOHR_TO_ANGSTROMS_FACTOR = 0.5291772;

    private static double convertAfterImport(double v) {
        return v * 0.5291772;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        mol.clearForImport("cube");
        mol.setDim(3);
        if (!this.skipLines(2)) {
            return false;
        }
        if (this.readLine() == null) {
            return false;
        }
        int na = this.readInteger();
        if (!this.skipLines(3)) {
            return false;
        }
        for (int i = 0; i < na; ++i) {
            if (this.readLine() == null) {
                return false;
            }
            int atno = this.readInteger();
            this.readCoordinate();
            double x = CubeImport.convertAfterImport(this.readCoordinate());
            double y = CubeImport.convertAfterImport(this.readCoordinate());
            double z = CubeImport.convertAfterImport(this.readCoordinate());
            MolAtom a = mol.reuseAtom(atno, i);
            a.setXYZ(x, y, z);
        }
        mol.endReuse(na);
        this.bondsFromCoords.calc(mol);
        return true;
    }

    private boolean skipLines(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (this.readLine() != null) continue;
            return false;
        }
        return true;
    }
}

