/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.common.util.MProgressMonitor;
import chemaxon.marvin.io.MPropHandler;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.xyz.XYZRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;

public class CubeRecordReader
extends XYZRecordReader {
    public static final String VDATA_PROPKEY = "VOLUMETRIC_DATA";
    private MProgressMonitor pmon = null;
    private boolean readVolumetricData = true;

    public CubeRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
        if (opts != null && opts.indexOf("M") != -1) {
            this.readVolumetricData = false;
        }
    }

    @Override
    public void setProgressMonitor(MProgressMonitor pmon) {
        this.pmon = pmon;
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        return this.nextRecord(false);
    }

    @Override
    public MRecord skipRecord() throws MRecordParseException, IOException {
        return this.nextRecord(true);
    }

    private MRecord nextRecord(boolean skip) throws MRecordParseException, IOException {
        StringBuffer sb = skip ? null : new StringBuffer();
        StringBuffer vb = skip || !this.readVolumetricData ? null : new StringBuffer();
        long startpos = this.getFilePointer();
        int lineno = this.getLineCount();
        String line = this.readLine();
        if (line == null) {
            return null;
        }
        boolean emptyFirstLine = line.trim().length() == 0;
        CubeRecordReader.appendVolDataLine(vb, line);
        this.appendLine(sb, "-");
        line = this.readLine();
        if (line == null) {
            if (emptyFirstLine) {
                return null;
            }
            throw new MRecordParseException(this.getPosition(), "comment line expected");
        }
        boolean emptySecondLine = line.trim().length() == 0;
        CubeRecordReader.appendVolDataLine(vb, line);
        this.appendLine(sb, "-");
        line = this.readLine();
        if (line == null || line.trim().length() == 0) {
            if (emptyFirstLine && emptySecondLine) {
                return null;
            }
            throw new MRecordParseException(this.getPosition(), "number of atoms and origo coordinates expected");
        }
        LineSplitter splitter = new LineSplitter(line);
        int na = Math.abs(splitter.getInteger());
        this.appendLine(sb, "" + na + "\t0.0\t0.0\t0.0");
        CubeRecordReader.appendVolDataLine(vb, splitter.getRemainder());
        int gridCount = 1;
        for (int i = 0; i < 3; ++i) {
            line = this.readLine();
            if (line == null) {
                throw new MRecordParseException(this.getPosition(), "axis line expected");
            }
            splitter = new LineSplitter(line);
            gridCount *= Math.abs(splitter.getInteger());
            CubeRecordReader.appendVolDataLine(vb, line);
            this.appendLine(sb, "0\t0.0\t0.0\t0.0");
        }
        this.appendLines(sb, na, "atom");
        this.appendGridLines(vb, gridCount);
        MPropertyContainer pc = null;
        if (vb != null) {
            pc = new MPropertyContainer();
            pc.set(VDATA_PROPKEY, MPropHandler.createScalar("VolumetricData", vb.toString(), this.pmon));
        }
        return this.endMolecule(sb != null ? sb.toString() : null, pc, startpos, lineno);
    }

    private void appendLines(StringBuffer sb, int count, String type) throws MRecordParseException, IOException {
        for (int i = 0; i < count; ++i) {
            String line = this.readLine();
            if (line == null) {
                throw new MRecordParseException(this.getPosition(), type + " line expected");
            }
            this.appendLine(sb, line);
        }
    }

    private void appendGridLines(StringBuffer vb, int count) throws MRecordParseException, IOException {
        while (count > 0) {
            String line = this.readLine();
            if (line == null) {
                throw new MRecordParseException(this.getPosition(), "premature and of file: grid line expected");
            }
            CubeRecordReader.appendVolDataLine(vb, line);
            count -= new StringTokenizer(line, " \t\r\n").countTokens();
        }
    }

    private static void appendVolDataLine(StringBuffer vb, String line) {
        if (vb != null) {
            vb.append(line);
            vb.append('\n');
        }
    }

    private class LineSplitter {
        private int integer = 0;
        private String remainder = null;

        LineSplitter(String line) throws MRecordParseException {
            int len = line.length();
            int i = -1;
            while (++i < len && Character.isWhitespace(line.charAt(i))) {
            }
            if (i == len) {
                throw new MRecordParseException(CubeRecordReader.this.getPosition(), line + ": integer expected");
            }
            int j = i;
            while (++j < len && !Character.isWhitespace(line.charAt(j))) {
            }
            try {
                this.integer = Integer.parseInt(line.substring(i, j));
            }
            catch (NumberFormatException e) {
                throw new MRecordParseException(CubeRecordReader.this.getPosition(), line + ": integer expected");
            }
            this.remainder = line.substring(j);
        }

        int getInteger() {
            return this.integer;
        }

        String getRemainder() {
            return this.remainder;
        }
    }
}

