/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.marvin.io.MolExportModule;
import chemaxon.struc.Molecule;

public class GjfExport
extends MolExportModule {
    @Override
    public Object convert(Molecule mol) {
        int i;
        StringBuffer sb = this.stringBuffer;
        sb.setLength(0);
        String commandLine = mol.getProperty("Gaussian_commandline");
        sb.append("--Link1--\n");
        if (commandLine == null) {
            sb.append("# Opt=(Tight,GDIIS) B3LYP/6-31G(d) SCRF");
        } else {
            sb.append(commandLine);
        }
        sb.append('\n');
        sb.append('\n');
        String titleLine = mol.getProperty("Gaussian_titleline");
        if (titleLine == null) {
            try {
                Molecule mol2 = mol.cloneMolecule();
                mol2.implicitizeHydrogens(0);
                sb.append(mol2.exportToFormat("smiles"));
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                sb.append("Generated by Chemaxon/Marvin");
            }
        } else {
            sb.append(titleLine);
        }
        sb.append('\n');
        if (mol.getComment() != null && !mol.getComment().equals("")) {
            sb.append(mol.getComment());
            sb.append("\n");
        }
        sb.append("\n");
        int charge = 0;
        for (i = 0; i < mol.getAtomCount(); ++i) {
            charge += mol.getAtom(i).getCharge();
        }
        sb.append("  ").append(charge).append("  1");
        sb.append("\n");
        for (i = 0; i < mol.getAtomCount(); ++i) {
            sb.append(mol.getAtom(i).getSymbol());
            sb.append(",");
            sb.append(mol.getAtom(i).getX());
            sb.append(",");
            sb.append(mol.getAtom(i).getY());
            sb.append(",");
            sb.append(mol.getAtom(i).getZ());
            sb.append("\n");
        }
        sb.append("\n");
        String extrainput = mol.getProperty("Gaussian_extrainput");
        if (extrainput != null) {
            sb.append(extrainput);
            sb.append("\n");
        }
        return sb.toString();
    }
}

