/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.gaussian;

import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.smiles.SmilesImport;
import chemaxon.marvin.modelling.struc.Substructure3DSearch;
import chemaxon.marvin.modules.BondsFromCoords;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.BitSet;
import java.util.StringTokenizer;

public class GoutImport
extends MolImportModule {
    private MolInputStream istream;
    private int lineCount = 0;
    private boolean connectivityOK = false;
    private BondsFromCoords bondsFromCoords = null;

    @Override
    public void initMolImport(MolInputStream mis) {
        this.istream = mis;
    }

    @Override
    public boolean readMol(Molecule mol) throws IOException {
        Molecule mSmiles;
        mol.clearForImport("gout");
        this.bondsFromCoords = new BondsFromCoords();
        this.bondsFromCoords.initParser();
        this.bondsFromCoords.parseOption("b", 0);
        this.lineCount = 1;
        String commandLine = this.getCommandLine();
        if (commandLine == null) {
            return false;
        }
        String headerLine = this.getHeaderLine();
        if (this.fillFromSmiles(headerLine, mSmiles = this.createMol()) == null) {
            System.err.println("No SMILES string found in header");
        } else {
            mSmiles.hydrogenize(true);
            this.connectivityOK = true;
        }
        mol.setDim(3);
        double energy = 0.0;
        while (this.findCoordinates(mol) && this.findEnergy(mol)) {
        }
        mol.setProperty("Energy_unit", "Hartree");
        mol.setProperty("Gaussian_commandline", commandLine);
        mol.setProperty("Gaussian_titleline", headerLine);
        if (this.connectivityOK) {
            this.mergeBondTypes(mSmiles, mol);
        }
        return true;
    }

    private String getCommandLine() throws IOException {
        String line = "";
        String commandLine = null;
        this.findLineStartingWith("-");
        this.findLineStartingWith("-");
        this.findLineStartingWith("-");
        line = this.istream.readLine();
        ++this.lineCount;
        if (line == null) {
            return null;
        }
        while (!line.startsWith("-", 1)) {
            if (commandLine == null) {
                commandLine = "";
            }
            if (line.length() > 1) {
                commandLine = commandLine + line.substring(1);
            }
            line = this.istream.readLine();
            ++this.lineCount;
            if (line != null) continue;
            return commandLine;
        }
        return commandLine;
    }

    private String getHeaderLine() throws IOException {
        String line = "";
        String headerLine = null;
        this.findLineStartingWith("-");
        line = this.istream.readLine();
        ++this.lineCount;
        if (line == null) {
            return null;
        }
        while (!line.startsWith("-", 1)) {
            if (headerLine == null) {
                headerLine = "";
            }
            if (line.length() > 1) {
                headerLine = headerLine + line.substring(1);
            }
            line = this.istream.readLine();
            ++this.lineCount;
            if (line != null) continue;
            return headerLine;
        }
        return headerLine;
    }

    private String findLineStartingWith(String st) throws IOException {
        String line = "";
        while (!line.startsWith(st, 1)) {
            line = this.istream.readLine();
            ++this.lineCount;
            if (line != null) continue;
            return null;
        }
        return line;
    }

    private boolean findCoordinates(Molecule mol) throws IOException {
        String line = "";
        boolean atomCount = false;
        while (!(line.startsWith("Normal termination", 1) || line.startsWith("Error termination", 1) || line.startsWith("Initial command", 1))) {
            int i;
            line = this.istream.readLine();
            ++this.lineCount;
            if (line == null) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(line);
            String oName = null;
            if (st.countTokens() != 2 || !(oName = st.nextToken()).equals("Standard") && !oName.equals("Z-Matrix") && !oName.equals("Input") || !st.nextToken().equals("orientation:")) continue;
            line = this.istream.readLine();
            line = this.istream.readLine();
            line = this.istream.readLine();
            line = this.istream.readLine();
            this.lineCount += 4;
            if (line == null) {
                return false;
            }
            int nAtoms = 0;
            line = this.istream.readLine();
            st = new StringTokenizer(line);
            do {
                st.nextToken();
                int atNo = Integer.valueOf(st.nextToken());
                st.nextToken();
                double x = Double.valueOf(st.nextToken());
                double y = Double.valueOf(st.nextToken());
                double z = Double.valueOf(st.nextToken());
                MolAtom a = mol.reuseAtom(atNo, nAtoms);
                a.setXYZ(x, y, z);
                ++nAtoms;
            } while ((st = new StringTokenizer(line = this.istream.readLine())).countTokens() > 5);
            mol.endReuse(nAtoms);
            this.bondsFromCoords.calc(mol);
            BitSet bonds = new BitSet(mol.getBondCount());
            for (i = 0; i < mol.getAtomCount(); ++i) {
                for (int j = 0; j < i; ++j) {
                    if (mol.getBondTable().getBondIndex(i, j) == -1) continue;
                    bonds.set(mol.getBondTable().getBondIndex(i, j));
                }
            }
            for (i = mol.getBondCount() - 1; i >= 0; --i) {
                if (bonds.get(i)) continue;
                mol.removeBond(i);
            }
            return true;
        }
        return false;
    }

    private boolean findEnergy(Molecule mol) throws IOException {
        String line = "";
        boolean atomCount = false;
        while (!(line.startsWith("Normal termination", 1) || line.startsWith("Error termination", 1) || line.startsWith("Initial command", 1))) {
            line = this.istream.readLine();
            ++this.lineCount;
            if (line == null) {
                return false;
            }
            StringTokenizer st = new StringTokenizer(line);
            if (st.countTokens() > 4 && st.nextToken().equals("SCF") && st.nextToken().equals("Done:")) {
                st.nextToken();
                st.nextToken();
                String en = st.nextToken();
                double energy = Double.valueOf(en);
                mol.setProperty("Energy", en);
                return true;
            }
            if (st.countTokens() <= 1 || !st.nextToken().equals("Energy=")) continue;
            String en = st.nextToken();
            double energy = Double.valueOf(en);
            mol.setProperty("Energy", en);
            return true;
        }
        return false;
    }

    private String findLastLine() throws IOException {
        String line = "";
        while (!(line.startsWith("Normal termination", 1) || line.startsWith("Error termination", 1) || line.startsWith("Initial command", 1))) {
            line = this.istream.readLine();
            ++this.lineCount;
            if (line != null) continue;
            return null;
        }
        return line;
    }

    @Override
    public Molecule createMol() {
        Molecule mol = new Molecule();
        mol.setDim(0);
        return mol;
    }

    public Molecule fillFromSmiles(String smilesString, Molecule mol) {
        Molecule m = this.createMol();
        SmilesImport si = new SmilesImport();
        try {
            si.readMol(smilesString, m);
            if (m.getAtomCount() == 0) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        int numAtoms = m.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            MolAtom a = mol.reuseAtom(m.getAtom(i).getAtno(), i);
        }
        mol.endReuse(numAtoms);
        int numBonds = m.getBondCount();
        for (int i = 0; i < numBonds; ++i) {
            int atomIndex1 = m.indexOf(m.getBond(i).getAtom1());
            int atomIndex2 = m.indexOf(m.getBond(i).getAtom2());
            int order = m.getBond(i).getType();
            MolBond b = new MolBond(mol.getAtom(atomIndex1), mol.getAtom(atomIndex2), order);
            mol.add(b);
        }
        mol.valenceCheck();
        return mol;
    }

    private void mergeBondTypes(Molecule bondSource, Molecule bondTarget) {
        Substructure3DSearch sSS = new Substructure3DSearch();
        sSS.setMolecules(bondSource, bondTarget);
        sSS.setIgnoreBondType(true);
        sSS.setIgnoreGeometryMatching(true, 0.0);
        if (sSS.findFirst()) {
            bondTarget.removeAllBonds();
            int[] map = sSS.getResult();
            int numBonds = bondSource.getBondCount();
            for (int i = 0; i < numBonds; ++i) {
                int atomIndex1 = map[bondSource.indexOf(bondSource.getBond(i).getAtom1())];
                int atomIndex2 = map[bondSource.indexOf(bondSource.getBond(i).getAtom2())];
                int order = bondSource.getBond(i).getType();
                MolBond b = new MolBond(bondTarget.getAtom(atomIndex1), bondTarget.getAtom(atomIndex2), order);
                bondTarget.add(b);
            }
            bondTarget.setProperty("anyBondsFromCoords", null);
        } else {
            System.err.println("Match NOT found");
            System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            System.err.println(bondSource.toFormat("smiles"));
            System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
            System.err.println(bondTarget.toFormat("sdf"));
            System.err.println("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        }
    }
}

