/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.jtf;

import chemaxon.common.util.Base64Util;
import chemaxon.formats.MFileFormatUtil;
import chemaxon.marvin.io.MRecord;
import chemaxon.marvin.io.MRecordParseException;
import chemaxon.marvin.io.formats.SingleLineRecordReader;
import chemaxon.struc.MPropertyContainer;
import java.io.IOException;
import java.io.InputStream;

public class JTFRecordReader
extends SingleLineRecordReader {
    public JTFRecordReader(InputStream istr, String opts) throws IOException {
        super(istr, opts);
    }

    @Override
    protected String[] parseFieldNamesFromHeaderRow(String line) {
        return MFileFormatUtil.getJTFFields(line);
    }

    @Override
    protected String parseFields(String line, MPropertyContainer pc) {
        String[] fields = MFileFormatUtil.getJTFFields(line);
        String source = null;
        for (int x = 0; x < fields.length; ++x) {
            String field = fields[x];
            if (x >= this.fieldNames.length) continue;
            String fieldName = this.fieldNames[x];
            if (fieldName.equals("CD_STRUCTURE")) {
                source = field;
                continue;
            }
            pc.setString(fieldName, field);
        }
        return source;
    }

    @Override
    public MRecord nextRecord() throws MRecordParseException, IOException {
        MRecord record = super.nextRecord();
        if (record != null) {
            String source = record.getString();
            byte[] bytes = Base64Util.decode(source);
            record.setMolBytes(bytes);
        }
        return record;
    }
}

