/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.mdl;

import chemaxon.common.util.text.SimpleTeX;
import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.marvin.io.formats.mdl.MolImportX;
import chemaxon.marvin.io.formats.mdl.MolfileUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.CTransform3D;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MDocument;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.Expandable;
import chemaxon.struc.sgroup.MulticenterSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import chemaxon.struc.sgroup.SuperatomSgroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MolImport
extends MolImportModule
implements StereoConstants {
    private static final Map<String, Integer> SGROUP_SUBTYPES;
    private static final int XYZSCALE_SET = 1;
    private static final int XYZSCALE_AVERAGE = 2;
    private static final int[] OLD_ATNO_MAP;
    static final int FMT_COMPRESSED = 1;
    static final int FMT_SDF = 2;
    static final int FMT_V3 = 4;
    static final String NOSCALEOPT = "b1.54";
    static final String[] FORMATS;
    String currentLine;
    int currentColumn;
    String generatorProgram;
    private boolean isCompressed;
    private double xyzScale;
    private int xyzScaleMode = 0;
    MolInputStream molInputStream;
    private Sgroup[] sgroups = null;
    private HashMap<Integer, ArrayList<MolBond>> sgroupBonds = null;
    private HashMap<Integer, ArrayList<MolBond>> sgroupConnections = null;
    private int sgroupCount;
    int molfileVersion;
    private boolean skipMMRV = false;
    private boolean expandAllSgroups = false;
    private boolean ungroupAllSgroups = false;
    private boolean readAtomValues = true;
    Set<Sgroup> expandedSgroups = null;
    ArrayList<Sgroup> roundedBrackets = null;
    private boolean isLastSED = false;
    boolean inputIsRDF = false;
    private int origInputFormatFlags = 0;

    @Override
    public void setOptions(String opts) {
        this.skipMMRV = false;
        this.expandAllSgroups = false;
        this.ungroupAllSgroups = false;
        this.expandedSgroups = null;
        this.inputIsRDF = false;
        if (opts != null) {
            for (int i = 0; i < opts.length(); ++i) {
                int j;
                char c = opts.charAt(i);
                if (opts.length() >= i + "nomolp".length() && opts.substring(i, 6).equals("nomolp")) {
                    i += "nomolp".length();
                    continue;
                }
                if (opts.length() >= i + "skipMMRV".length() && opts.substring(i, 8).equals("skipMMRV")) {
                    this.skipMMRV = true;
                    i += "skipMMRV".length();
                    continue;
                }
                if (opts.length() >= i + "skipAtomValue".length() && opts.substring(i, "skipAtomValue".length()).equals("skipAtomValue")) {
                    this.readAtomValues = false;
                    i += "skipAtomValue".length();
                    continue;
                }
                if (c == 'X' || c == 'U') {
                    if (i + 2 < opts.length() && opts.substring(i + 1, i + 3).equals("sg")) {
                        if (c == 'X') {
                            this.expandAllSgroups = true;
                        } else {
                            this.ungroupAllSgroups = true;
                        }
                        i += 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown import option(s) " + opts.substring(i));
                }
                if (c != 'b') continue;
                for (j = i + 1; j < opts.length(); ++j) {
                    c = opts.charAt(j);
                    if (j == i + 1 && c == 'A') {
                        ++j;
                        break;
                    }
                    if ((c < '0' || c > '9') && c != '.') break;
                }
                String s = opts.substring(i + 1, j);
                try {
                    if (s.equals("A")) {
                        this.xyzScaleMode = 2;
                    } else {
                        double blen = Double.valueOf(s);
                        this.xyzScale = blen == 0.0 ? 1.0 : 1.54 / blen;
                        this.xyzScaleMode = 1;
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
                i = j;
            }
        }
    }

    @Override
    public void initMolImport(MolInputStream is) throws MolFormatException, IOException {
        this.setMolInputStream(is);
        String line = is.readLine();
        if (line != null) {
            if (line.startsWith("$RDFILE ")) {
                String s = line.substring(8);
                if (!s.startsWith("1")) {
                    throw new MolFormatException("Only version 1 RDfiles can be imported");
                }
                line = is.readLine();
                if (line == null) {
                    throw new MolFormatException("Missing \"$DATM\" line in RDfile");
                }
                if (!line.startsWith("$DATM")) {
                    throw new MolFormatException("Bad RDfile line, \"$DATM\" expected");
                }
            } else {
                is.putBackLine();
            }
        }
    }

    void setMolInputStream(MolInputStream is) {
        this.molInputStream = is;
    }

    @Override
    public boolean readMol(Molecule mol) throws MolFormatException, IOException {
        String f;
        boolean rxnRead = false;
        MolInputStream mis = this.molInputStream;
        String l = mis.readLine();
        if (l == null) {
            return false;
        }
        boolean okay = false;
        this.generatorProgram = "";
        String originfmt = mol.getInputFormat();
        this.origInputFormatFlags = 0;
        if (originfmt != null) {
            if (originfmt.equals("sdf") || originfmt.equals("cssdf") || originfmt.endsWith(":sdf") || originfmt.endsWith(":cssdf")) {
                this.origInputFormatFlags |= 2;
            }
            if (originfmt.equals("rdf") || originfmt.equals("csrdf") || originfmt.endsWith(":rdf") || originfmt.endsWith(":csrdf")) {
                this.inputIsRDF = true;
            }
        }
        if (this.inputIsRDF && (l.startsWith("$MFMT") || l.startsWith("$RFMT"))) {
            String ss;
            if (l.contains("$RIREG") || l.contains("$REREG")) {
                ss = l.contains("$RIREG") ? l.substring(l.indexOf("$RIREG")) : l.substring(l.indexOf("$REREG"));
                mol.setProperty("$REGNO", ss.substring(1, 3) + ss.substring(6).trim());
            }
            if (l.contains("$MIREG") || l.contains("$MEREG")) {
                ss = l.contains("$MIREG") ? l.substring(l.indexOf("$MIREG")) : l.substring(l.indexOf("$MEREG"));
                mol.setProperty("$REGNO", ss.substring(1, 3) + ss.substring(6).trim());
            }
            l = mis.readLine();
            mis.putBackLine();
            okay = l.startsWith("$RXN") ? (l.startsWith("$RXN V3000") ? this.readRxnV3(mol) != -1 : this.readRxnV2(mol) != -1) : (l.startsWith("$MDL ") ? this.readRgfV2(mol, false) : this.readMol0(mol, false));
            f = mol.getInputFormat();
            mol.setInputFormat(f != null && f.startsWith("cs") ? "csrdf" : "rdf");
            rxnRead = true;
        } else if (this.inputIsRDF && (l.startsWith("$MIREG") || l.startsWith("$MEREG") || l.startsWith("$RIREG") || l.startsWith("$REREG"))) {
            this.readLine();
            mol.clearForImport("rdf");
            mol.setProperty("$REGNO", l.substring(1, 3) + l.substring(6).trim());
            okay = true;
            f = mol.getInputFormat();
            mol.setInputFormat(f != null && f.startsWith("cs") ? "csrdf" : "rdf");
            rxnRead = true;
        } else if (l.startsWith("$RXN")) {
            mis.putBackLine();
            okay = l.startsWith("$RXN V3000") ? this.readRxnV3(mol) != -1 : this.readRxnV2(mol) != -1;
            rxnRead = true;
        } else if (l.startsWith("$MDL ")) {
            mis.putBackLine();
            okay = this.readRgfV2(mol, true);
        } else if (l.startsWith(">  <")) {
            this.inputIsRDF = false;
            mol.clear();
            mol.setInputFormat("sdf");
            this.currentLine = l;
            okay = this.tryReadingSDF(mol, 2);
        } else {
            mis.putBackLine();
            okay = this.readMol0(mol, true);
        }
        if (okay) {
            MolImport.initDim(mol);
            if (!this.rescaleIfRequired(mol)) {
                MolImport.initDim(mol);
            }
            if (mol.getSgroupCount() != 0) {
                Sgroup sg;
                int i;
                int cf = 0;
                if (!this.expandAllSgroups && !this.ungroupAllSgroups) {
                    cf = 4;
                }
                Sgroup[] sortedSgroups = mol.getSortedSgroups();
                for (i = sortedSgroups.length - 1; i >= 0; --i) {
                    sg = sortedSgroups[i];
                    if (!(sg instanceof Expandable)) continue;
                    Expandable x = (Expandable)((Object)sg);
                    if (this.expandedSgroups != null && this.expandedSgroups.contains(x)) continue;
                    x.contract(cf);
                }
                if (this.roundedBrackets != null) {
                    for (i = 0; i < this.roundedBrackets.size(); ++i) {
                        sg = this.roundedBrackets.get(i);
                        ArrayList<MBracket> brackets = sg.getBrackets();
                        for (int j = 0; j < brackets.size(); ++j) {
                            brackets.get(j).setType(0);
                        }
                    }
                }
                int xf = 0;
                if (!this.expandAllSgroups && !this.ungroupAllSgroups) {
                    xf = cf | 2;
                }
                for (int i2 = 0; i2 < sortedSgroups.length; ++i2) {
                    Sgroup sg2 = sortedSgroups[i2];
                    if (!(sg2 instanceof Expandable)) continue;
                    Expandable x = (Expandable)((Object)sg2);
                    if (this.expandedSgroups != null && this.expandedSgroups.contains(x)) continue;
                    x.expand(xf);
                    sortedSgroups = mol.getSortedSgroups();
                }
                if (this.ungroupAllSgroups) {
                    mol.ungroupSgroups();
                }
            }
            if (rxnRead) {
                this.reCalcRxn(mol);
            }
            this.setReactionArrow(mol);
            if (mol.isEmpty() && mol.getProperty("$REGNO") != null) {
                MolImport.fixBeilsteinRDF(mol);
            }
            this.convertSpecialDataSgroup(mol);
            mol.revalidateCoordDependentProps();
        }
        if (this.importOldAPOFormat() || this.molfileVersion == 3 && this.getVersionNumber() < 541) {
            MolImportUtil.convertSgroupLikeRgroupAttachments(mol);
        } else if (this.molfileVersion != 3) {
            MolImportUtil.calcAttachmentPoints(mol, this.calcScale(mol));
        }
        mol.valenceCheck();
        return okay;
    }

    private int convertAttachmentPointInformation(MolAtom atom, int value) {
        double bondlength = 1.54 / this.calcScale(atom.getParent());
        int extraAtomCount = 0;
        if (value == 1) {
            CleanUtil.setBestLigandPosition(atom, atom.addRgroupAttachmentPoint(1, 1), bondlength);
            extraAtomCount = 1;
        }
        if (value == 2) {
            CleanUtil.setBestLigandPosition(atom, atom.addRgroupAttachmentPoint(2, 1), bondlength);
            extraAtomCount = 1;
        }
        if (value == 3) {
            CleanUtil.setBestLigandPosition(atom, atom.addRgroupAttachmentPoint(1, 1), bondlength);
            CleanUtil.setBestLigandPosition(atom, atom.addRgroupAttachmentPoint(2, 1), bondlength);
            extraAtomCount = 2;
        }
        return extraAtomCount;
    }

    private MDocument addDocument(MoleculeGraph molg) {
        MDocument mdoc = null;
        MoleculeGraph p = molg.getParent();
        mdoc = p instanceof RgMolecule && ((RgMolecule)p).getRoot() == molg ? this.addDocument(p) : new MDocument(molg);
        return mdoc;
    }

    private int parseIntData(String data, Molecule mol, int removable) {
        int h = 0;
        try {
            h = Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            return h;
        }
        MDocument mdoc = mol.getDocument();
        if (mdoc == null) {
            mdoc = this.addDocument(mol);
        }
        mdoc.getPageSettings().setEnabled(true);
        mol.ungroupSgroup(removable);
        return h;
    }

    private double parseDoubleData(String data, Molecule mol, int removable) {
        double h = 0.0;
        try {
            h = Double.parseDouble(data);
        }
        catch (NumberFormatException e) {
            return h;
        }
        MDocument mdoc = mol.getDocument();
        if (mdoc == null) {
            mdoc = this.addDocument(mol);
        }
        mdoc.getPageSettings().setEnabled(true);
        mol.ungroupSgroup(removable);
        return h;
    }

    private void convertSpecialDataSgroup(Molecule mol) {
        if (mol instanceof RgMolecule) {
            RgMolecule rgm = (RgMolecule)mol;
            this.convertSpecialDataSgroup(rgm.getRoot());
            for (int i = 0; i < rgm.getRgroupCount(); ++i) {
                for (int j = 0; j < rgm.getRgroupMemberCount(i); ++j) {
                    this.convertSpecialDataSgroup(rgm.getRgroupMember(i, j));
                }
            }
        } else if (mol instanceof RxnMolecule) {
            int i;
            RxnMolecule rxnm = (RxnMolecule)mol;
            for (i = 0; i < rxnm.getReactantCount(); ++i) {
                this.convertSpecialDataSgroup(rxnm.getReactant(i));
            }
            for (i = 0; i < rxnm.getAgentCount(); ++i) {
                this.convertSpecialDataSgroup(rxnm.getAgent(i));
            }
            for (i = 0; i < rxnm.getProductCount(); ++i) {
                this.convertSpecialDataSgroup(rxnm.getProduct(i));
            }
        } else {
            for (int i = 0; i < mol.getSgroupCount(); ++i) {
                Sgroup sg = mol.getSgroup(i);
                if (!(sg instanceof DataSgroup)) continue;
                DataSgroup dsg = (DataSgroup)sg;
                String data = dsg.getData();
                if ("MRV_IMPLICIT_H".equalsIgnoreCase(dsg.getFieldName()) && data != null && data.length() > 6 && "IMPL_H".equalsIgnoreCase(data.substring(0, 6))) {
                    int h;
                    String hs = dsg.getData().substring(6);
                    try {
                        h = Integer.parseInt(hs);
                    }
                    catch (NumberFormatException e) {
                        continue;
                    }
                    for (int j = 0; j < dsg.getAtomCount(); ++j) {
                        MolAtom a = dsg.getAtom(j);
                        int hx = a.getExplicitHcount();
                        a.setImplicitHcount(h - hx);
                    }
                    mol.ungroupSgroup(i);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_WIDTH".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setWidth(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_HEIGHT".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setHeight(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_COLUMN_COUNT".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    int value = this.parseIntData(data, mol, i);
                    mol.getDocument().getPageSettings().setColumnCount(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_ROW_COUNT".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    int value = this.parseIntData(data, mol, i);
                    mol.getDocument().getPageSettings().setRowCount(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_SELECTED".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    int value = this.parseIntData(data, mol, i);
                    mol.getDocument().getPageSettings().setSelectedPage(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_LEFT_MARGIN".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setLeftMargin(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_RIGHT_MARGIN".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setRightMargin(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_TOP_MARGIN".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setTopMargin(value);
                    --i;
                    continue;
                }
                if ("MRV_PAGE_BOTTOM_MARGIN".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    double value = this.parseDoubleData(data, mol, i);
                    mol.getDocument().getPageSettings().setBottomMargin(value);
                    --i;
                    continue;
                }
                if ("MRV_MULTICENTER_ATOM_INDEX".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    this.convertFromDataToMulticenter(dsg, mol);
                    --i;
                    continue;
                }
                if ("MRV_COORDINATE_BOND_TYPE".equalsIgnoreCase(dsg.getFieldName()) && data != null) {
                    this.convertFromDataToCoordinateBond(dsg, mol);
                    --i;
                    continue;
                }
                if (!"MRV_CHARGE_ON_GROUP".equalsIgnoreCase(dsg.getFieldName()) || data == null) continue;
                this.convertFromDataToChargeLocation(dsg, mol);
                --i;
            }
        }
    }

    private void convertFromDataToMulticenter(DataSgroup dsg, Molecule mol) {
        String data = dsg.getData();
        MulticenterSgroup msg = new MulticenterSgroup(mol);
        for (int i = 0; i < dsg.getAtomCount(); ++i) {
            MolAtom a = dsg.getAtom(i);
            mol.setSgroupParent(a, msg, true);
        }
        if (dsg.getParentSgroup() != null) {
            dsg.getParentSgroup().addChildSgroup(msg);
        }
        int index = -1;
        try {
            index = Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index > 0) {
            msg.setCentralAtom(mol.getAtom(index - 1));
        }
        mol.ungroupSgroup(dsg);
    }

    private void convertFromDataToCoordinateBond(DataSgroup dsg, Molecule mol) {
        String data = dsg.getData();
        int index = -1;
        try {
            index = Integer.parseInt(data);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (index > 0) {
            mol.getBond(index - 1).setType(9);
        }
        mol.ungroupSgroup(dsg);
    }

    private void convertFromDataToChargeLocation(DataSgroup dsg, Molecule mol) {
        Sgroup parentSgroup = dsg.getParentSgroup();
        parentSgroup.setChargeLocation(2);
        mol.ungroupSgroup(dsg);
    }

    @Override
    public Molecule createMol() {
        String fmt = this.molInputStream.getFormat();
        if (fmt.equals("rxn") || fmt.equals("csrxn")) {
            RgMolecule rgmol = new RgMolecule();
            rgmol.setRoot(new RxnMolecule());
            return rgmol;
        }
        return new RgMolecule();
    }

    protected int getMolfileVersion() {
        return this.molfileVersion;
    }

    private boolean readMol0(Molecule mol, boolean trySDF) throws MolFormatException, IOException {
        Object[] hinfo = this.readHeader();
        if (hinfo == null) {
            return false;
        }
        try {
            int format2 = this.readCtab(mol, hinfo, null, null, null);
            if (format2 < 0) {
                return false;
            }
            if (((format2 |= this.origInputFormatFlags) & 4) != 0) {
                while (this.currentLine.startsWith("BEGIN RGROUP ")) {
                    this.readRgroupBlockV3((RgMolecule)mol);
                }
                this.checkEnd();
            }
            mol.setInputFormat(this.getFormat(format2));
            if (trySDF) {
                this.tryReadingSDF(mol, format2);
            }
        }
        catch (NumberFormatException ex) {
            throw new MolFormatException("Neither in MDL mol nor in SDfile format.", ex);
        }
        return true;
    }

    private void setReactionArrow(Molecule mol) {
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        if (rxmol != null) {
            rxmol.setReactionArrow();
        }
    }

    Object[] readHeader() throws IOException {
        Object[] hinfo = new Object[5];
        int dim = -1;
        for (int i = 0; i < 3; ++i) {
            String s = this.molInputStream.readLine();
            if (s == null) {
                return null;
            }
            if (i == 0 || i == 2) {
                hinfo[i] = s;
                continue;
            }
            if (i != 1) continue;
            this.generatorProgram = (s.length() > 10 ? s.substring(0, 10) : s).trim();
            if (s.length() < 22) continue;
            if (s.charAt(21) == 'D' && (dim = s.charAt(20) - 48) > 3) {
                dim = -1;
            }
            if (s.length() <= 34) continue;
            String s1 = s.substring(34, Math.min(46, s.length())).trim();
            Double energy = null;
            if (s1.length() > 0) {
                try {
                    energy = Double.valueOf(s1);
                    if (energy == 0.0) {
                        energy = null;
                    }
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            hinfo[3] = energy;
        }
        hinfo[1] = new Integer(dim);
        return hinfo;
    }

    boolean tryReadingSDF(Molecule mol, int format2) throws IOException {
        boolean issdf = false;
        MolInputStream mis = this.molInputStream;
        String l = this.currentLine;
        if (l != null) {
            if (l.startsWith("$$$$")) {
                issdf = true;
            } else {
                mis.putBackLine();
            }
            if (issdf) {
                format2 |= 2;
            }
            mol.setInputFormat(FORMATS[format2]);
        }
        return issdf;
    }

    int readCtab(Molecule mol, Object[] hinfo, Object[] rlogic, List<Integer> rlogicFlags, List<String> rlogicRanges) throws MolFormatException, IOException, NumberFormatException {
        String name = (String)hinfo[0];
        int dim = (Integer)hinfo[1];
        String comment = (String)hinfo[2];
        Double energy = (Double)hinfo[3];
        int format2 = this.origInputFormatFlags;
        if (this.readLine() == null) {
            return -1;
        }
        int na = this.atoiV2(3);
        int nb = this.atoiV2(3);
        int nl = this.atoiV2(3);
        this.currentColumn = 12;
        int chiralFlag = this.atoiV2(3);
        mol.clearForImport(this.getFormat(format2));
        mol.setName(name);
        mol.setComment(comment);
        mol.setAbsStereo(chiralFlag != 0);
        mol.setDim(dim >= 0 ? dim : 0);
        if (energy != null) {
            mol.setProperty("Energy", energy.toString());
        }
        if (na > 0) {
            boolean[] stereoCare = new boolean[na];
            format2 |= this.readAtomBlockV2(mol, stereoCare);
            format2 |= this.readBondBlockV2(mol, stereoCare, nb);
        } else if (nb != 0) {
            throw new MolFormatException("Molfile contains bonds but no atoms");
        }
        this.readAtomListBlockV2(mol, nl);
        int extraAtoms = this.readPropertiesBlockV2(mol, rlogic, rlogicFlags, rlogicRanges);
        if (this.molfileVersion == 3) {
            format2 |= 4;
            this.readCtab2V3(mol);
        } else {
            mol.endReuse(na + extraAtoms);
        }
        mol.setInputFormat(this.getFormat(format2));
        return format2;
    }

    private String getFormat(int format2) {
        if (this.inputIsRDF) {
            boolean compressed = (format2 & 1) != 0;
            StringBuffer sb = new StringBuffer(compressed ? "csrdf" : "rdf");
            if ((format2 & 4) != 0) {
                sb.append(":V3");
            }
            return sb.toString();
        }
        return FORMATS[format2];
    }

    void correctSgroup(Sgroup sg) {
        if (sg instanceof MultipleSgroup) {
            this.correctMUL((MultipleSgroup)sg);
        }
    }

    void checkEnd() throws MolFormatException, IOException {
        String line = this.currentLine;
        if (line != null) {
            if (!line.startsWith("M  END") && !line.startsWith("$MOL")) {
                throw new MolFormatException("Molfile does not end with M  END");
            }
            this.readLine();
        }
    }

    private int readAtomBlockV2(Molecule mol, boolean[] stereoCare) throws MolFormatException, IOException, NumberFormatException {
        int format2 = this.origInputFormatFlags;
        int na = stereoCare.length;
        boolean allInOrigin = true;
        for (int i = 0; i < na; ++i) {
            MolAtom a;
            int atno;
            boolean inOrigin;
            this.readLine();
            int len = this.currentLine.length();
            if (len == 10 || len == 14) {
                this.isCompressed = true;
            } else {
                this.isCompressed = false;
                if (len < 32) {
                    throw new MolFormatException("Line too short in atom block.");
                }
            }
            double x = this.atofV2();
            double y = this.atofV2();
            double z = len == 14 || !this.isCompressed ? this.atofV2() : 0.0;
            boolean bl = inOrigin = x > -5.0E-5 && x < 5.0E-5 && y > -5.0E-5 && y < 5.0E-5;
            if (z < -5.0E-5 || z > 5.0E-5) {
                mol.setDim(3);
                inOrigin = false;
            }
            allInOrigin &= inOrigin;
            int charge = 0;
            if (this.isCompressed) {
                int f = this.atoiV2(2);
                atno = OLD_ATNO_MAP[f & 0x7F];
                int p = MolImport.decodeMDLParity(f >> 7 & 3);
                a = mol.reuseAtom(atno, i);
                a.setXYZ(x, y, z);
                a.setFlags(p, 7);
                format2 |= 1;
            } else {
                String aaa = this.currentLine.substring(31, len < 34 ? len : 34);
                atno = this.decodeSymbol(aaa = aaa.trim());
                if (atno == 0) {
                    atno = 136;
                }
                a = mol.reuseAtom(atno, i);
                if (atno == 136) {
                    a.setAliasstr(MolImport.convertMDL2Short(aaa));
                }
                a.setForSpecIsotopeSymbol(aaa);
                a.setXYZ(x, y, z);
                this.currentColumn = 34;
                int diso = this.atoiV2(2);
                if (diso != 0) {
                    int a0 = PeriodicSystem.getMostFrequentNaturalIsotope(atno);
                    int iso = a0 + diso;
                    a.setMassno(iso);
                }
                int chargecode = this.atoiV2(3);
                int p = MolImport.decodeMDLParity(this.atoiV2(3));
                a.setFlags(p, 7);
                int hcount1 = this.atoiV2(3);
                if (hcount1 > 0) {
                    a.setQProp("H", hcount1 - 1);
                }
                stereoCare[i] = len > 47 && this.currentLine.charAt(47) == '1';
                this.currentColumn = 48;
                int v = this.atoiV2(3);
                switch (v) {
                    case 0: {
                        v = -1;
                        break;
                    }
                    case 15: {
                        v = 0;
                    }
                }
                a.setValenceProp(v);
                if (chargecode != 0 && chargecode != 4) {
                    charge = 4 - chargecode;
                }
                this.currentColumn = 60;
                v = this.atoiV2(3);
                if (v == -1) {
                    v = 0;
                }
                a.setAtomMap(v);
                v = this.atoiV2(3);
                a.setReactionStereo(v);
            }
            a.setCharge(charge);
        }
        if (allInOrigin) {
            mol.setDim(0);
        } else if (mol.getDim() < 2) {
            mol.setDim(2);
        }
        return format2;
    }

    static int decodeMDLParity(int p) {
        switch (p) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    private int readBondBlockV2(Molecule mol, boolean[] stereoCare, int nb) throws MolFormatException, IOException, NumberFormatException {
        int format2 = this.origInputFormatFlags;
        int na = stereoCare.length;
        for (int j = 0; j < nb; ++j) {
            int f;
            this.readLine();
            int len = this.currentLine.length();
            if (len == 5) {
                this.isCompressed = true;
            } else {
                this.isCompressed = false;
                if (len < 9) {
                    throw new MolFormatException("Line too short in bond block.");
                }
            }
            int isize = this.isCompressed ? 2 : 3;
            int i1 = this.atoiV2(isize) & 0x3FF;
            int i2 = this.atoiV2(isize) & 0x3FF;
            if (i1 < 1 || i1 > na || i2 < 1 || i2 > na || i1 == i2) {
                throw new MolFormatException("Invalid atom indices in bond definition (" + i1 + ", " + i2 + ")");
            }
            --i1;
            --i2;
            if (this.isCompressed) {
                f = this.atoiV2(1);
                f = f & 7 | MolImport.convertMolStereoToFlags(f >> 3);
                format2 |= 1;
            } else {
                int type = this.atoiV2(3);
                if (type == 8) {
                    type = 0;
                } else if (type < 1 || type > 8) {
                    throw new MolFormatException("Bad bond type " + type);
                }
                int stereo = this.atoiV2(3);
                stereo = MolImport.convertMolStereoToFlags(stereo);
                int topology = 0;
                int rCenterState = 0;
                if (this.currentLine.length() >= 18) {
                    this.currentColumn += 3;
                    topology = this.atoiV2(3);
                    topology = topology == 1 ? 1024 : (topology == 2 ? 2048 : 0);
                    this.currentColumn = 18;
                    int rcFlag = this.atoiV2(3);
                    if (rcFlag != 0) {
                        rCenterState = this.parseReactingCenterBlock(rcFlag);
                    }
                }
                f = type | stereo | topology | rCenterState;
                if (stereoCare[i1] && stereoCare[i2] && type == 2) {
                    f |= 0x200;
                }
            }
            MolAtom a1 = mol.getAtom(i1);
            MolAtom a2 = mol.getAtom(i2);
            if (a1.isBoundTo(a2)) continue;
            MolBond b = new MolBond(a1, a2, f);
            mol.add(b);
        }
        return format2;
    }

    int parseReactingCenterBlock(int f) {
        int rcFlag;
        switch (f) {
            case -1: 
            case 15: {
                rcFlag = 20480;
                break;
            }
            case 1: {
                rcFlag = 4096;
                break;
            }
            case 2: {
                rcFlag = 24576;
                break;
            }
            case 4: {
                rcFlag = 8192;
                break;
            }
            case 8: {
                rcFlag = 12288;
                break;
            }
            case 12: {
                rcFlag = 16384;
                break;
            }
            default: {
                rcFlag = 0;
            }
        }
        return rcFlag;
    }

    private void readAtomListBlockV2(Molecule mol, int nl) throws MolFormatException, IOException, NumberFormatException {
        MolInputStream mis = this.molInputStream;
        int na = mol.getAtomCount();
        for (int i = 0; i < nl; ++i) {
            int index;
            if (this.readLine() == null) {
                return;
            }
            boolean compr = this.isCompressed;
            this.isCompressed = false;
            try {
                index = this.atoiV2(3);
            }
            catch (NumberFormatException ex) {
                mis.putBackLine();
                return;
            }
            this.isCompressed = compr;
            if (index < 1) {
                mis.putBackLine();
                return;
            }
            if (index > na) {
                throw new MolFormatException("atom index too in atom list block too large, " + index + " > " + na);
            }
            MolAtom a = mol.getAtom(index - 1);
            char c = this.currentLine.charAt(4);
            if (c == 'T') {
                a.setAtno(129);
            } else if (c != 'F') {
                throw new MolFormatException("T or F expected in column 5 of atom list block");
            }
            int count = this.currentLine.charAt(9) - 48;
            int[] list = new int[count];
            this.currentColumn = 10;
            this.isCompressed = false;
            for (int j = 0; j < count; ++j) {
                list[j] = this.atoiV2(4);
                if (list[j] >= 0) continue;
                this.isCompressed = compr;
                throw new MolFormatException("Invalid atomic number " + list[i] + " in atom list block");
            }
            this.isCompressed = compr;
            a.setList(list);
        }
    }

    private int readPropertiesBlockV2(Molecule mol, Object[] rlogic, List<Integer> rlogicFlags, List<String> rlogicRanges) throws MolFormatException, IOException, NumberFormatException {
        MolInputStream mis = this.molInputStream;
        int extraAtomCount = 0;
        this.isCompressed = false;
        this.currentColumn = 0;
        if (this.readLine() == null) {
            this.molfileVersion = 2;
            return extraAtomCount;
        }
        if (this.currentLine.equals("$$$$")) {
            this.molfileVersion = 2;
            return extraAtomCount;
        }
        if (this.currentLine.startsWith("M  V30 BEGIN CTAB")) {
            this.molfileVersion = 3;
            return extraAtomCount;
        }
        this.sgroupCount = 0;
        this.sgroups = null;
        boolean splinfo = false;
        while (!this.currentLine.startsWith("$MOL") && !this.currentLine.startsWith("$DTYPE ")) {
            if (this.currentLine.length() >= 6) {
                String s = this.currentLine.substring(0, 6);
                if (s.startsWith(">") || s.startsWith("$$$$")) break;
                if (s.equals("M  END")) {
                    String l = this.readLine();
                    if (l == null || !l.startsWith("$RXN")) break;
                    mis.putBackLine();
                    break;
                }
                this.currentColumn = 6;
                if (s.startsWith("A  ")) {
                    this.currentColumn = 3;
                    int i = this.atoiV2(3);
                    MolAtom a = mol.getAtom(i - 1);
                    s = mis.readLine();
                    if (s.startsWith("'") && s.endsWith("'") && s.length() > 2 && a.getAtno() == 131) {
                        s = s.substring(1, s.length() - 1);
                        a.setAtno(136);
                    } else if (MolfileUtil.isSpecBeilsteinGeneric(s)) {
                        a.setAtno(136);
                    }
                    a.setAliasstr(MolImport.convertMDL2Short(s));
                } else if (s.startsWith("V  ") && this.readAtomValues) {
                    this.currentColumn = 3;
                    int i = this.atoiV2(3);
                    MolAtom a = mol.getAtom(i - 1);
                    a.setExtraLabel(this.currentLine.substring(this.currentColumn + 1));
                } else if (s.equals("M  CHG")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        int i = this.atoiV2(4);
                        mol.getAtom(i - 1).setCharge(this.atoiV2(4));
                    }
                } else if (s.equals("M  RAD")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        int i = this.atoiV2(4);
                        int rad = this.atoiV2(4);
                        MolImport.setRadical(mol.getAtom(i - 1), rad);
                    }
                } else if (s.equals("M  ISO")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        MolAtom a = mol.getAtom(this.atoiV2(4) - 1);
                        a.setMassno(this.atoiV2(4));
                    }
                } else if (s.equals("M  LOG")) {
                    this.readRlogicLine(0, false, rlogic);
                    rlogicFlags.add((Integer)rlogic[0]);
                    rlogicRanges.add((String)rlogic[1]);
                } else if (s.equals("M  RGP")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        int i = this.atoiV2(4);
                        int r = this.atoiV2(4);
                        mol.getAtom(i - 1).setRgroup(r);
                    }
                } else if (s.equals("M  APO")) {
                    boolean oldFormat = this.importOldAPOFormat();
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        int i = this.atoiV2(4);
                        int r = this.atoiV2(4);
                        MolAtom atom = mol.getAtom(i - 1);
                        if (oldFormat) {
                            atom.setAttach(r);
                            continue;
                        }
                        extraAtomCount += this.convertAttachmentPointInformation(atom, r);
                    }
                } else if (s.equals("M  ALS")) {
                    int ii = this.atoiV2(4) - 1;
                    MolAtom a = mol.getAtom(ii);
                    int count = this.atoiV2(3);
                    int[] list = new int[count];
                    char c = this.currentLine.charAt(14);
                    if (c == 'T') {
                        a.setAtno(129);
                    } else if (c != 'F') {
                        throw new MolFormatException("Error at \"M  ALS\"");
                    }
                    for (int i = 0; i < count; ++i) {
                        int beg = 16 + (i << 2);
                        s = beg + 4 < this.currentLine.length() ? this.currentLine.substring(beg, beg + 4) : this.currentLine.substring(beg);
                        list[i] = this.decodeSymbol(s);
                    }
                    a.setList(list);
                } else if (s.equals("M  LIN")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        int i = this.atoiV2(4);
                        int r = this.atoiV2(4);
                        MolAtom linkA = mol.getAtom(i - 1);
                        linkA.setMaxRepetitions(r);
                        int outIdx1 = this.atoiV2(4) - 1;
                        int outer1 = outIdx1 == -1 ? -1 : linkA.getLigandIndex(mol.getAtom(outIdx1));
                        linkA.setLinkNodeOuterAtom(0, outer1);
                        int outIdx2 = this.atoiV2(4) - 1;
                        int outer2 = outIdx2 == -1 ? -1 : linkA.getLigandIndex(mol.getAtom(outIdx2));
                        linkA.setLinkNodeOuterAtom(1, outer2);
                    }
                } else if (s.equals("M  SUB")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        MolAtom a = mol.getAtom(this.atoiV2(4) - 1);
                        int v = this.atoiV2(4);
                        if (v == 0) continue;
                        if (v == -1) {
                            v = 0;
                        }
                        a.setQProp("s", v);
                    }
                } else if (s.equals("M  RBC")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        MolAtom a = mol.getAtom(this.atoiV2(4) - 1);
                        int v = this.atoiV2(4);
                        if (v == 0) continue;
                        if (v == -1) {
                            v = 0;
                        }
                        a.setQProp("rb", v);
                    }
                } else if (s.equals("M  UNS")) {
                    for (int j = this.atoiV2(3); j > 0; --j) {
                        MolAtom a = mol.getAtom(this.atoiV2(4) - 1);
                        int v = this.atoiV2(4);
                        if (v == 0) continue;
                        a.setQProp("u", v);
                    }
                } else if (s.equals("M  STY")) {
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        Sgroup sg;
                        int j = this.atoiV2(4);
                        if (j < 1) {
                            throw new MolFormatException("Bad S-group number " + j);
                        }
                        --j;
                        if (this.sgroups == null) {
                            this.sgroups = new Sgroup[j + 16];
                            this.sgroupCount = j + 1;
                            this.sgroupBonds = new HashMap(j + 16);
                            this.sgroupConnections = new HashMap(j + 16);
                        } else if (j >= this.sgroups.length) {
                            Sgroup[] tmp = new Sgroup[2 * (j + 1)];
                            System.arraycopy(this.sgroups, 0, tmp, 0, this.sgroups.length);
                            this.sgroups = tmp;
                            this.sgroupCount = j + 1;
                        } else if (j >= this.sgroupCount) {
                            this.sgroupCount = j + 1;
                        }
                        int beg = this.currentColumn + 1;
                        int end = beg + 3;
                        s = this.currentLine.substring(beg, end);
                        this.currentColumn = end;
                        Integer t = MolfileUtil.getSgroupType(s);
                        if (t == null) {
                            throw new MolFormatException("Unknown S-group type \"" + s + "\"");
                        }
                        this.sgroups[j] = sg = this.createSgroup(mol, t);
                    }
                } else if (s.equals("M  SPL")) {
                    splinfo = true;
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int j = this.readSgroupNumberV2();
                        int k = this.readSgroupNumberV2();
                        Sgroup gj = this.sgroups[j];
                        Sgroup gk = this.sgroups[k];
                        gk.addChildSgroup(gj);
                    }
                } else if (s.equals("M  SNC")) {
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int j = this.readSgroupNumberV2();
                        int k = this.atoiV2(4);
                        Sgroup gj = this.sgroups[j];
                        gj.setSubscript("c" + Integer.toString(k));
                    }
                } else if (s.equals("M  SBT")) {
                    this.roundedBrackets = new ArrayList();
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int j = this.readSgroupNumberV2();
                        int k = this.atoiV2(4);
                        if (k != 1) continue;
                        this.roundedBrackets.add(this.sgroups[j]);
                    }
                } else if (s.equals("M  SST")) {
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int sgi = this.readSgroupNumberV2();
                        Sgroup sg = this.sgroups[sgi];
                        int beg = this.currentColumn + 1;
                        int end = beg + 3;
                        s = this.currentLine.substring(beg, end);
                        this.currentColumn = end;
                        Integer t = MolImport.readSubtype(s);
                        if (t == null) {
                            throw new MolFormatException("Unknown S-group subtype \"" + s + "\"");
                        }
                        sg.setSubType(t);
                    }
                } else if (s.equals("M  SMT")) {
                    int sgi = this.readSgroupNumberV2();
                    Sgroup sg = this.sgroups[sgi];
                    s = this.currentLine.substring(this.currentColumn + 1);
                    MolImport.setSgroupSubscript(sg, s);
                } else if (s.equals("M  SAP")) {
                    this.readSAP(mol);
                } else if (s.equals("M  SCN")) {
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int sgi = this.readSgroupNumberV2();
                        Sgroup sg = this.sgroups[sgi];
                        int beg = this.currentColumn + 1;
                        int end = beg + 3;
                        if (end > this.currentLine.length()) {
                            end = this.currentLine.length();
                        }
                        s = this.currentLine.substring(beg, end).trim();
                        this.currentColumn = end;
                        int t = MolImport.readSgroupConnectivity(s);
                        sg.setConnectivity(t);
                    }
                } else if (s.equals("M  SDS")) {
                    if (this.currentLine.startsWith("M  SDS EXP")) {
                        this.currentColumn = 10;
                        for (int i = this.atoiV2(3); i > 0; --i) {
                            int sgi = this.readSgroupNumberV2();
                            Sgroup sg = this.sgroups[sgi];
                            if (this.expandedSgroups == null) {
                                this.expandedSgroups = new HashSet<Sgroup>();
                            }
                            this.expandedSgroups.add(sg);
                        }
                    }
                } else if (s.equals("M  SAL")) {
                    int sgi = this.readSgroupNumberV2();
                    Sgroup sg = this.sgroups[sgi];
                    for (int i = this.atoiV2(3); i > 0; --i) {
                        int j = this.atoiV2(4) - 1;
                        MolAtom a = mol.getAtom(j);
                        mol.setSgroupParent(a, sg, true);
                    }
                } else if (s.equals("M  SPA")) {
                    int sgi = this.readSgroupNumberV2();
                    if (this.sgroups[sgi].getType() == 1) {
                        MultipleSgroup sg = (MultipleSgroup)this.sgroups[sgi];
                        for (int i = this.atoiV2(3); i > 0; --i) {
                            int j = this.atoiV2(4) - 1;
                            MolAtom a = mol.getAtom(j);
                            mol.setSgroupParent(a, sg, true);
                            sg.setRepeatingUnitAtom(a, true);
                        }
                    }
                } else if (s.equals("M  SBL")) {
                    int sgi = this.readSgroupNumberV2();
                    Sgroup sgroup = this.sgroups[sgi];
                    MolBond[] bonds = this.readBondsFromSBL(mol);
                    if (sgroup instanceof RepeatingUnitSgroup) {
                        RepeatingUnitSgroup sg = (RepeatingUnitSgroup)sgroup;
                        if (bonds.length > 0 && this.sgroupBonds.get(sgi) == null) {
                            this.sgroupBonds.put(sgi, new ArrayList());
                        }
                        for (int i = bonds.length - 1; i >= 0; --i) {
                            this.sgroupBonds.get(sgi).add(bonds[i]);
                        }
                        if (this.sgroupConnections.get(sgi) != null || sg.getConnectivity() == 0) {
                            sg.addCrossingBonds((List<MolBond>)this.sgroupConnections.get(sgi), (List<MolBond>)this.sgroupBonds.get(sgi));
                        }
                    }
                } else if (s.equals("M  CRS")) {
                    int sgi = this.readSgroupNumberV2();
                    if (this.sgroups[sgi] instanceof RepeatingUnitSgroup) {
                        RepeatingUnitSgroup sg = (RepeatingUnitSgroup)this.sgroups[sgi];
                        ArrayList<MolBond> blist = new ArrayList<MolBond>();
                        for (int i = this.atoiV2(3) - 1; i >= 0; --i) {
                            int j = this.atoiV2(4) - 1;
                            MolBond b = mol.getBond(j);
                            blist.add(b);
                        }
                        if (this.sgroupBonds.get(sgi) != null) {
                            sg.addCrossingBonds(blist, (List<MolBond>)this.sgroupBonds.get(sgi));
                        } else {
                            this.sgroupConnections.put(sgi, blist);
                        }
                    }
                } else if (s.equals("M  SDI")) {
                    int sgi = this.readSgroupNumberV2();
                    this.atoiV2(3);
                    DPoint3[] d = new DPoint3[2];
                    d[0] = new DPoint3();
                    d[0].x = this.atofV2();
                    d[0].y = this.atofV2();
                    d[1] = new DPoint3();
                    d[1].x = this.atofV2();
                    d[1].y = this.atofV2();
                    MolImportUtil.readBrackets(this.sgroups[sgi], d, false, 1.54 / (4.0 * this.calcScale(mol)));
                } else if (s.equals("M  SDT")) {
                    String queryOp;
                    String qc;
                    int sgi = this.readSgroupNumberV2();
                    DataSgroup sg = (DataSgroup)this.sgroups[sgi];
                    ++this.currentColumn;
                    sg.setFieldName(this.readString(30));
                    String fieldType = this.readString(2);
                    sg.setFieldType(fieldType);
                    String units = this.readString(20);
                    if (units != null && !units.equals("")) {
                        sg.setUnits(units);
                    }
                    if ((qc = this.readString(2)) != null && !qc.equals("")) {
                        sg.setQueryCode(qc);
                    }
                    if ((queryOp = this.readString(-1)) != null && !queryOp.equals("")) {
                        sg.setQueryOp(queryOp);
                    }
                } else if (s.equals("M  SDD")) {
                    int sgi = this.readSgroupNumberV2();
                    DataSgroup sg = (DataSgroup)this.sgroups[sgi];
                    ++this.currentColumn;
                    this.readSDDValue(sg, null);
                    this.isLastSED = false;
                } else if (s.equals("M  SCD")) {
                    int sgi = this.readSgroupNumberV2();
                    DataSgroup sg = (DataSgroup)this.sgroups[sgi];
                    ++this.currentColumn;
                    String val = this.readString(-1);
                    int lastLine = sg.getDataLineCount() - 1;
                    if (this.isLastSED || lastLine == -1) {
                        sg.addDataLine(val);
                    } else {
                        sg.setDataLine(lastLine, sg.getDataLine(lastLine) + val);
                    }
                    this.isLastSED = false;
                } else if (s.equals("M  SED")) {
                    int sgi = this.readSgroupNumberV2();
                    DataSgroup sg = (DataSgroup)this.sgroups[sgi];
                    ++this.currentColumn;
                    String val = this.readString(-1);
                    int lastLine = sg.getDataLineCount() - 1;
                    if (this.isLastSED || lastLine == -1) {
                        sg.addDataLine(val);
                    } else {
                        sg.setDataLine(lastLine, sg.getDataLine(lastLine) + val);
                    }
                    this.isLastSED = true;
                } else if (s.equals("M  MRV") && !this.skipMMRV) {
                    String ss = this.currentLine.substring(6, 10);
                    int stereo2 = 0;
                    if (ss.equals(" SMA")) {
                        this.currentColumn = 10;
                        int k = this.atoiV2(4) - 1;
                        MolAtom a = mol.getAtom(k);
                        s = this.currentLine.substring(15);
                        a.setSMARTS(s);
                    } else if (ss.equals(" CTU")) {
                        stereo2 = 256;
                    } else if (ss.equals(" SDD")) {
                        this.currentColumn += ss.length();
                        int sgi = this.readSgroupNumberV2();
                        DataSgroup sg = (DataSgroup)this.sgroups[sgi];
                        String val = this.readString(4);
                        sg.setContext(Integer.parseInt(val.trim()));
                    }
                    if (stereo2 != 0) {
                        this.currentColumn = 10;
                        for (int j = this.atoiV2(3); j > 0; --j) {
                            int k = this.atoiV2(4) - 1;
                            if (k >= mol.getBondCount()) {
                                throw new MolFormatException("Bond index " + (k + 1) + " is referenced but the molecule contains" + " only " + mol.getBondCount() + " bonds.");
                            }
                            MolBond b = mol.getBond(k);
                            b.setFlags(stereo2, 448);
                        }
                    }
                }
            }
            if (this.readLine() != null) continue;
        }
        if (!splinfo) {
            MolImportUtil.setSgroupParentSgroups(mol);
        }
        MolImportUtil.reparentEmptySgroups(mol);
        MolImportUtil.recalcBrackets(mol, 1.54 / (4.0 * this.calcScale(mol)));
        int resSeq = 0;
        if (this.sgroups != null) {
            for (int i = 0; i < this.sgroups.length; ++i) {
                Sgroup sg = this.sgroups[i];
                if (sg == null) continue;
                if (sg.getParentSgroup() == null) {
                    MolImport.setResidues(sg, resSeq);
                    ++resSeq;
                }
                this.correctSgroup(sg);
            }
        }
        this.molfileVersion = 2;
        return extraAtomCount;
    }

    private boolean importOldAPOFormat() {
        int version;
        if (this.generatorProgram == null || this.generatorProgram.length() < 7) {
            return true;
        }
        String ver = this.generatorProgram.substring(3, 7);
        try {
            version = Integer.parseInt(ver);
        }
        catch (Exception ex) {
            version = 0;
        }
        return this.generatorProgram.startsWith("Mrv") && version < 540;
    }

    private int getVersionNumber() {
        if (this.generatorProgram == null || this.generatorProgram.length() < 7) {
            return 0;
        }
        if (this.generatorProgram.startsWith("Mrv")) {
            int version;
            String ver = this.generatorProgram.substring(3, 7);
            try {
                version = Integer.parseInt(ver);
            }
            catch (Exception ex) {
                version = 0;
            }
            return version;
        }
        return 0;
    }

    private void readSAP(Molecule mol) throws MolFormatException {
        int sgi = this.readSgroupNumberV2();
        Sgroup sg = this.sgroups[sgi];
        this.atoiV2(3);
        int atomIndex = this.atoiV2(4) - 1;
        MolAtom atom = mol.getAtom(atomIndex);
        if (atom.getAttach() > 0) {
            atom.setAttach(3, sg);
        } else {
            MolAtom firstApo = null;
            for (int k = 0; k < sg.getAtomCount() && firstApo == null; ++k) {
                if (sg.getAtom(k).getAttach() <= 0) continue;
                firstApo = sg.getAtom(k);
            }
            if (firstApo == null) {
                atom.setAttach(1, sg);
            } else if (firstApo != atom) {
                atom.setAttach(2, sg);
            }
        }
    }

    private MolBond[] readBondsFromSBL(Molecule mol) {
        int n = this.atoiV2(3);
        MolBond[] bonds = new MolBond[n];
        for (int i = 0; i < n; ++i) {
            int j = this.atoiV2(4) - 1;
            bonds[i] = mol.getBond(j);
        }
        return bonds;
    }

    private int decodeSymbol(String s) {
        int z = 0;
        try {
            z = MolAtom.getAtomicNumber(s);
        }
        catch (IllegalArgumentException e) {
            try {
                s = s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
                z = MolAtom.getAtomicNumber(s);
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return z;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readSDDValue(DataSgroup sg, String sddValue) {
        String oldCurrentLine = null;
        int oldCurrentColumn = 0;
        if (sddValue != null) {
            oldCurrentLine = this.currentLine;
            oldCurrentColumn = this.currentColumn;
            this.currentLine = sddValue;
            this.currentColumn = 0;
        }
        try {
            sg.setX(this.atofV2());
            sg.setY(this.atofV2());
            this.currentColumn += 4;
            sg.setDataDetached(this.readString(1).equals("D"));
            sg.setAbsolutePlacement(this.readString(1).equals("A"));
            sg.setUnitDisplayed(this.readString(1).equals("U"));
            this.currentColumn += 3;
            String numDataDisp = this.readString(3);
            if (numDataDisp.equals("ALL")) {
                sg.setDisplayedChars(0);
            } else {
                sg.setDisplayedChars(Integer.parseInt(numDataDisp.trim()));
            }
            sg.setDisplayedLines(Integer.parseInt(this.readString(3).trim()));
            this.currentColumn += 4;
            String tag = this.readString(1);
            if (!tag.equals("")) {
                sg.setTag(tag.charAt(0));
            }
            this.currentColumn += 2;
            String dasp = this.readString(1);
            if (!dasp.equals("")) {
                sg.setPos(Integer.parseInt(dasp.trim()));
            }
        }
        finally {
            if (sddValue != null) {
                this.currentLine = oldCurrentLine;
                this.currentColumn = oldCurrentColumn;
            }
        }
    }

    private String readString(int maxLength) {
        int beginIndex = this.currentColumn;
        try {
            if (maxLength <= 0) {
                this.currentColumn = this.currentLine.length();
                return this.currentLine.substring(beginIndex);
            }
            int length = Math.min(maxLength, this.currentLine.length() - this.currentColumn);
            char lastCh = this.currentLine.charAt(beginIndex + length - 1);
            while (length > 0 && (' ' == lastCh || '\t' == lastCh)) {
                lastCh = this.currentLine.charAt(this.currentColumn + --length - 1);
            }
            this.currentColumn += maxLength;
            return this.currentLine.substring(beginIndex, beginIndex + length);
        }
        catch (IndexOutOfBoundsException e) {
            this.currentColumn = this.currentLine.length();
            return null;
        }
    }

    int atoiV2(int w) {
        int i = this.currentColumn;
        if (this.currentLine.length() < i + w) {
            return 0;
        }
        if (this.isCompressed) {
            int k = 0;
            this.currentColumn = i + w;
            String s = this.currentLine.substring(i, this.currentColumn);
            for (int j = 0; j < w; ++j) {
                char c = s.charAt(j);
                int x = c == '+' ? 62 : (c == '-' ? 63 : (c >= 'a' ? c - 97 + 36 : (c >= 'A' ? c - 65 + 10 : c - 48)));
                k |= x << j * 6;
            }
            return k;
        }
        boolean spaceonly = true;
        for (int j = 0; j < w && spaceonly; ++j) {
            if (this.currentLine.charAt(i + j) == ' ') continue;
            spaceonly = false;
        }
        if (spaceonly) {
            return 0;
        }
        String s = this.currentLine;
        this.currentColumn = i + w;
        return Integer.parseInt(s.substring(i, i + w).trim());
    }

    private double atofV2() {
        int i = this.currentColumn;
        if (this.isCompressed) {
            int x = this.atoiV2(4);
            return (double)(x - 0x800000) / 10000.0;
        }
        this.currentColumn += 10;
        String s = this.currentLine;
        return Double.valueOf(s.substring(i, i + 10));
    }

    Sgroup createSgroup(Molecule mol, int t) {
        if (t == 0) {
            return new SuperatomSgroup(mol);
        }
        if (t == 1) {
            return new MultipleSgroup(mol, true);
        }
        if (t == 10) {
            DataSgroup dsg = new DataSgroup(mol);
            mol.addSgroup(dsg, true);
            return dsg;
        }
        if (t == 11 || t == 5 || t == 6 || t == 15 || t == 7 || t == 2) {
            return new RepeatingUnitSgroup(mol, t);
        }
        return new Sgroup(mol, t);
    }

    private int readSgroupNumberV2() throws MolFormatException {
        int i = this.atoiV2(4);
        if (this.sgroups == null || i < 1 || i > this.sgroups.length) {
            throw new MolFormatException("Bad S-group number " + i);
        }
        return i - 1;
    }

    String readLine() throws IOException {
        String l;
        this.currentColumn = 0;
        this.currentLine = l = this.molInputStream.readLine();
        return l;
    }

    private static int convertMolStereoToFlags(int stereo) {
        if (stereo == 1) {
            return 16;
        }
        if (stereo == 6) {
            return 32;
        }
        if (stereo == 4) {
            return 48;
        }
        if (stereo == 3) {
            return 192;
        }
        return 0;
    }

    static int readSgroupConnectivity(String s) throws MolFormatException {
        if (s.equals("HH")) {
            return 1;
        }
        if (s.equals("HT")) {
            return 2;
        }
        if (s.equals("EU")) {
            return 0;
        }
        throw new MolFormatException("Unknown S-group connectivity \"" + s + "\"");
    }

    static Integer readSubtype(String s) {
        return SGROUP_SUBTYPES.get(s);
    }

    private boolean rescaleIfRequired(Molecule m) {
        boolean mdl0825scaled;
        boolean bl = mdl0825scaled = this.molfileVersion < 3 || this.generatorProgram.equals("ChemDraw");
        if (m.getDim() == 2 && mdl0825scaled || this.xyzScaleMode != 0) {
            double c = this.xyzScale;
            if (this.xyzScaleMode == 2 || mdl0825scaled && m.getDim() == 2 && this.xyzScaleMode != 1) {
                double blen = 0.825;
                if (m.getBondCount() > 0) {
                    double l = m.bondlength();
                    if (l == 0.0) {
                        MoleculeGraph u = m.getGraphUnion();
                        for (int i = 0; i < u.getAtomCount(); ++i) {
                            u.getAtom(i).setXYZ(0.0, 0.0, 0.0);
                        }
                        m.setDim(0);
                        return false;
                    }
                    if (l < 0.82495 || l > 0.82505) {
                        blen = l;
                    }
                }
                this.xyzScale = c = 1.54 / blen;
            }
            CTransform3D t = new CTransform3D();
            t.m00 = c;
            t.m11 = c;
            t.m22 = c;
            t.m33 = c;
            m.transform(t);
        }
        return true;
    }

    private double calcScale(MoleculeGraph m) {
        boolean mdl0825scaled = this.molfileVersion < 3 || this.generatorProgram.equals("ChemDraw");
        double scale = 1.0;
        if ((m.getDim() == 2 && mdl0825scaled || this.xyzScaleMode != 0) && (this.xyzScaleMode == 2 || mdl0825scaled && m.getDim() == 2 && this.xyzScaleMode != 1)) {
            double blen = 0.825;
            if (m.getBondCount() > 0) {
                double l = m.bondlength();
                if (l == 0.0) {
                    return 1.0;
                }
                if (l < 0.82495 || l > 0.82505) {
                    blen = l;
                }
            }
            scale = 1.54 / blen;
        }
        return scale;
    }

    private static int initRxnDim(RxnMolecule rxmol, int i, int maxdim) {
        for (int j = 0; j < rxmol.getComponentCount(i); ++j) {
            Molecule m = rxmol.getComponent(i, j);
            int d = m.getDim();
            if (d <= maxdim) continue;
            maxdim = d;
        }
        return maxdim;
    }

    private static void initRxnDim(RxnMolecule rxmol) {
        int maxdim = MolImport.initRxnDim(rxmol, 0, 0);
        maxdim = MolImport.initRxnDim(rxmol, 1, maxdim);
        maxdim = MolImport.initRxnDim(rxmol, 2, maxdim);
        rxmol.setDim(maxdim);
    }

    private static void initDim(Molecule m) {
        if (m instanceof RgMolecule) {
            RgMolecule rgmol = (RgMolecule)m;
            Molecule root = rgmol.getRoot();
            if (root instanceof RxnMolecule) {
                MolImport.initRxnDim((RxnMolecule)root);
            }
            int maxdim = root.getDim();
            for (int i = 0; i < rgmol.getRgroupCount(); ++i) {
                for (int j = 0; j < rgmol.getRgroupMemberCount(i); ++j) {
                    Molecule mm = rgmol.getRgroupMember(i, j);
                    int d = mm.getDim();
                    if (d <= maxdim) continue;
                    maxdim = d;
                }
            }
            m.setDim(maxdim);
        } else if (m instanceof RxnMolecule) {
            MolImport.initRxnDim((RxnMolecule)m);
        }
    }

    static void setResidues(Sgroup sg, int resSeq) {
        String resName = sg.getSubscript();
        int resType = Molecule.residueTypeOf(resName);
        MolImport.setResiduesRecursively(sg, resSeq, resType);
    }

    private static void setResiduesRecursively(Sgroup sg, int resSeq, int resType) {
        int i;
        for (i = 0; i < sg.getAtomCount(); ++i) {
            MolAtom a = sg.getAtom(i);
            a.setResidueSeq(resSeq);
            a.setResidueType(resType);
        }
        for (i = 0; i < sg.getChildSgroupCount(); ++i) {
            Sgroup child = sg.getChildSgroup(i);
            MolImport.setResiduesRecursively(child, resSeq, resType);
        }
    }

    private static void fixBeilsteinRDF(Molecule mol) {
        MolImportUtil.fixBeilsteinRDF(mol);
    }

    private void reCalcRxn(Molecule mol) {
        MolImportX.reCalcRxn(mol);
    }

    private int readRxnV2(Molecule arg) throws MolFormatException, IOException {
        return MolImportX.readRxnV2(this, arg);
    }

    private int readRxnV3(Molecule arg) throws MolFormatException, IOException {
        return MolImportX.readRxnV3(this, arg, this.getVersionNumber());
    }

    private boolean readRgfV2(Molecule arg, boolean trySDF) throws MolFormatException, IOException {
        return MolImportX.readRgfV2(this, arg, trySDF);
    }

    private void readCtab2V3(Molecule mol) throws MolFormatException, IOException {
        MolImportX.readCtab2V3(this, mol, this.getVersionNumber());
    }

    private void correctMUL(MultipleSgroup sg) {
        MolImportX.correctMUL(sg);
    }

    private void readRlogicLine(int r1, boolean v3, Object[] rlogic) throws MolFormatException, IOException {
        MolImportX.readRlogicLine(this, r1, v3, rlogic);
    }

    private void readRgroupBlockV3(RgMolecule mol) throws MolFormatException, IOException {
        MolImportX.readRgroupBlockV3(this, mol, this.getVersionNumber());
    }

    static void setRadical(MolAtom a, int rad) {
        int r;
        switch (rad) {
            case 1: {
                r = 6;
                break;
            }
            case 2: {
                r = 1;
                break;
            }
            case 3: {
                r = 10;
                break;
            }
            default: {
                r = rad << 10;
            }
        }
        a.setRadical(r);
    }

    static String convertMDL2Short(String str) {
        String tex = SimpleTeX.convertShort2TeX(str, 1);
        return SimpleTeX.convertTeX2Short(tex, 0);
    }

    static void setSgroupSubscript(Sgroup sg, String str) throws MolFormatException {
        if (!(sg instanceof MultipleSgroup)) {
            str = MolImport.convertMDL2Short(str);
        }
        try {
            sg.setSubscript(str);
        }
        catch (IllegalArgumentException ex) {
            throw new MolFormatException(ex.getMessage());
        }
    }

    static {
        int i;
        FORMATS = new String[8];
        SGROUP_SUBTYPES = new HashMap<String, Integer>();
        SGROUP_SUBTYPES.put("ALT", new Integer(1));
        SGROUP_SUBTYPES.put("RAN", new Integer(2));
        SGROUP_SUBTYPES.put("BLO", new Integer(3));
        for (i = 0; i < FORMATS.length; ++i) {
            StringBuffer sb = new StringBuffer((i & 1) != 0 ? "cs" : "");
            sb.append((i & 2) != 0 ? "sdf" : "mol");
            if ((i & 4) != 0) {
                sb.append(":V3");
            }
            MolImport.FORMATS[i] = sb.toString();
        }
        OLD_ATNO_MAP = new int[128];
        for (i = 0; i < OLD_ATNO_MAP.length; ++i) {
            MolImport.OLD_ATNO_MAP[i] = i;
        }
        MolImport.OLD_ATNO_MAP[110] = 128;
        MolImport.OLD_ATNO_MAP[111] = 130;
        MolImport.OLD_ATNO_MAP[112] = 131;
        MolImport.OLD_ATNO_MAP[113] = 132;
        MolImport.OLD_ATNO_MAP[114] = 133;
        MolImport.OLD_ATNO_MAP[115] = 134;
        MolImport.OLD_ATNO_MAP[116] = 135;
        MolImport.OLD_ATNO_MAP[117] = 136;
        MolImport.OLD_ATNO_MAP[118] = 137;
    }
}

