/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.mdl;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.marvin.io.formats.mdl.MolImport;
import chemaxon.marvin.io.formats.mdl.MolfileUtil;
import chemaxon.marvin.util.CleanUtil;
import chemaxon.marvin.util.MolImportUtil;
import chemaxon.struc.DPoint3;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.MoleculeGraph;
import chemaxon.struc.RgMolecule;
import chemaxon.struc.RxnMolecule;
import chemaxon.struc.SelectionMolecule;
import chemaxon.struc.Sgroup;
import chemaxon.struc.StereoConstants;
import chemaxon.struc.graphics.MBracket;
import chemaxon.struc.sgroup.DataSgroup;
import chemaxon.struc.sgroup.MultipleSgroup;
import chemaxon.struc.sgroup.RepeatingUnitSgroup;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

class MolImportX
implements StereoConstants {
    MolImportX() {
    }

    static void reCalcRxn(Molecule mol) {
        RxnMolecule rxmol = RxnMolecule.getReaction(mol);
        if (rxmol != null && MolImportX.unarrangedComponents(rxmol)) {
            mol.arrangeComponents();
        }
    }

    private static boolean unarrangedComponents(RxnMolecule rxmol) {
        int pcount;
        double ax = 0.0;
        double ay = 0.0;
        double az = 0.0;
        DPoint3 b1 = new DPoint3();
        DPoint3 c1 = new DPoint3();
        DPoint3 b2 = new DPoint3();
        DPoint3 c2 = new DPoint3();
        int rcount = rxmol.getReactantCount();
        int count = rcount + (pcount = rxmol.getProductCount());
        if (count == 0) {
            return false;
        }
        Molecule m = rcount > 0 ? rxmol.getReactant(0) : rxmol.getProduct(0);
        m.calcOutRect(b1);
        m.calcOutRectCenter(c1);
        for (int i = 1; i < count; ++i) {
            m = i < rcount ? rxmol.getReactant(i) : rxmol.getProduct(i - rcount);
            m.calcOutRect(b2);
            m.calcOutRectCenter(c2);
            if ((c2.x - c1.x) * ax + (c2.y - c1.y) * ay + (c2.z - c1.z) * az <= -1.0E-4 || MolImportX.overlapping(b1, c1, b2, c2)) {
                return true;
            }
            ax = c2.x - c1.x;
            ay = c2.y - c1.y;
            az = c2.z - c1.z;
            b1.set(b2);
            c1.set(c2);
        }
        return false;
    }

    private static boolean overlapping(DPoint3 b1, DPoint3 c1, DPoint3 b2, DPoint3 c2) {
        return Math.abs(c2.x - c1.x) <= 0.4 * (b2.x + b1.x) && Math.abs(c2.y - c1.y) <= 0.4 * (b2.y + b1.y) && Math.abs(c2.z - c1.z) <= 0.4 * (b2.z + b1.z) + 1.0E-4;
    }

    static int readRxnV2(MolImport that, Molecule arg) throws MolFormatException, IOException {
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (arg instanceof RxnMolecule) {
            rxmol = (RxnMolecule)arg;
            rxmol.setInputFormat(that.inputIsRDF ? "rdf" : "rxn");
        } else if (arg instanceof RgMolecule) {
            rgmol = (RgMolecule)arg;
            rgmol.clearForImport(that.inputIsRDF ? "rdf" : "rxn");
            Molecule m = rgmol.getRoot();
            rxmol = m instanceof RxnMolecule ? (RxnMolecule)m : new RxnMolecule();
            rxmol.setInputFormat(that.inputIsRDF ? "rdf" : "rxn");
        }
        if (rxmol == null) {
            throw new MolFormatException("Cannot read Rxnfile, argument is not a RxnMolecule");
        }
        MolInputStream mis = that.molInputStream;
        String[] lines = new String[3];
        for (int i = 0; i < 3; ++i) {
            String s = mis.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return -1;
        }
        if (!lines[0].startsWith("$RXN")) {
            return -1;
        }
        that.readLine();
        String commentLine = that.currentLine;
        rxmol.setComment(commentLine);
        if (rgmol != null) {
            rgmol.setComment(commentLine);
        }
        that.readLine();
        that.currentColumn = 0;
        int nr = that.atoiV2(3);
        int np = that.atoiV2(3);
        int na = that.atoiV2(3);
        if (na < 0) {
            na = 0;
        }
        int m = nr + np;
        int n = m + na;
        int format2 = 0;
        MolImport mi = new MolImport();
        mi.setOptions("b1.54");
        mi.setMolInputStream(mis);
        for (int i = 0; i < n; ++i) {
            Object[] hinfo;
            String l = that.currentLine;
            if (l == null || !l.startsWith("$MOL")) {
                l = mis.readLine();
                if (l == null) {
                    throw new MolFormatException("Unexpected end of Rxnfile before " + (i < nr ? "reactant " + (i + 1) : "product " + (i - nr + 1)));
                }
                if (!l.startsWith("$MOL")) {
                    throw new MolFormatException("Unexpected line in Rxnfile ($MOL expected)");
                }
            }
            if ((hinfo = that.readHeader()) == null) {
                throw new MolFormatException("Unexpected end of Rxnfile");
            }
            Molecule mol = new Molecule();
            try {
                mi.setOptions("b1.54");
                mi.setMolInputStream(mis);
                int fmt = mi.readCtab(mol, hinfo, null, null, null);
                that.currentLine = mi.currentLine;
                that.currentColumn = 0;
                if (fmt < 0) {
                    throw new MolFormatException("Reactant or product in bad format");
                }
                mol.setInputFormat(MolImport.FORMATS[format2 |= fmt]);
                rxmol.addComponent(mol, i < nr ? 0 : (i < m ? 1 : 2));
                continue;
            }
            catch (NumberFormatException e) {
                throw new MolFormatException("Cannot read Rxnfile, molecule is not in MDL mol format");
            }
        }
        if (format2 & true) {
            rxmol.setInputFormat(that.inputIsRDF ? "csrdf" : "csrxn");
            if (rgmol != null) {
                rgmol.setInputFormat("csrgf");
            }
        }
        rxmol.valenceCheck();
        if (rgmol != null) {
            MolImportUtil.addProperties(rxmol.properties(), rgmol.getRoot().properties());
            rgmol.setRoot(rxmol);
        }
        that.molfileVersion = 2;
        return format2;
    }

    static int readRxnV3(MolImport that, Molecule arg, int versionNumber) throws MolFormatException, IOException {
        String l;
        RxnMolecule rxmol = null;
        RgMolecule rgmol = null;
        if (arg instanceof RxnMolecule) {
            rxmol = (RxnMolecule)arg;
        } else if (arg instanceof RgMolecule) {
            rgmol = (RgMolecule)arg;
            rgmol.clearForImport(that.inputIsRDF ? "rdf:V3" : "rxn:V3");
            Molecule m = rgmol.getRoot();
            rxmol = m instanceof RxnMolecule ? (RxnMolecule)m : new RxnMolecule();
        } else {
            rxmol = new RxnMolecule();
        }
        rxmol.setInputFormat(that.inputIsRDF ? "rdf:V3" : "rxn:V3");
        MolInputStream mis = that.molInputStream;
        String[] lines = new String[3];
        for (int i = 0; i < 3; ++i) {
            String s = mis.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return -1;
        }
        if (!lines[0].startsWith("$RXN V3000")) {
            return -1;
        }
        that.readLine();
        String commentLine = that.currentLine;
        rxmol.setComment(commentLine);
        if (rgmol != null) {
            rgmol.setComment(commentLine);
        }
        if ((l = MolImportX.readLineV3(that)) == null || !l.startsWith("COUNTS ")) {
            throw new MolFormatException("COUNTS line expected");
        }
        that.currentColumn = 7;
        int[] nm = new int[]{MolImportX.atoiV3(that), MolImportX.atoiV3(that), MolImportX.atoiV3(that)};
        if (nm[0] < 0 || nm[1] < 0) {
            throw new MolFormatException("Numbers in COUNTS line are missing or negative");
        }
        l = MolImportX.readLineV3(that);
        String[] blocks = new String[]{"REACTANT", "PRODUCT", "AGENT"};
        for (int i = 0; i < blocks.length; ++i) {
            if (l != null && l.startsWith("BEGIN " + blocks[i])) {
                for (int j = 0; j < nm[i]; ++j) {
                    l = MolImportX.readLineV3(that);
                    if (!l.startsWith("BEGIN CTAB")) {
                        throw new MolFormatException("BEGIN CTAB expected");
                    }
                    Molecule g = new Molecule();
                    MolImportX.readCtabV3(that, g, versionNumber);
                    g.setInputFormat(that.inputIsRDF ? "rdf:V3" : "rxn:V3");
                    rxmol.addComponent(g, i == 0 ? 0 : (i == 1 ? 1 : 2));
                }
                l = MolImportX.readLineV3(that);
                if (l == null || !l.startsWith("END " + blocks[i])) {
                    throw new MolFormatException("END " + blocks[i] + " expected");
                }
                l = MolImportX.readLineV3(that);
                continue;
            }
            if (nm[i] <= 0) continue;
            throw new MolFormatException(blocks[i] + " block expected");
        }
        if (l == null) {
            throw new MolFormatException("Unexpected end of file");
        }
        while (l != null && l.startsWith("BEGIN RGROUP ")) {
            if (rgmol == null) {
                throw new MolFormatException("Cannot read Rgroups into RxnMolecule, use RgMolecule instead");
            }
            MolImportX.readRgroupBlockV3(that, rgmol, versionNumber);
            l = that.currentLine;
        }
        that.checkEnd();
        l = that.currentLine;
        if (l != null && l.startsWith("$RXN")) {
            mis.putBackLine();
        }
        rxmol.valenceCheck();
        if (rgmol != null) {
            MolImportUtil.addProperties(rxmol.properties(), rgmol.getRoot().properties());
            rgmol.setRoot(rxmol);
        }
        that.molfileVersion = 3;
        return 4;
    }

    static boolean readRgfV2(MolImport that, Molecule arg, boolean trySDF) throws MolFormatException, IOException {
        int format2;
        if (!(arg instanceof RgMolecule)) {
            throw new MolFormatException("Cannot read RGfile, argument is not RgMolecule");
        }
        RgMolecule mol = (RgMolecule)arg;
        MolInputStream mis = that.molInputStream;
        String[] lines = new String[3];
        for (int i = 0; i < 3; ++i) {
            String s = mis.readLine();
            lines[i] = s;
            if (lines[i] != null) continue;
            return false;
        }
        if (!lines[0].startsWith("$MDL ")) {
            return false;
        }
        if (!lines[1].equals("$MOL") || !lines[2].equals("$HDR")) {
            throw new MolFormatException("Not in MDL RGfile format");
        }
        MolImport mi = new MolImport();
        mi.setOptions("b1.54");
        mi.setMolInputStream(mis);
        Object[] hinfo = mi.readHeader();
        for (int i = 0; i < 2; ++i) {
            lines[i] = mis.readLine();
            if (lines[i] != null) continue;
            throw new MolFormatException("Unexpected end of RGfile");
        }
        if (!lines[0].equals("$END HDR") || !lines[1].equals("$CTAB")) {
            throw new MolFormatException("Bad RGfile");
        }
        Object[] rlogic = new Object[2];
        ArrayList<Integer> rlogicFlags = new ArrayList<Integer>();
        ArrayList<String> rlogicRanges = new ArrayList<String>();
        String l = mis.readLine();
        mis.putBackLine();
        if (l.equals("$RXN")) {
            format2 = MolImportX.readRxnV2(mi, mol);
            while (true) {
                if ((l = mi.currentLine) == null) {
                    throw new MolFormatException("Unexpected end of RGfile after the root structure (a reaction)");
                }
                if (l.startsWith("M  LOG")) {
                    MolImportX.readRlogicLine(mi, 0, false, rlogic);
                    rlogicFlags.add((Integer)rlogic[0]);
                    rlogicRanges.add((String)rlogic[1]);
                    l = mi.readLine();
                    continue;
                }
                break;
            }
        } else {
            format2 = mi.readCtab(mol, hinfo, rlogic, rlogicFlags, rlogicRanges);
            if (format2 < 0) {
                throw new MolFormatException("Root structure in bad format");
            }
        }
        if (that.inputIsRDF) {
            mol.setInputFormat((format2 & 1) != 0 ? "csrdf" : "rdf");
        } else {
            mol.setInputFormat((format2 & 1) != 0 ? "csrgf" : "rgf");
        }
        l = mi.currentLine;
        if (l == null) {
            throw new MolFormatException("Unexpected end of RGfile after the root structure");
        }
        if (!l.equals("$END CTAB")) {
            throw new MolFormatException("Bad RGfile");
        }
        l = mis.readLine();
        while (l != null && l.equals("$RGP")) {
            l = mis.readLine();
            if (l == null) {
                throw new MolFormatException("Unexpected end of RGfile");
            }
            int rgid = 0;
            l = l.trim();
            try {
                rgid = Integer.parseInt(l);
            }
            catch (NumberFormatException ex) {
                throw new MolFormatException("Rgroup id \"" + l + "\" is not an integer");
            }
            l = mis.readLine();
            while (l != null && l.equals("$CTAB")) {
                Molecule rgroup = new Molecule();
                mi.setOptions("b1.54");
                mi.setMolInputStream(mis);
                if (mi.readCtab(rgroup, hinfo, null, null, null) < 0) {
                    throw new MolFormatException("Rgroup in bad format");
                }
                that.generatorProgram = mi.generatorProgram;
                mol.addRgroup(rgid, rgroup);
                l = mi.currentLine;
                if (l != null && !l.equals("$END CTAB")) {
                    throw new MolFormatException("Bad RGfile");
                }
                l = mis.readLine();
            }
            if (l == null) {
                throw new MolFormatException("Unexpected end of RGfile");
            }
            if (!l.equals("$END RGP")) {
                throw new MolFormatException("Bad RGfile");
            }
            l = mis.readLine();
        }
        for (int i = 0; i < rlogicFlags.size(); ++i) {
            int f = (Integer)rlogicFlags.get(i);
            int j = mol.findRgroupIndex(f & Short.MAX_VALUE);
            if (j < 0) continue;
            String s = (String)rlogicRanges.get(i);
            try {
                mol.setRlogic(j, f);
                mol.setRlogicRange(j, s);
                continue;
            }
            catch (IllegalArgumentException ex) {
                throw new MolFormatException(ex.getMessage());
            }
        }
        mol.valenceCheck();
        if (l == null || !l.equals("$END MOL")) {
            return true;
        }
        that.readLine();
        if (trySDF) {
            that.tryReadingSDF(mol, format2);
        }
        return true;
    }

    static void readCtab2V3(MolImport that, Molecule mol, int versionNumber) throws MolFormatException, IOException {
        MolImportX.readCtabV3(that, mol, versionNumber);
        MolImportX.readLineV3(that);
    }

    private static void readCtabV3(MolImport that, Molecule mol, int versionNumber) throws MolFormatException, IOException {
        String line = MolImportX.readLineV3(that);
        if (!line.startsWith("COUNTS ")) {
            throw new MolFormatException("COUNTS line missing from V30 CTAB");
        }
        that.currentColumn = 7;
        int na = MolImportX.atoiV3(that);
        int nb = MolImportX.atoiV3(that);
        int nsg = MolImportX.atoiV3(that);
        int n3d = MolImportX.atoiV3(that);
        int chiralFlag = MolImportX.atoiV3(that);
        if (na < 0 || nb < 0 || nsg < 0 || n3d < 0 || chiralFlag < 0) {
            throw new MolFormatException("Bad COUNTS: less than 5 nonnegative numbers specified");
        }
        mol.setAbsStereo(chiralFlag != 0);
        MolImportX.atoiV3(that);
        line = MolImportX.readLineV3(that);
        if (!line.startsWith("BEGIN ATOM") && na == 0) {
            mol.endReuse(na);
            return;
        }
        int[] atomIndex = new int[na];
        HashMap<MolAtom, ArrayList<Integer>> extraAtoms = MolImportX.readAtomBlockV3(that, mol, na, versionNumber, atomIndex);
        line = MolImportX.readLineV3(that);
        if (line != null && line.startsWith("BEGIN BOND")) {
            MolImportX.readBondBlockV3(that, mol, nb, atomIndex);
            line = MolImportX.readLineV3(that);
        }
        while (line != null && !line.startsWith("END CTAB")) {
            if (line.startsWith("LINKNODE")) {
                that.currentColumn += 8;
                MolImportX.readLinkNodeV3(that, mol);
            } else if (line.startsWith("BEGIN SGROUP")) {
                MolImportX.readSgroupBlockV3(that, mol, nsg);
                MolImportUtil.reparentEmptySgroups(mol);
            } else if (line.startsWith("BEGIN OBJ3D")) {
                MolImportX.read3DBlockV3(that, n3d);
            } else if (line.startsWith("BEGIN COLLECTION")) {
                MolImportX.readCollectionBlockV3(that, mol);
            } else if (line.startsWith("BEGIN ")) {
                String what = line.substring(6).trim();
                while (line != null && !line.startsWith("END " + what)) {
                    line = MolImportX.readLineV3(that);
                }
                if (line == null) {
                    throw new MolFormatException("Premature end of file");
                }
            } else {
                throw new MolFormatException("Unexpected line in CTAB");
            }
            line = MolImportX.readLineV3(that);
        }
        if (line == null) {
            throw new MolFormatException("Premature end of file");
        }
        int extraAtomCount = MolImportX.addAttachmentPoints(extraAtoms);
        mol.endReuse(na + extraAtomCount);
    }

    static void correctMUL(MultipleSgroup sg) {
        if (sg.getRepeatingUnitAtomCount() == 0) {
            int i;
            SelectionMolecule smol = sg.getSgroupGraph();
            MoleculeGraph[] frags = smol.findFrags(SelectionMolecule.class, 1);
            ArrayList<MoleculeGraph> unit = new ArrayList<MoleculeGraph>();
            unit.add(frags[0]);
            for (i = 1; i < frags.length; ++i) {
                MoleculeGraph g;
                int j;
                for (j = 0; j < unit.size() && !(g = (MoleculeGraph)unit.get(j)).isSimilarTo(frags[i]); ++j) {
                }
                if (j != unit.size()) continue;
                unit.add(frags[i]);
            }
            for (i = 0; i < unit.size(); ++i) {
                MoleculeGraph g = (MoleculeGraph)unit.get(i);
                for (int j = 0; j < g.getAtomCount(); ++j) {
                    sg.setRepeatingUnitAtom(g.getAtom(j), true);
                }
            }
        }
    }

    static void readRlogicLine(MolImport that, int r1, boolean v3, Object[] rlogic) throws MolFormatException, IOException {
        that.currentColumn = 6;
        if (rlogic != null) {
            String range;
            String currentLine;
            int restH;
            int r2;
            if (v3) {
                r2 = MolImportX.atoiV3(that);
                restH = MolImportX.atoiV3(that);
                currentLine = that.currentLine;
                int currentColumn = that.currentColumn;
                range = currentLine.length() >= currentColumn + 1 ? currentLine.substring(currentColumn + 1).trim() : ">0";
            } else {
                that.atoiV2(3);
                r1 = that.atoiV2(4);
                r2 = that.atoiV2(4);
                restH = that.atoiV2(4);
                currentLine = that.currentLine;
                String string = range = currentLine.length() > 24 ? currentLine.substring(24).trim() : ">0";
            }
            if (range.startsWith("\"")) {
                if (range.length() == 1) {
                    throw new MolFormatException("Invalid R-logic range " + range);
                }
                if (range.endsWith("\"")) {
                    range = range.substring(1, range.length() - 1);
                }
            }
            r1 &= Short.MAX_VALUE;
            r2 &= Short.MAX_VALUE;
            if (restH != 0) {
                restH = Integer.MIN_VALUE;
            }
            if (range.length() == 0 || range.equals("\"\"")) {
                range = ">0";
            }
            int f = r1 | restH;
            if (r2 > 0) {
                f |= 0x8000 | r2 << 16;
            }
            rlogic[0] = new Integer(f);
            rlogic[1] = range;
        }
    }

    static HashMap<MolAtom, ArrayList<Integer>> readAtomBlockV3(MolImport that, Molecule mol, int na, int versionNumber, int[] atomIndex) throws MolFormatException, IOException, NumberFormatException {
        HashMap<MolAtom, ArrayList<Integer>> extraAtoms = new HashMap<MolAtom, ArrayList<Integer>>();
        boolean allInOrigin = true;
        for (int i = 0; i < na; ++i) {
            String word;
            boolean inOrigin;
            MolImportX.readLineV3(that);
            int index = MolImportX.atoiV3(that);
            if (index > atomIndex.length) {
                int[] tmp = new int[index + 1];
                System.arraycopy(atomIndex, 0, tmp, 0, atomIndex.length);
                atomIndex = tmp;
            }
            atomIndex[i] = index - 1;
            MolAtom a = mol.reuseAtom(0, i);
            MolImportX.readTypeV3(that, a);
            double x = MolImportX.atofV3(that);
            double y = MolImportX.atofV3(that);
            double z = MolImportX.atofV3(that);
            a.setXYZ(x, y, z);
            a.setCharge(0);
            boolean bl = inOrigin = x > -5.0E-5 && x < 5.0E-5 && y > -5.0E-5 && y < 5.0E-5;
            if (z < -5.0E-5 || z > 5.0E-5) {
                mol.setDim(3);
                inOrigin = false;
            }
            allInOrigin &= inOrigin;
            int aamap = MolImportX.atoiV3(that);
            a.setAtomMap(aamap);
            while ((word = MolImportX.readWordV3(that)) != null) {
                int h;
                if (word.startsWith("CHG=")) {
                    String s = word.substring(word.charAt(4) == '+' ? 5 : 4);
                    try {
                        a.setCharge(Integer.parseInt(s));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new MolFormatException("Charge \"" + s + "\" is not an integer");
                    }
                }
                if (word.startsWith("CFG=")) {
                    String s = word.substring(4);
                    try {
                        int p = Integer.parseInt(s);
                        a.setFlags(MolImport.decodeMDLParity(p), 7);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new MolFormatException("Parity \"" + s + "\" is not an integer");
                    }
                }
                if (word.startsWith("RAD=")) {
                    String s = word.substring(4);
                    try {
                        MolImport.setRadical(a, Integer.parseInt(s));
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new MolFormatException("Radical \"" + s + "\" is not an integer");
                    }
                }
                if (word.startsWith("MASS=")) {
                    int m = Integer.parseInt(word.substring(5));
                    a.setMassno(m);
                    continue;
                }
                if (word.startsWith("VAL=")) {
                    int v = Integer.parseInt(word.substring(4));
                    switch (v) {
                        case 0: {
                            v = -1;
                            break;
                        }
                        case -1: {
                            v = 0;
                        }
                    }
                    a.setValenceProp(v);
                    continue;
                }
                if (word.startsWith("HCOUNT=")) {
                    int h2 = Integer.parseInt(word.substring(7));
                    switch (h2) {
                        case 0: {
                            h2 = -1;
                            break;
                        }
                        case -1: {
                            h2 = 0;
                        }
                    }
                    if (h2 <= 0) continue;
                    a.setImplicitHcount(h2);
                    continue;
                }
                if (word.startsWith("ATTCHPT=")) {
                    MolImportX.readATTCHPT(versionNumber, extraAtoms, a, word);
                    continue;
                }
                if (word.startsWith("RGROUPS=")) {
                    String s = MolImportX.readWordV3(that);
                    if (s.endsWith(")")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    int r = Integer.parseInt(s);
                    a.setRgroup(r);
                    continue;
                }
                if (word.startsWith("INVRET=")) {
                    int v = Integer.parseInt(word.substring(7));
                    a.setReactionStereo(v);
                    continue;
                }
                if (word.startsWith("SUBST=")) {
                    int h3 = Integer.parseInt(word.substring(6));
                    if (h3 == 0) continue;
                    if (h3 == -1) {
                        h3 = 0;
                    }
                    a.setQProp("s", h3);
                    continue;
                }
                if (word.startsWith("UNSAT=")) {
                    int h4 = Integer.parseInt(word.substring(6));
                    if (h4 == 0) continue;
                    a.setQProp("u", h4);
                    continue;
                }
                if (!word.startsWith("RBCNT=") || (h = Integer.parseInt(word.substring(6))) == 0) continue;
                if (h == -1) {
                    h = 0;
                }
                a.setQProp("rb", h);
            }
        }
        if (allInOrigin) {
            mol.setDim(0);
        } else if (mol.getDim() < 2) {
            mol.setDim(2);
        }
        MolImportX.readLineV3(that);
        if (!that.currentLine.startsWith("END ATOM")) {
            throw new MolFormatException("Atom block does not end with `END ATOM'");
        }
        return extraAtoms;
    }

    private static int addAttachmentPoints(HashMap<MolAtom, ArrayList<Integer>> extraAtoms) {
        int extraAtomCount = 0;
        Set<MolAtom> keys = extraAtoms.keySet();
        for (MolAtom key : keys) {
            ArrayList<Integer> orderList = extraAtoms.get(key);
            for (int order : orderList) {
                if (order == -1) {
                    CleanUtil.setBestLigandPosition(key, key.addRgroupAttachmentPoint(1, 1));
                    CleanUtil.setBestLigandPosition(key, key.addRgroupAttachmentPoint(2, 1));
                    extraAtomCount += 2;
                    continue;
                }
                CleanUtil.setBestLigandPosition(key, key.addRgroupAttachmentPoint(order, 1));
                ++extraAtomCount;
            }
        }
        return extraAtomCount;
    }

    private static void readATTCHPT(int versionNumber, HashMap<MolAtom, ArrayList<Integer>> extraAtoms, MolAtom a, String word) {
        int k = Integer.parseInt(word.substring(8));
        if (versionNumber < 541) {
            if (k == -1) {
                k = 3;
            }
            a.setAttach(k);
        } else if (extraAtoms.get(a) == null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            list.add(k);
            extraAtoms.put(a, list);
        } else {
            ArrayList<Integer> list = extraAtoms.get(a);
            list.add(k);
        }
    }

    static void readBondBlockV3(MolImport that, Molecule mol, int nb, int[] atomIndex) throws MolFormatException, IOException, NumberFormatException {
        for (int i = 0; i < nb; ++i) {
            MolAtom a2;
            String word;
            MolImportX.readLineV3(that);
            MolImportX.atoiV3(that);
            int type = MolImportX.atoiV3(that);
            if (type == 8) {
                type = 0;
            } else if (type < 1 || type > 8) {
                throw new MolFormatException("Bad bond type " + type);
            }
            int f = type;
            int i1 = MolImportX.atoiV3(that);
            int i2 = MolImportX.atoiV3(that);
            if (i1 < 1 || i1 > atomIndex.length || i2 < 1 || i2 > atomIndex.length || i1 == i2) {
                throw new MolFormatException("Invalid atom indices in bond definition (" + i1 + ", " + i2 + ")");
            }
            i1 = atomIndex[i1 - 1];
            i2 = atomIndex[i2 - 1];
            while ((word = MolImportX.readWordV3(that)) != null) {
                if (word.startsWith("CFG=")) {
                    int t = f & 0xF;
                    char c = word.charAt(4);
                    if (t == 1) {
                        switch (c) {
                            case '1': {
                                f |= 0x10;
                                break;
                            }
                            case '2': {
                                f |= 0x30;
                                break;
                            }
                            case '3': {
                                f |= 0x20;
                            }
                        }
                        continue;
                    }
                    if (t == 2 && c == '2') {
                        f |= 0xC0;
                        continue;
                    }
                    throw new MolFormatException("Invalid CFG=" + c + " value for bond type " + t + ".");
                }
                if (word.startsWith("TOPO=")) {
                    switch (word.charAt(5)) {
                        case '1': {
                            f |= 0x400;
                            break;
                        }
                        case '2': {
                            f |= 0x800;
                        }
                    }
                    continue;
                }
                if (word.startsWith("STBOX=")) {
                    if (word.charAt(6) != '1') continue;
                    f |= 0x200;
                    continue;
                }
                if (!word.startsWith("RXCTR=")) continue;
                StringTokenizer st = new StringTokenizer(word, "=");
                String flagToken = "";
                while (st.hasMoreTokens()) {
                    flagToken = st.nextToken();
                }
                int rcFlag = new Integer(flagToken);
                switch (rcFlag) {
                    case -1: 
                    case 15: {
                        rcFlag = 20480;
                        break;
                    }
                    case 1: {
                        rcFlag = 4096;
                        break;
                    }
                    case 2: {
                        rcFlag = 24576;
                        break;
                    }
                    case 4: {
                        rcFlag = 8192;
                        break;
                    }
                    case 8: {
                        rcFlag = 12288;
                        break;
                    }
                    case 12: {
                        rcFlag = 16384;
                        break;
                    }
                    default: {
                        rcFlag = 0;
                    }
                }
                f |= rcFlag;
            }
            MolAtom a1 = mol.getAtom(i1);
            if (a1.isBoundTo(a2 = mol.getAtom(i2))) continue;
            MolBond b = new MolBond(a1, a2, f);
            mol.add(b);
        }
        MolImportX.readLineV3(that);
        if (!that.currentLine.startsWith("END BOND")) {
            throw new MolFormatException("Bond block does not end with `END BOND'");
        }
    }

    private static void readLinkNodeV3(MolImport that, Molecule mol) throws NumberFormatException {
        int min = MolImportX.atoiV3(that);
        int max = MolImportX.atoiV3(that);
        int n = MolImportX.atoiV3(that);
        for (int i = 0; i < n; ++i) {
            int inner = MolImportX.atoiV3(that);
            int outIdx = MolImportX.atoiV3(that);
            MolAtom a = mol.getAtom(inner - 1);
            a.setMinRepetitions(min);
            a.setMaxRepetitions(max);
            MolAtom aout = mol.getAtom(outIdx - 1);
            int outer = outIdx == 0 ? -1 : a.getLigandIndex(aout);
            a.setLinkNodeOuterAtom(i, outer);
        }
    }

    private static void readSgroupBlockV3(MolImport that, Molecule mol, int nsg) throws MolFormatException, IOException, NumberFormatException {
        int i;
        ArrayList<Serializable> parents = new ArrayList<Serializable>();
        for (i = 0; i < nsg; ++i) {
            String word;
            MolImportX.readLineV3(that);
            MolImportX.atoiV3(that);
            String s = MolImportX.readWordV3(that);
            Integer sgtype = MolfileUtil.getSgroupType(s);
            if (sgtype == null) {
                throw new MolFormatException("Unknown S-group type \"" + s + "\"");
            }
            Sgroup sg = that.createSgroup(mol, sgtype);
            while ((word = MolImportX.readWordV3(that)) != null) {
                MolBond[] b;
                DataSgroup dsg;
                int j;
                Object a;
                if (word.startsWith("ATOMS=(")) {
                    a = MolImportX.readAtomsV3(that, mol, word);
                    for (j = 0; j < ((MolAtom[])a).length; ++j) {
                        mol.setSgroupParent(a[j], sg, true);
                        a[j].setResidueSeq(i);
                    }
                } else if (word.startsWith("PATOMS=(")) {
                    MultipleSgroup mulsg = (MultipleSgroup)sg;
                    if ((word = word.substring(8)).length() == 0 && (word = MolImportX.readWordV3(that)).endsWith(")")) {
                        word = word.substring(0, word.length() - 1);
                    }
                    int n = Integer.parseInt(word);
                    for (int j2 = 0; j2 < n; ++j2) {
                        word = MolImportX.readWordV3(that);
                        if (j2 == n - 1 && word.endsWith(")")) {
                            word = word.substring(0, word.length() - 1);
                        }
                        int k = Integer.parseInt(word);
                        MolAtom a2 = mol.getAtom(k - 1);
                        mol.setSgroupParent(a2, sg, true);
                        mulsg.setRepeatingUnitAtom(a2, true);
                        a2.setResidueSeq(i);
                    }
                }
                if (word.startsWith("BRKXYZ=(")) {
                    double[] d = MolImportX.readDisplayInfoV3(that, word);
                    DPoint3[] points = new DPoint3[2];
                    if (d != null) {
                        points[0] = new DPoint3(d[0], d[1], d[2]);
                        points[1] = new DPoint3(d[3], d[4], d[5]);
                    }
                    MolImportUtil.readBrackets(sg, points, true, 0.385);
                    continue;
                }
                if (word.startsWith("SAP=(")) {
                    MolImportX.readSAPV3(that, sg, mol, word);
                    continue;
                }
                if (word.startsWith("LABEL=")) {
                    word = word.substring(6);
                    if (sg.getType() == 0 && sg.countAllAtoms() == 1 && MolImportX.isV3BeilsteinGeneric(word)) {
                        a = sg.getAtom(0);
                        mol.setSgroupParent((MolAtom)a, sg, false);
                        mol.ungroupSgroup(sg);
                        ((MolAtom)a).setAtno(136);
                        ((MolAtom)a).setResidueSeq(0);
                        ((MolAtom)a).setAliasstr(word.toUpperCase());
                        continue;
                    }
                    MolImport.setSgroupSubscript(sg, word);
                    continue;
                }
                if (word.startsWith("MULT=")) {
                    word = word.substring(5);
                    try {
                        int n = Integer.parseInt(word);
                        ((MultipleSgroup)sg).setMultiplier(n);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        throw new MolFormatException("Multiple group multipler \"" + word + "\" is not a positive integer");
                    }
                }
                if (word.startsWith("CONNECT=")) {
                    word = word.substring(8);
                    int t = MolImport.readSgroupConnectivity(word);
                    sg.setConnectivity(t);
                    continue;
                }
                if (word.startsWith("PARENT=")) {
                    word = word.substring(7);
                    int k = Integer.parseInt(word);
                    parents.add(sg);
                    parents.add(new Integer(k - 1));
                    continue;
                }
                if (word.startsWith("COMPNO=")) {
                    word = word.substring(7);
                    int k = Integer.parseInt(word);
                    sg.setSubscript("c" + Integer.toString(k));
                    continue;
                }
                if (word.startsWith("BRKTYP=")) {
                    if (!(word = word.substring(7)).startsWith("PAREN")) continue;
                    ArrayList<MBracket> brackets = sg.getBrackets();
                    for (j = 0; j < brackets.size(); ++j) {
                        brackets.get(j).setType(0);
                    }
                    continue;
                }
                if (word.startsWith("ESTATE=")) {
                    if (!(word = word.substring(7)).equals("E")) continue;
                    if (that.expandedSgroups == null) {
                        that.expandedSgroups = new HashSet<Sgroup>();
                    }
                    that.expandedSgroups.add(sg);
                    continue;
                }
                if (word.startsWith("CBONDS=")) continue;
                if (word.startsWith("FIELDNAME=")) {
                    word = word.substring(10);
                    dsg = (DataSgroup)sg;
                    dsg.setFieldName(word);
                    continue;
                }
                if (word.startsWith("FIELDINFO=")) {
                    String units;
                    String format2;
                    word = word.substring(10);
                    dsg = (DataSgroup)sg;
                    if (word.length() > 2) {
                        format2 = word.substring(0, 2);
                        units = word.substring(2);
                    } else {
                        format2 = "  ";
                        units = word;
                    }
                    dsg.setFieldType(format2);
                    if (units == null || units.equals("")) continue;
                    dsg.setUnits(units);
                    continue;
                }
                if (word.startsWith("FIELDDISP=")) {
                    word = word.substring(10);
                    dsg = (DataSgroup)sg;
                    that.readSDDValue(dsg, word);
                    continue;
                }
                if (word.startsWith("MRV_FIELDDISP=")) {
                    word = word.substring(14);
                    dsg = (DataSgroup)sg;
                    dsg.setContext(Integer.parseInt(word));
                    continue;
                }
                if (word.startsWith("QUERYTYPE=")) {
                    word = word.substring(10);
                    dsg = (DataSgroup)sg;
                    dsg.setQueryCode(word);
                    continue;
                }
                if (word.startsWith("QUERYOP=")) {
                    word = word.substring(8);
                    dsg = (DataSgroup)sg;
                    dsg.setQueryOp(word);
                    continue;
                }
                if (word.startsWith("FIELDDATA=")) {
                    word = word.substring(10);
                    dsg = (DataSgroup)sg;
                    dsg.addDataLine(word);
                    continue;
                }
                if (word.startsWith("XBONDS=(")) {
                    word = word.substring(8);
                    MolImportX.readBondsV3(that, mol, word);
                    continue;
                }
                if (word.startsWith("XBHEAD=(")) {
                    word = word.substring(8);
                    b = MolImportX.readBondsV3(that, mol, word);
                    if (!(sg instanceof RepeatingUnitSgroup)) continue;
                    RepeatingUnitSgroup sru = (RepeatingUnitSgroup)sg;
                    MolBond[] head = sru.getHeadCrossingBonds();
                    MolBond[] tail = sru.getTailCrossingBonds();
                    if (head == null) {
                        sru.setHeadCrossingBonds(b);
                        continue;
                    }
                    if (tail == null || (tail[0] != b[0] || tail[1] != b[1]) && (tail[0] != b[1] || tail[1] != b[0])) continue;
                    sru.swapHeadTail();
                    continue;
                }
                if (word.startsWith("XBCORR=(")) {
                    word = word.substring(8);
                    b = MolImportX.readBondsV3(that, mol, word);
                    if (!(sg instanceof RepeatingUnitSgroup)) continue;
                    RepeatingUnitSgroup sru = (RepeatingUnitSgroup)sg;
                    sru.setBondCorrespondence(b);
                    continue;
                }
                if (!word.startsWith("SUBTYPE=")) continue;
                Integer t = MolImport.readSubtype(word = word.substring(8));
                if (t == null) {
                    throw new MolFormatException("Unknown S-group subtype \"" + word + "\"");
                }
                sg.setSubType(t);
            }
        }
        for (i = 0; i < parents.size(); i += 2) {
            Sgroup sg = (Sgroup)parents.get(i);
            int k = (Integer)parents.get(i + 1);
            mol.getSgroup(k).addChildSgroup(sg);
        }
        int resSeq = 0;
        for (int i2 = 0; i2 < mol.getSgroupCount(); ++i2) {
            Sgroup sg = mol.getSgroup(i2);
            if (sg.getParentSgroup() == null) {
                MolImport.setResidues(sg, resSeq);
                ++resSeq;
            }
            that.correctSgroup(sg);
        }
        MolImportUtil.setSgroupParentSgroups(mol);
        MolImportUtil.recalcBrackets(mol, 0.385);
        MolImportX.readLineV3(that);
        if (!that.currentLine.startsWith("END SGROUP")) {
            throw new MolFormatException("S-group block does not end with `END SGROUP'");
        }
    }

    private static void readSAPV3(MolImport that, Sgroup sg, Molecule mol, String word) throws IOException {
        int n;
        if ((word = word.substring(5)).length() == 0) {
            word = MolImportX.readWordV3(that);
            if (word.endsWith(")")) {
                word = word.substring(0, word.length() - 1);
            }
        } else if (word.endsWith(")")) {
            word = word.substring(0, word.length() - 1);
        }
        if ((n = Integer.parseInt(word)) == 3) {
            word = MolImportX.readWordV3(that);
            int atom_index = Integer.parseInt(word);
            word = MolImportX.readWordV3(that);
            word = MolImportX.readWordV3(that);
            word = word.substring(0, word.length() - 1);
            int order_value = Integer.parseInt(word);
            MolAtom atom = mol.getAtom(atom_index - 1);
            if (atom.getAttach() == 0 && (order_value == 1 || order_value == 2)) {
                atom.setAttach(order_value, sg);
            } else if (atom.getAttach() == 1 && order_value == 2 || atom.getAttach() == 2 && order_value == 2) {
                atom.setAttach(3, sg);
            }
        }
    }

    private static boolean isV3BeilsteinGeneric(String s) {
        return MolfileUtil.isSpecBeilsteinGeneric(s.toUpperCase());
    }

    static void readRgroupBlockV3(MolImport that, RgMolecule mol, int versionNumber) throws MolFormatException, IOException {
        Object[] rlogic = null;
        that.currentColumn = 12;
        int rgid = MolImportX.atoiV3(that);
        String line = MolImportX.readLineV3(that);
        while (!line.startsWith("END RGROUP")) {
            if (line.startsWith("RLOGIC")) {
                rlogic = new Object[2];
                MolImportX.readRlogicLine(that, rgid, true, rlogic);
            } else if (line.startsWith("BEGIN CTAB")) {
                Molecule rgroup = new Molecule();
                MolImportX.readCtabV3(that, rgroup, versionNumber);
                rgroup.setInputFormat(that.inputIsRDF ? "rdf:V3" : "mol:V3");
                mol.addRgroup(rgid, rgroup);
            } else {
                throw new MolFormatException("RLOGIC or BEGIN CTAB expected");
            }
            line = MolImportX.readLineV3(that);
        }
        if (rlogic != null) {
            int f = (Integer)rlogic[0];
            int i = mol.findRgroupIndex(rgid);
            if (i >= 0) {
                String s = (String)rlogic[1];
                try {
                    mol.setRlogic(i, f);
                    mol.setRlogicRange(i, s);
                }
                catch (IllegalArgumentException ex) {
                    throw new MolFormatException(ex.getMessage());
                }
            }
        }
        MolImportX.readLineV3(that);
    }

    private static void read3DBlockV3(MolImport that, int n3d) throws MolFormatException, IOException, NumberFormatException {
        for (int i = 0; i < n3d; ++i) {
            MolImportX.readLineV3(that);
        }
        MolImportX.readLineV3(that);
        if (!that.currentLine.startsWith("END OBJ3D")) {
            throw new MolFormatException("3D block does not end with `END OBJ3D'");
        }
    }

    private static void readCollectionBlockV3(MolImport that, Molecule mol) throws MolFormatException, IOException, NumberFormatException {
        String line = MolImportX.readLineV3(that);
        while (line != null && !line.startsWith("END COLLECTION")) {
            if (line.startsWith("MDLV30/STE")) {
                String word;
                int type = 0;
                int g = 1;
                if (line.startsWith("MDLV30/STEABS ")) {
                    type = 1;
                    that.currentColumn = 14;
                } else if (line.startsWith("MDLV30/STEREL")) {
                    type = 2;
                    that.currentColumn = 13;
                    g = MolImportX.atoiV3(that);
                } else if (line.startsWith("MDLV30/STERAC")) {
                    type = 3;
                    that.currentColumn = 13;
                    g = MolImportX.atoiV3(that);
                } else {
                    throw new MolFormatException("Invalid stereo group specification");
                }
                if ((type == 2 || type == 3) && g <= 0) {
                    throw new MolFormatException("Invalid stereo group number");
                }
                while ((word = MolImportX.readWordV3(that)) != null) {
                    if (word.startsWith("ATOMS=(")) {
                        MolAtom[] a = MolImportX.readAtomsV3(that, mol, word);
                        for (int j = 0; j < a.length; ++j) {
                            a[j].setStereoGroupType(type);
                            a[j].setStereoGroupNumber(g);
                        }
                        continue;
                    }
                    throw new MolFormatException("Unexpected token " + word);
                }
            } else if (line.startsWith("MDLV30/HILITE ")) {
                String word;
                that.currentColumn = 13;
                while ((word = MolImportX.readWordV3(that)) != null) {
                    int j;
                    if (word.startsWith("ATOMS=(")) {
                        MolAtom[] a = MolImportX.readAtomsV3(that, mol, word);
                        for (j = 0; j < a.length; ++j) {
                            a[j].setSetSeq(1);
                        }
                        continue;
                    }
                    if (!word.startsWith("BONDS=(")) continue;
                    word = word.substring(7);
                    MolBond[] b = MolImportX.readBondsV3(that, mol, word);
                    for (j = 0; j < b.length; ++j) {
                        b[j].setSetSeq(1);
                    }
                }
            }
            line = MolImportX.readLineV3(that);
        }
        if (line == null) {
            throw new MolFormatException("Premature end of file");
        }
    }

    private static MolAtom[] readAtomsV3(MolImport that, MoleculeGraph mol, String word) throws IOException {
        if ((word = word.substring(7)).length() == 0) {
            word = MolImportX.readWordV3(that);
            if (word.endsWith(")")) {
                word = word.substring(0, word.length() - 1);
            }
        } else if (word.endsWith(")")) {
            word = word.substring(0, word.length() - 1);
        }
        int n = Integer.parseInt(word);
        MolAtom[] a = new MolAtom[n];
        for (int j = 0; j < n; ++j) {
            word = MolImportX.readWordV3(that);
            if (j == n - 1 && word.endsWith(")")) {
                word = word.substring(0, word.length() - 1);
            }
            int k = Integer.parseInt(word);
            a[j] = mol.getAtom(k - 1);
        }
        return a;
    }

    private static MolBond[] readBondsV3(MolImport that, MoleculeGraph mol, String word) throws IOException {
        if (word.length() == 0 && (word = MolImportX.readWordV3(that)).endsWith(")")) {
            word = word.substring(0, word.length() - 1);
        }
        int n = Integer.parseInt(word);
        MolBond[] b = new MolBond[n];
        for (int j = 0; j < n; ++j) {
            word = MolImportX.readWordV3(that);
            if (j == n - 1 && word.endsWith(")")) {
                word = word.substring(0, word.length() - 1);
            }
            int k = Integer.parseInt(word);
            b[j] = mol.getBond(k - 1);
        }
        return b;
    }

    private static double[] readDisplayInfoV3(MolImport that, String word) throws IOException {
        if ((word = word.substring(8)).length() == 0 && (word = MolImportX.readWordV3(that)).endsWith(")")) {
            word = word.substring(0, word.length() - 1);
        }
        int n = Integer.parseInt(word);
        double[] d = new double[n];
        for (int j = 0; j < n; ++j) {
            word = MolImportX.readWordV3(that);
            if (j == n - 1 && word.endsWith(")")) {
                word = word.substring(0, word.length() - 1);
            }
            d[j] = Double.parseDouble(word);
        }
        return d;
    }

    private static boolean goToWordStartV3(MolImport that) {
        int i = that.currentColumn;
        String s = that.currentLine;
        if (i >= s.length()) {
            return false;
        }
        char c = s.charAt(i);
        while ((c == ' ' || c == '\t') && i < s.length() - 1) {
            c = s.charAt(++i);
        }
        that.currentColumn = i;
        return i < s.length();
    }

    private static int findWordEndV3(MolImport that) throws MolFormatException, IOException {
        String s = that.currentLine;
        int i = that.currentColumn;
        char c = s.charAt(i);
        while (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
            if (c == '\"') {
                int nextQuote;
                while (true) {
                    if ((nextQuote = s.indexOf(34, i + 1)) == -1) {
                        throw new MolFormatException("Unclosed quotation mark.");
                    }
                    if (nextQuote + 1 >= s.length() || s.charAt(nextQuote + 1) != '\"') break;
                    i = nextQuote + 1;
                }
                i = nextQuote;
            }
            if (++i < s.length()) {
                c = s.charAt(i);
                continue;
            }
            return i;
        }
        return i;
    }

    private static int atoiV3(MolImport that) {
        if (!MolImportX.goToWordStartV3(that)) {
            return -1;
        }
        String s = that.currentLine;
        int i = that.currentColumn;
        char c = s.charAt(i);
        if (c < '0' || c > '9') {
            return -1;
        }
        int x = 0;
        while (c >= '0' && c <= '9') {
            x = 10 * x + (c - 48);
            if (++i >= s.length()) break;
            c = s.charAt(i);
        }
        that.currentColumn = i;
        return x;
    }

    private static double atofV3(MolImport that) {
        if (!MolImportX.goToWordStartV3(that)) {
            return 0.0;
        }
        String s = that.currentLine;
        int i = that.currentColumn;
        char c = s.charAt(i);
        if (c == '+') {
            that.currentColumn = ++i;
            if (i >= s.length()) {
                return 0.0;
            }
        }
        if ((c < '0' || c > '9') && c != '.' && c != '-') {
            return 0.0;
        }
        int j = i;
        while ((c >= '0' && c <= '9' || c == '.' || c == '-' || c == 'e' || c == 'E') && ++j < s.length()) {
            c = s.charAt(j);
        }
        that.currentColumn = j;
        return Double.valueOf(s.substring(i, j));
    }

    private static String readWordV3(MolImport that) throws IOException {
        String word;
        int j;
        if (!MolImportX.goToWordStartV3(that)) {
            return null;
        }
        String s = that.currentLine;
        int i = that.currentColumn;
        that.currentColumn = j = MolImportX.findWordEndV3(that);
        if (j > i) {
            word = s.substring(i, j);
            word = MolImportX.dequotify(word);
        } else {
            word = null;
        }
        return word;
    }

    private static String dequotify(String word) {
        int quotePlace;
        int pos = 0;
        while ((quotePlace = word.indexOf("\"", pos)) != -1) {
            pos = quotePlace + 1 < word.length() && word.charAt(quotePlace + 1) == '\"' ? quotePlace + 1 : quotePlace;
            word = word.substring(0, quotePlace) + word.substring(quotePlace + 1);
        }
        return word;
    }

    private static void readTypeV3(MolImport that, MolAtom a) throws MolFormatException, IOException {
        int atno;
        char cc;
        if (!MolImportX.goToWordStartV3(that)) {
            throw new MolFormatException("Cannot read atom type");
        }
        String s = that.currentLine;
        int i = that.currentColumn;
        char c = s.charAt(i);
        int j = i;
        if (c == '\'' || c == '\"') {
            ++i;
            if (++j >= s.length()) {
                throw new MolFormatException("Cannot read atom type");
            }
            cc = s.charAt(j);
            while (cc != c && j < s.length()) {
                if (++j >= s.length()) continue;
                cc = s.charAt(j);
            }
        } else {
            cc = s.charAt(j);
            while (cc != ' ' && j < s.length()) {
                if (++j >= s.length()) continue;
                cc = s.charAt(j);
            }
        }
        that.currentColumn = j + 1;
        if ((s = s.substring(i, j)).startsWith("NOT") || s.startsWith("[")) {
            atno = s.startsWith("NOT") ? 129 : 128;
            int k = s.indexOf(91);
            int l = s.indexOf(93);
            if (k < 0 || l < 0 || k > l) {
                throw new MolFormatException("atom list with unmatched square bracket");
            }
            s = s.substring(k + 1, l);
            StringTokenizer st = new StringTokenizer(s, ",");
            int n = st.countTokens();
            int[] list = new int[n];
            for (k = 0; k < n; ++k) {
                String sym = st.nextToken().trim();
                try {
                    list[k] = MolAtom.getAtomicNumber(sym);
                }
                catch (IllegalArgumentException e) {
                    list[k] = 0;
                }
                if (list[k] >= 0) continue;
                throw new MolFormatException("unknown atom type \"" + sym + "\"");
            }
            a.setAtno(atno);
            a.setList(list);
        } else {
            atno = 0;
            try {
                atno = MolAtom.getAtomicNumber(s);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (atno == 0) {
                atno = 136;
            }
            a.setAtno(atno);
            a.setForSpecIsotopeSymbol(s);
            if (atno == 136) {
                a.setAliasstr(MolImport.convertMDL2Short(s));
            }
        }
    }

    private static String readLineV3(MolImport that) throws IOException {
        String line;
        StringBuffer sbuf = new StringBuffer();
        do {
            if ((line = that.molInputStream.readLine()).length() < 7) {
                that.currentLine = line;
                that.currentColumn = 0;
                return line;
            }
            if ((line = line.substring(7)).endsWith("\\\r\n")) {
                line = line.substring(0, line.length() - 3);
            } else if (line.endsWith("\\\r") || line.endsWith("\\\n")) {
                line = line.substring(0, line.length() - 2);
            } else if (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
            }
            if (line.endsWith("-")) {
                sbuf.append(line.substring(0, line.length() - 1));
                continue;
            }
            sbuf.append(line);
        } while (line.endsWith("-"));
        that.currentLine = sbuf.toString();
        that.currentColumn = 0;
        return that.currentLine;
    }
}

