/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name;

import chemaxon.license.Licensable;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.MolExportModule;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.struc.MPropertyContainer;
import chemaxon.struc.Molecule;
import java.util.List;

public class NameExport
extends MolExportModule
implements Licensable {
    public static final char nameSeparator = '\n';
    private String licenseEnvironment = "";
    private int timeout = -1;
    private boolean ignoreErrors = false;
    private boolean source = false;

    protected void getOptionDescriptors(String fmtname, String optnames, List l) {
    }

    @Override
    public Object convert(Molecule mol) throws MolExportException {
        if (mol.getAtomCount() == 0) {
            return "\n";
        }
        if (this.source) {
            return mol.getName() + "\n";
        }
        String name = null;
        try {
            name = IUPACNamer.generateName(mol, this.timeout, true, this.licenseEnvironment);
        }
        catch (IUPACNamer.Error e) {
            if (this.ignoreErrors) {
                name = "";
            }
            throw e;
        }
        return name + '\n';
    }

    @Override
    public Object open(String fmtopts, MPropertyContainer props) throws MolExportException {
        Options.resetToDefault();
        this.ignoreErrors = false;
        return super.open(fmtopts, props);
    }

    @Override
    protected int parseOption(String opts, int i) throws IllegalArgumentException {
        String remaining = opts.substring(i);
        if (remaining.startsWith("+dict")) {
            Options.traditionalFullNames = true;
            return i + "+dict".length();
        }
        if (remaining.startsWith("-dict")) {
            Options.traditionalFullNames = false;
            Options.noDict = true;
            return i + "-dict".length();
        }
        if (remaining.startsWith("common")) {
            Options.common = true;
            return i + "common".length();
        }
        if (remaining.startsWith("all")) {
            Options.all = true;
            return i + "all".length();
        }
        if (remaining.startsWith("ignoreErrors")) {
            this.ignoreErrors = true;
            return i + "ignoreErrors".length();
        }
        if (remaining.startsWith("source")) {
            this.source = true;
            return i + "source".length();
        }
        int newI = super.parseOption(opts, i);
        if (newI != i) {
            return newI;
        }
        switch (opts.charAt(i)) {
            case 'a': {
                Options.unicode = false;
                ++i;
            }
            case 'i': {
                Options.IUPAC();
                ++i;
            }
            case 't': {
                if (opts.substring(i).startsWith("timeout=")) {
                    try {
                        int end = opts.indexOf(44, i);
                        if (end == -1) {
                            end = opts.length();
                        }
                        this.timeout = Integer.parseInt(opts.substring(i + "timeout=".length(), end));
                        i = end;
                    }
                    finally {
                        return i;
                    }
                }
                Options.traditional();
                ++i;
            }
            case 'u': {
                Options.unicode = true;
                ++i;
            }
            default: {
                return i;
            }
        }
    }

    @Override
    public boolean isCleanable() {
        return false;
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Structure to Name Plugin");
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }
}

