/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name;

import chemaxon.formats.MolFormatException;
import chemaxon.formats.MolInputStream;
import chemaxon.license.Licensable;
import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolImportModule;
import chemaxon.naming.n2s.N2S;
import chemaxon.naming.n2s.Options;
import chemaxon.struc.Molecule;
import java.io.IOException;
import java.util.ArrayList;

public class NameImport
extends MolImportModule
implements Licensable {
    private MolInputStream istream;
    private String licenseEnvironment = "";
    private ArrayList<String> fieldNames = null;
    private String userDictPath = null;
    private Options options;
    private boolean ignoreErrors = false;
    public static final String CORRECTED_NAME = "CorrectedName";
    public static final String APPROXIMATE = "Approximate";
    public static final String AMBIGUOUS = "Ambiguous";
    public static final String TYPE = "type";
    public static final String GENERIC = "generic";
    public static final String SYSTEMATIC = "systematic";
    public static final String COMMON = "common";
    public static final String EXCEPTION = "Exception";

    private void setDefaultOptions() {
        this.options = new Options(null, false, true, false, false, 5, true, true);
    }

    @Override
    public void initMolImport(MolInputStream is) throws IOException {
        this.istream = is;
        if (this.userDictPath != null) {
            N2S.setUserDefineDictionary(this.userDictPath);
        }
    }

    @Override
    public boolean readMol(Molecule m) throws IOException {
        Molecule mol;
        m.clearForImport("name");
        String line = this.istream.readLine();
        if (line == null) {
            return false;
        }
        String name = this.readData(line, m);
        try {
            mol = this.importName(name);
        }
        catch (MolFormatException e) {
            this.ignoreErrors |= "true".equals(System.getProperty("chemaxon.marvin.View.running"));
            if (this.ignoreErrors) {
                mol = new Molecule();
                mol.setName(name);
                mol.setProperty(EXCEPTION, e.toString());
            }
            throw e;
        }
        m.setDim(mol.getDim());
        m.setName(name);
        if (!name.equals(mol.getName())) {
            m.setProperty(CORRECTED_NAME, mol.getName());
        }
        m.setProperty(APPROXIMATE, mol.getProperty(APPROXIMATE));
        m.setProperty(AMBIGUOUS, mol.getProperty(AMBIGUOUS));
        m.setProperty(TYPE, mol.getProperty(TYPE));
        m.setProperty(EXCEPTION, mol.getProperty(EXCEPTION));
        m.fuse(mol);
        return true;
    }

    public Molecule importName(String name) throws MolFormatException {
        try {
            if (this.options == null) {
                this.setDefaultOptions();
            }
            return N2S.importName(name, this.options, this.licenseEnvironment);
        }
        catch (MolFormatException e) {
            throw e;
        }
        catch (LicenseException le) {
            throw le;
        }
        catch (Exception e) {
            throw new MolFormatException(name + " : error in molecule file: " + e);
        }
    }

    private String readData(String line, Molecule m) {
        if (line.indexOf(9) == -1) {
            return line;
        }
        String[] data = line.split("\t");
        for (int i = 1; i < data.length; ++i) {
            String fieldName = this.fieldNames != null && this.fieldNames.size() >= i ? this.fieldNames.get(i - 1) : "field_" + i;
            m.setProperty(fieldName, data[i]);
        }
        return data[0];
    }

    @Override
    public Molecule createMol() {
        return new Molecule();
    }

    @Override
    public boolean isLicensed() {
        return LicenseHandler.getInstance().isLicensed("Name to Structure", this.licenseEnvironment);
    }

    @Override
    public void setLicenseEnvironment(String env) {
        this.licenseEnvironment = env;
    }

    @Override
    public void setOptions(String opts) {
        this.setDefaultOptions();
        this.fieldNames = null;
        if (opts == null) {
            return;
        }
        while (opts.length() > 0) {
            String thisOpt;
            int end;
            if (opts.startsWith("licenseEnvironment=")) {
                end = opts.indexOf(44);
                if (end == -1) {
                    end = opts.length();
                }
                this.licenseEnvironment = opts.substring(opts.indexOf(61) + 1, end);
                opts = opts.substring(end);
                continue;
            }
            if (opts.startsWith("dict=")) {
                end = opts.indexOf(44);
                if (end == -1) {
                    end = opts.length();
                }
                this.userDictPath = opts.substring(opts.indexOf(61) + 1, end);
                opts = opts.substring(end);
                continue;
            }
            end = opts.indexOf(44);
            if (end == -1) {
                end = opts.length();
            }
            if (NameImport.applyOption(thisOpt = opts.substring(0, end), this.options)) {
                opts = opts.substring(end);
                continue;
            }
            if (opts.equalsIgnoreCase("dataMining")) {
                opts = opts.substring(end);
                this.options.dataMining = true;
                continue;
            }
            if (opts.equalsIgnoreCase("ignoreErrors")) {
                opts = opts.substring(end);
                this.ignoreErrors = true;
                continue;
            }
            if (opts.startsWith("ambiguous")) {
                String opt = opts.substring("ambiguous".length(), end);
                opts = opts.substring(end);
                if (opt.equals("")) {
                    this.options.setAmbiguous(10);
                    continue;
                }
                if (opt.equals("=0")) {
                    this.options.setAmbiguous(0);
                    continue;
                }
                throw new RuntimeException("Unsupported option: " + opt);
            }
            if (opts.startsWith("nextgen")) {
                opts = opts.substring(end);
                this.options.nextGen = true;
                this.options.vieuxCon = false;
                continue;
            }
            if (opts.startsWith("oldgen")) {
                opts = opts.substring(end);
                this.options.nextGen = false;
                this.options.vieuxCon = true;
                continue;
            }
            if (opts.startsWith("fusion")) {
                opts = opts.substring(end);
                this.options.nextGen = true;
                this.options.vieuxCon = true;
                continue;
            }
            char c = opts.charAt(0);
            if (c == ',') {
                opts = opts.substring(1);
                continue;
            }
            if (c == 'f') {
                String fieldName = opts.substring(1, end);
                if (this.fieldNames == null) {
                    this.fieldNames = new ArrayList();
                }
                this.fieldNames.add(fieldName);
                opts = opts.substring(end);
                continue;
            }
            if (opts.indexOf("license") != -1) {
                opts = "";
            }
            throw new IllegalArgumentException("Unknow name import option: " + opts);
        }
    }

    public static boolean applyOption(String option, Options options) {
        boolean value = true;
        if (option.startsWith("-")) {
            value = false;
            option = option.substring(1);
        } else if (option.startsWith("+")) {
            option = option.substring(1);
        }
        if (option.equals(SYSTEMATIC)) {
            options.systematic = value;
        } else if (option.equals("elements")) {
            options.convertElements = value;
        } else if (option.equals("ions")) {
            options.convertIons = value;
        } else if (option.equals("ocr")) {
            options.ocrCorrection = value;
        } else {
            return false;
        }
        return true;
    }
}

