/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.dictionaries;

public class NameCategorizer {
    public static boolean isChemicalFormula(String text) {
        if (text.indexOf("CH") != -1) {
            return true;
        }
        if (text.startsWith("[")) {
            return true;
        }
        return NameCategorizer.isCondensedFormula(text);
    }

    private static boolean isCondensedFormula(String text) {
        int pos = 0;
        int digits = 0;
        while (pos < text.length()) {
            char c;
            if ((c = text.charAt(pos++)) < 'A' || c > 'Z') {
                return false;
            }
            int curDigits = 0;
            while (pos < text.length() && NameCategorizer.isDigit(text.charAt(pos))) {
                ++pos;
                ++digits;
                if (++curDigits <= 2) continue;
                return false;
            }
        }
        return digits >= text.length() / 3;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean looksSystematic(String text) {
        return text.length() > 30;
    }

    public static boolean looksLikeName(String text) {
        if (NameCategorizer.isChemicalFormula(text)) {
            return false;
        }
        int letters = 0;
        for (char c : text.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            ++letters;
        }
        return letters > text.length() / 2;
    }
}

