/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.sgroup.SgroupAtom;
import chemaxon.struc.sgroup.SuperatomSgroup;

public class AminoAcid {
    static boolean isAminoAcid(MolAtom a) {
        return AminoAcid.getAminoAcidName(a) != null;
    }

    static boolean isAminoAcid(MolAtom[] chain) {
        return chain.length == 1 && AminoAcid.isAminoAcid(chain[0]);
    }

    static String getAminoAcidName(MolAtom a) {
        String res;
        char descriptor;
        if (a.getAtno() != 135) {
            return null;
        }
        String sym = a.getSymbol();
        if (sym == null) {
            return null;
        }
        String prefix = null;
        if ((sym.length() == 4 || sym.length() == 5 && sym.charAt(1) == '-') && ((descriptor = sym.charAt(0)) == 'D' || descriptor == 'L')) {
            prefix = descriptor + "-";
            sym = sym.substring(sym.length() - 3);
        }
        if (sym.startsWith("Me") && sym.length() >= 5) {
            prefix = "N-methyl";
            sym = sym.substring(2);
        }
        if ((res = AminoAcid.getAminoAcidName(sym)) == null) {
            return null;
        }
        if (prefix == null) {
            return res;
        }
        return prefix + res;
    }

    private static String getAminoAcidName(String sym) {
        if ((sym = sym.intern()) == "Ala") {
            return "alanine";
        }
        if (sym == "Arg") {
            return "arginine";
        }
        if (sym == "Asn") {
            return "asparagine";
        }
        if (sym == "Asp") {
            return "aspartic acid";
        }
        if (sym == "Cys") {
            return "cysteine";
        }
        if (sym == "Gln") {
            return "glutamine";
        }
        if (sym == "Glu") {
            return "glutamic acid";
        }
        if (sym == "Gly") {
            return "glycine";
        }
        if (sym == "His") {
            return "histidine";
        }
        if (sym == "Ile") {
            return "isoleucine";
        }
        if (sym == "Leu") {
            return "leucine";
        }
        if (sym == "Lys") {
            return "lysine";
        }
        if (sym == "Met") {
            return "methionine";
        }
        if (sym == "Phe") {
            return "phenylalanine";
        }
        if (sym == "Pro") {
            return "proline";
        }
        if (sym == "Ser") {
            return "serine";
        }
        if (sym == "Thr") {
            return "threonine";
        }
        if (sym == "Trp") {
            return "tryptophan";
        }
        if (sym == "Tyr") {
            return "tyrosine";
        }
        if (sym == "Val") {
            return "valine";
        }
        if (sym == "5Hyl") {
            return "5-hydroxylysine";
        }
        if (sym == "3Hyp") {
            return "3-hydroxyproline";
        }
        if (sym == "4Hyp") {
            return "4-hydroxyproline";
        }
        if (sym == "Abu") {
            return "2-aminobutyric acid";
        }
        if (sym == "Aib") {
            return "2-aminoisobutyric acid";
        }
        if (sym == "Orn") {
            return "ornithine";
        }
        if (sym == "Sar") {
            return "sarcosine";
        }
        if (sym == "Thi") {
            return "\u03b2-(2-thienyl)-L-alanine";
        }
        if (sym == "Nva") {
            return "norvaline";
        }
        if (sym == "Nle") {
            return "norleucine";
        }
        if (sym == "aIle") {
            return "alloisoleucine";
        }
        if (sym == "aThr") {
            return "allothreonine";
        }
        if (sym == "pGlu") {
            return "pyroglutamic acid";
        }
        return null;
    }

    static String acylName(MolAtom a) {
        return AminoAcid.acylName(a, null);
    }

    static String acylName(MolAtom a, MolAtom root) {
        MolAtom radical = null;
        if (root != null) {
            radical = AminoAcid.findAtomConnectedTo(root, a);
        }
        String acylNameStart = AminoAcid.acylNameStart(a);
        if (radical == null || radical.getAtno() == 6 || radical.getAtno() == 7) {
            return acylNameStart + "yl";
        }
        return acylNameStart + '-' + radical.getSymbol() + '-' + "yl";
    }

    private static String acylNameStart(MolAtom a) {
        String base = AminoAcid.getAminoAcidName(a);
        if (base == "cysteine") {
            return "cystein";
        }
        if (base == "tryptophan") {
            return "tryptoph";
        }
        if (base == "aspartic acid" || base == "glutamic acid") {
            boolean alpha;
            SuperatomSgroup sg = ((SgroupAtom)a).getSgroup();
            MolAtom attach = AminoAcid.findCarbonAttachment(sg);
            MolAtom neighbour = AminoAcid.findNeighbour(attach, 6);
            boolean bl = alpha = AminoAcid.findNeighbour(neighbour, 7) != null;
            if (base == "aspartic acid") {
                return alpha ? "\u03b1-aspart" : "\u03b2-aspart";
            }
            return alpha ? "\u03b1-glutam" : "\u03b3-glutam";
        }
        if (base.endsWith("ic acid")) {
            return base.substring(0, base.length() - 7);
        }
        return base.substring(0, base.length() - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MolAtom findAtomConnectedTo(MolAtom root, MolAtom superAtom) {
        root = SubmoleculeBuilder.originalAtom(root);
        superAtom = SubmoleculeBuilder.originalAtom(superAtom);
        SgroupAtom sga = (SgroupAtom)superAtom;
        SuperatomSgroup sg = sga.getSgroup();
        boolean expanded = false;
        try {
            expanded = sg.expand(0);
            MolBond[] crosses = sg.findCrossingBonds();
            int i = crosses.length;
            while (--i >= 0) {
                MolBond b = crosses[i];
                if (b.getAtom1() == root) {
                    MolAtom molAtom = b.getAtom2();
                    return molAtom;
                }
                if (b.getAtom2() != root) continue;
                MolAtom molAtom = b.getAtom1();
                return molAtom;
            }
            MolAtom molAtom = null;
            return molAtom;
        }
        finally {
            if (expanded) {
                sg.contract(0);
            }
        }
    }

    private static MolAtom findCarbonAttachment(SuperatomSgroup sg) {
        MolAtom[] attachments = sg.getAttachAtoms();
        int i = attachments.length;
        while (--i >= 0) {
            MolAtom neighbour = attachments[i];
            if (neighbour.getAtno() != 6) continue;
            return neighbour;
        }
        i = sg.getAtomCount();
        while (--i >= 0) {
            MolAtom a = sg.getAtom(i);
            if (a.getAtno() != 6 || a.getAttach() == 0) continue;
            return a;
        }
        return null;
    }

    private static MolAtom findNeighbour(MolAtom a, int atno) {
        int i = a.getBondCount();
        while (--i >= 0) {
            MolAtom neighbour = a.getLigand(i);
            if (neighbour.getAtno() != atno) continue;
            return neighbour;
        }
        return null;
    }

    public static boolean isParentAminoAcid(MolAtom a) {
        if (!AminoAcid.isAminoAcid(a)) {
            return false;
        }
        SuperatomSgroup sg = ((SgroupAtom)a).getSgroup();
        MolAtom C = AminoAcid.findCarbonAttachment(sg);
        if (C == null) {
            assert (false) : "An amino acid should always have a carbon attachment point";
            return false;
        }
        MolAtom neighbour = AminoAcid.findAtomConnectedTo(C, a);
        return neighbour == null || neighbour.getAtno() != 135 && neighbour.getBondCount() == 1;
    }
}

