/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Acyclic;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;

abstract class ChainComparator {
    ChainComparator() {
    }

    static int compare(MolAtom[] chain1, MolAtom[] chain2) {
        return ChainComparator.compare(chain1, chain1.length, chain2, null);
    }

    static int compare(MolAtom[] chain, int len, MolAtom[] principalChain, Acyclic acyclic) {
        int i;
        int diff;
        block39: {
            if (len == principalChain.length) {
                int i2 = len;
                while (--i2 >= 0) {
                    if (chain[i2] == principalChain[i2]) continue;
                    break block39;
                }
                return 1;
            }
        }
        if (acyclic != null) {
            int[] seniorityOld = acyclic.chainSeniority(principalChain, principalChain.length);
            int[] seniorityNew = acyclic.chainSeniority(chain, len);
            diff = seniorityNew[0] - seniorityOld[0];
            if (diff != 0) {
                return diff;
            }
            diff = seniorityOld[1] - seniorityNew[1];
            if (diff != 0) {
                return diff;
            }
        }
        int heteroOld = 0;
        int heteroNew = 0;
        int i3 = principalChain.length;
        while (--i3 >= 0) {
            if (!ChainComparator.isSeniorHeteroAtom(principalChain[i3])) continue;
            ++heteroOld;
        }
        i3 = len;
        while (--i3 >= 0) {
            if (!ChainComparator.isSeniorHeteroAtom(chain[i3])) continue;
            ++heteroNew;
        }
        diff = heteroOld - heteroNew;
        if (diff != 0) {
            return diff;
        }
        diff = principalChain.length - len;
        if (diff != 0) {
            return diff;
        }
        int[] seniorAtomsNew = ChainComparator.seniorAtoms(chain, len);
        int[] seniorAtomsOld = ChainComparator.seniorAtoms(principalChain, len);
        diff = seniorAtomsOld[0] - seniorAtomsNew[0];
        if (diff != 0) {
            return diff;
        }
        diff = seniorAtomsOld[1] - seniorAtomsNew[1];
        if (diff != 0) {
            return diff;
        }
        int unsatBondsNew = 0;
        int unsatBondsOld = 0;
        int i4 = principalChain.length;
        while (--i4 >= 1) {
            if (principalChain[i4 - 1].getBondTo(principalChain[i4]).getType() != 1) {
                ++unsatBondsOld;
            }
            if (chain[i4 - 1].getBondTo(chain[i4]).getType() == 1) continue;
            ++unsatBondsNew;
        }
        diff = unsatBondsOld - unsatBondsNew;
        if (diff != 0) {
            return diff;
        }
        int doubleBondsNew = 0;
        int doubleBondsOld = 0;
        int i5 = principalChain.length;
        while (--i5 >= 1) {
            if (principalChain[i5 - 1].getBondTo(principalChain[i5]).getType() == 2) {
                ++doubleBondsOld;
            }
            if (chain[i5 - 1].getBondTo(chain[i5]).getType() != 2) continue;
            ++doubleBondsNew;
        }
        diff = doubleBondsOld - doubleBondsNew;
        if (diff != 0) {
            return diff;
        }
        int[] heteroPosOld = new int[heteroOld];
        int[] heteroPosNew = new int[heteroNew];
        int o = 0;
        int n = 0;
        int i6 = len;
        while (--i6 >= 0) {
            if (ChainComparator.isSeniorHeteroAtom(principalChain[i6])) {
                heteroPosOld[o++] = i6;
            }
            if (!ChainComparator.isSeniorHeteroAtom(chain[i6])) continue;
            heteroPosNew[n++] = i6;
        }
        diff = Util.setComparison(heteroPosNew, heteroPosOld);
        if (diff != 0) {
            return diff;
        }
        if (acyclic != null && acyclic.radical != null) {
            int radicalOld = Util.indexOf(acyclic.radical, principalChain);
            int radicalNew = Util.indexOf(acyclic.radical, chain);
            diff = radicalNew - radicalOld;
            if (diff != 0) {
                return diff;
            }
        }
        int[] unsatPosOld = new int[unsatBondsOld];
        int[] unsatPosNew = new int[unsatBondsNew];
        o = 0;
        n = 0;
        i6 = principalChain.length;
        while (--i6 >= 1) {
            if (principalChain[i6 - 1].getBondTo(principalChain[i6]).getType() != 1) {
                unsatPosOld[o++] = i6;
            }
            if (chain[i6 - 1].getBondTo(chain[i6]).getType() == 1) continue;
            unsatPosNew[n++] = i6;
        }
        diff = Util.setComparison(unsatPosNew, unsatPosOld);
        if (diff != 0) {
            return diff;
        }
        int[] doublePosOld = new int[doubleBondsOld];
        int[] doublePosNew = new int[doubleBondsNew];
        o = 0;
        n = 0;
        i6 = principalChain.length;
        while (--i6 >= 1) {
            if (principalChain[i6 - 1].getBondTo(principalChain[i6]).getType() == 2) {
                doublePosOld[o++] = i6;
            }
            if (chain[i6 - 1].getBondTo(chain[i6]).getType() != 2) continue;
            doublePosNew[n++] = i6;
        }
        diff = Util.setComparison(doublePosNew, doublePosOld);
        if (diff != 0) {
            return diff;
        }
        IntVector positionsNew = new IntVector(len);
        IntVector positionsOld = new IntVector(len);
        if (acyclic != null && acyclic.substituted != null) {
            i = len;
            while (--i >= 0) {
                if (Util.indexOf(acyclic.m.indexOf(principalChain[i]), acyclic.substituted) != -1) {
                    positionsOld.add(i);
                }
                if (Util.indexOf(acyclic.m.indexOf(chain[i]), acyclic.substituted) == -1) continue;
                positionsNew.add(i);
            }
        }
        i = len - 1;
        while (--i >= 1) {
            if (principalChain[i].getBondCount() > 2) {
                positionsOld.add(i);
            }
            if (chain[i].getBondCount() <= 2) continue;
            positionsNew.add(i);
        }
        if (principalChain[0].getBondCount() > 1) {
            positionsOld.add(0);
        }
        if (principalChain[len - 1].getBondCount() > 1) {
            positionsOld.add(len - 1);
        }
        if (chain[0].getBondCount() > 1) {
            positionsNew.add(0);
        }
        if (chain[len - 1].getBondCount() > 1) {
            positionsNew.add(len - 1);
        }
        if ((diff = positionsOld.size() - positionsNew.size()) != 0) {
            return diff;
        }
        diff = Util.setComparison(positionsNew.toArray(), positionsOld.toArray());
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    static int compare(Chain c1, Chain c2) {
        return Util.alphabeticalPointToPointComparison(c1.modifiers.getSubstituents(), c2.modifiers.getSubstituents());
    }

    static boolean isSeniorHeteroAtom(MolAtom atom) {
        return Chem.parentSeniority(atom.getAtno()) > 1;
    }

    static int[] seniorAtoms(MolAtom[] chain, int len) {
        int[] seniority = new int[2];
        int i = len;
        while (--i >= 0) {
            int s = Chem.parentSeniority(chain[i].getAtno());
            if (s == seniority[0]) {
                seniority[1] = seniority[1] + 1;
                continue;
            }
            if (s <= seniority[0]) continue;
            seniority[0] = s;
            seniority[1] = 1;
        }
        return seniority;
    }
}

