/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.SubstituablePart;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.PeriodicSystem;
import java.util.ArrayList;

class CharacteristicGroup
extends SubstituablePart {
    MolAtom alternateRoot;
    MolBond rootBond;
    String prefixName;
    boolean eatCarbon = false;
    boolean asPrefix;
    MolAtom usualRadical;
    GroupDictionary.Structure group;
    MolAtom[] atoms;
    private int specialJuniority = -1;
    MolBond ezBond;

    static CharacteristicGroup create(MolAtom root, MolAtom alternateRoot, MolAtom start, GroupDictionary.Structure match, boolean asPrefix, MolAtom usualRadical) {
        boolean turned = usualRadical != null;
        String prefixName = match.prefixName;
        if (match.radicalName != null && Chem.isRealRadical(start)) {
            prefixName = match.radicalName;
        }
        if (turned && match.turnedPrefixName != null) {
            prefixName = match.turnedRadicalName != null && Chem.isRealRadical(start) ? match.turnedRadicalName : match.turnedPrefixName;
            asPrefix = true;
        }
        if (root != null && start != null && prefixName != null && prefixName.endsWith("yl")) {
            int type = -1;
            if (prefixName == match.turnedRadicalName) {
                type = Chem.effectiveRadicalCount(start, false);
            } else {
                MolBond bond = root.getBondTo(start);
                if (bond != null) {
                    type = bond.getType();
                }
            }
            if (type > 0) {
                prefixName = prefixName.substring(0, prefixName.length() - 2) + Chem.substituentEnding[type];
            }
        }
        return new CharacteristicGroup(root, alternateRoot, start, match, match.eatCarbon, prefixName, asPrefix, usualRadical);
    }

    CharacteristicGroup(MolAtom root) {
        super(root);
    }

    CharacteristicGroup(MolAtom root, MolAtom alternateRoot, MolAtom start, GroupDictionary.Structure group, boolean eatCarbon, String prefixName, boolean asPrefix, MolAtom usualRadical) {
        super(root);
        this.radical = start;
        this.alternateRoot = alternateRoot;
        this.group = group;
        this.eatCarbon = eatCarbon;
        this.prefixName = prefixName;
        this.asPrefix = asPrefix;
        this.usualRadical = usualRadical;
    }

    boolean hasSeveral(int atno) {
        int count = 0;
        for (MolAtom a : this.atoms) {
            if (a.getAtno() != atno || ++count != 2) continue;
            return true;
        }
        return false;
    }

    void setRootBond(MolBond rootBond) {
        this.rootBond = rootBond;
    }

    int getType() {
        return this.rootBond == null ? 1 : this.rootBond.getType();
    }

    @Override
    String getName() {
        if (this.asPrefix) {
            return this.getPrefixName();
        }
        return this.getParentName();
    }

    private String unsubstitutedVersion(String end) {
        if (end == "amido") {
            return "formamido";
        }
        if (end.endsWith("amido") && !end.startsWith("carba")) {
            if (Util.isVowel(end.charAt(0))) {
                return "methan" + end;
            }
            return "methane" + end;
        }
        return end;
    }

    private boolean hasUnlocatedSubstituent(int[] locants) {
        if (locants == null) {
            return true;
        }
        int i = locants.length;
        while (--i >= 0) {
            if (locants[i] != -899) continue;
            return true;
        }
        return false;
    }

    private void prettifySubstituents() {
        if (this.substituents == null) {
            return;
        }
        if (this.group != null && (this.group.acceptsSubstituents || this.noYl())) {
            int i = this.substituents.length;
            while (--i >= 0) {
                SimplePart p;
                if (!(this.substituents[i] instanceof SimplePart) || (p = (SimplePart)this.substituents[i]).complex() && this.group.acceptsSubstituents && !p.isBenzene() && !(p instanceof Chain) || !this.group.acceptsSubstituents && p.root.getAtno() == 7) continue;
                p.glueToSuffix();
            }
        }
    }

    String substituents(String end, boolean asPrefix, boolean asSuffix) {
        this.prettifySubstituents();
        boolean asParent = !asPrefix && !asSuffix;
        StringBuffer res = new StringBuffer();
        Modifiers mod = new Modifiers(this);
        if (this.substituents != null) {
            int[] roots = (int[])(asParent || this.isTurned() ? this.computeRoots() : null);
            mod.addSubstituents(roots, this.substituents);
            if (!this.hasUnlocatedSubstituent(roots)) {
                end = this.unsubstitutedVersion(end);
            }
        } else {
            end = this.unsubstitutedVersion(end);
        }
        if (this.atoms != null) {
            for (MolAtom a : this.atoms) {
                if (a == null || a == this.atoms[0] && this.group.eatCarbon || a.getMassno() == 0) continue;
                mod.addIsotope(-899, a.getAtno(), a.getMassno());
            }
        }
        if (!asSuffix) {
            mod.addChiralAtom(Chem.getChirality(this.radical));
            if (this.ezBond != null) {
                mod.addBond(2, this.originalMolecule.indexOf(this.ezBond.getAtom1()), this.originalMolecule.indexOf(this.ezBond.getAtom2()));
            }
        }
        mod.printPrefix(null, null, res);
        if (end == "amido" && res.toString().endsWith("benzene")) {
            res.delete(res.length() - 3, res.length());
        }
        if (res.length() > 0 && end.indexOf(45) != -1) {
            res.append('-');
        }
        res.append(end);
        return mod.getFullName(res.toString()).intern();
    }

    @Override
    boolean needsLocants() {
        if (this.group == null || this.substituents == null) {
            return false;
        }
        if (!this.group.needsLocants()) {
            return false;
        }
        boolean toLabelLess = false;
        for (Part sub : this.substituents) {
            MolAtom root;
            if (sub == null || (root = SubmoleculeBuilder.originalAtom(sub.root)) == null || root.getExtraLabel() != null || this.isUsualRadical(root)) continue;
            toLabelLess = true;
        }
        return toLabelLess;
    }

    boolean isTurned() {
        return this.usualRadical != null;
    }

    boolean isUsualRadical(MolAtom a) {
        MolAtom radical = this.usualRadical != null ? this.usualRadical : this.radical;
        return a == SubmoleculeBuilder.originalAtom(radical);
    }

    int[] computeRoots() {
        if (!this.needsLocants()) {
            return null;
        }
        int[] res = new int[this.substituents.length];
        int i = this.substituents.length;
        while (--i >= 0) {
            MolAtom root = SubmoleculeBuilder.originalAtom(this.substituents[i].root);
            if (root != null && !this.isUsualRadical(root)) {
                String label = root.getExtraLabel();
                if (label == " ") {
                    res[i] = -900;
                    continue;
                }
                if (label != null) {
                    throw new IUPACNamer.Failure("Locants should assigned to all atoms in the group: " + this.group);
                }
                res[i] = Part.heteroLocant(root);
                continue;
            }
            res[i] = -899;
        }
        return res;
    }

    @Override
    String computePrefixName() {
        String end = this.getPrefixNameEnd();
        return this.substituents(end, true, false);
    }

    String getPrefixNameEnd() {
        if (this.prefixName != null) {
            return this.prefixName;
        }
        throw new IUPACNamer.Failure("Group " + this.group + " cannot be expressed as a prefix");
    }

    String getSuffixName() {
        if (this.asPrefix) {
            return this.getPrefixNameEnd();
        }
        if (this.group.suffixName == null) {
            throw new IUPACNamer.Failure("Group " + this.group + " cannot be a suffix");
        }
        return this.substituents(this.group.suffixName, false, true).intern();
    }

    String getParentName() {
        return this.substituents(this.getParentNameStem(), false, false);
    }

    private String getParentNameStem() {
        String suffixName;
        String string = suffixName = this.hasRadical() ? this.prefixName : this.group.suffixName;
        if (suffixName == null) {
            throw new IUPACNamer.Failure("Group " + this.group + " cannot be a parent");
        }
        if (suffixName == "carboxamide") {
            return "formamide";
        }
        if (suffixName == "carboximidamide") {
            return "methanimidamide";
        }
        if (suffixName == "carboxylate") {
            return "formate";
        }
        return suffixName;
    }

    @Override
    boolean isHydroxy() {
        return this.group != null && this.group.prefixName == "hydroxy";
    }

    boolean isKetone() {
        return this.group.suffixName == "one";
    }

    boolean isNonSuffixKetone() {
        int column;
        return this.isKetone() && this.root != null && ((column = PeriodicSystem.getColumn(this.root.getAtno())) < 14 || column > 16);
    }

    boolean isEster() {
        return this.group != null && this.group.getSuffix1() == 9;
    }

    void forceAsSuffix() {
        this.specialJuniority = 1;
    }

    void clearAsSuffix() {
        this.specialJuniority = -1;
    }

    @Override
    int suffixJuniority() {
        if (this.isNonSuffixKetone()) {
            return -1;
        }
        if (this.specialJuniority != -1) {
            return this.specialJuniority;
        }
        int res = 2 * this.group.suffixJuniority;
        if (this.isTurned()) {
            ++res;
        }
        return res;
    }

    @Override
    int parentSeniority() {
        if (this.group != null && this.group.suffixName == null) {
            return Integer.MAX_VALUE;
        }
        return super.parentSeniority();
    }

    @Override
    boolean complex() {
        if (this.group != null && this.group.complex) {
            return true;
        }
        if (this.substituents == null) {
            return false;
        }
        if (this.group == null) {
            return true;
        }
        if (this.group.acceptsSubstituents && this.substituents.length == 1 && this.substituents[0].isMethane()) {
            return false;
        }
        return !this.noYl() || this.substituents.length != 1;
    }

    boolean noYl() {
        return this.prefixName != null && this.prefixName.endsWith("amido");
    }

    @Override
    void addSubstituents(Part[] newSubstituents) {
        if (newSubstituents == null || newSubstituents.length == 0) {
            return;
        }
        super.addSubstituents(newSubstituents);
        this.findSubstituentsOnSubstituents();
    }

    private void findSubstituentsOnSubstituents() {
        int nbRemoved = 0;
        int i = this.substituents.length;
        while (--i >= 0) {
            int j = this.substituents.length;
            while (--j >= 0) {
                MolAtom radical2;
                MolAtom root1;
                if (i == j) continue;
                Part s1 = this.substituents[i];
                Part s2 = this.substituents[j];
                if (s1 == null || s2 == null || (root1 = SubmoleculeBuilder.originalAtom(s1.root)) != (radical2 = SubmoleculeBuilder.originalAtom(s2.radical))) continue;
                s2.addSubstituent(s1, s2.originalMolecule.indexOf(s2.radical));
                this.substituents[i] = null;
                ++nbRemoved;
            }
        }
        if (nbRemoved > 0) {
            Part[] substituents = new Part[this.substituents.length - nbRemoved];
            int n = 0;
            int i2 = this.substituents.length;
            while (--i2 >= 0) {
                if (this.substituents[i2] == null) continue;
                substituents[n++] = this.substituents[i2];
            }
            this.substituents = substituents;
        }
    }

    @Override
    void removeSubstituents(ArrayList substituents) {
        if (this.substituents == null) {
            return;
        }
        int i = this.substituents.length;
        while (--i >= 0) {
            this.substituents[i].removeSubstituents(substituents);
        }
    }

    @Override
    Part getRealParent(MolAtom atom) {
        int i;
        if (atom == SubmoleculeBuilder.originalAtom(this.radical)) {
            return this;
        }
        if (this.atoms != null) {
            i = this.atoms.length;
            while (--i >= 0) {
                if (atom != this.atoms[i]) continue;
                return this;
            }
        }
        if (this.substituents != null) {
            i = this.substituents.length;
            while (--i >= 0) {
                Part res = this.substituents[i].getRealParent(atom);
                if (res == null) continue;
                return res;
            }
        }
        return super.getRealParent(atom);
    }

    @Override
    int getParentRootBondStereo() {
        if (this.rootBond == null) {
            return 0;
        }
        return Modifiers.getBondStereo(this.rootBond);
    }

    String getPrefix() {
        if (this.group == null) {
            return null;
        }
        return this.group.getPrefix();
    }

    @Override
    int getCharge() {
        int charge;
        int n = charge = this.group == null ? 0 : this.group.getCharge();
        if (charge == 0) {
            return super.getCharge();
        }
        return charge;
    }
}

