/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.core.calculations.LonePairCounter;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MoleculeGraph;

public abstract class Chem {
    public static final int H = 1;
    public static final int He = 2;
    public static final int Li = 3;
    public static final int Be = 4;
    public static final int B = 5;
    public static final int C = 6;
    public static final int N = 7;
    public static final int O = 8;
    public static final int F = 9;
    public static final int Ne = 10;
    public static final int Na = 11;
    public static final int Mg = 12;
    public static final int Al = 13;
    public static final int Si = 14;
    public static final int P = 15;
    public static final int S = 16;
    public static final int Cl = 17;
    public static final int Ar = 18;
    public static final int K = 19;
    public static final int Ca = 20;
    public static final int Sc = 21;
    public static final int Ti = 22;
    public static final int V = 23;
    public static final int Cr = 24;
    public static final int Mn = 25;
    public static final int Fe = 26;
    public static final int Co = 27;
    public static final int Ni = 28;
    public static final int Cu = 29;
    public static final int Zn = 30;
    public static final int Ga = 31;
    public static final int Ge = 32;
    public static final int As = 33;
    public static final int Se = 34;
    public static final int Br = 35;
    public static final int Kr = 36;
    public static final int Rb = 37;
    public static final int Sr = 38;
    public static final int Y = 39;
    public static final int Zr = 40;
    public static final int Nb = 41;
    public static final int Mo = 42;
    public static final int Tc = 43;
    public static final int Ru = 44;
    public static final int Rh = 45;
    public static final int Pd = 46;
    public static final int Ag = 47;
    public static final int Cd = 48;
    public static final int In = 49;
    public static final int Sn = 50;
    public static final int Sb = 51;
    public static final int Te = 52;
    public static final int I = 53;
    public static final int Xe = 54;
    public static final int Cs = 55;
    public static final int Ba = 56;
    public static final int La = 57;
    public static final int Ce = 58;
    public static final int Pr = 59;
    public static final int Nd = 60;
    public static final int Pm = 61;
    public static final int Sm = 62;
    public static final int Eu = 63;
    public static final int Gd = 64;
    public static final int Tb = 65;
    public static final int Dy = 66;
    public static final int Ho = 67;
    public static final int Er = 68;
    public static final int Tm = 69;
    public static final int Yb = 70;
    public static final int Lu = 71;
    public static final int Hf = 72;
    public static final int Ta = 73;
    public static final int W = 74;
    public static final int Re = 75;
    public static final int Os = 76;
    public static final int Ir = 77;
    public static final int Pt = 78;
    public static final int Au = 79;
    public static final int Hg = 80;
    public static final int Tl = 81;
    public static final int Pb = 82;
    public static final int Bi = 83;
    public static final int Po = 84;
    public static final int At = 85;
    public static final int Rn = 86;
    public static final int Fr = 87;
    public static final int Ra = 88;
    public static final int Ac = 89;
    public static final int Th = 90;
    public static final int Pa = 91;
    public static final int U = 92;
    public static final int Np = 93;
    public static final int Pu = 94;
    public static final int Am = 95;
    public static final int Cm = 96;
    public static final int Bk = 97;
    public static final int Cf = 98;
    public static final int Es = 99;
    public static final int Fm = 100;
    public static final int Md = 101;
    public static final int No = 102;
    public static final int Lr = 103;
    public static final int Rf = 104;
    public static final int Db = 105;
    public static final int Sg = 106;
    public static final int Bh = 107;
    public static final int Hs = 108;
    public static final int Mt = 109;
    public static final int Ds = 110;
    public static final int Rg = 111;
    public static final int MAX_SENIORITY = Chem.seniority(9) + 1;
    public static final int seniorityAl = Chem.seniority(13);
    public static final int seniorityB = Chem.seniority(5);
    public static final int seniorityF = Chem.seniority(9);
    public static final int seniorityI = Chem.seniority(53);
    public static final int seniorityN = Chem.seniority(7);
    public static final int seniorityO = Chem.seniority(8);
    public static final int seniorityP = Chem.seniority(15);
    public static final int seniorityPb = Chem.seniority(82);
    public static final int senioritySb = Chem.seniority(51);
    public static final int senioritySi = Chem.seniority(14);
    public static final int seniorityTe = Chem.seniority(52);
    public static final int seniorityTl = Chem.seniority(81);
    static final String[] substituentEnding = new String[]{"e", "yl", "ylidene", "ylidyne"};
    private static final int REL_STEREO_BITS = 10;
    public static final int STEREO_CIS = 0;
    public static final int STEREO_TRANS = 1;
    public static final int STEREO_R = 2;
    public static final int STEREO_S = 3;
    public static final int STEREO_r = 4;
    public static final int STEREO_s = 5;
    public static final int STEREO_M = 6;
    public static final int STEREO_P = 7;

    static boolean isHalogen(MolAtom a) {
        int atno = a.getAtno();
        return atno == 9 || atno == 17 || atno == 35 || atno == 53;
    }

    static boolean isEtherAnalog(MolAtom a) {
        if (a.getCharge() != 0) {
            return false;
        }
        int atno = a.getAtno();
        return atno == 8 || atno == 16 || atno == 34 || atno == 52;
    }

    public static boolean isChalcogen(int atno) {
        return atno == 8 || atno == 16 || atno == 34 || atno == 52 || atno == 84;
    }

    public static int seniority(int atno) {
        switch (atno) {
            case 9: {
                return 119;
            }
            case 17: {
                return 118;
            }
            case 35: {
                return 117;
            }
            case 53: {
                return 116;
            }
            case 85: {
                return 115;
            }
            case 8: {
                return 114;
            }
            case 16: {
                return 113;
            }
            case 34: {
                return 112;
            }
            case 52: {
                return 111;
            }
            case 84: {
                return 110;
            }
            case 1: {
                return 109;
            }
            case 7: {
                return 108;
            }
            case 15: {
                return 107;
            }
            case 33: {
                return 106;
            }
            case 51: {
                return 105;
            }
            case 83: {
                return 104;
            }
            case 6: {
                return 103;
            }
            case 14: {
                return 102;
            }
            case 32: {
                return 101;
            }
            case 50: {
                return 100;
            }
            case 82: {
                return 99;
            }
            case 5: {
                return 98;
            }
            case 13: {
                return 97;
            }
            case 31: {
                return 96;
            }
            case 49: {
                return 95;
            }
            case 81: {
                return 94;
            }
            case 30: {
                return 93;
            }
            case 48: {
                return 92;
            }
            case 80: {
                return 91;
            }
            case 29: {
                return 90;
            }
            case 47: {
                return 89;
            }
            case 79: {
                return 88;
            }
            case 111: {
                return 87;
            }
            case 28: {
                return 86;
            }
            case 46: {
                return 85;
            }
            case 78: {
                return 84;
            }
            case 110: {
                return 83;
            }
            case 27: {
                return 82;
            }
            case 45: {
                return 81;
            }
            case 77: {
                return 80;
            }
            case 109: {
                return 79;
            }
            case 26: {
                return 78;
            }
            case 44: {
                return 77;
            }
            case 76: {
                return 76;
            }
            case 108: {
                return 75;
            }
            case 25: {
                return 74;
            }
            case 43: {
                return 73;
            }
            case 75: {
                return 72;
            }
            case 107: {
                return 71;
            }
            case 24: {
                return 70;
            }
            case 42: {
                return 69;
            }
            case 74: {
                return 68;
            }
            case 106: {
                return 67;
            }
            case 23: {
                return 66;
            }
            case 41: {
                return 65;
            }
            case 73: {
                return 64;
            }
            case 105: {
                return 63;
            }
            case 22: {
                return 62;
            }
            case 40: {
                return 61;
            }
            case 72: {
                return 60;
            }
            case 104: {
                return 59;
            }
            case 21: {
                return 58;
            }
            case 39: {
                return 57;
            }
            case 57: {
                return 56;
            }
            case 58: {
                return 55;
            }
            case 59: {
                return 54;
            }
            case 60: {
                return 53;
            }
            case 61: {
                return 52;
            }
            case 62: {
                return 51;
            }
            case 63: {
                return 50;
            }
            case 64: {
                return 49;
            }
            case 65: {
                return 48;
            }
            case 66: {
                return 47;
            }
            case 67: {
                return 46;
            }
            case 68: {
                return 45;
            }
            case 69: {
                return 44;
            }
            case 70: {
                return 43;
            }
            case 71: {
                return 42;
            }
            case 89: {
                return 41;
            }
            case 90: {
                return 40;
            }
            case 91: {
                return 39;
            }
            case 92: {
                return 38;
            }
            case 93: {
                return 37;
            }
            case 94: {
                return 36;
            }
            case 95: {
                return 35;
            }
            case 96: {
                return 34;
            }
            case 97: {
                return 33;
            }
            case 98: {
                return 32;
            }
            case 99: {
                return 31;
            }
            case 100: {
                return 30;
            }
            case 101: {
                return 29;
            }
            case 102: {
                return 28;
            }
            case 103: {
                return 27;
            }
            case 4: {
                return 26;
            }
            case 12: {
                return 25;
            }
            case 20: {
                return 24;
            }
            case 38: {
                return 23;
            }
            case 56: {
                return 22;
            }
            case 88: {
                return 21;
            }
            case 3: {
                return 20;
            }
            case 11: {
                return 19;
            }
            case 19: {
                return 18;
            }
            case 37: {
                return 17;
            }
            case 55: {
                return 16;
            }
            case 87: {
                return 15;
            }
            case 2: {
                return 14;
            }
            case 10: {
                return 13;
            }
            case 18: {
                return 12;
            }
            case 36: {
                return 11;
            }
            case 54: {
                return 10;
            }
            case 86: {
                return 9;
            }
            case 128: 
            case 135: 
            case 138: {
                return 5;
            }
        }
        throw IUPACNamer.UnsupportedError.unsupportedPseudoAtom(atno);
    }

    public static int parentSeniority(int atno) {
        if (atno == 6) {
            return 1;
        }
        if (atno == 1) {
            return 0;
        }
        int seniority = Chem.seniority(atno);
        if (seniority == -1) {
            return 4;
        }
        if (seniorityTl <= seniority && seniority <= seniorityN) {
            return seniority + 4;
        }
        if (seniorityTe <= seniority && seniority <= seniorityO) {
            return seniority - seniorityTe + seniorityTl;
        }
        return seniority;
    }

    public static String greek(int num) {
        return Chem.greek(num, false);
    }

    private static String greek(int num, boolean composite) {
        switch (num) {
            case 0: {
                return "";
            }
            case 1: {
                return composite ? "hen" : "mono";
            }
            case 2: {
                return composite ? "do" : "di";
            }
            case 3: {
                return "tri";
            }
            case 4: {
                return "tetra";
            }
            case 5: {
                return "penta";
            }
            case 6: {
                return "hexa";
            }
            case 7: {
                return "hepta";
            }
            case 8: {
                return "octa";
            }
            case 9: {
                return "nona";
            }
            case 10: {
                return "deca";
            }
            case 11: {
                return "undeca";
            }
            case 12: {
                return "dodeca";
            }
            case 13: {
                return "trideca";
            }
            case 14: {
                return "tetradeca";
            }
            case 15: {
                return "pentadeca";
            }
            case 16: {
                return "hexadeca";
            }
            case 17: {
                return "heptadeca";
            }
            case 18: {
                return "octadeca";
            }
            case 19: {
                return "nonadeca";
            }
            case 20: {
                return "icosa";
            }
            case 21: {
                return "henicosa";
            }
        }
        switch (num / 10) {
            case 2: {
                return Chem.greek(num % 10, true) + "cosa";
            }
            case 3: {
                return Chem.greek(num % 10, true) + "triaconta";
            }
            case 4: {
                return Chem.greek(num % 10, true) + "tetraconta";
            }
            case 5: {
                return Chem.greek(num % 10, true) + "pentaconta";
            }
            case 6: {
                return Chem.greek(num % 10, true) + "hexaconta";
            }
            case 7: {
                return Chem.greek(num % 10, true) + "heptaconta";
            }
            case 8: {
                return Chem.greek(num % 10, true) + "octaconta";
            }
            case 9: {
                return Chem.greek(num % 10, true) + "nonaconta";
            }
        }
        return "" + num;
    }

    public static String diMultiplier(int n) {
        switch (n) {
            case 1: {
                return "";
            }
        }
        return Chem.greek(n);
    }

    static String multiplier(int n) {
        switch (n) {
            case 1: {
                return "";
            }
            case 2: {
                return "bi";
            }
        }
        return Chem.greek(n);
    }

    static String complexMultiplier(int n) {
        switch (n) {
            case 1: {
                return "";
            }
            case 2: {
                return "bis";
            }
            case 3: {
                return "tris";
            }
        }
        return Chem.multiplier(n) + "kis";
    }

    static String carbonChainName(int length) {
        switch (length) {
            case 1: {
                return "methane";
            }
            case 2: {
                return "ethane";
            }
            case 3: {
                return "propane";
            }
            case 4: {
                return "butane";
            }
        }
        return Chem.greek(length) + "ne";
    }

    static String carbonChainName(int length, String ending) {
        switch (length) {
            case 1: {
                return "meth" + ending;
            }
            case 2: {
                return "eth" + ending;
            }
            case 3: {
                return "prop" + ending;
            }
            case 4: {
                return "but" + ending;
            }
        }
        String res = Chem.greek(length);
        return res.substring(0, res.length() - 1) + ending;
    }

    static String unsaturatedHantzschWidman(int length, HeteroAnalyser.HeteroAtom[] heteroAtoms) {
        switch (length) {
            case 3: {
                if (heteroAtoms[0].atno == 7 && heteroAtoms[heteroAtoms.length - 1].atno == 7) {
                    return "irine";
                }
                return "irene";
            }
            case 4: {
                return "ete";
            }
            case 5: {
                return "ole";
            }
            case 6: {
                int atno = heteroAtoms[heteroAtoms.length - 1].atno;
                HantzschWidmanGroup g = Chem.getHantzschWidmanGroup(atno);
                switch (g) {
                    case Group6A: {
                        return "ine";
                    }
                    case Group6B: {
                        return "ine";
                    }
                    case Group6C: {
                        return "inine";
                    }
                }
            }
            case 7: {
                return "epine";
            }
            case 8: {
                return "ocine";
            }
            case 9: {
                return "onine";
            }
            case 10: {
                return "ecine";
            }
        }
        return null;
    }

    static String saturatedHantzschWidman(int length, HeteroAnalyser.HeteroAtom[] heteroAtoms) {
        switch (length) {
            case 3: {
                return Chem.hasNitro(heteroAtoms) ? "iridine" : "irane";
            }
            case 4: {
                return Chem.hasNitro(heteroAtoms) ? "etidine" : "etane";
            }
            case 5: {
                return Chem.hasNitro(heteroAtoms) ? "olidine" : "olane";
            }
            case 6: {
                int atno = heteroAtoms[heteroAtoms.length - 1].atno;
                HantzschWidmanGroup g = Chem.getHantzschWidmanGroup(atno);
                switch (g) {
                    case Group6A: {
                        return "ane";
                    }
                    case Group6B: {
                        return "inane";
                    }
                    case Group6C: {
                        return "inane";
                    }
                }
            }
            case 7: {
                return "epane";
            }
            case 8: {
                return "ocane";
            }
            case 9: {
                return "onane";
            }
            case 10: {
                return "ecane";
            }
        }
        return null;
    }

    public static HantzschWidmanGroup getHantzschWidmanGroup(int atno) {
        int seniority = Chem.seniority(atno);
        if (atno == 7 || seniorityPb <= seniority && seniority <= senioritySi) {
            return HantzschWidmanGroup.Group6B;
        }
        if (seniorityTl <= seniority && seniority <= seniorityB || senioritySb <= seniority && seniority <= seniorityP || seniorityI <= seniority && seniority <= seniorityF) {
            return HantzschWidmanGroup.Group6C;
        }
        return HantzschWidmanGroup.Group6A;
    }

    static String aPrefixForAtom(int atno) {
        return Chem.aPrefixForAtom(atno, false, true);
    }

    static String aPrefixForAtom(int atno, boolean hantzschWidman) {
        return Chem.aPrefixForAtom(atno, hantzschWidman, true);
    }

    static String aPrefixForAtom(int atno, boolean hantzschWidman, boolean fail) {
        if (atno > 109) {
            throw IUPACNamer.UnsupportedError.unsupportedPseudoAtom(atno);
        }
        switch (atno) {
            case 5: {
                return "bora";
            }
            case 6: {
                return "carba";
            }
            case 7: {
                return "aza";
            }
            case 8: {
                return "oxa";
            }
            case 9: {
                return "fluora";
            }
            case 13: {
                return hantzschWidman ? "aluma" : "alumina";
            }
            case 14: {
                return "sila";
            }
            case 15: {
                return "phospha";
            }
            case 16: {
                return "thia";
            }
            case 17: {
                return "chlora";
            }
            case 31: {
                return "galla";
            }
            case 32: {
                return "germa";
            }
            case 33: {
                return "arsa";
            }
            case 34: {
                return "selena";
            }
            case 35: {
                return "broma";
            }
            case 49: {
                return hantzschWidman ? "indiga" : "inda";
            }
            case 50: {
                return "stanna";
            }
            case 51: {
                return "stiba";
            }
            case 52: {
                return "tellura";
            }
            case 53: {
                return "ioda";
            }
            case 80: {
                return "mercura";
            }
            case 81: {
                return "thalla";
            }
        }
        if (!hantzschWidman) {
            switch (atno) {
                case 79: {
                    return "aura";
                }
                case 28: {
                    return "nickela";
                }
                case 46: {
                    return "pallada";
                }
                case 78: {
                    return "platina";
                }
                case 85: {
                    return "astata";
                }
                case 110: {
                    return "darmstadta";
                }
                case 27: {
                    return "cobalta";
                }
                case 45: {
                    return "rhoda";
                }
                case 77: {
                    return "irida";
                }
                case 109: {
                    return "meitnera";
                }
                case 84: {
                    return "polona";
                }
                case 26: {
                    return "ferra";
                }
                case 44: {
                    return "ruthena";
                }
                case 76: {
                    return "osma";
                }
                case 108: {
                    return "hassa";
                }
                case 25: {
                    return "mangana";
                }
                case 83: {
                    return "bisma";
                }
                case 43: {
                    return "techneta";
                }
                case 75: {
                    return "rhena";
                }
                case 107: {
                    return "bohra";
                }
                case 24: {
                    return "chroma";
                }
                case 42: {
                    return "molybda";
                }
                case 82: {
                    return "plumba";
                }
                case 74: {
                    return "tungsta";
                }
                case 106: {
                    return "seaborga";
                }
                case 23: {
                    return "vanada";
                }
                case 41: {
                    return "nioba";
                }
                case 73: {
                    return "tantala";
                }
                case 105: {
                    return "dubna";
                }
                case 30: {
                    return "zinca";
                }
                case 22: {
                    return "titana";
                }
                case 48: {
                    return "cadma";
                }
                case 40: {
                    return "zircona";
                }
                case 72: {
                    return "hafna";
                }
                case 29: {
                    return "cupra";
                }
                case 104: {
                    return "rutherforda";
                }
                case 47: {
                    return "argenta";
                }
                case 21: {
                    return "scanda";
                }
                case 39: {
                    return "yttra";
                }
                case 98: {
                    return "californa";
                }
                case 57: {
                    return "lanthana";
                }
                case 99: {
                    return "einsteina";
                }
                case 58: {
                    return "cera";
                }
                case 100: {
                    return "ferma";
                }
                case 59: {
                    return "praseodyma";
                }
                case 101: {
                    return "mendeleva";
                }
                case 60: {
                    return "neodyma";
                }
                case 102: {
                    return "nobela";
                }
                case 61: {
                    return "prometha";
                }
                case 103: {
                    return "lawrenca";
                }
                case 62: {
                    return "samara";
                }
                case 4: {
                    return "berylla";
                }
                case 63: {
                    return "europa";
                }
                case 12: {
                    return "magnesa";
                }
                case 64: {
                    return "gadolina";
                }
                case 20: {
                    return "calca";
                }
                case 65: {
                    return "terba";
                }
                case 38: {
                    return "stronta";
                }
                case 66: {
                    return "dysprosa";
                }
                case 56: {
                    return "bara";
                }
                case 67: {
                    return "holma";
                }
                case 88: {
                    return "rada";
                }
                case 68: {
                    return "erba";
                }
                case 3: {
                    return "litha";
                }
                case 69: {
                    return "thula";
                }
                case 11: {
                    return "soda";
                }
                case 70: {
                    return "ytterba";
                }
                case 19: {
                    return "potassa";
                }
                case 71: {
                    return "luteta";
                }
                case 37: {
                    return "rubida";
                }
                case 89: {
                    return "actina";
                }
                case 55: {
                    return "caesa";
                }
                case 90: {
                    return "thora";
                }
                case 87: {
                    return "franca";
                }
                case 91: {
                    return "protactina";
                }
                case 2: {
                    return "hela";
                }
                case 92: {
                    return "urana";
                }
                case 10: {
                    return "neona";
                }
                case 93: {
                    return "neptuna";
                }
                case 18: {
                    return "argona";
                }
                case 94: {
                    return "plutona";
                }
                case 36: {
                    return "kryptona";
                }
                case 95: {
                    return "america";
                }
                case 54: {
                    return "xenona";
                }
                case 96: {
                    return "cura";
                }
                case 86: {
                    return "radona";
                }
                case 97: {
                    return "berkela";
                }
            }
        }
        if (fail) {
            throw new IUPACNamer.Failure("Unsupported element number: " + atno);
        }
        return null;
    }

    static String aSuffixForAtom(int atno) {
        if (atno == 16) {
            return "sulfa";
        }
        if (atno == 8) {
            return "oxida";
        }
        return Chem.aPrefixForAtom(atno, true, false);
    }

    static String elementNameAsSubstituent(String name) {
        if (name == "arsenic") {
            return "arsenio";
        }
        if (name == "copper") {
            return "cuprio";
        }
        if (name == "gold") {
            return "aurio";
        }
        if (name == "iron") {
            return "ferrio";
        }
        if (name == "lead") {
            return "plumbio";
        }
        if (name == "manganese") {
            return "manganio";
        }
        if (name == "phosphorus") {
            return "phosphorio";
        }
        if (name == "silicon") {
            return "silicio";
        }
        if (name == "silver") {
            return "argentio";
        }
        if (name == "tin") {
            return "stannio";
        }
        int len = name.length();
        String base = name;
        if (name.endsWith("ium")) {
            base = name.substring(0, len - 3);
        } else if (name.endsWith("um")) {
            base = name.substring(0, len - 2);
        } else if (name.endsWith("ine")) {
            base = name.substring(0, len - 3);
        } else if (name.charAt(len - 1) == 'y') {
            base = name.substring(0, len - 1);
        }
        return base + "io";
    }

    private static boolean hasNitro(HeteroAnalyser.HeteroAtom[] ha) {
        int i = ha.length;
        while (--i >= 0) {
            if (ha[i].atno != 7) continue;
            return true;
        }
        return false;
    }

    public static int standardValence(int atno) {
        switch (atno) {
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 2;
            }
            case 9: {
                return 1;
            }
            case 13: {
                return 3;
            }
            case 14: {
                return 4;
            }
            case 15: {
                return 3;
            }
            case 16: {
                return 2;
            }
            case 17: {
                return 1;
            }
            case 31: {
                return 3;
            }
            case 32: {
                return 4;
            }
            case 33: {
                return 3;
            }
            case 34: {
                return 2;
            }
            case 35: {
                return 1;
            }
            case 49: {
                return 3;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 2;
            }
            case 53: {
                return 1;
            }
            case 81: {
                return 3;
            }
            case 82: {
                return 4;
            }
            case 83: {
                return 3;
            }
            case 84: {
                return 2;
            }
            case 85: {
                return 1;
            }
            case 30: {
                return 2;
            }
            case 48: {
                return 2;
            }
            case 59: {
                return 3;
            }
            case 62: {
                return 3;
            }
            case 28: {
                return 2;
            }
            case 71: {
                return 3;
            }
            case 40: {
                return 4;
            }
            case 60: {
                return 3;
            }
            case 57: {
                return 3;
            }
            case 58: {
                return 3;
            }
            case 29: {
                return 2;
            }
            case 66: {
                return 3;
            }
            case 67: {
                return 3;
            }
            case 63: {
                return 3;
            }
        }
        return -1;
    }

    public static int maxValence(int atno) {
        switch (atno) {
            case 33: {
                return 5;
            }
            case 83: {
                return 5;
            }
            case 53: {
                return 3;
            }
            case 7: {
                return 5;
            }
            case 15: {
                return 5;
            }
            case 16: {
                return 6;
            }
            case 51: {
                return 5;
            }
        }
        int res = Chem.standardValence(atno);
        if (res < 0) {
            return Integer.MAX_VALUE;
        }
        return res;
    }

    public static boolean hasNonStandardBondingNumber(MolAtom atom) {
        int standardValence = Chem.standardValence(atom.getAtno());
        int valence = Chem.getRealValence(atom);
        if (standardValence < 0 || valence == 0) {
            return false;
        }
        return valence != standardValence;
    }

    public static boolean isRadical(MolAtom atom) {
        return Chem.radicalCount(atom, false) > 0;
    }

    public static int effectiveRadicalCount(MolAtom atom, boolean ignoreCharge) {
        int res = Chem.radicalCount(atom, ignoreCharge);
        if ("substituent".equals(SubmoleculeBuilder.originalAtom(atom).getAliasstr())) {
            --res;
        }
        return res;
    }

    public static int radicalCount(MolAtom atom, boolean ignoreCharge) {
        if (atom.getRadicalCount() > 0) {
            return atom.getRadicalCount();
        }
        int atno = atom.getAtno();
        if (atno == 35 && atom.getValence() == 7 || atno == 9 && atom.getValence() == 3) {
            return 0;
        }
        int bonding = atom.getValence();
        if (!ignoreCharge) {
            bonding += Math.abs(atom.getCharge());
        }
        int i = MolAtom.numoxstatesOf(atno);
        while (--i >= 0) {
            if (bonding != MolAtom.oxstateOf(atno, i)) continue;
            return 0;
        }
        int stdValence = Chem.standardValence(atno);
        if (stdValence == -1) {
            return 0;
        }
        int res = stdValence - bonding;
        if (res < 0) {
            res = 0;
        }
        return res;
    }

    static boolean isRealRadical(MolAtom atom) {
        return Chem.effectiveRadicalCount(atom = SubmoleculeBuilder.originalAtom(atom), false) > 0;
    }

    static String ylSuffix(int radical) {
        return substituentEnding[radical];
    }

    static String suffix(MolAtom global, MolAtom local, boolean multiplier, boolean yl) {
        int charge = global.getCharge();
        int radicalCount = Chem.radicalCount(global, false);
        if (charge == 0 && radicalCount == 0) {
            return null;
        }
        int ionicType = Chem.getIonicType(local);
        String suffix = null;
        switch (ionicType) {
            case -2: {
                suffix = "ide";
                break;
            }
            case -1: {
                suffix = "uide";
                break;
            }
            case 0: {
                if (charge != -1) break;
                suffix = "ide";
                break;
            }
            case 1: {
                suffix = "ylium";
                break;
            }
            case 2: {
                suffix = "ium";
                break;
            }
            case 3: {
                suffix = "ium+ylium";
                break;
            }
            default: {
                throw new IUPACNamer.Failure("Unknown case");
            }
        }
        if (suffix == null) {
            return yl ? substituentEnding[radicalCount] : null;
        }
        if (multiplier && ionicType != 3 && Math.abs(charge) > 1) {
            suffix = Chem.diMultiplier(Math.abs(charge)) + suffix;
        }
        if (!yl || radicalCount == 0) {
            return suffix;
        }
        StringBuffer res = new StringBuffer();
        res.append(suffix);
        Util.appendRemovingVowel(substituentEnding[radicalCount], res);
        return res.toString();
    }

    static int getChirality(MolAtom a) {
        int index = SubmoleculeBuilder.globalMolecule.indexOf(a = SubmoleculeBuilder.originalAtom(a));
        if (index == -1) {
            return 0;
        }
        int res = SubmoleculeBuilder.globalMolecule.getChirality(index);
        if (res == 3) {
            return 0;
        }
        if (a.getStereoGroupType() == 2) {
            res |= a.getStereoGroupNumber() << 10;
        }
        return res;
    }

    public static String stereoDescriptorString(int j) {
        boolean relative = j >> 10 != 0;
        switch (j &= 0x3FF) {
            case 0: {
                return "Z";
            }
            case 1: {
                return "E";
            }
            case 2: {
                return relative ? "R*" : "R";
            }
            case 3: {
                return relative ? "S*" : "S";
            }
            case 4: {
                return relative ? "r*" : "r";
            }
            case 5: {
                return relative ? "s*" : "s";
            }
            case 6: {
                return "M";
            }
            case 7: {
                return "P";
            }
        }
        throw new IUPACNamer.Failure("Unknown stereodescriptor: " + j);
    }

    public static int chiralStereoConstant(int chirality) {
        int relativePart = chirality >> 10 << 10;
        switch (chirality &= 0x3FF) {
            case 8: {
                return 2 | relativePart;
            }
            case 16: {
                return 3 | relativePart;
            }
            case 32: {
                return 4 | relativePart;
            }
            case 64: {
                return 5 | relativePart;
            }
            case 256: {
                return 6 | relativePart;
            }
            case 128: {
                return 7 | relativePart;
            }
        }
        throw new IUPACNamer.Failure("Unknown chirality: " + chirality);
    }

    public static int bondStereoConstant(int chirality) {
        switch (chirality) {
            case 128: {
                return 0;
            }
            case 64: {
                return 1;
            }
        }
        throw new IUPACNamer.Failure("Unknown bond stereo");
    }

    static int getHCount(MolAtom a) {
        return a.getImplicitHcount() + a.getExplicitHcount();
    }

    static int getNonIsotopeHCount(MolAtom a) {
        int explicitH = 0;
        if (a.getExplicitHcount() > 0) {
            int i = a.getBondCount();
            while (--i >= 0) {
                MolAtom a1 = a.getLigand(i);
                if (a1.getAtno() != 1 || a1.getMassno() != 0) continue;
                ++explicitH;
            }
        }
        return a.getImplicitHcount() + explicitH;
    }

    static int getIonicType(MolAtom atom) {
        MolAtom a = SubmoleculeBuilder.getParentAtom(atom);
        a = SubmoleculeBuilder.originalAtom(atom);
        return LonePairCounter.getIonicType(a.getParent(), a);
    }

    static int getRealValence(MolAtom atom) {
        MolAtom global = SubmoleculeBuilder.originalAtom(atom);
        return Chem.getValence(global);
    }

    public static int getValence(MolAtom global) {
        int valence = global.getValence();
        int charge = global.getCharge();
        int ionicType = Chem.getIonicType(global);
        switch (ionicType) {
            case -2: {
                valence -= charge;
                break;
            }
            case -1: {
                valence += charge;
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                valence += charge;
                break;
            }
            case 2: {
                valence -= charge;
            }
        }
        switch (global.getRadical()) {
            case 0: {
                break;
            }
            case 1: {
                ++valence;
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                valence += 2;
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                valence += 3;
            }
        }
        return valence;
    }

    static boolean isRingAtom(MolAtom a) {
        MoleculeGraph g = a.getParent();
        int idx = g.indexOf(a);
        int[][] sssr = g.getSSSR();
        int i = sssr.length;
        while (--i >= 0) {
            if (!Util.contains(sssr[i], idx)) continue;
            return true;
        }
        return false;
    }

    public static int reverseChirality(int chirality) {
        switch (chirality) {
            case 8: {
                return 16;
            }
            case 16: {
                return 8;
            }
        }
        return chirality;
    }

    public static enum HantzschWidmanGroup {
        Group6A,
        Group6B,
        Group6C;

    }
}

