/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import java.util.Arrays;
import java.util.Comparator;

public class Compound {
    Part[] fragments;
    static final Comparator<Name> partComparator = new Comparator<Name>(){

        @Override
        public int compare(Name n1, Name n2) {
            int diff = n2.charge - n1.charge;
            if (diff != 0) {
                return diff;
            }
            if (n1.salt != n2.salt) {
                return n1.salt ? 1 : -1;
            }
            if (n1.name == "hydrogen") {
                return 1;
            }
            if (n2.name == "hydrogen") {
                return -1;
            }
            return n1.name.compareTo(n2.name);
        }
    };

    Compound(Part[] fragments) {
        this.fragments = fragments;
    }

    String getName() {
        if (this.fragments.length == 1) {
            return this.fragments[0].getRewrittenName();
        }
        Name[] names = new Name[this.fragments.length];
        int i = this.fragments.length;
        while (--i >= 0) {
            Name name = this.getFragmentName(this.fragments[i]);
            if (name == null) {
                throw new IUPACNamer.Failure("Unsupported multipart molecule because of " + this.fragments[i].getName());
            }
            names[i] = name;
        }
        Arrays.sort(names, partComparator);
        String separator = this.isSalt(names) ? " " : "; ";
        StringBuffer res = new StringBuffer();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (i2 > 0) {
                res.append(separator);
            }
            String name = names[i2].name;
            int repeat = 1;
            while (i2 + repeat < names.length && name.equals(names[i2 + repeat].name)) {
                ++repeat;
            }
            if (repeat > 1) {
                name = !names[i2].salt || name.indexOf(45) != -1 ? Chem.complexMultiplier(repeat) + '(' + name + ')' : Chem.greek(repeat) + name;
            }
            res.append(name);
            i2 += repeat - 1;
        }
        return res.toString();
    }

    Name getFragmentName(Part p) {
        String name = p.getRewrittenName();
        if (p.hasCharge()) {
            return new Name(name, p.getCharge());
        }
        return new Name(name, p.isSalt() || name.endsWith("ate"));
    }

    boolean isSalt(Name[] names) {
        int i = names.length;
        while (--i >= 0) {
            if (!names[i].salt) continue;
            return true;
        }
        return false;
    }

    class Name {
        String name;
        int charge;
        boolean salt;

        Name(String name, boolean isSalt) {
            this.name = name;
            this.salt = isSalt;
        }

        Name(String name, int charge) {
            this.name = name;
            this.charge = charge;
            this.salt = true;
        }

        public String toString() {
            return this.name;
        }
    }
}

