/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.ParentFinder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.marvin.io.formats.smiles.CxsmilesImport;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import chemaxon.struc.PeriodicSystem;
import chemaxon.struc.StaticMolecule;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class Dictionary {
    private CxsmilesImport smiImporter = new CxsmilesImport();
    Structure[] structures = new Structure[]{new Structure("benzene", "c1ccccc1", false), new Structure("pyridazine", "n1ncccc1 |$1;2;3;4;5;6$|").notSaturated(), new Structure("pyrimidine", "n1cnccc1 |$1;2;3;4;5;6$|").notSaturated(), new Structure("imidazolidine", "N1CNCC1 |$1;2;3;4;5$|", false), new Structure("imidazole", "n1cncc1 |$1;2;3;4;5$|"), new Structure("piperazine", "C1CNCCN1 |$3;2;1;6;5;4$|", false), new Structure("pyrazine", "c1cnccn1 |$3;2;1;6;5;4$|"), new Structure("pyrazolidine", "N1NCCC1 |$1;2;3;4;5$|", false), new Structure("pyrazole", "n1nccc1 |$1;2;3;4;5$|"), new Structure("morpholine", "O1CCNCC1 |$1;2;3;4;5;6$|", false), new Structure("thiomorpholine", "S1CCNCC1 |$1;2;3;4;5;6$|", false), new Structure("selenomorpholine", "[Se]1CCNCC1 |$1;2;3;4;5;6$|", false), new Structure("telluromorpholine", "[Te]1CCNCC1 |$1;2;3;4;5;6$|", false), new Structure("adamantane", "C1C2CC3CC1CC(C2)C3 |$9;5;4;3;2;1;8;7;6;10$|"), new Structure("ovalene", "c1cc2ccc3cc4ccc5ccc6ccc7cc8ccc1c9c2c3c%10c4c5c6c7c%10c89 |$11;10;9a;9;8;7a;7;6a;6;5;4a;4;3;2a;2;1;14a;14;13a;13;12;11a;11a^1;9a^1;7a^1;6a^2;6a^1;4a^1;2a^1;14a^1;13a^2;13a^1$|"), new Structure("pyranthrene", "c1ccc2c(c1)cc3ccc4cc5c6ccccc6cc7ccc8cc2c3c4c8c57 |$10;11;12;12a;8a;9;8;7a;7;6;5a;5;4b;4a;4;3;2;1;16a;16;15a;15;14;13a;13;12b;7a^1;5a^1;13a^1;4b^1$|"), new Structure("coronene", "c1cc2ccc3ccc4ccc5ccc6ccc1c7c2c3c4c5c67 |$12;11;10a;10;9;8a;8;7;6a;6;5;4a;4;3;2a;2;1;12a;12a^1;10a^1;8a^1;6a^1;4a^1;2a^1$|"), new Structure("rubicene", "c1ccc2c(c1)c3cccc4c5c6ccccc6c7cccc(c2c34)c57 |$12;13;14;14a;10b;11;10a;10;9;8;7c;7b;7a;7;6;5;4;3b;3a;3;2;1;14c;14b;7c^1;3a^1$|"), new Structure("perylene", "c1cc2cccc3c4cccc5cccc(c(c1)c23)c45 |$5;4;3a;3;2;1;12b;12a;12;11;10;9a;9;8;7;6b;6a;6;3a^1;6b^1$|"), new Structure("picene", "c1ccc2c(c1)ccc3c2ccc4c5ccccc5ccc34 |$10;11;12;12a;8a;9;8;7;6b;12b;13;14;14a;14b;1;2;3;4;4a;5;6;6a$|"), new Structure("pleiadene", "c1ccc2cc3cccc4cccc(cc2c1)c34 |$10;9;8;7a;7;6a;6;5;4;3a;3;2;1;12a;12;11a;11;3a^1$|"), new Structure("chrysene", "c1ccc2c(c1)ccc3c4ccccc4ccc23 |$8;9;10;10a;6a;7;6;5;4b;4a;4;3;2;1;12a;12;11;10b$|"), new Structure("pyrene", "c1cc2ccc3cccc4ccc(c1)c2c34 |$2;1;10a;10;9;8a;8;7;6;5a;5;4;3a;3;3a^1;5a^1$|"), new Structure("fluoranthene", "c1ccc2c(c1)c3cccc4cccc2c34 |$8;9;10;10a;6b;7;6a;6;5;4;3a;3;2;1;10b;3a^1$|"), new Structure("anthracene", "c1ccc2cc3ccccc3cc2c1 |$7;6;5;10a;10;4a;4;3;2;1;9a;9;8a;8$|"), new Structure("phenanthrene", "c1ccc2c(c1)ccc3ccccc23 |$7;6;5;4b;8a;8;9;10;10a;1;2;3;4;4a$|"), new Structure("phenalene", "c1ccc2cccc3cccc1c23 |$1;2;3;3a;4;5;6;6a;7;8;9;9a;3a^1$|"), new Structure("fluorene", "c1c2ccccc2c3ccccc13 |$9;8a;8;7;6;5;4b;4a;4;3;2;1;9a$|"), new Structure("s-indacene", "c1cc2cc3cccc3cc2c1 |$2;3;3a;4;4a;5;6;7;7a;8;8a;1$|"), new Structure("as-indacene", "c1cc2ccc3cccc3c2c1 |$2;3;3a;4;5;5a;6;7;8;8a;8b;1$|"), new Structure("azulene", "c1cc2cccccc2c1 |$2;1;8a;8;7;6;5;4;3a;3$|"), new Structure("naphthalene", "c1ccc2ccccc2c1 |$7;6;5;4a;4;3;2;1;8a;8$|"), new Structure("indene", "c1cc2ccccc2c1 |$2;3;3a;4;5;6;7;7a;1$|"), new Structure("acenaphthylene", "c1cc2cccc3cccc1c23 |$1;2;2a;3;4;5;5a;6;7;8;8a;2b$|"), new Structure("aceanthrylene", "c1cc2c3c1cccc3cc4ccccc24 |$2;1;10b;2a^1;2a;3;4;5;5a;6;6a;7;8;9;10;10a$|"), new Structure("acephenanthrylene", "c1cc2cc3ccccc3c4cccc1c24 |$4;5;5a;6;6a;7;8;9;10;10a;10b;1;2;3;3a;3a^1$|"), new Structure("1,7-phenanthroline", "c1cnc2c(c1)ccc3ncccc23 |$3;2;1;10b;4a;4;5;6;6a;7;8;9;10;10a$|"), new Structure("1,8-phenanthroline", "c1cnc2c(c1)ccc3cnccc23 |$3;2;1;10b;4a;4;5;6;6a;7;8;9;10;10a$|"), new Structure("1,9-phenanthroline", "c1cnc2c(c1)ccc3ccncc23 |$3;2;1;10b;4a;4;5;6;6a;7;8;9;10;10a$|"), new Structure("1,10-phenanthroline", "c1cnc2c(c1)ccc3cccnc23 |$3;2;1;10b;4a;4;5;6;6a;7;8;9;10;10a$|"), new Structure("2,7-phenanthroline", "c1cnc2ccc3ccncc3c2c1 |$9;8;7;6a;6;5;4a;4;3;2;1;10b;10a;10$|"), new Structure("2,8-phenanthroline", "c1cc2ccc3cnccc3c2cn1 |$3;4;4a;5;6;6a;7;8;9;10;10a;10b;1;2$|"), new Structure("2,9-phenanthroline", "c1cc2ccc3ccncc3c2cn1 |$3;4;4a;5;6;6a;7;8;9;10;10a;10b;1;2$|"), new Structure("3,7-phenanthroline", "c1cnc2ccc3cnccc3c2c1 |$9;8;7;6a;6;5;4a;4;3;2;1;10b;10a;10$|"), new Structure("3,8-phenanthroline", "c1cc2c(ccc3cnccC23)cn1 |$2;1;10b;4a;5;6;6a;7;8;9;10;10a;4;3$|"), new Structure("4,7-phenanthroline", "c1cnc2ccc3ncccc3c2c1 |$2;3;4;4a;5;6;6a;7;8;9;10;10a;10b;1$|"), new Structure("perimidine", "c1cc2cccc3nccc(c1)c23 |$5;6;6a;7;8;9;9a;1;2;3;3a;4;3a^1$|"), new Structure("c1ccc2[n,as,p]c3ccccc3cc2c1 |$2;3;4;4a;10;10a;5;6;7;8;8a;9;9a;1$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[4]).getAtno();
            switch (atno) {
                case 7: {
                    return "acridine";
                }
                case 33: {
                    return "acridarsine";
                }
                case 15: {
                    return "acridophosphine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1ccc2c(c1)c[n,as,p]c3ccccc23 |$8;9;10;10a;6a;7;6;5;4a;4;3;2;1;10b$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[7]).getAtno();
            switch (atno) {
                case 7: {
                    return "phenanthridine";
                }
                case 33: {
                    return "arsanthridine";
                }
                case 15: {
                    return "phosphanthridine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("carbazole", "c1ccc2c(c1)nc3ccccc23 |$2;3;4;4a;9a;1;9;8a;8;7;6;5;4b$|"), new Structure("pteridine", "c1cnc2ncncc2n1 |$6;7;8;8a;1;2;3;4;4a;5$|"), new Structure("cinnoline", "c1ccc2nnccc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"), new Structure("quinazoline", "c1ccc2ncncc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"), new Structure("quinoxaline", "c1ccc2nccnc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"), new Structure("1,5-naphthyridine", "c1cnc2cccnc2c1 |$3;2;1;8a;8;7;6;5;4a;4$|"), new Structure("1,6-naphthyridine", "c1cnc2ccncc2c1 |$3;2;1;8a;8;7;6;5;4a;4$|"), new Structure("1,7-naphthyridine", "c1cnc2cnccc2c1 |$3;2;1;8a;8;7;6;5;4a;4$|"), new Structure("1,8-naphthyridine", "c1cnc2ncccc2c1 |$3;2;1;8a;8;7;6;5;4a;4$|"), new Structure("2,6-naphthyridine", "c1cc2cnccc2cn1 |$3;4;4a;5;6;7;8;8a;1;2$|"), new Structure("2,7-naphthyridine", "c1cc2ccncc2cn1 |$3;4;4a;5;6;7;8;8a;1;2$|"), new Structure("phthalazine", "c1ccc2cnncc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"), new Structure("c1ccc2[n,as,p]cccc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[4]).getAtno();
            switch (atno) {
                case 7: {
                    return "quinoline";
                }
                case 33: {
                    return "arsinoline";
                }
                case 15: {
                    return "phosphinoline";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1ccc2c[n,as,p]ccc2c1 |$6;7;8;8a;1;2;3;4;4a;5$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[5]).getAtno();
            switch (atno) {
                case 7: {
                    return "isoquinoline";
                }
                case 33: {
                    return "isoarsinoline";
                }
                case 15: {
                    return "isophosphinoline";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1cc[n,as,p]2ccccc2c1 |$2;3;4;5;6;7;8;9;9a;1$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[3]).getAtno();
            switch (atno) {
                case 7: {
                    return "quinolizine";
                }
                case 33: {
                    return "arsinolizine";
                }
                case 15: {
                    return "phosphinolizine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case: " + PeriodicSystem.getName(atno));
        }
    }, new Structure("purine", "c1nc2cncnc2n1 |$8;7;5;6;1;2;3;4;9$|"), new Structure("indazole", "n1ncc2ccccc12 |$1;2;3;3a;4;5;6;7;7a$|"), new Structure("c1cc2ccccc2[n,as,p]1 |$2;3;3a;4;5;6;7;7a;1$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[8]).getAtno();
            switch (atno) {
                case 7: {
                    return "indole";
                }
                case 33: {
                    return "arsindole";
                }
                case 15: {
                    return "phosphindole";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1[n,as,p]cc2ccccc12 |$3;2;1;7a;7;6;5;4;3a$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[1]).getAtno();
            switch (atno) {
                case 7: {
                    return "isoindole";
                }
                case 33: {
                    return "isoarsindole";
                }
                case 15: {
                    return "isophosphindole";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1cc2cccc[n,as,p]2c1 |$2;1;8a;8;7;6;5;4;3$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[7]).getAtno();
            switch (atno) {
                case 7: {
                    return "indolizine";
                }
                case 33: {
                    return "arsindolizine";
                }
                case 15: {
                    return "phosphindolizine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("pyrrolizine", "c1cc2cccn2c1 |$2;1;7a;7;6;5;4;3$|"), new Structure("xanthene", "c1ccc2oc3ccccc3cc2c1 |$2;3;4;4a;10;10a;5;6;7;8;8a;9;9a;1$|"), new Structure("thioxanthene", "c1c2ccccc2sc3ccccc13 |$9;9a;1;2;3;4;4a;10;10a;5;6;7;8;8a$|"), new Structure("selenoxanthene", "c1c2ccccc2[Se]c3ccccc13 |$9;9a;1;2;3;4;4a;10;10a;5;6;7;8;8a$|"), new Structure("telluroxanthene", "c1c2ccccc2[Te]c3ccccc13 |$9;9a;1;2;3;4;4a;10;10a;5;6;7;8;8a$|"), new Structure("C1[O,S,Se,Te]c2ccccc2CC1 |$2;1;8a;8;7;6;5;4a;4;3$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            MolAtom atom2 = matched.getAtom(mapping[0]);
            MolAtom atom3 = matched.getAtom(mapping[9]);
            MolAtom atom4 = matched.getAtom(mapping[8]);
            MolBond b1 = atom2.getBondTo(atom3);
            MolBond b2 = atom3.getBondTo(atom4);
            if (b1.getType() == 1 && b2.getType() == 1) {
                return null;
            }
            switch (matched.getAtom(mapping[1]).getAtno()) {
                case 8: {
                    return "chromene";
                }
                case 16: {
                    return "thiochromene";
                }
                case 34: {
                    return "selenochromene";
                }
                case 52: {
                    return "tellurochromene";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("C1[O,S,Se,Te]C=Cc2ccccc12 |$1;2;3;4;4a;5;6;7;8;8a$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            MolAtom atom3 = matched.getAtom(mapping[2]);
            MolAtom atom4 = matched.getAtom(mapping[3]);
            MolAtom atom4a = matched.getAtom(mapping[4]);
            MolBond b34 = atom3.getBondTo(atom4);
            MolBond b44a = atom4.getBondTo(atom4a);
            if (b34.getType() == 1 && b44a.getType() == 1) {
                return null;
            }
            switch (matched.getAtom(mapping[1]).getAtno()) {
                case 8: {
                    return "isochromene";
                }
                case 16: {
                    return "isothiochromene";
                }
                case 34: {
                    return "isoselenochromene";
                }
                case 52: {
                    return "isotellurochromene";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("c1ccc2[N,O,S,Se,Te,P,As,Si,B]c3ccccc3[N,O,S,Se,Te,P,As,Si,B]c2c1 |$2;3;4;4a;5;5a;6;7;8;9;9a;10;10a;1$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno2;
            int atno1 = matched.getAtom(mapping[4]).getAtno();
            if (atno1 != (atno2 = matched.getAtom(mapping[11]).getAtno())) {
                return null;
            }
            switch (atno1) {
                case 7: {
                    return "phenazine";
                }
                case 8: {
                    return "oxanthrene";
                }
                case 16: {
                    return "thianthrene";
                }
                case 34: {
                    return "selenanthrene";
                }
                case 52: {
                    return "telluranthrene";
                }
                case 15: {
                    return "phosphanthrene";
                }
                case 33: {
                    return "arsanthrene";
                }
                case 14: {
                    return "silanthrene";
                }
                case 5: {
                    return "boranthrene";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("n1c2ccccc2[O,S,Se,Te]c3ccccc13 |$10;10a;1;2;3;4;4a;5;5a;6;7;8;9;9a$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[7]).getAtno();
            switch (atno) {
                case 8: {
                    return "phenoxazine";
                }
                case 16: {
                    return "phenothiazine";
                }
                case 34: {
                    return "phenoselenazine";
                }
                case 52: {
                    return "phenotellurazine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("n1c2ccccc2[P,As]c3ccccc13 |$5;4a;4;3;2;1;10a;10;9a;9;8;7;6;5a$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[7]).getAtno();
            switch (atno) {
                case 15: {
                    return "phenophosphazinine";
                }
                case 33: {
                    return "phenarsazinine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("[S,Se,Te,P,As,Sb]1~c2ccccc2Oc3ccccc13 |$10;10a;1;2;3;4;4a;5;5a;6;7;8;9;9a$|"){

        @Override
        String getName(Molecule matched, int[] mapping) {
            int atno = matched.getAtom(mapping[0]).getAtno();
            switch (atno) {
                case 16: {
                    return "phenoxathiine";
                }
                case 34: {
                    return "phenoxaselenine";
                }
                case 52: {
                    return "phenoxatellurine";
                }
                case 15: {
                    return "phenoxaphosphinine";
                }
                case 33: {
                    return "phenoxarsinine";
                }
                case 51: {
                    return "phenoxastibinine";
                }
            }
            throw new IUPACNamer.Failure("Unhandled case");
        }
    }, new Structure("phenothiarsinine", "[As]1~c2ccccc2Sc3ccccc13 |$10;10a;1;2;3;4;4a;5;5a;6;7;8;9;9a$|"), new Structure("phenomercurazine", "c1ccc2[hg]c3ccccc3nc2c1 |$3;2;1;10a;10;9a;9;8;7;6;5a;5;4a;4$|"), new Structure("adamantane", "C1C2CC3CC1CC(C2)C3 |$2;3;4;5;9;1;8;7;10;6$|"), new Structure("cubane", "C12C3C4C1C5C2C3C45 |$1;2;3;4;7;6;5;8$|"), new Structure("prismane", "C12C3C1C4C2C34 |$1;2;6;5;4;3$|")};

    public Dictionary() {
        Arrays.sort(this.structures, new Comparator(){

            public int compare(Object o1, Object o2) {
                Structure s1 = (Structure)o1;
                Structure s2 = (Structure)o2;
                return Dictionary.dictionaryOrder(s1.query, s2.query);
            }
        });
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public static int dictionaryOrder(Molecule m1, Molecule m2) {
        int diff = ParentFinder.compareCyclic1(m1, m2, true);
        if (diff != 0) {
            return diff;
        }
        diff = -ParentFinder.compareCyclic2(m1, m2);
        if (diff != 0) {
            return diff;
        }
        return diff;
    }

    static int fusedCriteria(Molecule m1, Molecule m2) {
        HeteroAnalyser.HeteroAtom[] ha1 = Dictionary.getHA(m1);
        HeteroAnalyser.HeteroAtom[] ha2 = Dictionary.getHA(m2);
        return HeteroAnalyser.compareHeteroAtoms(ha1, ha2);
    }

    private static HeteroAnalyser.HeteroAtom[] getHA(Molecule m) {
        int[] numbering = new int[m.getAtomCount()];
        int i = numbering.length;
        while (--i >= 0) {
            numbering[i] = Util.locant(m.getAtom(i).getAliasstr());
        }
        return HeteroAnalyser.findHeteroAtoms(m, numbering, null);
    }

    public class Structure {
        String name;
        Molecule query;
        boolean ignoreBondType;
        boolean notSaturated;
        StaticMolecule sQuery;

        Structure(String name, String query) {
            this(name, query, true);
        }

        Structure(String name, String query, boolean ignoreBondType) {
            this.name = name;
            this.query = new Molecule();
            this.ignoreBondType = ignoreBondType;
            try {
                Dictionary.this.smiImporter.readMol(query, this.query);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        Structure(String query) {
            this(null, query);
        }

        Structure notSaturated() {
            this.notSaturated = true;
            return this;
        }

        String getName(Molecule matched, int[] mapping) {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public Molecule getQuery() {
            return this.query;
        }

        public StaticMolecule getStaticQuery() {
            if (this.sQuery == null) {
                this.sQuery = new StaticMolecule(this.query);
            }
            return this.sQuery;
        }
    }
}

