/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MoleculeGraph;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

class GraphUtil {
    int steps = 0;
    final int maxSteps;

    public GraphUtil(int maxSteps) {
        this.maxSteps = maxSteps;
    }

    public int[][] longestBridges(MoleculeGraph g, BitSet border, BitSet excluded) {
        ArrayList<int[]> res = new ArrayList<int[]>();
        int i = border.nextSetBit(0);
        while (i >= 0) {
            this.findLongestBridges(g, border, excluded, i, new BitSet(), new IntVector(), res);
            i = border.nextSetBit(i + 1);
        }
        return Util.intArrayArray(res);
    }

    private void findLongestBridges(MoleculeGraph g, BitSet border, BitSet excluded, int cur, BitSet visited, IntVector path, List<int[]> res) {
        ++this.steps;
        if (this.steps > this.maxSteps && res.size() > 0) {
            return;
        }
        path.add(cur);
        visited.set(cur);
        int[] neighbours = g.getCtab()[cur];
        for (int i = 0; i < neighbours.length; ++i) {
            int n = neighbours[i];
            if (visited.get(n)) continue;
            if (border.get(n)) {
                path.add(n);
                GraphUtil.addLongest(path.toArray(), res);
                path.removeLast();
                continue;
            }
            if (excluded != null && excluded.get(n)) continue;
            this.findLongestBridges(g, border, excluded, n, visited, path, res);
        }
        visited.clear(cur);
        path.removeLast();
    }

    static void addLongest(int[] bridge, List<int[]> bridges) {
        if (!bridges.isEmpty()) {
            int currentLongest = bridges.get(0).length;
            if (bridge.length < currentLongest) {
                return;
            }
            if (bridge.length > currentLongest) {
                bridges.clear();
            }
        }
        bridges.add(bridge);
    }
}

