/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Acyclic;
import chemaxon.marvin.io.formats.name.nameexport.Canonicalizer;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;
import chemaxon.struc.Molecule;
import java.util.ArrayList;
import java.util.HashMap;

class GroupMatch {
    GroupDictionary.Structure group;
    int[] map;
    ArrayList substituentRoots;

    GroupMatch(GroupDictionary.Structure group, int[] map, ArrayList substituentRoots) {
        this.group = group;
        this.map = map;
        this.substituentRoots = substituentRoots;
    }

    void setSpecialLocants(Acyclic acyclic, CharacteristicGroup g) {
        Molecule m = acyclic.m;
        Molecule query = this.group.query;
        boolean noLocants = this.group.suffixName != null && this.group.suffixName.endsWith("urea") && this.nbSubstituents(acyclic) == 1;
        int i = this.map.length;
        while (--i >= 0) {
            String locant;
            int atom = this.map[i];
            MolAtom localMatched = m.getAtom(atom);
            MolAtom queryAtom = query.getAtom(i);
            MolAtom matched = acyclic.global(localMatched);
            String string = locant = noLocants ? "" : queryAtom.getAliasstr();
            if (locant == null) {
                localMatched.clearExtraLabel();
                matched.clearExtraLabel();
                continue;
            }
            localMatched.setExtraLabel(locant);
            matched.setExtraLabel(locant);
        }
    }

    private int nbSubstituents(Acyclic acyclic) {
        Molecule m = acyclic.m;
        int res = 0;
        int i = this.map.length;
        while (--i >= 0) {
            int atom = this.map[i];
            MolAtom localMatched = m.getAtom(atom);
            MolAtom matched = acyclic.global(localMatched);
            int j = matched.getBondCount();
            while (--j >= 0) {
                int index;
                MolAtom n = matched.getLigand(j);
                MolAtom neighbour = SubmoleculeBuilder.localAtom(n, m);
                if (neighbour == null) {
                    neighbour = n;
                }
                if (Util.indexOf(index = m.indexOf(neighbour), this.map) != -1) continue;
                ++res;
            }
        }
        return res;
    }

    void setOwners(Molecule m, HashMap atomOwner, Part res) {
        Molecule query = this.group.query;
        int i = this.map.length;
        while (--i >= 0) {
            MolAtom queryAtom = query.getAtom(i);
            if (queryAtom.getAtno() == 131) continue;
            int atom = this.map[i];
            MolAtom localMatched = m.getAtom(atom);
            atomOwner.put(SubmoleculeBuilder.originalAtom(localMatched), res);
        }
    }

    static void setOwners(MolAtom[] atoms, Part res) {
        if (atoms == null || res.owners == null) {
            return;
        }
        int i = atoms.length;
        while (--i >= 0) {
            MolAtom a = atoms[i];
            if (a == null) continue;
            res.owners.put(a, res);
        }
    }

    MolAtom[] getAtoms(Acyclic acyclic) {
        Molecule m = acyclic.m;
        Molecule query = this.group.query;
        MolAtom[] res = new MolAtom[this.map.length];
        int i = this.map.length;
        while (--i >= 0) {
            MolAtom queryAtom = query.getAtom(i);
            if (queryAtom.getAtno() == 131) continue;
            int atom = this.map[i];
            MolAtom localMatched = m.getAtom(atom);
            res[i] = SubmoleculeBuilder.originalAtom(localMatched);
        }
        return res;
    }

    MolBond getEZBond(Acyclic acyclic, CharacteristicGroup g) {
        MolAtom a2;
        if (this.group.doubleBond == null) {
            return null;
        }
        Molecule m = acyclic.m;
        Molecule query = this.group.query;
        int ga1 = query.indexOf(this.group.doubleBond.getAtom1());
        int ga2 = query.indexOf(this.group.doubleBond.getAtom2());
        MolAtom a1 = m.getAtom(this.map[ga1]);
        if (Canonicalizer.getStereo(a1, a2 = m.getAtom(this.map[ga2])) != 0) {
            return a1.getBondTo(a2);
        }
        return null;
    }
}

