/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.license.LicenseException;
import chemaxon.license.LicenseHandler;
import chemaxon.marvin.io.MolExportException;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamerThread;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class IUPACNamer {
    public static String generateName(Molecule m) throws Error {
        return IUPACNamer.generateName(m, "");
    }

    public static String generateName(Molecule m, String licenseEnvironment) throws Error {
        return IUPACNamer.generateName(m, -1, true, licenseEnvironment);
    }

    public static String generateName(Molecule m, int timeout, boolean throwErrors) throws Error {
        return IUPACNamer.generateName(m, timeout, throwErrors, "");
    }

    public static String generateName(Molecule m, int timeout, boolean throwErrors, String licenseEnvironment) throws Error {
        IUPACNamer.checkLicense(licenseEnvironment);
        if (timeout == -1) {
            timeout = 20;
        }
        return IUPACNamerThread.generateName(m, timeout, throwErrors);
    }

    private static void checkLicense(String licenseEnvironment) throws LicenseException {
        LicenseHandler.getInstance().checkLicense("Structure to Name Plugin", licenseEnvironment);
    }

    public static void main(String[] args) {
        boolean interactive = false;
        boolean printSmiles = false;
        int arg = 0;
        while (arg < args.length && args[arg].charAt(0) == '-') {
            String argument = args[arg];
            if (argument.equals("-smiles")) {
                printSmiles = true;
                ++arg;
                continue;
            }
            System.out.println("Unknown option: " + argument);
        }
        if (interactive) {
            System.out.println("IUPAC Preferred Name calculator\n");
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        try {
            String line;
            while ((line = r.readLine()) != null) {
                IUPACNamer.handleInputLine(line, printSmiles, interactive);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void handleInputLine(String line, boolean printSmiles, boolean interactive) {
        try {
            Molecule m = Util.moleculeFromSmiles(line);
            if (m == null) {
                System.out.println("Invalid SMILES string");
                return;
            }
            long time = System.currentTimeMillis();
            String name = IUPACNamer.generateName(m, 0, !printSmiles);
            if (printSmiles) {
                System.out.println(line + " \"" + name + "\"");
            } else {
                System.out.println(name);
            }
            time = System.currentTimeMillis() - time;
            if (interactive) {
                System.out.println("Generation time: " + time + "ms");
            }
        }
        catch (Error e) {
            System.out.println("Could not generate name:");
            e.printStackTrace(System.out);
        }
    }

    public static class UnsupportedError
    extends RuntimeException {
        UnsupportedError(String message) {
            super("Naming is not supported on this structure: " + message);
        }

        static UnsupportedError unsupportedPseudoAtom(int atno) {
            String msg;
            switch (atno) {
                case 131: {
                    msg = "query atom (\"any\", \"*\", \"A\")";
                    break;
                }
                case 137: {
                    msg = "multicenter";
                    break;
                }
                default: {
                    msg = "unknown pseudo-atom #" + atno;
                }
            }
            throw new UnsupportedError(msg);
        }
    }

    public static class Failure
    extends RuntimeException {
        Failure(String message) {
            super("Name generation failed for an unexpected reason: " + message);
        }

        Failure(Throwable t) {
            super("Name generation failed for an unexpected reason", t);
        }
    }

    public static class NoCommonName
    extends Error {
        NoCommonName() {
            super("No common name is known for this structure");
        }
    }

    public static class TimeoutError
    extends Error {
        public final int timeout;

        TimeoutError(int timeout, String stackTrace) {
            super("Timeout after " + timeout + "s while computing name. Stack trace at the time of the timeout:\n" + stackTrace);
            this.timeout = timeout;
        }
    }

    public static class Error
    extends MolExportException {
        Error(String message, Throwable cause) {
            super(message + ": " + cause, cause);
        }

        Error(String message) {
            super(message);
        }
    }
}

