/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.NamingCentral;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.util.MarvinModule;
import chemaxon.struc.Molecule;

class IUPACNamerThread
extends Thread {
    Molecule m;
    IUPACNamer.Error error;
    RuntimeException runtimeException;
    String computedName;

    static String generateName(Molecule m, int timeout, boolean throwErrors) throws IUPACNamer.Error {
        String name = throwErrors ? IUPACNamerThread.getName(m, timeout) : IUPACNamerThread.getNameNoThrow(m, timeout);
        return name;
    }

    private static String getNameNoThrow(Molecule m, int timeout) {
        try {
            return IUPACNamerThread.getName(m, timeout);
        }
        catch (IUPACNamer.Error e) {
            return "NO NAME: " + m.toFormat("smiles");
        }
    }

    static String getName(Molecule m, int timeout) throws IUPACNamer.Error {
        if (timeout == 0) {
            return new NamingCentral().getName(m);
        }
        try {
            IUPACNamerThread namer = new IUPACNamerThread(m);
            namer.start();
            namer.join(timeout * 1000);
            while (MarvinModule.isModuleLoadingInProgress()) {
                namer.join(timeout * 100);
            }
            if (namer.isAlive()) {
                String name;
                String stackTrace = IUPACNamerThread.printStackTrace(namer.getStackTrace());
                namer.stop();
                if (Options.traditionalFullNames && (name = NamingCentral.nameFromSmiles(m)) != null) {
                    return name;
                }
                throw new IUPACNamer.TimeoutError(timeout, stackTrace);
            }
            if (namer.error != null) {
                throw namer.error;
            }
            if (namer.runtimeException != null) {
                throw namer.runtimeException;
            }
            return namer.computedName;
        }
        catch (InterruptedException e) {
            throw new IUPACNamer.Error("Name generation interrupted", e);
        }
    }

    private static String printStackTrace(StackTraceElement[] stack) {
        if (stack == null) {
            return "Null stack trace";
        }
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < stack.length; ++i) {
            res.append(stack[i]).append('\n');
        }
        return res.toString();
    }

    IUPACNamerThread(Molecule m) {
        this.m = m;
    }

    @Override
    public void run() {
        try {
            this.computedName = new NamingCentral().getName(this.m);
        }
        catch (IUPACNamer.Error e) {
            this.error = e;
        }
        catch (RuntimeException e) {
            this.runtimeException = e;
        }
    }
}

