/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.GeneralSpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.RingSystemRecognizer;
import chemaxon.marvin.io.formats.name.nameexport.UnbranchedSpiroNamer;
import chemaxon.struc.Molecule;

public class MonoSpiroNamer
extends UnbranchedSpiroNamer {
    MonoSpiroNamer(RingSystemRecognizer.RingTree tree, Molecule m) {
        super(tree, m);
    }

    @Override
    void computePartNames() {
        RingSystem someRS = this.tree.ringSystems[0];
        GeneralSpiroNamer.NameComponent component = this.nameRingSystem(0, someRS);
        IntVector neighbours = someRS.connections;
        for (int i = 0; i < neighbours.size(); ++i) {
            int n = neighbours.get(i);
            int outgoingSpiroAtom = someRS.spiroAtoms.get(i);
            if (i == 0) {
                component.addSpiroAtom(outgoingSpiroAtom);
                this.insertSorted(component);
            }
            component = this.nameRingSystem(n, this.tree.ringSystems[n]);
            component.addSpiroAtom(outgoingSpiroAtom);
            this.insertSorted(component);
        }
    }

    @Override
    protected String getFirstPrime(int rank, String rankPrime) {
        return "";
    }

    @Override
    int getFirstSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        return numbering[((GeneralSpiroNamer.NameComponent)this.components.get((int)0)).localSpiroAtoms.get(0)];
    }

    @Override
    int getSecondSpiroLocant(int rank, IntVector localSpiroAtoms, int[] numbering) {
        return numbering[localSpiroAtoms.get(0)];
    }
}

