/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.AminoAcid;
import chemaxon.marvin.io.formats.name.nameexport.Chain;
import chemaxon.marvin.io.formats.name.nameexport.ChainComparator;
import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Modifiers;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.TopologyAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

class ParentFinder {
    Part[] parts;
    TopologyAnalyser.Neighbour[][] allNeighbours;
    private static final int seniorityN = Chem.MAX_SENIORITY - Chem.seniority(7);

    static Part parent(Part[] parts, TopologyAnalyser.Neighbour[][] neighbours) {
        return new ParentFinder(parts, neighbours).computeParent();
    }

    private ParentFinder(Part[] parts, TopologyAnalyser.Neighbour[][] neighbours) {
        this.parts = parts;
        this.allNeighbours = neighbours;
    }

    private Part computeParent() {
        ArrayList<Part> bests = new ArrayList<Part>();
        int bestIndex = -1;
        int i = this.parts.length;
        while (--i >= 0) {
            int diff;
            Part p = this.parts[i];
            if (p == null || (diff = bestIndex == -1 ? -1 : this.compare(p, this.parts[bestIndex], this.allNeighbours[i], this.allNeighbours[bestIndex])) > 0) continue;
            if (diff < 0) {
                bests.clear();
                bestIndex = i;
            }
            bests.add(p);
        }
        if (bests.size() == 0) {
            return null;
        }
        return (Part)bests.get(Util.randomInt(bests.size()));
    }

    long seniority(Part part, TopologyAnalyser.Neighbour[] neighbours) {
        if (part instanceof CharacteristicGroup) {
            CharacteristicGroup g = (CharacteristicGroup)part;
            return Integer.MAX_VALUE - (long)g.suffixJuniority() << 32;
        }
        if (ParentFinder.asGroup(part) != null) {
            return 0L;
        }
        if (part instanceof SimplePart) {
            Modifiers mods = ((SimplePart)part).modifiers;
            if (mods.suffixGroups != null) {
                int repeat = mods.suffixLocants == null ? 1 : mods.suffixLocants.length;
                return Integer.MAX_VALUE - (long)mods.suffixGroupsJuniority() << 32 | (long)repeat;
            }
        }
        long res = 0L;
        if (neighbours == null) {
            return res;
        }
        int i = neighbours.length;
        block0: while (--i >= 0) {
            long newRes;
            int neighbourIndex = neighbours[i].neighbourIndex;
            Part p = this.parts[neighbourIndex];
            CharacteristicGroup group = ParentFinder.asGroup(p);
            if (group == null || group.suffixJuniority() <= 0 || group.group != null && group.group.alwaysParent) continue;
            MolAtom groupRadical = SubmoleculeBuilder.originalAtom(group.radical);
            if (group.radical != null && groupRadical != neighbours[i].start) continue;
            if (!p.isAmine() && this.allNeighbours[neighbourIndex].length > 1) {
                int j = this.allNeighbours[neighbourIndex].length;
                while (--j >= 0) {
                    Part other = this.parts[this.allNeighbours[neighbourIndex][j].neighbourIndex];
                    if (other == part || this.allNeighbours[neighbourIndex][j].root != groupRadical) continue;
                    continue block0;
                }
            }
            if ((newRes = ParentFinder.updateSeniority(p, res)) != res) {
                if (newRes != res + 1L) {
                    int j = neighbours.length;
                    while (--j > i) {
                        neighbours[j].isSuffixOf = null;
                    }
                }
                neighbours[i].isSuffixOf = part;
            }
            res = newRes;
        }
        return res;
    }

    private static CharacteristicGroup asGroup(Part p) {
        if (p instanceof Chain) {
            Chain c = (Chain)p;
            if (c.chain.length != 1) {
                return null;
            }
            if (c.modifiers.suffixGroups == null || c.modifiers.suffixGroups.size() != 1) {
                return null;
            }
            CharacteristicGroup group = c.modifiers.suffixGroup(0);
            if (group.eatCarbon) {
                return group;
            }
        } else if (p instanceof CharacteristicGroup) {
            return (CharacteristicGroup)p;
        }
        return null;
    }

    static long updateSeniority(Part p, long res) {
        int juniority = p.suffixJuniority();
        if (juniority <= 0) {
            return res;
        }
        int bestJuniority = Integer.MAX_VALUE - (int)(res >> 32);
        if (juniority > bestJuniority) {
            return res;
        }
        if (juniority < bestJuniority) {
            res = (long)(Integer.MAX_VALUE - juniority) << 32;
        }
        return ++res;
    }

    static int compare(Part p1, Part p2) {
        return new ParentFinder(null, null).compare(p1, p2, null, null);
    }

    int compare(Part p1, Part p2, TopologyAnalyser.Neighbour[] n1, TopologyAnalyser.Neighbour[] n2) {
        int neighbours2;
        long seniority2;
        int seniorityClass2;
        int seniorityClass1 = p1.getSeniorityClass();
        int diff = seniorityClass1 - (seniorityClass2 = p2.getSeniorityClass());
        if (diff != 0) {
            return diff;
        }
        long seniority1 = this.seniority(p1, n1);
        if (seniority1 != (seniority2 = this.seniority(p2, n2))) {
            return seniority1 < seniority2 ? 1 : -1;
        }
        diff = ParentFinder.atomSeniority(p2) - ParentFinder.atomSeniority(p1);
        if (diff != 0) {
            return diff;
        }
        boolean nonCyclic1 = !p1.cyclic();
        boolean nonCyclic2 = !p2.cyclic();
        int neighbours1 = n1 == null ? 0 : n1.length;
        int n = neighbours2 = n2 == null ? 0 : n2.length;
        if (nonCyclic1) {
            if (nonCyclic2) {
                return ParentFinder.compareNonCyclic(p1, neighbours1, p2, neighbours2);
            }
            return 1;
        }
        if (nonCyclic2) {
            return -1;
        }
        return ParentFinder.compareCyclic(p1, neighbours1, p2, neighbours2);
    }

    static int atomSeniority(Part p) {
        int res = -1;
        Molecule m = p.originalMolecule;
        if (m == null) {
            return res;
        }
        if (ParentFinder.isEther(m)) {
            return res;
        }
        int i = m.getAtomCount();
        while (--i >= 0) {
            int s = Chem.parentSeniority(m.getAtom(i).getAtno());
            if (s <= res) continue;
            res = s;
        }
        return res;
    }

    static long atomSeniority(MolAtom a) {
        long res;
        int ionicType = Chem.getIonicType(a);
        switch (ionicType) {
            case -2: {
                res = 1L;
                break;
            }
            case 2: {
                res = 1L;
                break;
            }
            case -1: {
                res = 2L;
                break;
            }
            case 1: {
                res = 2L;
                break;
            }
            case 0: {
                res = 0L;
                break;
            }
            default: {
                throw new IUPACNamer.Failure("Unknown output of getIonicType(): " + ionicType);
            }
        }
        res <<= 32;
        if (a.getAtno() != 1 || a.getMassno() == 0) {
            res |= (long)(Chem.parentSeniority(a.getAtno()) + 1);
            if (AminoAcid.isParentAminoAcid(a)) {
                ++res;
            }
        }
        return res;
    }

    static boolean isEther(Molecule m) {
        if (m.getAtomCount() > 2) {
            return false;
        }
        int i = m.getAtomCount();
        while (--i >= 0) {
            if (Chem.isEtherAnalog(m.getAtom(i))) continue;
            return false;
        }
        return true;
    }

    static int compareNonCyclic(Part p1, int numNeighbours1, Part p2, int numNeighbours2) {
        if (p1 instanceof Chain && p2 instanceof Chain) {
            Chain chain1 = (Chain)p1;
            Chain chain2 = (Chain)p2;
            MolAtom[] c1 = chain1.originalChain;
            MolAtom[] c2 = chain2.originalChain;
            int diff = ChainComparator.compare(c1, c2);
            if (diff != 0) {
                return diff;
            }
            diff = chain2.modifiers.getNumberOfSubstituents() - chain1.modifiers.getNumberOfSubstituents();
            if (diff != 0) {
                return diff;
            }
            diff = ChainComparator.compare(chain1, chain2);
            if (diff != 0) {
                return diff;
            }
        }
        int numSubstituents1 = p1 instanceof SimplePart ? ((SimplePart)p1).modifiers.getNumberOfSubstituents() : -1;
        int numSubstituents2 = p2 instanceof SimplePart ? ((SimplePart)p2).modifiers.getNumberOfSubstituents() : -1;
        return numSubstituents2 + numNeighbours2 - numSubstituents1 - numNeighbours1;
    }

    static int compareCyclic(Part p1, Part p2) {
        int numSubstituents1 = p1 instanceof SimplePart ? ((SimplePart)p1).modifiers.getNumberOfSubstituents() : -1;
        int numSubstituents2 = p2 instanceof SimplePart ? ((SimplePart)p2).modifiers.getNumberOfSubstituents() : -1;
        return ParentFinder.compareCyclic(p1, numSubstituents1, p2, numSubstituents2);
    }

    private static int compareCyclic(Part p1, int numSubstituents1, Part p2, int numSubstituents2) {
        Molecule m1 = p1.originalMolecule;
        Molecule m2 = p2.originalMolecule;
        int diff = ParentFinder.compareCyclic1(m1, m2, false);
        if (diff != 0) {
            return diff;
        }
        diff = p1.parentSeniority() - p2.parentSeniority();
        if (diff != 0) {
            return diff;
        }
        diff = p1.compareSeniority(p2);
        if (diff != 0) {
            return diff;
        }
        diff = ParentFinder.compareCyclic2(m1, m2);
        if (diff != 0) {
            return diff;
        }
        diff = numSubstituents2 - numSubstituents1;
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    static int compareCyclic1(Molecule m1, Molecule m2, boolean fused) {
        int[] heteros2;
        int[] heteros1 = ParentFinder.heteros(m1);
        int diff = ParentFinder.heteroCriteria1(heteros1, heteros2 = ParentFinder.heteros(m2));
        if (diff != 0) {
            return diff;
        }
        diff = m2.getSSSR().length - m1.getSSSR().length;
        if (diff != 0) {
            return diff;
        }
        diff = m2.getAtomCount() - m1.getAtomCount();
        if (diff != 0) {
            return diff;
        }
        if (fused) {
            diff = Util.countNonZeroElements(heteros2) - Util.countNonZeroElements(heteros1);
            if (diff != 0) {
                return diff;
            }
            heteros1[0] = -1;
            heteros2[0] = -1;
            diff = Util.pointToPointComparison(heteros2, heteros1);
        } else {
            diff = ParentFinder.heteroCriteria2(heteros1, heteros2);
        }
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    static int compareCyclic2(Molecule m1, Molecule m2) {
        int diff = ParentFinder.bondCount(m2) - ParentFinder.bondCount(m1);
        if (diff != 0) {
            return diff;
        }
        return 0;
    }

    private static int comparePresence(int n1, int n2) {
        if (n1 > 0) {
            return n2 == 0 ? -1 : 0;
        }
        if (n2 > 0) {
            return 1;
        }
        return -2;
    }

    static int heteroCriteria1(int[] heteros1, int[] heteros2) {
        int diff = ParentFinder.comparePresence(heteros1[seniorityN], heteros2[seniorityN]);
        if (diff != -2) {
            return diff;
        }
        for (int i = 1; i < Chem.MAX_SENIORITY; ++i) {
            diff = ParentFinder.comparePresence(heteros1[i], heteros2[i]);
            if (diff == -2) continue;
            return diff;
        }
        return 0;
    }

    static int heteroCriteria2(int[] heteros1, int[] heteros2) {
        int diff = Util.pointToPointComparison(heteros2, heteros1);
        return diff;
    }

    static int[] heteros(Molecule m) {
        int[] res = new int[Chem.MAX_SENIORITY + 1];
        int i = m.getAtomCount();
        while (--i >= 0) {
            int atno = m.getAtom(i).getAtno();
            if (atno == 6) continue;
            res[0] = res[0] + 1;
            int seniority = Chem.seniority(atno);
            if (seniority < 0) continue;
            int n = Chem.MAX_SENIORITY - seniority;
            res[n] = res[n] + 1;
        }
        return res;
    }

    static int bondCount(Molecule m) {
        int res = 0;
        int i = m.getBondCount();
        while (--i >= 0) {
            switch (m.getBond(i).getType()) {
                case 2: {
                    res += 524288;
                    break;
                }
                case 3: {
                    res += 131072;
                    break;
                }
                case 4: {
                    res += 131072;
                }
            }
        }
        return res;
    }
}

