/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.HeteroAnalyser;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SpecialFusedRingSystem;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;

public class Polyalene
extends SpecialFusedRingSystem {
    int size;

    static SpecialFusedRingSystem create(Molecule m, int[] atomIndexMap, RingSystem rs) {
        int[][] rings = rs.getRings();
        if (rings.length != 2) {
            return null;
        }
        if (rings[0].length != rings[1].length) {
            return null;
        }
        int len = rings[0].length;
        if (len == 6) {
            return null;
        }
        if (len == 5 && HeteroAnalyser.hasHeteroAtoms(m)) {
            return null;
        }
        return new Polyalene(m, atomIndexMap, rs, len);
    }

    private Polyalene(Molecule m, int[] atomIndexMap, RingSystem rs, int size) {
        super(m, atomIndexMap, rs);
        this.size = size;
    }

    @Override
    String nameDescriptor(int[] descriptor, int[] numbering, boolean saturatedBase, boolean omitSuffix) {
        StringBuffer res = new StringBuffer();
        res.append(Chem.greek(this.size));
        Util.appendRemovingVowel("alene", res);
        return res.toString();
    }

    @Override
    int[][][] recognize() {
        int[][] numberings = this.rs.linearFusedNumberings(new int[]{0, 1}, this.originalMolecule.getAtomCount());
        int[][][] res = new int[4][][];
        int i = numberings.length;
        while (--i >= 0) {
            res[i] = new int[][]{null, numberings[i]};
        }
        return res;
    }
}

