/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.TraditionalDictionary;

abstract class RetainedFullName {
    private static String[] IUPACdictionary = new String[]{"ethyne", "acetylene", "hentriacontacyclo[12.11.34.1^{5,8}.0^{2,33}.0^{3,51}.0^{4,25}.0^{6,23}.0^{7,12}.0^{9,54}.0^{10,56}.0^{11,59}.0^{13,22}.0^{15,42}.0^{16,21}.0^{17,41}.0^{18,28}.0^{19,26}.0^{20,24}.0^{27,32}.0^{29,40}.0^{30,38}.0^{31,35}.0^{34,50}.0^{36,48}.0^{37,46}.0^{39,44}.0^{43,58}.0^{45,57}.0^{47,55}.0^{49,53}.0^{52,60}]hexaconta-1(26),2,4(25),5,7(12),8(60),9,11(59),13,15,17,19,21,23,27,29(40),30,32,34,36(48),37,39(44),41,43(58),45(57),46,49,51,53,55-triacontaene", "(C60-Ih)[5,6]fullerene", "hentriacontacyclo[10.10.38.0^{2,16}.0^{3,14}.0^{4,8}.0^{5,23}.0^{6,33}.0^{7,50}.0^{9,13}.0^{10,51}.0^{11,54}.0^{15,59}.0^{17,21}.0^{18,58}.0^{19,41}.0^{20,27}.0^{22,25}.0^{24,32}.0^{26,30}.0^{28,40}.0^{29,37}.0^{31,35}.0^{34,49}.0^{36,47}.0^{38,46}.0^{39,43}.0^{42,57}.0^{44,55}.0^{45,53}.0^{48,52}.0^{56,60}]hexaconta-1,3,5(23),6(33),7,9(13),10,12(60),14,16,18,20(27),21,24(32),25,28(40),29,31(35),34(49),36(47),37,39(43),41,44(55),45,48(52),50,53,56,58-triacontaene", "(C60-Ih)[5,6]fullerene", "hentriacontacyclo[16.16.21.1^{2,6}.1^{4,23}.1^{12,15}.1^{16,40}.1^{29,32}.0^{3,33}.0^{5,22}.0^{7,20}.0^{8,13}.0^{10,35}.0^{11,37}.0^{14,19}.0^{17,52}.0^{21,55}.0^{24,54}.0^{25,30}.0^{26,53}.0^{27,50}.0^{28,48}.0^{34,45}.0^{36,44}.0^{38,42}.0^{41,49}.0^{43,47}.0^{9,60}.0^{31,58}.0^{39,59}.0^{46,57}.0^{51,56}]hexaconta-1,3,5(22),6(60),7(20),8(13),9,11,14(19),15,17,21(55),23(58),24(54),25,27(50),28,30,32(57),33,35,37,39(59),40,42,44,46,48,51(56),52-triacontaene", "(C60-Ih)[5,6]fullerene", "hentriacontacyclo[25.18.6.4^{2,6}.1^{3,41}.1^{9,13}.1^{11,18}.1^{22,25}.1^{28,31}.0^{5,40}.0^{7,39}.0^{8,33}.0^{12,16}.0^{14,30}.0^{15,23}.0^{17,21}.0^{20,46}.0^{24,29}.0^{26,49}.0^{34,38}.0^{36,51}.0^{37,42}.0^{43,50}.0^{45,48}.0^{4,59}.0^{10,57}.0^{19,60}.0^{32,56}.0^{35,53}.0^{44,52}.0^{47,54}.0^{55,58}]hexaconta-1(45),2,4,6,8(33),9,11,13,15,17(21),18(55),19,22,24(29),25(54),26,28(53),30,32(56),34,36,38,40,42,44(52),46,48,50,57,59-triacontaene", "(C60-Ih)[5,6]fullerene", "hexatriacontacyclo[13.12.43.0^{2,34}.0^{3,36}.0^{4,52}.0^{5,27}.0^{6,54}.0^{7,26}.0^{8,56}.0^{9,58}.0^{10,25}.0^{11,23}.0^{12,59}.0^{13,21}.0^{14,60}.0^{16,20}.0^{17,45}.0^{18,42}.0^{19,31}.0^{22,30}.0^{24,28}.0^{29,33}.0^{32,41}.0^{35,40}.0^{37,51}.0^{38,49}.0^{39,43}.0^{44,48}.0^{46,70}.0^{47,67}.0^{50,66}.0^{53,65}.0^{55,64}.0^{57,62}.0^{61,69}.0^{63,68}]heptaconta-1(27),2,4,6,8(56),9(58),10,12(59),13(21),14,16(20),17(45),18(42),19(31),22,24(28),25,29,32,34,36,38(49),39(43),40,44(48),46(70),47(67),50,52,54,57(62),60,63,65,68-pentatriacontaene", "(C70-D5h(6))[5,6]fullerene"};

    RetainedFullName() {
    }

    static String get(String name) {
        String res = RetainedFullName.get(name, IUPACdictionary);
        if (res != null) {
            name = res;
        }
        if (Options.traditionalFullNames && (res = TraditionalDictionary.getTraditionalName(name)) != null) {
            name = res;
        }
        return name;
    }

    static String get(String systematicName, String[] dictionary) {
        int i = dictionary.length;
        while ((i -= 2) >= 0) {
            if (!dictionary[i].equals(systematicName)) continue;
            return dictionary[i + 1];
        }
        return null;
    }
}

