/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.common.util.IntVector;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SpiroNamer;
import chemaxon.marvin.io.formats.name.nameexport.SubmoleculeBuilder;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.Molecule;
import java.util.ArrayList;

abstract class RingSystemRecognizer {
    static final int VISIT_STARTED = 1;
    static final int VISIT_DONE = 2;

    RingSystemRecognizer() {
    }

    static Part[] separateRingsSystems(Molecule m) {
        int[][] sssr = m.getSSSR();
        sssr = RingSystemRecognizer.clone(sssr);
        boolean[] visited = new boolean[sssr.length];
        ArrayList ringSystems = new ArrayList();
        for (int i = 0; i < sssr.length; ++i) {
            RingSystemRecognizer.findRingSystem(i, sssr, visited, ringSystems, null);
        }
        RingSystem[] ringSystemArray = ringSystems.toArray(new RingSystem[ringSystems.size()]);
        int[] visit = new int[ringSystems.size()];
        ArrayList ringTrees = new ArrayList();
        for (int i = 0; i < ringSystems.size(); ++i) {
            RingSystemRecognizer.findRingTree(i, ringSystemArray, visit, ringTrees, null);
        }
        Part[] res = new Part[ringTrees.size()];
        int n = 0;
        for (RingTree ringTree : ringTrees) {
            res[n++] = ringTree.getPart(m);
        }
        return res;
    }

    private static int[][] clone(int[][] array) {
        int[][] res = new int[array.length][];
        int i = array.length;
        while (--i >= 0) {
            res[i] = (int[])array[i].clone();
        }
        return res;
    }

    static void findRingSystem(int n, int[][] sssr, boolean[] visited, ArrayList ringSystems, RingSystem rs) {
        if (visited[n]) {
            return;
        }
        visited[n] = true;
        if (rs == null) {
            rs = new RingSystem();
            ringSystems.add(rs);
        }
        rs.add(sssr[n]);
        for (int i = 0; i < sssr.length; ++i) {
            int[] intersection;
            int len;
            if (i == n || (len = (intersection = Util.intersection(sssr[n], sssr[i], 2))[0]) < 2) continue;
            RingSystemRecognizer.findRingSystem(i, sssr, visited, ringSystems, rs);
            if (len > 2) {
                rs.notFused = true;
                continue;
            }
            if (len != 2) continue;
            rs.addFusion(sssr[n], sssr[i], intersection[1], intersection[2]);
        }
    }

    static void findRingTree(int n, RingSystem[] ringSystems, int[] visited, ArrayList ringTrees, RingTree tree) {
        if (visited[n] >= 1) {
            return;
        }
        visited[n] = 1;
        RingSystem rs = ringSystems[n];
        if (tree == null) {
            tree = new RingTree(ringSystems.length);
            ringTrees.add(tree);
        }
        tree.add(rs);
        for (int i = 0; i < ringSystems.length; ++i) {
            int spiroAtom;
            if (i == n || visited[i] == 2 || (spiroAtom = RingSystemRecognizer.intersection(rs, ringSystems[i])) < 0) continue;
            RingSystemRecognizer.findRingTree(i, ringSystems, visited, ringTrees, tree);
            tree.addConnection(rs, ringSystems[i], spiroAtom);
        }
        visited[n] = 2;
    }

    private static int intersection(RingSystem r1, RingSystem r2) {
        for (int i = 0; i < r1.rings.size(); ++i) {
            for (int j = 0; j < r2.rings.size(); ++j) {
                int[] intersection = Util.intersection((int[])r1.rings.get(i), (int[])r2.rings.get(j), 1);
                int len = intersection[0];
                if (len == 0) continue;
                return intersection[1];
            }
        }
        return -1;
    }

    static class RingTree {
        RingSystem[] ringSystems;
        int size = 0;
        boolean purelyMonocyclic = true;
        IntVector threeRingSpiroAtoms = new IntVector();

        RingTree(int capacity) {
            this.ringSystems = new RingSystem[capacity];
        }

        void add(RingSystem rs) {
            this.ringSystems[this.size++] = rs;
            if (rs.rings.size() > 1) {
                this.purelyMonocyclic = false;
            }
        }

        void addConnection(RingSystem rs1, RingSystem rs2, int spiroAtom) {
            int r1 = Util.indexOf(rs1, this.ringSystems);
            int r2 = Util.indexOf(rs2, this.ringSystems);
            if (rs1.connections.indexOf(r2) != -1) {
                return;
            }
            if (this.threeRingSpiroAtoms.indexOf(spiroAtom) == -1 && rs1.spiroAtoms.indexOf(spiroAtom) != -1) {
                this.threeRingSpiroAtoms.add(spiroAtom);
            }
            rs1.connections.add(r2);
            rs1.spiroAtoms.add(spiroAtom);
            rs2.connections.add(r1);
            rs2.spiroAtoms.add(spiroAtom);
        }

        Part getPart(Molecule m) {
            if (this.size == 1) {
                RingSystem rs = this.ringSystems[0];
                SubmoleculeBuilder builder = rs.computeMolecule(m);
                rs.updateIndexes(builder);
                return rs.create(builder.getMolecule(), builder.atomIndexMap.toArray());
            }
            SubmoleculeBuilder builder = new SubmoleculeBuilder(m);
            int i = this.size;
            while (--i >= 0) {
                this.ringSystems[i].computeMolecule(builder);
            }
            i = this.size;
            while (--i >= 0) {
                this.ringSystems[i].updateIndexes(builder);
            }
            i = this.threeRingSpiroAtoms.size();
            while (--i >= 0) {
                this.threeRingSpiroAtoms.set(i, builder.getNewIndex(this.threeRingSpiroAtoms.get(i)));
            }
            return SpiroNamer.createPart(this, builder.getMolecule());
        }
    }
}

