/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.CharacteristicGroup;
import chemaxon.marvin.io.formats.name.nameexport.Chem;
import chemaxon.marvin.io.formats.name.nameexport.GroupDictionary;
import chemaxon.marvin.io.formats.name.nameexport.Halogen;
import chemaxon.marvin.io.formats.name.nameexport.IUPACNamer;
import chemaxon.marvin.io.formats.name.nameexport.Options;
import chemaxon.marvin.io.formats.name.nameexport.Part;
import chemaxon.marvin.io.formats.name.nameexport.Util;
import chemaxon.struc.MolAtom;
import chemaxon.struc.MolBond;

class SimpleGroup
extends CharacteristicGroup {
    int atno;

    static Part lookup(MolAtom root, MolAtom radical) {
        if (SimpleGroup.isGroup(radical) || SimpleGroup.isGroup2(radical)) {
            return SimpleGroup.create(root, radical);
        }
        return null;
    }

    static boolean isGroup(MolAtom atom) {
        int atno = atom.getAtno();
        if (atom.getCharge() != 0 && (atno != 7 || Math.abs(atom.getCharge()) != 1)) {
            return false;
        }
        if (atom.getBondCount() > 1) {
            return false;
        }
        return atno == 8 || atno == 16 || atno == 34 || atno == 52 || atno == 7 || Chem.isHalogen(atom);
    }

    static boolean isGroup2(MolAtom atom) {
        int atno = atom.getAtno();
        if (atom.getCharge() != 0) {
            return false;
        }
        if (atom.getBondCount() > 1) {
            return false;
        }
        return atno == 16 || atno == 34 || atno == 52 || atno == 7;
    }

    static Part create(MolAtom root, MolAtom atom) {
        if (Chem.isHalogen(atom)) {
            return new Halogen(root, atom);
        }
        return new SimpleGroup(root, atom);
    }

    static Part create(MolBond rootBond, MolAtom atom) {
        if (Chem.isHalogen(atom)) {
            return new Halogen(null, atom);
        }
        return new SimpleGroup(rootBond, atom);
    }

    MolAtom getAtom() {
        return this.radical;
    }

    int getGroupCharge() {
        return this.getAtom().getCharge();
    }

    SimpleGroup(MolAtom root, MolAtom atom) {
        super(root);
        this.radical = atom;
        this.setRootBond(root.getBondTo(atom));
        this.atno = atom.getAtno();
    }

    SimpleGroup(MolBond rootBond, MolAtom atom) {
        super((MolAtom)null);
        this.radical = atom;
        this.setRootBond(rootBond);
        this.atno = atom.getAtno();
    }

    @Override
    String getPrefixNameEnd() {
        switch (this.atno) {
            case 8: {
                return this.getType() == 2 ? "oxo" : "hydroxy";
            }
            case 16: {
                return "sulfan" + Chem.substituentEnding[this.getType()];
            }
            case 34: {
                return "selan" + Chem.substituentEnding[this.getType()];
            }
            case 52: {
                return "tellan" + Chem.substituentEnding[this.getType()];
            }
            case 7: {
                String res = this.aminePrefix();
                if (res == null) break;
                return res;
            }
        }
        throw new IUPACNamer.Failure("Unsupported suffix: #" + this.atno + " charge:" + this.getGroupCharge() + " bond:" + this.getType());
    }

    private String aminePrefix() {
        switch (this.getGroupCharge()) {
            case -2: {
                return this.getType() == 1 ? "azanediidyl" : "azanediidylene";
            }
            case -1: {
                return this.getType() == 1 ? "azanidyl" : "azanidylene";
            }
            case 0: {
                switch (Chem.effectiveRadicalCount(this.radical, true)) {
                    case 0: {
                        return this.getType() == 1 ? "amino" : "imino";
                    }
                    case 1: {
                        if (this.getType() == 1) {
                            return "aminyl";
                        }
                    }
                    case 2: {
                        if (this.getType() != 1) break;
                        return "azanylidene";
                    }
                }
            }
            case 1: {
                switch (this.getType()) {
                    case 1: {
                        return Options.traditionalGroups ? "aminio" : "azaniumyl";
                    }
                    case 2: {
                        return Options.traditionalGroups ? "iminio" : "iminiumyl";
                    }
                }
            }
        }
        return null;
    }

    @Override
    boolean isKetone() {
        return this.getType() == 2 && (this.atno == 8 || this.atno == 16 || this.atno == 34 || this.atno == 52);
    }

    @Override
    int suffixJuniority() {
        if (this.isNonSuffixKetone()) {
            return -1;
        }
        if (this.atno == 7) {
            if (this.getGroupCharge() != 0) {
                return 2 * SimpleGroup.ionSeniority(this.radical);
            }
            return 2 * GroupDictionary.Structure.seniority(18 + this.getType(), 0, 0);
        }
        return 2 * GroupDictionary.Structure.seniority(18 - this.getType(), 0, this.atno);
    }

    static int ionSeniority(MolAtom atom) {
        int seniorityClass = atom.getCharge() < 0 ? 4 : 6;
        return GroupDictionary.Structure.seniority(seniorityClass, Chem.seniority(atom.getAtno()), 0);
    }

    static String printIsotope(MolAtom atom, String name) {
        if (atom == null || atom.getMassno() == 0) {
            return name;
        }
        StringBuilder res = new StringBuilder();
        res.append("(");
        res.append(Util.unicodeSuperscriptNumber(atom.getMassno()));
        res.append(atom.getSymbol());
        res.append(")");
        res.append(name);
        return res.toString();
    }

    @Override
    String getSuffixName() {
        return SimpleGroup.printIsotope(this.getAtom(), this.getSuffixNameStem(false));
    }

    @Override
    String getParentName() {
        return this.getSuffixNameStem(true);
    }

    private String getSuffixNameStem(boolean asParent) {
        if (this.getType() == 2) {
            switch (this.atno) {
                case 8: {
                    return "one";
                }
                case 16: {
                    return "thione";
                }
                case 34: {
                    return "selone";
                }
                case 52: {
                    return "tellone";
                }
                case 7: {
                    break;
                }
                default: {
                    throw new IUPACNamer.Failure("Unsupported suffix: #" + this.atno);
                }
            }
        }
        switch (this.atno) {
            case 8: {
                return "ol";
            }
            case 16: {
                return "thiol";
            }
            case 34: {
                return "selenol";
            }
            case 52: {
                return "tellurol";
            }
            case 7: {
                String base;
                int charge = this.getGroupCharge();
                if (Chem.isRadical(this.radical)) {
                    base = this.aminePrefix();
                } else {
                    base = this.getType() == 2 ? "imine" : (charge == 0 || !asParent ? "amine" : "azane");
                    String suffix = Chem.suffix(this.radical, this.radical, true, true);
                    if (suffix != null) {
                        StringBuffer sb = new StringBuffer(base);
                        Util.appendRemovingVowel(suffix, sb);
                        base = sb.toString().intern();
                    }
                }
                return this.substituents(base, false, !asParent);
            }
        }
        throw new IUPACNamer.Failure("Unsupported suffix: #" + this.atno);
    }

    @Override
    boolean isAmine() {
        return this.atno == 7;
    }
}

