/*
 * Decompiled with CFR 0.152.
 */
package chemaxon.marvin.io.formats.name.nameexport;

import chemaxon.marvin.io.formats.name.nameexport.Polyacene;
import chemaxon.marvin.io.formats.name.nameexport.Polyalene;
import chemaxon.marvin.io.formats.name.nameexport.Polyhelicene;
import chemaxon.marvin.io.formats.name.nameexport.Polyphenylene;
import chemaxon.marvin.io.formats.name.nameexport.RingSystem;
import chemaxon.marvin.io.formats.name.nameexport.SimplePart;
import chemaxon.struc.Molecule;

abstract class SpecialFusedRingSystem
extends SimplePart {
    RingSystem rs;

    static SpecialFusedRingSystem create(Molecule molecule, int[] atomIndexMap, RingSystem rs) {
        SpecialFusedRingSystem res = Polyacene.create(molecule, atomIndexMap, rs);
        if (res != null) {
            return res;
        }
        res = Polyalene.create(molecule, atomIndexMap, rs);
        if (res != null) {
            return res;
        }
        res = Polyphenylene.create(molecule, atomIndexMap, rs);
        if (res != null) {
            return res;
        }
        res = Polyhelicene.create(molecule, atomIndexMap, rs);
        if (res != null) {
            return res;
        }
        return null;
    }

    SpecialFusedRingSystem(Molecule m, int[] atomIndexMap, RingSystem rs) {
        super(m, atomIndexMap);
        this.rs = rs;
    }

    @Override
    boolean cyclic() {
        return true;
    }

    @Override
    boolean hasRetainedName() {
        return true;
    }

    @Override
    boolean hasSaturatedBase() {
        return false;
    }
}

